/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.backend.server;

import java.util.List;
import java.util.Objects;
import org.drools.workbench.screens.scenariosimulation.model.FactMappingValidationError;
import org.drools.workbench.screens.scenariosimulation.utils.ScenarioSimulationI18nServerMessage;
import org.junit.Assert;

public abstract class AbstractScenarioValidationTest {
    protected void checkResult(List<FactMappingValidationError> validationErrors, ExpectedError ... expectedErrors) {
        if (expectedErrors.length == 0) {
            Assert.assertEquals((long)0L, (long)validationErrors.size());
        }
        for (ExpectedError expectedError : expectedErrors) {
            if (expectedError.getErrorMessage() != null) {
                Assert.assertTrue((boolean)validationErrors.stream().anyMatch(validationError -> Objects.equals(expectedError.getErrorMessage(), validationError.getErrorMessage())));
                continue;
            }
            Assert.assertTrue((boolean)validationErrors.stream().anyMatch(validationError -> this.checkValidationErrorWithExpected((FactMappingValidationError)validationError, expectedError)));
        }
    }

    protected boolean checkValidationErrorWithExpected(FactMappingValidationError validationError, ExpectedError expectedError) {
        boolean parametersSameLength;
        if (validationError.getErrorMessage() != null) {
            return false;
        }
        boolean isSameServerMessage = validationError.getServerMessage().equals((Object)expectedError.getServerMessage());
        boolean bl = parametersSameLength = validationError.getParameters().length == expectedError.getParameters().size();
        if (isSameServerMessage && parametersSameLength) {
            if (expectedError.getParameters().isEmpty()) {
                return true;
            }
            for (int i = 0; i < validationError.getParameters().length; ++i) {
                if (Objects.equals(validationError.getParameters()[i], expectedError.getParameters().get(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    static class ExpectedError {
        private String errorMessage;
        private ScenarioSimulationI18nServerMessage serverMessage;
        private List<String> parameters;

        public ExpectedError(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        public ExpectedError(ScenarioSimulationI18nServerMessage serverMessage, List<String> parameters) {
            this.serverMessage = serverMessage;
            this.parameters = parameters;
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }

        public ScenarioSimulationI18nServerMessage getServerMessage() {
            return this.serverMessage;
        }

        public List<String> getParameters() {
            return this.parameters;
        }
    }
}

