/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.backend.server;

import javax.enterprise.event.Event;
import org.drools.scenariosimulation.api.model.Background;
import org.drools.scenariosimulation.api.model.ScenarioSimulationModel;
import org.drools.scenariosimulation.api.model.Settings;
import org.drools.scenariosimulation.api.model.Simulation;
import org.drools.workbench.screens.scenariosimulation.backend.server.ScenarioSimulationServiceImpl;
import org.drools.workbench.screens.scenariosimulation.model.ScenarioSimulationModelContent;
import org.drools.workbench.screens.scenariosimulation.service.DMNTypeService;
import org.guvnor.common.services.backend.config.SafeSessionInfo;
import org.guvnor.common.services.shared.metadata.model.Overview;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.soup.project.datamodel.oracle.PackageDataModelOracle;
import org.kie.workbench.common.services.backend.service.KieServiceOverviewLoader;
import org.kie.workbench.common.services.datamodel.backend.server.service.DataModelService;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.backend.vfs.PathFactory;
import org.uberfire.ext.editor.commons.backend.version.PathResolver;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.Path;
import org.uberfire.rpc.SessionInfo;
import org.uberfire.workbench.events.ResourceOpenedEvent;

@RunWith(value=MockitoJUnitRunner.class)
public class ScenarioSimulationServiceImplLoadContentTest {
    @Mock
    private IOService ioService;
    @Mock
    private PathResolver pathResolver;
    @Mock
    protected KieServiceOverviewLoader overviewLoader;
    @Mock
    private Event<ResourceOpenedEvent> resourceOpenedEvent;
    @Mock
    private DataModelService dataModelService;
    @Mock
    private DMNTypeService dmnTypeServiceMock;
    @InjectMocks
    private ScenarioSimulationServiceImpl serviceSpy = (ScenarioSimulationServiceImpl)Mockito.spy((Object)new ScenarioSimulationServiceImpl((SessionInfo)Mockito.mock(SafeSessionInfo.class)){

        protected ScenarioSimulationModel unmarshalInternal(String content) {
            Simulation simulation = new Simulation();
            Background background = new Background();
            Settings settings = new Settings();
            settings.setType(ScenarioSimulationModel.Type.DMN);
            ScenarioSimulationModel toReturn = new ScenarioSimulationModel();
            toReturn.setSimulation(simulation);
            toReturn.setBackground(background);
            toReturn.setSettings(settings);
            return toReturn;
        }
    });
    private org.uberfire.backend.vfs.Path path = PathFactory.newPath((String)"contextpath", (String)"file:///contextpath");

    @Before
    public void setUp() {
        ((IOService)Mockito.doReturn((Object)"").when((Object)this.ioService)).readAllString((Path)Matchers.any());
        ((PathResolver)Mockito.doReturn((Object)false).when((Object)this.pathResolver)).isDotFile((Path)Matchers.any());
        ((KieServiceOverviewLoader)Mockito.doReturn((Object)Mockito.mock(Overview.class)).when((Object)this.overviewLoader)).loadOverview((org.uberfire.backend.vfs.Path)Matchers.any());
        ((DataModelService)Mockito.doReturn((Object)Mockito.mock(PackageDataModelOracle.class)).when((Object)this.dataModelService)).getDataModel(this.path);
    }

    @Test
    public void loadContent() {
        ScenarioSimulationModelContent scenarioSimulationModelContent = (ScenarioSimulationModelContent)this.serviceSpy.loadContent(this.path);
        Assert.assertNotNull((Object)scenarioSimulationModelContent);
        Assert.assertNotNull((Object)scenarioSimulationModelContent.getDataModel());
        Assert.assertNotNull((Object)scenarioSimulationModelContent.getModel());
        Assert.assertNotNull((Object)scenarioSimulationModelContent.getOverview());
        ((ScenarioSimulationServiceImpl)Mockito.verify((Object)this.serviceSpy, (VerificationMode)Mockito.times((int)1))).constructContent((org.uberfire.backend.vfs.Path)Matchers.eq((Object)this.path), (Overview)Matchers.isA(Overview.class));
        ((DMNTypeService)Mockito.verify((Object)this.dmnTypeServiceMock, (VerificationMode)Mockito.times((int)1))).initializeNameAndNamespace((Settings)Matchers.isA(Settings.class), (org.uberfire.backend.vfs.Path)Matchers.eq((Object)this.path), (String)Matchers.any());
        ((Event)Mockito.verify(this.resourceOpenedEvent)).fire(Matchers.any(ResourceOpenedEvent.class));
    }
}

