/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.backend.server;

import java.util.HashSet;
import java.util.List;
import javax.inject.Named;
import org.drools.scenariosimulation.api.model.Background;
import org.drools.scenariosimulation.api.model.ScenarioSimulationModel;
import org.drools.scenariosimulation.api.model.Settings;
import org.drools.scenariosimulation.api.model.Simulation;
import org.drools.scenariosimulation.backend.util.ImpossibleToFindDMNException;
import org.drools.workbench.screens.scenariosimulation.backend.server.ScenarioRunnerServiceImpl;
import org.drools.workbench.screens.scenariosimulation.backend.server.ScenarioSimulationServiceImpl;
import org.drools.workbench.screens.scenariosimulation.backend.server.util.ScenarioSimulationBuilder;
import org.drools.workbench.screens.scenariosimulation.service.DMNTypeService;
import org.guvnor.common.services.backend.config.SafeSessionInfo;
import org.guvnor.common.services.backend.metadata.MetadataServerSideService;
import org.guvnor.common.services.backend.util.CommentedOptionFactory;
import org.guvnor.common.services.project.model.Dependencies;
import org.guvnor.common.services.project.model.Dependency;
import org.guvnor.common.services.project.model.GAV;
import org.guvnor.common.services.project.model.Module;
import org.guvnor.common.services.project.model.POM;
import org.guvnor.common.services.project.model.Package;
import org.guvnor.common.services.project.service.POMService;
import org.guvnor.common.services.shared.metadata.model.Metadata;
import org.jboss.errai.security.shared.api.identity.User;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.services.backend.service.KieServiceOverviewLoader;
import org.kie.workbench.common.services.shared.project.KieModule;
import org.kie.workbench.common.services.shared.project.KieModuleService;
import org.mockito.ArgumentMatchers;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.backend.vfs.PathFactory;
import org.uberfire.ext.editor.commons.backend.service.SaveAndRenameServiceImpl;
import org.uberfire.ext.editor.commons.backend.version.PathResolver;
import org.uberfire.ext.editor.commons.service.CopyService;
import org.uberfire.ext.editor.commons.service.DeleteService;
import org.uberfire.ext.editor.commons.service.RenameService;
import org.uberfire.ext.editor.commons.service.support.SupportsSaveAndRename;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.DeleteOption;
import org.uberfire.java.nio.file.FileAlreadyExistsException;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.rpc.SessionInfo;

@RunWith(value=MockitoJUnitRunner.class)
public class ScenarioSimulationServiceImplTest {
    private static final String ORG_DROOLS = "org.drools";
    private static final String ORG_KIE = "org.kie";
    private static final String ORG_JBPM = "org.jbpm";
    @Mock
    protected KieServiceOverviewLoader overviewLoaderMock;
    @Mock
    protected MetadataServerSideService metadataServiceMock;
    @Mock
    @Named(value="ioStrategy")
    private IOService ioServiceMock;
    @Mock
    private CommentedOptionFactory commentedOptionFactoryMock;
    @Mock
    private SaveAndRenameServiceImpl<ScenarioSimulationModel, Metadata> saveAndRenameServiceMock;
    @Mock
    private PathResolver pathResolverMock;
    @Mock
    private DeleteService deleteServiceMock;
    @Mock
    private RenameService renameServiceMock;
    @Mock
    private CopyService copyServiceMock;
    @Mock
    private User userMock;
    @Mock
    private ScenarioRunnerServiceImpl scenarioRunnerServiceMock;
    @Mock
    private POMService pomServiceMock;
    @Mock
    private Path activatorPathMock;
    @Mock
    private KieModuleService kieModuleServiceMock;
    @Mock
    private KieModule kieModuleMock;
    @Mock
    private POM projectPomMock;
    @Mock
    private GAV gavMock;
    @Mock
    private Dependencies dependenciesMock;
    @Mock
    private Package packageMock;
    @Mock
    private ScenarioSimulationBuilder scenarioSimulationBuilderMock;
    @Mock
    private DMNTypeService dmnTypeServiceMock;
    @InjectMocks
    private ScenarioSimulationServiceImpl service = new ScenarioSimulationServiceImpl((SessionInfo)Mockito.mock(SafeSessionInfo.class)){

        protected ScenarioSimulationModel unmarshalInternal(String content) {
            Simulation simulation = new Simulation();
            Settings settings = new Settings();
            settings.setType(ScenarioSimulationModel.Type.DMN);
            ScenarioSimulationModel toReturn = new ScenarioSimulationModel();
            toReturn.setSimulation(simulation);
            toReturn.setSettings(settings);
            return toReturn;
        }
    };
    private org.uberfire.backend.vfs.Path path = PathFactory.newPath((String)"contextPath", (String)"file:///contextPath");

    @Before
    public void setup() {
        HashSet<Package> testPackages = new HashSet<Package>();
        Package testPackage = new Package(this.path, this.path, this.path, this.path, this.path, "Test", "", "");
        testPackages.add(testPackage);
        Mockito.when((Object)this.kieModuleServiceMock.resolveModule((org.uberfire.backend.vfs.Path)ArgumentMatchers.any())).thenReturn((Object)this.kieModuleMock);
        Mockito.when((Object)this.kieModuleServiceMock.resolvePackages((Module)Mockito.any())).thenReturn(testPackages);
        Mockito.when((Object)this.kieModuleServiceMock.newPackage((Package)ArgumentMatchers.any(), (String)ArgumentMatchers.any())).thenReturn((Object)testPackage);
        Mockito.when((Object)this.kieModuleServiceMock.resolveDefaultPackage((Module)ArgumentMatchers.any())).thenReturn((Object)testPackage);
        Mockito.when((Object)this.kieModuleServiceMock.resolveModule((org.uberfire.backend.vfs.Path)ArgumentMatchers.any())).thenReturn((Object)this.kieModuleMock);
        Mockito.when((Object)this.kieModuleMock.getPom()).thenReturn((Object)this.projectPomMock);
        Mockito.when((Object)this.projectPomMock.getGav()).thenReturn((Object)this.gavMock);
        Mockito.when((Object)this.gavMock.getGroupId()).thenReturn((Object)"Test");
        Mockito.when((Object)this.projectPomMock.getDependencies()).thenReturn((Object)this.dependenciesMock);
        Mockito.when((Object)this.dependenciesMock.iterator()).thenReturn((Object)new Dependencies().iterator());
        Mockito.when((Object)this.ioServiceMock.exists((Path)ArgumentMatchers.any())).thenReturn((Object)false);
        Mockito.when((Object)this.packageMock.getPackageTestSrcPath()).thenReturn((Object)this.path);
        Mockito.when((Object)this.scenarioSimulationBuilderMock.createSimulation((org.uberfire.backend.vfs.Path)ArgumentMatchers.any(), (ScenarioSimulationModel.Type)ArgumentMatchers.any(), (String)ArgumentMatchers.any())).thenReturn((Object)new Simulation());
        Mockito.when((Object)this.scenarioSimulationBuilderMock.createBackground((org.uberfire.backend.vfs.Path)ArgumentMatchers.any(), (ScenarioSimulationModel.Type)ArgumentMatchers.any(), (String)ArgumentMatchers.any())).thenReturn((Object)new Background());
        Mockito.when((Object)this.scenarioSimulationBuilderMock.createSettings((org.uberfire.backend.vfs.Path)ArgumentMatchers.any(), (ScenarioSimulationModel.Type)ArgumentMatchers.any(), (String)ArgumentMatchers.any())).thenReturn((Object)new Settings());
        this.service.scenarioSimulationBuilder = this.scenarioSimulationBuilderMock;
    }

    @Test
    public void init() {
        this.service.init();
        ((SaveAndRenameServiceImpl)Mockito.verify(this.saveAndRenameServiceMock)).init((SupportsSaveAndRename)this.service);
    }

    @Test
    public void delete() {
        this.service.delete(this.path, "Removing this");
        ((DeleteService)Mockito.verify((Object)this.deleteServiceMock)).delete(this.path, "Removing this");
    }

    @Test
    public void rename() {
        this.service.rename(this.path, "newName.scesim", "comment");
        ((RenameService)Mockito.verify((Object)this.renameServiceMock)).rename(this.path, "newName.scesim", "comment");
    }

    @Test
    public void copy() throws Exception {
        this.service.copy(this.path, "newName.scesim", "comment");
        ((CopyService)Mockito.verify((Object)this.copyServiceMock)).copy(this.path, "newName.scesim", "comment");
    }

    @Test
    public void copyToDirectory() {
        org.uberfire.backend.vfs.Path folder = (org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class);
        this.service.copy(this.path, "newName.scesim", folder, "comment");
        ((CopyService)Mockito.verify((Object)this.copyServiceMock)).copy(this.path, "newName.scesim", folder, "comment");
    }

    @Test
    public void saveAndRename() {
        Metadata metadata = (Metadata)Mockito.mock(Metadata.class);
        ScenarioSimulationModel model = new ScenarioSimulationModel();
        this.service.saveAndRename(this.path, "newName.scesim", metadata, model, "comment");
        ((SaveAndRenameServiceImpl)Mockito.verify(this.saveAndRenameServiceMock)).saveAndRename(this.path, "newName.scesim", (Object)metadata, (Object)model, "comment");
    }

    @Test
    public void save() {
        org.uberfire.backend.vfs.Path returnPath = this.service.save(this.path, new ScenarioSimulationModel(), new Metadata(), "Commit comment");
        Assert.assertNotNull((Object)returnPath);
        ((IOService)Mockito.verify((Object)this.ioServiceMock)).write((Path)ArgumentMatchers.any(Path.class), ArgumentMatchers.anyString(), ArgumentMatchers.anyMap(), (OpenOption[])ArgumentMatchers.any());
    }

    @Test
    public void createRULEScenario() {
        ((IOService)Mockito.doReturn((Object)false).when((Object)this.ioServiceMock)).exists((Path)ArgumentMatchers.any());
        ScenarioSimulationModel model = new ScenarioSimulationModel();
        Assert.assertNull((Object)model.getSimulation());
        Assert.assertNull((Object)model.getBackground());
        Assert.assertNull((Object)model.getSettings());
        org.uberfire.backend.vfs.Path returnPath = this.service.create(this.path, "test.scesim", model, "Commit comment", ScenarioSimulationModel.Type.RULE, null);
        Assert.assertNotNull((Object)returnPath);
        Assert.assertNotNull((Object)model.getSimulation());
        Assert.assertNotNull((Object)model.getBackground());
        Assert.assertNotNull((Object)model.getSettings());
        ((IOService)Mockito.verify((Object)this.ioServiceMock, (VerificationMode)Mockito.times((int)2))).write((Path)ArgumentMatchers.any(Path.class), ArgumentMatchers.anyString(), (OpenOption[])ArgumentMatchers.any());
    }

    @Test
    public void createDMNScenario() {
        ((IOService)Mockito.doReturn((Object)false).when((Object)this.ioServiceMock)).exists((Path)ArgumentMatchers.any());
        ScenarioSimulationModel model = new ScenarioSimulationModel();
        Assert.assertNull((Object)model.getSimulation());
        Assert.assertNull((Object)model.getBackground());
        Assert.assertNull((Object)model.getSettings());
        org.uberfire.backend.vfs.Path returnPath = this.service.create(this.path, "test.scesim", model, "Commit comment", ScenarioSimulationModel.Type.DMN, "test");
        Assert.assertNotNull((Object)returnPath);
        Assert.assertNotNull((Object)model.getSimulation());
        Assert.assertNotNull((Object)model.getBackground());
        Assert.assertNotNull((Object)model.getSettings());
        ((IOService)Mockito.verify((Object)this.ioServiceMock, (VerificationMode)Mockito.times((int)2))).write((Path)ArgumentMatchers.any(Path.class), ArgumentMatchers.anyString(), (OpenOption[])ArgumentMatchers.any());
    }

    @Test(expected=FileAlreadyExistsException.class)
    public void createFileExists() throws Exception {
        ((IOService)Mockito.doReturn((Object)true).when((Object)this.ioServiceMock)).exists((Path)ArgumentMatchers.any());
        ScenarioSimulationModel model = new ScenarioSimulationModel();
        this.service.create(this.path, "test.scesim", model, "Commit comment");
    }

    @Test
    public void runScenario() throws Exception {
        ((User)Mockito.doReturn((Object)"test userMock").when((Object)this.userMock)).getIdentifier();
        org.uberfire.backend.vfs.Path path = (org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class);
        Simulation simulation = new Simulation();
        Settings settings = new Settings();
        Background background = new Background();
        this.service.runScenario(path, simulation.getScesimModelDescriptor(), simulation.getScenarioWithIndex(), settings, background);
        ((ScenarioRunnerServiceImpl)Mockito.verify((Object)this.scenarioRunnerServiceMock)).runTest("test userMock", path, simulation.getScesimModelDescriptor(), simulation.getScenarioWithIndex(), settings, background);
    }

    @Test
    public void createActivatorIfNotExistTest() {
        this.service.createActivatorIfNotExist(this.path);
        ((IOService)Mockito.verify((Object)this.ioServiceMock, (VerificationMode)Mockito.times((int)1))).write((Path)ArgumentMatchers.any(Path.class), ArgumentMatchers.anyString(), (OpenOption[])ArgumentMatchers.any());
        Mockito.reset((Object[])new IOService[]{this.ioServiceMock});
        Mockito.when((Object)this.ioServiceMock.exists((Path)ArgumentMatchers.any())).thenReturn((Object)true);
        this.service.createActivatorIfNotExist(this.path);
        ((IOService)Mockito.verify((Object)this.ioServiceMock, (VerificationMode)Mockito.never())).write((Path)ArgumentMatchers.any(Path.class), ArgumentMatchers.anyString(), (OpenOption[])ArgumentMatchers.any());
    }

    @Test
    public void getOrCreateJunitActivatorPackageTest() {
        this.service.getOrCreateJunitActivatorPackage(this.kieModuleMock);
        ((KieModuleService)Mockito.verify((Object)this.kieModuleServiceMock, (VerificationMode)Mockito.times((int)1))).newPackage((Package)ArgumentMatchers.any(), ArgumentMatchers.anyString());
        Mockito.reset((Object[])new KieModuleService[]{this.kieModuleServiceMock});
        Mockito.when((Object)this.kieModuleServiceMock.resolveDefaultPackage((Module)ArgumentMatchers.any())).thenReturn((Object)this.packageMock);
        Mockito.when((Object)this.kieModuleServiceMock.resolvePackage((org.uberfire.backend.vfs.Path)ArgumentMatchers.any())).thenReturn((Object)this.packageMock);
        this.service.getOrCreateJunitActivatorPackage(this.kieModuleMock);
        ((KieModuleService)Mockito.verify((Object)this.kieModuleServiceMock, (VerificationMode)Mockito.never())).newPackage((Package)ArgumentMatchers.any(), ArgumentMatchers.anyString());
    }

    @Test
    public void removeOldActivatorIfExistsTest() {
        Path existingActivatorPathMock = (Path)Mockito.mock(Path.class);
        this.service.removeOldActivatorIfExists(existingActivatorPathMock, this.kieModuleMock);
        ((IOService)Mockito.verify((Object)this.ioServiceMock, (VerificationMode)Mockito.times((int)2))).deleteIfExists((Path)ArgumentMatchers.any(), new DeleteOption[0]);
        Mockito.reset((Object[])new IOService[]{this.ioServiceMock});
        Mockito.when((Object)this.kieModuleServiceMock.resolvePackages((Module)ArgumentMatchers.any(KieModule.class))).thenReturn(new HashSet());
        this.service.removeOldActivatorIfExists(existingActivatorPathMock, this.kieModuleMock);
        ((IOService)Mockito.verify((Object)this.ioServiceMock, (VerificationMode)Mockito.times((int)1))).deleteIfExists(existingActivatorPathMock, new DeleteOption[0]);
    }

    @Test
    public void ensureDependenciesTest() {
        this.service.ensureDependencies(this.kieModuleMock);
        ((POMService)Mockito.verify((Object)this.pomServiceMock, (VerificationMode)Mockito.times((int)1))).save((org.uberfire.backend.vfs.Path)ArgumentMatchers.any(), ArgumentMatchers.any(POM.class), (Metadata)ArgumentMatchers.any(), ArgumentMatchers.anyString());
        Mockito.reset((Object[])new POMService[]{this.pomServiceMock});
        Mockito.when((Object)this.dependenciesMock.containsDependency((GAV)ArgumentMatchers.any())).thenReturn((Object)true);
        this.service.ensureDependencies(this.kieModuleMock);
        ((POMService)Mockito.verify((Object)this.pomServiceMock, (VerificationMode)Mockito.never())).save((org.uberfire.backend.vfs.Path)ArgumentMatchers.any(), ArgumentMatchers.any(POM.class), (Metadata)ArgumentMatchers.any(), ArgumentMatchers.anyString());
    }

    @Test
    public void removeFromPomIfNecessaryTest() {
        String groupId = "groupId";
        String artifactId = "artifactId";
        String version = "version";
        GAV toRemove = new GAV(groupId, artifactId, version);
        Dependencies dependencies = new Dependencies();
        dependencies.add(new Dependency(toRemove));
        Assert.assertTrue((boolean)this.service.removeFromPomIfNecessary(dependencies, toRemove));
        Assert.assertFalse((boolean)this.service.removeFromPomIfNecessary(dependencies, toRemove));
        dependencies.add(new Dependency(new GAV(groupId, artifactId, null)));
        Assert.assertTrue((boolean)this.service.removeFromPomIfNecessary(dependencies, toRemove));
        Assert.assertFalse((boolean)this.service.removeFromPomIfNecessary(dependencies, toRemove));
    }

    @Test
    public void editPomIfNecessaryTest() {
        String groupId = "groupId";
        String artifactId = "artifactId";
        String version = "version";
        GAV gav = new GAV(groupId, artifactId, version);
        Dependencies dependencies = new Dependencies();
        Assert.assertTrue((boolean)this.service.editPomIfNecessary(dependencies, gav));
        Assert.assertFalse((boolean)this.service.editPomIfNecessary(dependencies, gav));
    }

    @Test
    public void getActivatorPathTest() {
        Assert.assertTrue((boolean)this.service.getActivatorPath(this.packageMock).endsWith("ScenarioJunitActivatorTest.java"));
    }

    @Test
    public void load() {
        ScenarioSimulationModel model = this.service.load(this.path);
        Assert.assertEquals((Object)ScenarioSimulationModel.Type.DMN, (Object)model.getSettings().getType());
        ((DMNTypeService)Mockito.verify((Object)this.dmnTypeServiceMock, (VerificationMode)Mockito.times((int)1))).initializeNameAndNamespace((Settings)ArgumentMatchers.any(), (org.uberfire.backend.vfs.Path)ArgumentMatchers.any(), (String)ArgumentMatchers.any());
        ((DMNTypeService)Mockito.doThrow((Throwable[])new Throwable[]{new ImpossibleToFindDMNException("")}).when((Object)this.dmnTypeServiceMock)).initializeNameAndNamespace((Settings)ArgumentMatchers.any(), (org.uberfire.backend.vfs.Path)ArgumentMatchers.any(), (String)ArgumentMatchers.any());
        try {
            this.service.load(this.path);
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Test
    public void checkDependency() {
        GAV scesimApiDependency = new GAV(ORG_DROOLS, "drools-scenario-simulation-api", null);
        GAV scesimBackendDependency = new GAV(ORG_DROOLS, "drools-scenario-simulation-backend", null);
        GAV droolsCompilerDependency = new GAV(ORG_DROOLS, "drools-compiler", null);
        GAV gtableDependency = new GAV(ORG_DROOLS, "drools-workbench-models-guided-dtable", null);
        GAV jbpmBpmn2Dependency = new GAV(ORG_JBPM, "jbpm-bpmn2", null);
        GAV dmnFeelDependency = new GAV(ORG_KIE, "kie-dmn-feel", null);
        GAV dmnApi2Dependency = new GAV(ORG_KIE, "kie-dmn-api", null);
        GAV dmnCoreDependency = new GAV(ORG_KIE, "kie-dmn-core", null);
        List dependencies = this.service.getDependencies(null);
        Assert.assertEquals((long)8L, (long)dependencies.size());
        Assert.assertTrue((boolean)dependencies.contains(scesimApiDependency));
        Assert.assertTrue((boolean)dependencies.contains(scesimBackendDependency));
        Assert.assertTrue((boolean)dependencies.contains(droolsCompilerDependency));
        Assert.assertTrue((boolean)dependencies.contains(gtableDependency));
        Assert.assertTrue((boolean)dependencies.contains(jbpmBpmn2Dependency));
        Assert.assertTrue((boolean)dependencies.contains(dmnFeelDependency));
        Assert.assertTrue((boolean)dependencies.contains(dmnApi2Dependency));
        Assert.assertTrue((boolean)dependencies.contains(dmnCoreDependency));
    }
}

