/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.backend.server.importexport;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.drools.scenariosimulation.api.model.AbstractScesimModel;
import org.drools.scenariosimulation.api.model.ExpressionIdentifier;
import org.drools.scenariosimulation.api.model.FactIdentifier;
import org.drools.scenariosimulation.api.model.FactMapping;
import org.drools.scenariosimulation.api.model.FactMappingType;
import org.drools.scenariosimulation.api.model.FactMappingValue;
import org.drools.scenariosimulation.api.model.Scenario;
import org.drools.scenariosimulation.api.model.ScesimModelDescriptor;
import org.drools.scenariosimulation.api.model.Simulation;
import org.drools.workbench.screens.scenariosimulation.backend.server.importexport.ScenarioCsvImportExport;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ScenarioCsvImportExportTest {
    private static String instanceName = "instanceName";
    private static String propertyName = "propertyName";
    private CSVPrinter printer;
    private ScenarioCsvImportExport scenarioCsvImportExport;
    private StringBuilder output;

    @Before
    public void setup() throws IOException {
        this.output = new StringBuilder();
        this.printer = new CSVPrinter((Appendable)this.output, CSVFormat.EXCEL);
        this.scenarioCsvImportExport = new ScenarioCsvImportExport();
    }

    @Test
    public void exportData() throws IOException {
        int numberOfRow = 2;
        int numberOfColumn = 1;
        Simulation simulation = this.createDummySimulation(numberOfColumn, numberOfRow);
        List<String> exportData = Arrays.asList(this.scenarioCsvImportExport.exportData((AbstractScesimModel)simulation).split("\r\n"));
        Assert.assertEquals((long)(numberOfRow + 3), (long)exportData.size());
        Assert.assertEquals((Object)"1,My scenario 1,value_1_0", (Object)exportData.get(4));
    }

    @Test
    public void importData() throws IOException {
        Simulation originalSimulation = this.createDummySimulation(3, 1);
        Assert.assertEquals((long)1L, (long)originalSimulation.getUnmodifiableData().size());
        String rawCSV = "OTHER,OTHER,GIVEN,GIVEN,GIVEN\r\n#,Scenario description,instance1,instance2,instance3\r\nIndex,Description,property1,property2,property3\r\n1,My Scenario,value1,value2,";
        AbstractScesimModel retrieved = this.scenarioCsvImportExport.importData(rawCSV, (AbstractScesimModel)originalSimulation);
        Assert.assertEquals((long)1L, (long)retrieved.getUnmodifiableData().size());
        Assert.assertEquals((Object)"value1", (Object)((FactMappingValue)retrieved.getDataByIndex(0).getFactMappingValue(retrieved.getScesimModelDescriptor().getFactMappingByIndex(2)).get()).getRawValue());
        Assert.assertEquals((Object)"value2", (Object)((FactMappingValue)retrieved.getDataByIndex(0).getFactMappingValue(retrieved.getScesimModelDescriptor().getFactMappingByIndex(3)).get()).getRawValue());
        Assert.assertNull((Object)((FactMappingValue)retrieved.getDataByIndex(0).getFactMappingValue(retrieved.getScesimModelDescriptor().getFactMappingByIndex(4)).get()).getRawValue());
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.scenarioCsvImportExport.importData("", (AbstractScesimModel)originalSimulation)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Malformed file, missing header");
    }

    @Test
    public void generateHeader() throws IOException {
        ScesimModelDescriptor simulationDescriptor = new ScesimModelDescriptor();
        FactMapping test1FactMapping = this.createFactMapping(simulationDescriptor, 1);
        FactMapping test2FactMapping = this.createFactMapping(simulationDescriptor, 2);
        this.scenarioCsvImportExport.generateHeader(Arrays.asList(test1FactMapping, test2FactMapping), this.printer);
        System.out.println("output.toString() = " + this.output.toString());
        String[] result = this.output.toString().split("\r\n");
        Assert.assertEquals((long)3L, (long)result.length);
        Assert.assertEquals((Object)"GIVEN,GIVEN", (Object)result[0]);
        Assert.assertEquals((Object)(instanceName + 1 + "," + instanceName + 2), (Object)result[1]);
        Assert.assertEquals((Object)(propertyName + 1 + "," + propertyName + 2), (Object)result[2]);
    }

    private FactMapping createFactMapping(ScesimModelDescriptor simulationDescriptor, int number) {
        FactMapping toReturn = simulationDescriptor.addFactMapping(FactIdentifier.create((String)(instanceName + number), (String)String.class.getCanonicalName()), ExpressionIdentifier.create((String)(propertyName + number), (FactMappingType)FactMappingType.GIVEN));
        toReturn.setExpressionAlias(propertyName + number);
        return toReturn;
    }

    private Simulation createDummySimulation(int numberOfColumn, int numberOfRow) {
        Simulation simulation = new Simulation();
        ScesimModelDescriptor simulationDescriptor = simulation.getScesimModelDescriptor();
        simulationDescriptor.addFactMapping(FactIdentifier.INDEX, ExpressionIdentifier.INDEX).setExpressionAlias("Index");
        simulationDescriptor.addFactMapping(FactIdentifier.DESCRIPTION, ExpressionIdentifier.DESCRIPTION).setExpressionAlias("Description");
        for (int col = 0; col < numberOfColumn; ++col) {
            this.createFactMapping(simulationDescriptor, col);
        }
        for (int row = 0; row < numberOfRow; ++row) {
            Scenario scenario = (Scenario)simulation.addData();
            scenario.addMappingValue(FactIdentifier.INDEX, ExpressionIdentifier.INDEX, (Object)row);
            scenario.setDescription("My scenario " + row);
            for (int col = 2; col < numberOfColumn + 2; ++col) {
                FactMapping factMappingByIndex = simulationDescriptor.getFactMappingByIndex(col);
                scenario.addMappingValue(factMappingByIndex.getFactIdentifier(), factMappingByIndex.getExpressionIdentifier(), (Object)("value_" + row + "_" + (col - 2)));
            }
        }
        return simulation;
    }
}

