/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.backend.server;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.drools.scenariosimulation.api.model.ExpressionIdentifier;
import org.drools.scenariosimulation.api.model.FactIdentifier;
import org.drools.scenariosimulation.api.model.FactMapping;
import org.drools.scenariosimulation.api.model.FactMappingType;
import org.drools.scenariosimulation.api.model.ScenarioSimulationModel;
import org.drools.scenariosimulation.api.model.Settings;
import org.drools.scenariosimulation.api.model.Simulation;
import org.drools.workbench.screens.scenariosimulation.backend.server.AbstractScenarioValidationTest;
import org.drools.workbench.screens.scenariosimulation.backend.server.RULEScenarioValidation;
import org.drools.workbench.screens.scenariosimulation.backend.server.SampleBean;
import org.drools.workbench.screens.scenariosimulation.utils.ScenarioSimulationI18nServerMessage;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.api.runtime.KieContainer;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class RULEScenarioValidationTest
extends AbstractScenarioValidationTest {
    @Mock
    private KieContainer kieContainerMock;
    private Settings settingsLocal;

    @Before
    public void init() {
        this.settingsLocal = new Settings();
        this.settingsLocal.setType(ScenarioSimulationModel.Type.RULE);
        Mockito.when((Object)this.kieContainerMock.getClassLoader()).thenReturn((Object)Thread.currentThread().getContextClassLoader());
        Mockito.when((Object)this.kieContainerMock.getClassLoader()).thenReturn((Object)Thread.currentThread().getContextClassLoader());
    }

    @Test
    public void validate() {
        RULEScenarioValidation validation = new RULEScenarioValidation();
        Simulation test0 = new Simulation();
        test0.getScesimModelDescriptor().addFactMapping(FactIdentifier.DESCRIPTION, ExpressionIdentifier.create((String)"value", (FactMappingType)FactMappingType.OTHER));
        test0.getScesimModelDescriptor().addFactMapping(FactIdentifier.EMPTY, ExpressionIdentifier.create((String)"value", (FactMappingType)FactMappingType.GIVEN));
        List errorsTest0 = validation.validate(test0, this.settingsLocal, this.kieContainerMock);
        this.checkResult(errorsTest0, new AbstractScenarioValidationTest.ExpectedError[0]);
        Simulation test1 = new Simulation();
        test1.getScesimModelDescriptor().addFactMapping(FactIdentifier.create((String)"mySimpleType", (String)Integer.TYPE.getCanonicalName()), ExpressionIdentifier.create((String)"value", (FactMappingType)FactMappingType.GIVEN));
        List errorsTest1 = validation.validate(test1, this.settingsLocal, this.kieContainerMock);
        this.checkResult(errorsTest1, new AbstractScenarioValidationTest.ExpectedError[0]);
        FactMapping mySimpleType = test1.getScesimModelDescriptor().addFactMapping(FactIdentifier.create((String)"mySimpleType", (String)"notValidClass"), ExpressionIdentifier.create((String)"value", (FactMappingType)FactMappingType.GIVEN));
        mySimpleType.addExpressionElement("notValidClass", "notValidClass");
        errorsTest1 = validation.validate(test1, this.settingsLocal, this.kieContainerMock);
        this.checkResult(errorsTest1, new AbstractScenarioValidationTest.ExpectedError("Impossible to load class notValidClass"));
        Simulation test2 = new Simulation();
        FactIdentifier myFactIdentifier = FactIdentifier.create((String)"mySimpleType", (String)SampleBean.class.getCanonicalName());
        FactMapping nameFM = test2.getScesimModelDescriptor().addFactMapping(myFactIdentifier, ExpressionIdentifier.create((String)"name", (FactMappingType)FactMappingType.GIVEN));
        nameFM.addExpressionElement("SampleBean", String.class.getCanonicalName());
        nameFM.addExpressionElement("name", String.class.getCanonicalName());
        FactMapping parentFM = test2.getScesimModelDescriptor().addFactMapping(myFactIdentifier, ExpressionIdentifier.create((String)"parent", (FactMappingType)FactMappingType.EXPECT));
        parentFM.addExpressionElement("SampleBean", SampleBean.class.getCanonicalName());
        parentFM.addExpressionElement("parent", SampleBean.class.getCanonicalName());
        List errorsTest2 = validation.validate(test2, this.settingsLocal, this.kieContainerMock);
        this.checkResult(errorsTest2, new AbstractScenarioValidationTest.ExpectedError[0]);
        parentFM.addExpressionElement("notExisting", String.class.getCanonicalName());
        errorsTest2 = validation.validate(test2, this.settingsLocal, this.kieContainerMock);
        this.checkResult(errorsTest2, new AbstractScenarioValidationTest.ExpectedError("Impossible to find field with name 'notExisting' in class org.drools.workbench.screens.scenariosimulation.backend.server.SampleBean"));
        FactMapping nameWrongTypeFM = test2.getScesimModelDescriptor().addFactMapping(myFactIdentifier, ExpressionIdentifier.create((String)"parent2", (FactMappingType)FactMappingType.EXPECT));
        nameWrongTypeFM.addExpressionElement("SampleBean", Integer.class.getCanonicalName());
        nameWrongTypeFM.addExpressionElement("name", Integer.class.getCanonicalName());
        errorsTest2 = validation.validate(test2, this.settingsLocal, this.kieContainerMock);
        this.checkResult(errorsTest2, new AbstractScenarioValidationTest.ExpectedError("Impossible to find field with name 'notExisting' in class org.drools.workbench.screens.scenariosimulation.backend.server.SampleBean"), new AbstractScenarioValidationTest.ExpectedError(ScenarioSimulationI18nServerMessage.SCENARIO_VALIDATION_FIELD_CHANGED_ERROR, Arrays.asList("java.lang.Integer", "java.lang.String")));
        Simulation test3 = new Simulation();
        FactMapping topLevelListFM = test3.getScesimModelDescriptor().addFactMapping(FactIdentifier.create((String)"mySimpleType", (String)List.class.getCanonicalName()), ExpressionIdentifier.create((String)"name", (FactMappingType)FactMappingType.GIVEN));
        topLevelListFM.addExpressionElement("List", List.class.getCanonicalName());
        topLevelListFM.setGenericTypes(Collections.singletonList(String.class.getCanonicalName()));
        FactMapping addressesFM = test3.getScesimModelDescriptor().addFactMapping(myFactIdentifier, ExpressionIdentifier.create((String)"addresses", (FactMappingType)FactMappingType.EXPECT));
        addressesFM.addExpressionElement("SampleBean", List.class.getCanonicalName());
        addressesFM.addExpressionElement("addresses", List.class.getCanonicalName());
        addressesFM.setGenericTypes(Collections.singletonList(String.class.getCanonicalName()));
        List errorsTest3 = validation.validate(test3, this.settingsLocal, this.kieContainerMock);
        this.checkResult(errorsTest3, new AbstractScenarioValidationTest.ExpectedError[0]);
    }
}

