/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.backend.server;

import java.util.Collections;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.drools.scenariosimulation.api.model.ExpressionIdentifier;
import org.drools.scenariosimulation.api.model.FactIdentifier;
import org.drools.scenariosimulation.api.model.FactMapping;
import org.drools.scenariosimulation.api.model.FactMappingType;
import org.drools.scenariosimulation.api.model.ScenarioSimulationModel;
import org.drools.scenariosimulation.api.model.Settings;
import org.drools.scenariosimulation.api.model.Simulation;
import org.drools.workbench.screens.scenariosimulation.backend.server.ScenarioValidationService;
import org.drools.workbench.screens.scenariosimulation.model.FactMappingValidationError;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.api.runtime.KieContainer;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.backend.vfs.Path;

@RunWith(value=MockitoJUnitRunner.class)
public class ScenarioValidationServiceTest {
    @Mock
    private KieContainer kieContainerMock;
    @Mock
    private Path pathMock;

    @Test
    public void validateSimulationStructure() {
        Simulation simulation = new Simulation();
        Settings settings = new Settings();
        ScenarioValidationService scenarioValidationServiceSpy = (ScenarioValidationService)Mockito.spy((Object)new ScenarioValidationService(){

            protected List<FactMappingValidationError> validateDMN(Simulation simulation, Settings settings, KieContainer kieContainer) {
                return Collections.emptyList();
            }

            protected List<FactMappingValidationError> validateRULE(Simulation simulation, Settings settings, KieContainer kieContainer) {
                return Collections.emptyList();
            }

            protected KieContainer getKieContainer(Path path) {
                return ScenarioValidationServiceTest.this.kieContainerMock;
            }
        });
        settings.setType(ScenarioSimulationModel.Type.DMN);
        scenarioValidationServiceSpy.validateSimulationStructure(simulation, settings, this.pathMock);
        ((ScenarioValidationService)Mockito.verify((Object)scenarioValidationServiceSpy, (VerificationMode)Mockito.never())).validateDMN((Simulation)Matchers.eq((Object)simulation), (Settings)Matchers.eq((Object)settings), (KieContainer)Matchers.eq((Object)this.kieContainerMock));
        ((ScenarioValidationService)Mockito.verify((Object)scenarioValidationServiceSpy, (VerificationMode)Mockito.never())).validateRULE((Simulation)Matchers.eq((Object)simulation), (Settings)Matchers.eq((Object)settings), (KieContainer)Matchers.eq((Object)this.kieContainerMock));
        Mockito.reset((Object[])new ScenarioValidationService[]{scenarioValidationServiceSpy});
        FactMapping sampleFactMapping = simulation.getScesimModelDescriptor().addFactMapping(FactIdentifier.create((String)"sample", (String)String.class.getCanonicalName()), ExpressionIdentifier.create((String)"sample", (FactMappingType)FactMappingType.GIVEN));
        sampleFactMapping.addExpressionElement("sample", String.class.getCanonicalName());
        settings.setType(ScenarioSimulationModel.Type.DMN);
        scenarioValidationServiceSpy.validateSimulationStructure(simulation, settings, this.pathMock);
        ((ScenarioValidationService)Mockito.verify((Object)scenarioValidationServiceSpy, (VerificationMode)Mockito.timeout((long)1L))).validateDMN((Simulation)Matchers.eq((Object)simulation), (Settings)Matchers.eq((Object)settings), (KieContainer)Matchers.eq((Object)this.kieContainerMock));
        Mockito.reset((Object[])new ScenarioValidationService[]{scenarioValidationServiceSpy});
        settings.setType(ScenarioSimulationModel.Type.RULE);
        scenarioValidationServiceSpy.validateSimulationStructure(simulation, settings, this.pathMock);
        ((ScenarioValidationService)Mockito.verify((Object)scenarioValidationServiceSpy, (VerificationMode)Mockito.timeout((long)1L))).validateRULE((Simulation)Matchers.eq((Object)simulation), (Settings)Matchers.eq((Object)settings), (KieContainer)Matchers.eq((Object)this.kieContainerMock));
        settings.setType(null);
        Assertions.assertThatThrownBy(() -> scenarioValidationServiceSpy.validateSimulationStructure(simulation, settings, this.pathMock)).isInstanceOf(IllegalArgumentException.class);
    }
}

