/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.businesscentral.client.editor.strategies;

import java.util.Arrays;
import java.util.List;
import java.util.SortedMap;
import org.drools.workbench.screens.scenariosimulation.client.commands.ScenarioSimulationContext;
import org.drools.workbench.screens.scenariosimulation.client.editor.strategies.AbstractDMODataManagementStrategy;
import org.drools.workbench.screens.scenariosimulation.client.models.ScenarioGridModel;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.TestToolsView;
import org.drools.workbench.screens.scenariosimulation.model.ScenarioSimulationModelContent;
import org.drools.workbench.screens.scenariosimulation.model.typedescriptor.FactModelTree;
import org.kie.soup.project.datamodel.imports.HasImports;
import org.kie.soup.project.datamodel.oracle.ModelField;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracle;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracleFactory;
import org.uberfire.backend.vfs.ObservablePath;
import org.uberfire.backend.vfs.Path;
import org.uberfire.client.callbacks.Callback;

public class BusinessCentralDMODataManagementStrategy
extends AbstractDMODataManagementStrategy {
    private AsyncPackageDataModelOracleFactory oracleFactory;
    protected AsyncPackageDataModelOracle oracle;

    public BusinessCentralDMODataManagementStrategy(AsyncPackageDataModelOracleFactory oracleFactory, ScenarioSimulationContext scenarioSimulationContext) {
        this.oracleFactory = oracleFactory;
        this.scenarioSimulationContext = scenarioSimulationContext;
    }

    public void manageScenarioSimulationModelContent(ObservablePath currentPath, ScenarioSimulationModelContent toManage) {
        this.model = toManage.getModel();
        this.oracle = this.oracleFactory.makeAsyncPackageDataModelOracle((Path)currentPath, (HasImports)this.model, toManage.getDataModel());
    }

    public boolean isADataType(String value) {
        return this.oracle != null && Arrays.asList(this.oracle.getFactTypes()).contains(value);
    }

    public AsyncPackageDataModelOracle getOracle() {
        return this.oracle;
    }

    protected Callback<ModelField[]> fieldCompletionsCallback(String factName, Callback<FactModelTree> aggregatorCallback) {
        return result -> this.fieldCompletionsCallbackMethod(factName, (ModelField[])result, aggregatorCallback);
    }

    protected void fieldCompletionsCallbackMethod(String factName, ModelField[] result, Callback<FactModelTree> aggregatorCallback) {
        FactModelTree toSend = this.getFactModelTree(factName, result);
        aggregatorCallback.callback((Object)toSend);
    }

    protected Callback<FactModelTree> aggregatorCallback(TestToolsView.Presenter testToolsPresenter, int expectedElements, SortedMap<String, FactModelTree> factTypeFieldsMap, ScenarioGridModel scenarioGridModel, List<String> simpleJavaTypes) {
        return result -> this.aggregatorCallbackMethod(testToolsPresenter, expectedElements, factTypeFieldsMap, scenarioGridModel, (FactModelTree)result, simpleJavaTypes);
    }

    protected void manageDataObjects(List<String> dataObjectsTypes, TestToolsView.Presenter testToolsPresenter, int expectedElements, SortedMap<String, FactModelTree> dataObjectsFieldsMap, ScenarioGridModel scenarioGridModel, List<String> simpleJavaTypes) {
        Callback<FactModelTree> aggregatorCallback = this.aggregatorCallback(testToolsPresenter, expectedElements, dataObjectsFieldsMap, scenarioGridModel, simpleJavaTypes);
        dataObjectsTypes.forEach(factType -> this.oracle.getFieldCompletions(factType, this.fieldCompletionsCallback((String)factType, aggregatorCallback)));
    }

    protected List<String> getFactTypes() {
        return Arrays.asList(this.oracle.getFactTypes());
    }

    protected boolean skipPopulateTestTools() {
        return this.oracle == null || this.oracle.getFactTypes().length == 0;
    }

    protected String getFQCNByFactName(String factName) {
        return this.oracle.getFQCNByFactName(factName);
    }

    protected String getParametricFieldType(String factName, String propertyName) {
        return this.oracle.getParametricFieldType(factName, propertyName);
    }
}

