/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.businesscentral.client.editor;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.drools.scenariosimulation.api.model.Scenario;
import org.drools.scenariosimulation.api.model.ScenarioSimulationModel;
import org.drools.scenariosimulation.api.model.ScenarioWithIndex;
import org.drools.scenariosimulation.api.model.Simulation;
import org.drools.scenariosimulation.api.model.SimulationDescriptor;
import org.drools.workbench.screens.scenariosimulation.businesscentral.client.editor.ScenarioSimulationEditorBusinessCentralWrapper;
import org.drools.workbench.screens.scenariosimulation.client.editor.AbstractScenarioSimulationEditorTest;
import org.drools.workbench.screens.scenariosimulation.client.editor.ScenarioSimulationEditorPresenter;
import org.drools.workbench.screens.scenariosimulation.client.editor.ScenarioSimulationEditorWrapper;
import org.drools.workbench.screens.scenariosimulation.client.editor.ScenarioSimulationView;
import org.drools.workbench.screens.scenariosimulation.client.editor.strategies.DataManagementStrategy;
import org.drools.workbench.screens.scenariosimulation.client.handlers.ScenarioSimulationHasBusyIndicatorDefaultErrorCallback;
import org.drools.workbench.screens.scenariosimulation.client.type.ScenarioSimulationResourceType;
import org.drools.workbench.screens.scenariosimulation.service.ImportExportService;
import org.drools.workbench.screens.scenariosimulation.service.ImportExportType;
import org.drools.workbench.screens.scenariosimulation.service.ScenarioSimulationService;
import org.guvnor.common.services.shared.metadata.model.Metadata;
import org.guvnor.messageconsole.client.console.widget.button.AlertsButtonMenuItemBuilder;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.soup.project.datamodel.imports.Imports;
import org.kie.workbench.common.widgets.client.callbacks.CommandDrivenErrorCallback;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracle;
import org.kie.workbench.common.widgets.client.docks.DefaultEditorDock;
import org.kie.workbench.common.widgets.client.menu.FileMenuBuilder;
import org.kie.workbench.common.widgets.configresource.client.widget.bound.ImportsWidgetPresenter;
import org.kie.workbench.common.widgets.metadata.client.KieEditorWrapperView;
import org.kie.workbench.common.widgets.metadata.client.widget.OverviewWidgetPresenter;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.backend.vfs.ObservablePath;
import org.uberfire.backend.vfs.Path;
import org.uberfire.client.mvp.PerspectiveManager;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.mvp.PlaceStatus;
import org.uberfire.client.promise.Promises;
import org.uberfire.ext.editor.commons.client.history.VersionRecordManager;
import org.uberfire.ext.editor.commons.client.validation.DefaultFileNameValidator;
import org.uberfire.ext.widgets.common.client.callbacks.HasBusyIndicatorDefaultErrorCallback;
import org.uberfire.mocks.CallerMock;
import org.uberfire.mocks.EventSourceMock;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;
import org.uberfire.mvp.impl.PathPlaceRequest;
import org.uberfire.promise.SyncPromises;
import org.uberfire.workbench.events.NotificationEvent;
import org.uberfire.workbench.model.menu.MenuItem;

@RunWith(value=GwtMockitoTestRunner.class)
public class ScenarioSimulationEditorBusinessCentralWrapperTest
extends AbstractScenarioSimulationEditorTest {
    @Mock
    private PathPlaceRequest placeRequestMock;
    @Mock
    private ScenarioSimulationEditorPresenter scenarioSimulationEditorPresenter;
    @Mock
    private ScenarioSimulationResourceType scenarioSimulationResourceType;
    @Mock
    private KieEditorWrapperView kieViewMock;
    @Mock
    private ImportsWidgetPresenter importsWidgetPresenterMock;
    @Mock
    private PlaceManager placeManagerMock;
    @Mock
    private AlertsButtonMenuItemBuilder alertsButtonMenuItemBuilderMock;
    @Mock
    private OverviewWidgetPresenter overviewWidgetPresenterMock;
    @Mock
    private EventSourceMock<NotificationEvent> notificationMock;
    @Mock
    private DefaultFileNameValidator fileNameValidatorMock;
    @Mock
    private DefaultEditorDock docksMock;
    @Mock
    private PerspectiveManager perspectiveManagerMock;
    @Mock
    private Command populateTestToolsCommand;
    @Mock
    private MenuItem versionRecordMenuItemMock;
    @Mock
    private MenuItem alertsButtonMenuItemMock;
    @Mock
    private Metadata metaDataMock;
    private CallerMock<ScenarioSimulationService> scenarioSimulationCaller;
    private CallerMock<ImportExportService> importExportCaller;
    private Promises promises;
    private ScenarioSimulationEditorBusinessCentralWrapper scenarioSimulationEditorBusinessClientWrapper;

    @Before
    public void setup() {
        super.setup();
        this.promises = new SyncPromises();
        this.scenarioSimulationCaller = (CallerMock)Mockito.spy((Object)new CallerMock((Object)this.scenarioSimulationServiceMock));
        this.importExportCaller = (CallerMock)Mockito.spy((Object)new CallerMock((Object)this.importExportServiceMock));
        this.scenarioSimulationEditorBusinessClientWrapper = (ScenarioSimulationEditorBusinessCentralWrapper)Mockito.spy((Object)new ScenarioSimulationEditorBusinessCentralWrapper((Caller)this.scenarioSimulationCaller, this.scenarioSimulationEditorPresenter, this.importsWidgetPresenterMock, this.oracleFactoryMock, this.placeManagerMock, (Caller)new CallerMock((Object)this.dmnTypeServiceMock), (Caller)this.importExportCaller){
            {
                this.kieView = ScenarioSimulationEditorBusinessCentralWrapperTest.this.kieViewMock;
                this.overviewWidget = ScenarioSimulationEditorBusinessCentralWrapperTest.this.overviewWidgetPresenterMock;
                this.fileMenuBuilder = ScenarioSimulationEditorBusinessCentralWrapperTest.this.fileMenuBuilderMock;
                this.fileNameValidator = ScenarioSimulationEditorBusinessCentralWrapperTest.this.fileNameValidatorMock;
                this.versionRecordManager = ScenarioSimulationEditorBusinessCentralWrapperTest.this.versionRecordManagerMock;
                this.notification = ScenarioSimulationEditorBusinessCentralWrapperTest.this.notificationMock;
                this.workbenchContext = ScenarioSimulationEditorBusinessCentralWrapperTest.this.workbenchContextMock;
                this.alertsButtonMenuItemBuilder = ScenarioSimulationEditorBusinessCentralWrapperTest.this.alertsButtonMenuItemBuilderMock;
                this.docks = ScenarioSimulationEditorBusinessCentralWrapperTest.this.docksMock;
                this.perspectiveManager = ScenarioSimulationEditorBusinessCentralWrapperTest.this.perspectiveManagerMock;
                this.baseView = ScenarioSimulationEditorBusinessCentralWrapperTest.this.scenarioSimulationViewMock;
                this.promises = ScenarioSimulationEditorBusinessCentralWrapperTest.this.promises;
                this.metadata = ScenarioSimulationEditorBusinessCentralWrapperTest.this.metaDataMock;
            }
        });
        Mockito.when((Object)this.placeRequestMock.getPath()).thenReturn((Object)this.observablePathMock);
        Mockito.when((Object)this.scenarioSimulationEditorPresenter.getType()).thenReturn((Object)this.scenarioSimulationResourceType);
        Mockito.when((Object)this.scenarioSimulationEditorPresenter.getPopulateTestToolsCommand()).thenReturn((Object)this.populateTestToolsCommand);
        Mockito.when((Object)this.scenarioSimulationEditorPresenter.getJsonModel((ScenarioSimulationModel)Matchers.any())).thenReturn((Object)"");
        Mockito.when((Object)this.scenarioSimulationEditorPresenter.getView()).thenReturn((Object)this.scenarioSimulationViewMock);
        Mockito.when((Object)this.scenarioSimulationEditorPresenter.getModel()).thenReturn((Object)this.scenarioSimulationModelMock);
        Mockito.when((Object)this.alertsButtonMenuItemBuilderMock.build()).thenReturn((Object)this.alertsButtonMenuItemMock);
        Mockito.when((Object)this.versionRecordManagerMock.buildMenu()).thenReturn((Object)this.versionRecordMenuItemMock);
    }

    @Test
    public void onStartup() {
        this.scenarioSimulationEditorBusinessClientWrapper.onStartup(this.observablePathMock, (PlaceRequest)this.placeRequestMock);
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.scenarioSimulationEditorPresenter, (VerificationMode)Mockito.times((int)1))).init((ScenarioSimulationEditorWrapper)Matchers.eq((Object)this.scenarioSimulationEditorBusinessClientWrapper), (ObservablePath)Matchers.eq((Object)this.observablePathMock));
    }

    @Test
    public void onClose() {
        this.scenarioSimulationEditorBusinessClientWrapper.onClose();
        ((VersionRecordManager)Mockito.verify((Object)this.versionRecordManagerMock, (VerificationMode)Mockito.times((int)1))).clear();
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.scenarioSimulationEditorPresenter, (VerificationMode)Mockito.times((int)1))).onClose();
    }

    @Test
    public void mayClose() {
        this.scenarioSimulationEditorBusinessClientWrapper.mayClose();
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.scenarioSimulationEditorPresenter, (VerificationMode)Mockito.times((int)1))).isDirty();
    }

    @Test
    public void showDocks() {
        PlaceStatus placeStatusMock = (PlaceStatus)Mockito.mock(PlaceStatus.class);
        DefaultPlaceRequest placeRequest = new DefaultPlaceRequest("org.drools.scenariosimulation.TestTools");
        Mockito.when((Object)this.placeManagerMock.getStatus((PlaceRequest)Matchers.eq((Object)placeRequest))).thenReturn((Object)placeStatusMock);
        this.scenarioSimulationEditorBusinessClientWrapper.showDocks();
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.scenarioSimulationEditorPresenter, (VerificationMode)Mockito.times((int)1))).showDocks((PlaceStatus)Matchers.same((Object)placeStatusMock));
    }

    @Test
    public void onImport() {
        String FILE_CONTENT = "FILE_CONTENT";
        RemoteCallback remoteCallback = (RemoteCallback)Mockito.mock(RemoteCallback.class);
        ErrorCallback errorCallBack = (ErrorCallback)Mockito.mock(ErrorCallback.class);
        this.scenarioSimulationEditorBusinessClientWrapper.onImport(FILE_CONTENT, remoteCallback, errorCallBack, this.simulationMock);
        ((CallerMock)Mockito.verify(this.importExportCaller, (VerificationMode)Mockito.times((int)1))).call((RemoteCallback)Matchers.eq((Object)remoteCallback), (ErrorCallback)Matchers.eq((Object)errorCallBack));
        ((ImportExportService)Mockito.verify((Object)this.importExportServiceMock, (VerificationMode)Mockito.times((int)1))).importSimulation((ImportExportType)Matchers.eq((Object)ImportExportType.CSV), Matchers.eq((Object)FILE_CONTENT), (Simulation)Matchers.eq((Object)this.simulationMock));
    }

    @Test
    public void onExportToCSV() {
        RemoteCallback remoteCallback = (RemoteCallback)Mockito.mock(RemoteCallback.class);
        ScenarioSimulationHasBusyIndicatorDefaultErrorCallback errorCallback = (ScenarioSimulationHasBusyIndicatorDefaultErrorCallback)Mockito.mock(ScenarioSimulationHasBusyIndicatorDefaultErrorCallback.class);
        this.scenarioSimulationEditorBusinessClientWrapper.onExportToCsv(remoteCallback, errorCallback, this.simulationMock);
        ((CallerMock)Mockito.verify(this.importExportCaller, (VerificationMode)Mockito.times((int)1))).call((RemoteCallback)Matchers.eq((Object)remoteCallback), (ErrorCallback)Matchers.eq((Object)errorCallback));
        ((ImportExportService)Mockito.verify((Object)this.importExportServiceMock, (VerificationMode)Mockito.times((int)1))).exportSimulation((ImportExportType)Matchers.eq((Object)ImportExportType.CSV), (Simulation)Matchers.eq((Object)this.simulationMock));
    }

    @Test
    public void hideDocks() {
        this.scenarioSimulationEditorBusinessClientWrapper.hideDocks();
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.scenarioSimulationEditorPresenter, (VerificationMode)Mockito.times((int)1))).hideDocks();
        ((ScenarioSimulationEditorBusinessCentralWrapper)Mockito.verify((Object)this.scenarioSimulationEditorBusinessClientWrapper, (VerificationMode)Mockito.times((int)1))).unRegisterTestToolsCallback();
    }

    @Test
    public void onRunScenario() {
        this.scenarioWithIndexLocal.add(new ScenarioWithIndex(1, new Scenario()));
        this.scenarioWithIndexLocal.add(new ScenarioWithIndex(2, new Scenario()));
        this.scenarioWithIndexLocal.add(new ScenarioWithIndex(3, new Scenario()));
        RemoteCallback remoteCallback = (RemoteCallback)Mockito.mock(RemoteCallback.class);
        ScenarioSimulationHasBusyIndicatorDefaultErrorCallback errorCallback = (ScenarioSimulationHasBusyIndicatorDefaultErrorCallback)Mockito.mock(ScenarioSimulationHasBusyIndicatorDefaultErrorCallback.class);
        this.scenarioSimulationEditorBusinessClientWrapper.onRunScenario(remoteCallback, errorCallback, this.simulationDescriptorMock, this.scenarioWithIndexLocal);
        ((CallerMock)Mockito.verify(this.scenarioSimulationCaller, (VerificationMode)Mockito.times((int)1))).call((RemoteCallback)Matchers.eq((Object)remoteCallback), (ErrorCallback)Matchers.eq((Object)errorCallback));
        ((ScenarioSimulationService)Mockito.verify((Object)this.scenarioSimulationServiceMock, (VerificationMode)Mockito.times((int)1))).runScenario((Path)Matchers.eq((Object)this.observablePathMock), (SimulationDescriptor)Matchers.eq((Object)this.simulationDescriptorMock), (List)Matchers.eq((Object)this.scenarioWithIndexLocal));
    }

    @Test
    public void addDownloadMenuItem() {
        this.scenarioSimulationEditorBusinessClientWrapper.addDownloadMenuItem(this.fileMenuBuilderMock);
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.scenarioSimulationEditorPresenter, (VerificationMode)Mockito.times((int)1))).addDownloadMenuItem((FileMenuBuilder)Matchers.eq((Object)this.fileMenuBuilderMock), (Supplier)Matchers.isA(Supplier.class));
    }

    @Test
    public void registerTestToolsCallback() {
        this.scenarioSimulationEditorBusinessClientWrapper.registerTestToolsCallback();
        DefaultPlaceRequest request = new DefaultPlaceRequest("org.drools.scenariosimulation.TestTools");
        ((PlaceManager)Mockito.verify((Object)this.placeManagerMock, (VerificationMode)Mockito.times((int)1))).registerOnOpenCallback((PlaceRequest)Matchers.eq((Object)request), (Command)Matchers.eq((Object)this.populateTestToolsCommand));
    }

    @Test
    public void unRegisterTestToolsCallback() {
        DefaultPlaceRequest request = new DefaultPlaceRequest("org.drools.scenariosimulation.TestTools");
        List commands = (List)Mockito.spy(new ArrayList());
        commands.add(this.populateTestToolsCommand);
        Assert.assertTrue((boolean)commands.contains(this.populateTestToolsCommand));
        Mockito.when((Object)this.placeManagerMock.getOnOpenCallbacks((PlaceRequest)request)).thenReturn((Object)commands);
        this.scenarioSimulationEditorBusinessClientWrapper.unRegisterTestToolsCallback();
        ((PlaceManager)Mockito.verify((Object)this.placeManagerMock, (VerificationMode)Mockito.times((int)1))).getOnOpenCallbacks((PlaceRequest)Matchers.eq((Object)request));
        Assert.assertFalse((boolean)commands.contains(this.populateTestToolsCommand));
    }

    @Test
    public void makeMenuBar() {
        this.scenarioSimulationEditorBusinessClientWrapper.makeMenuBar();
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.scenarioSimulationEditorPresenter, (VerificationMode)Mockito.times((int)1))).makeMenuBar((FileMenuBuilder)Matchers.same((Object)this.fileMenuBuilderMock));
    }

    @Test
    public void getContentSupplier() {
        this.scenarioSimulationEditorBusinessClientWrapper.getContentSupplier();
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.scenarioSimulationEditorPresenter, (VerificationMode)Mockito.times((int)1))).getContentSupplier();
    }

    @Test
    public void save() {
        String saveMessage = "Save";
        this.scenarioSimulationEditorBusinessClientWrapper.save(saveMessage);
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.scenarioSimulationEditorPresenter, (VerificationMode)Mockito.times((int)1))).getModel();
        ((CallerMock)Mockito.verify(this.scenarioSimulationCaller, (VerificationMode)Mockito.times((int)1))).call((RemoteCallback)Matchers.isA(RemoteCallback.class), (ErrorCallback)Matchers.isA(HasBusyIndicatorDefaultErrorCallback.class));
        ((ScenarioSimulationService)Mockito.verify((Object)this.scenarioSimulationServiceMock, (VerificationMode)Mockito.times((int)1))).save((Path)Matchers.eq((Object)this.observablePathMock), Matchers.eq((Object)this.scenarioSimulationModelMock), Matchers.eq((Object)this.metaDataMock), (String)Matchers.eq((Object)saveMessage));
    }

    @Test
    public void addCommonActions() {
        this.scenarioSimulationEditorBusinessClientWrapper.addCommonActions(this.fileMenuBuilderMock);
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.scenarioSimulationEditorPresenter, (VerificationMode)Mockito.times((int)1))).addCommonActions((FileMenuBuilder)Matchers.eq((Object)this.fileMenuBuilderMock), (MenuItem)Matchers.eq((Object)this.versionRecordMenuItemMock), (MenuItem)Matchers.eq((Object)this.alertsButtonMenuItemMock));
    }

    @Test
    public void loadContent() {
        this.scenarioSimulationEditorBusinessClientWrapper.loadContent();
        ((CallerMock)Mockito.verify(this.scenarioSimulationCaller, (VerificationMode)Mockito.times((int)1))).call((RemoteCallback)Matchers.isA(RemoteCallback.class), (ErrorCallback)Matchers.isA(CommandDrivenErrorCallback.class));
        ((ScenarioSimulationService)Mockito.verify((Object)this.scenarioSimulationServiceMock, (VerificationMode)Mockito.times((int)1))).loadContent((Path)Matchers.eq((Object)this.observablePathMock));
    }

    @Test
    public void getModelSuccessCallBackMethod_Rule() {
        this.modelLocal.setSimulation(this.getSimulation(ScenarioSimulationModel.Type.RULE, null));
        this.scenarioSimulationEditorBusinessClientWrapper.getModelSuccessCallbackMethod(this.content);
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.scenarioSimulationEditorPresenter, (VerificationMode)Mockito.times((int)1))).setPackageName((String)Matchers.eq((Object)"test.scesim.package"));
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.scenarioSimulationEditorPresenter, (VerificationMode)Mockito.never())).getEventBus();
        ((ImportsWidgetPresenter)Mockito.verify((Object)this.importsWidgetPresenterMock, (VerificationMode)Mockito.times((int)1))).setContent((AsyncPackageDataModelOracle)Matchers.any(), (Imports)Matchers.any(), Matchers.anyBoolean());
        ((ScenarioSimulationView)Mockito.verify((Object)this.scenarioSimulationViewMock, (VerificationMode)Mockito.times((int)1))).hideBusyIndicator();
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.scenarioSimulationEditorPresenter, (VerificationMode)Mockito.times((int)1))).getJsonModel((ScenarioSimulationModel)Matchers.eq((Object)this.modelLocal));
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.scenarioSimulationEditorPresenter, (VerificationMode)Mockito.times((int)1))).getModelSuccessCallbackMethod((DataManagementStrategy)Matchers.isA(DataManagementStrategy.class), (ScenarioSimulationModel)Matchers.eq((Object)this.modelLocal));
    }

    @Test
    public void getModelSuccessCallBackMethod_DMN() {
        this.modelLocal.setSimulation(this.getSimulation(ScenarioSimulationModel.Type.DMN, null));
        this.scenarioSimulationEditorBusinessClientWrapper.getModelSuccessCallbackMethod(this.content);
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.scenarioSimulationEditorPresenter, (VerificationMode)Mockito.times((int)1))).setPackageName((String)Matchers.eq((Object)"test.scesim.package"));
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.scenarioSimulationEditorPresenter, (VerificationMode)Mockito.times((int)1))).getEventBus();
        ((VersionRecordManager)Mockito.verify((Object)this.versionRecordManagerMock, (VerificationMode)Mockito.times((int)2))).getCurrentPath();
        ((ImportsWidgetPresenter)Mockito.verify((Object)this.importsWidgetPresenterMock, (VerificationMode)Mockito.never())).setContent((AsyncPackageDataModelOracle)Matchers.any(), (Imports)Matchers.any(), Matchers.anyBoolean());
        ((ScenarioSimulationView)Mockito.verify((Object)this.scenarioSimulationViewMock, (VerificationMode)Mockito.times((int)1))).hideBusyIndicator();
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.scenarioSimulationEditorPresenter, (VerificationMode)Mockito.times((int)1))).getJsonModel((ScenarioSimulationModel)Matchers.eq((Object)this.modelLocal));
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.scenarioSimulationEditorPresenter, (VerificationMode)Mockito.times((int)1))).getModelSuccessCallbackMethod((DataManagementStrategy)Matchers.isA(DataManagementStrategy.class), (ScenarioSimulationModel)Matchers.eq((Object)this.modelLocal));
    }
}

