/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.businesscentral.client.editor.strategies;

import com.google.gwt.event.shared.EventBus;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.HashMap;
import java.util.SortedMap;
import java.util.TreeMap;
import junit.framework.TestCase;
import org.drools.workbench.screens.scenariosimulation.businesscentral.client.editor.strategies.BusinessCentralDMNDataManagementStrategy;
import org.drools.workbench.screens.scenariosimulation.client.editor.strategies.AbstractDataManagementStrategy;
import org.drools.workbench.screens.scenariosimulation.client.editor.strategies.AbstractDataManagementStrategyTest;
import org.drools.workbench.screens.scenariosimulation.client.models.ScenarioGridModel;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.TestToolsPresenter;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.TestToolsView;
import org.drools.workbench.screens.scenariosimulation.model.ScenarioSimulationModelContent;
import org.drools.workbench.screens.scenariosimulation.model.typedescriptor.FactModelTree;
import org.drools.workbench.screens.scenariosimulation.model.typedescriptor.FactModelTuple;
import org.drools.workbench.screens.scenariosimulation.service.DMNTypeService;
import org.jboss.errai.common.client.api.Caller;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.backend.vfs.ObservablePath;
import org.uberfire.backend.vfs.Path;
import org.uberfire.mocks.CallerMock;

@RunWith(value=GwtMockitoTestRunner.class)
public class BusinessCentralDMNDataManagementStrategyTest
extends AbstractDataManagementStrategyTest {
    @Mock
    private DMNTypeService dmnTypeServiceMock;
    private BusinessCentralDMNDataManagementStrategy businessCentralDmnDataManagementStrategySpy;
    private AbstractDataManagementStrategy.ResultHolder factModelTreeHolderlocal;
    private FactModelTuple factModelTupleLocal;
    private SortedMap<String, FactModelTree> visibleFactsLocal = new TreeMap<String, FactModelTree>();
    private SortedMap<String, FactModelTree> hiddenFactsLocal = new TreeMap<String, FactModelTree>();

    @Before
    public void setup() {
        super.setup();
        this.factModelTupleLocal = new FactModelTuple(this.visibleFactsLocal, this.hiddenFactsLocal);
        this.factModelTreeHolderlocal = new AbstractDataManagementStrategy.ResultHolder();
        this.factModelTreeHolderlocal.setFactModelTuple(this.factModelTupleLocal);
        try {
            Mockito.when((Object)this.dmnTypeServiceMock.retrieveFactModelTuple((Path)Matchers.any(), Matchers.anyString())).thenReturn((Object)this.factModelTupleLocal);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.modelLocal.getSimulation().getSimulationDescriptor().setDmnFilePath("dmn_file_path");
        this.businessCentralDmnDataManagementStrategySpy = (BusinessCentralDMNDataManagementStrategy)Mockito.spy((Object)new BusinessCentralDMNDataManagementStrategy((Caller)new CallerMock((Object)this.dmnTypeServiceMock), this.scenarioSimulationContextLocal, (EventBus)Mockito.mock(EventBus.class)){
            {
                this.currentPath = (Path)Mockito.mock(Path.class);
                this.model = BusinessCentralDMNDataManagementStrategyTest.this.modelLocal;
                this.scenarioSimulationContext = BusinessCentralDMNDataManagementStrategyTest.this.scenarioSimulationContextLocal;
                this.factModelTreeHolder = BusinessCentralDMNDataManagementStrategyTest.this.factModelTreeHolderlocal;
            }
        });
        this.abstractDataManagementStrategySpy = this.businessCentralDmnDataManagementStrategySpy;
    }

    @Test
    public void populateTestToolsWithoutFactModelTuple() throws Exception {
        this.factModelTreeHolderlocal.setFactModelTuple(null);
        this.businessCentralDmnDataManagementStrategySpy.populateTestTools((TestToolsView.Presenter)this.testToolsPresenterMock, this.scenarioGridModelMock);
        ((DMNTypeService)Mockito.verify((Object)this.dmnTypeServiceMock, (VerificationMode)Mockito.times((int)1))).retrieveFactModelTuple((Path)Matchers.any(), Matchers.anyString());
        ((BusinessCentralDMNDataManagementStrategy)Mockito.verify((Object)this.businessCentralDmnDataManagementStrategySpy, (VerificationMode)Mockito.times((int)1))).getSuccessCallback((TestToolsView.Presenter)this.testToolsPresenterMock, this.scenarioGridModelMock);
        ((BusinessCentralDMNDataManagementStrategy)Mockito.verify((Object)this.businessCentralDmnDataManagementStrategySpy, (VerificationMode)Mockito.times((int)1))).getSuccessCallbackMethod((FactModelTuple)Matchers.eq((Object)this.factModelTupleLocal), (TestToolsView.Presenter)Matchers.eq((Object)this.testToolsPresenterMock), (ScenarioGridModel)Matchers.eq((Object)this.scenarioGridModelMock));
    }

    @Test
    public void populateTestToolsWithFactModelTuple() throws Exception {
        this.businessCentralDmnDataManagementStrategySpy.populateTestTools((TestToolsView.Presenter)this.testToolsPresenterMock, this.scenarioGridModelMock);
        ((DMNTypeService)Mockito.verify((Object)this.dmnTypeServiceMock, (VerificationMode)Mockito.never())).retrieveFactModelTuple((Path)Matchers.any(), Matchers.anyString());
        ((BusinessCentralDMNDataManagementStrategy)Mockito.verify((Object)this.businessCentralDmnDataManagementStrategySpy, (VerificationMode)Mockito.times((int)1))).getSuccessCallback((TestToolsView.Presenter)this.testToolsPresenterMock, this.scenarioGridModelMock);
        ((BusinessCentralDMNDataManagementStrategy)Mockito.verify((Object)this.businessCentralDmnDataManagementStrategySpy, (VerificationMode)Mockito.times((int)1))).getSuccessCallbackMethod((FactModelTuple)Matchers.eq((Object)this.factModelTupleLocal), (TestToolsView.Presenter)Matchers.eq((Object)this.testToolsPresenterMock), (ScenarioGridModel)Matchers.eq((Object)this.scenarioGridModelMock));
    }

    @Test
    public void manageScenarioSimulationModelContent() {
        ScenarioSimulationModelContent contentMock = (ScenarioSimulationModelContent)Mockito.spy((Object)this.content);
        this.businessCentralDmnDataManagementStrategySpy.manageScenarioSimulationModelContent(this.observablePathMock, contentMock);
        ((ObservablePath)Mockito.verify((Object)this.observablePathMock, (VerificationMode)Mockito.times((int)1))).getOriginal();
        ((ScenarioSimulationModelContent)Mockito.verify((Object)contentMock, (VerificationMode)Mockito.times((int)1))).getModel();
    }

    @Test
    public void isADataType() {
        this.visibleFactsLocal.clear();
        this.hiddenFactsLocal.clear();
        this.commonIsADataType("TEST", false);
        this.visibleFactsLocal.put("TEST", new FactModelTree());
        this.commonIsADataType("TOAST", false);
        this.commonIsADataType("TEST", true);
        this.visibleFactsLocal.clear();
        this.hiddenFactsLocal.put("TEST", new FactModelTree());
        this.commonIsADataType("TOAST", false);
        this.commonIsADataType("TEST", true);
    }

    private void commonIsADataType(String value, boolean expected) {
        boolean retrieved = this.businessCentralDmnDataManagementStrategySpy.isADataType(value);
        if (expected) {
            TestCase.assertTrue((boolean)retrieved);
        } else {
            Assert.assertFalse((boolean)retrieved);
        }
    }

    @Test
    public void getSuccessCallbackMethod() {
        HashMap alreadyAssignedProperties = new HashMap();
        this.factModelTreeHolderlocal.setFactModelTuple(null);
        ((BusinessCentralDMNDataManagementStrategy)Mockito.doReturn(alreadyAssignedProperties).when((Object)this.businessCentralDmnDataManagementStrategySpy)).getPropertiesToHide(this.scenarioGridModelMock);
        this.businessCentralDmnDataManagementStrategySpy.getSuccessCallbackMethod(this.factModelTupleLocal, (TestToolsView.Presenter)this.testToolsPresenterMock, this.scenarioGridModelMock);
        ((BusinessCentralDMNDataManagementStrategy)Mockito.verify((Object)this.businessCentralDmnDataManagementStrategySpy, (VerificationMode)Mockito.times((int)1))).getPropertiesToHide((ScenarioGridModel)Matchers.eq((Object)this.scenarioGridModelMock));
        Assert.assertEquals((Object)this.factModelTupleLocal, (Object)this.factModelTreeHolderlocal.getFactModelTuple());
        ((TestToolsPresenter)Mockito.verify((Object)this.testToolsPresenterMock, (VerificationMode)Mockito.times((int)1))).setDataObjectFieldsMap((SortedMap)Matchers.isA(SortedMap.class));
        ((TestToolsPresenter)Mockito.verify((Object)this.testToolsPresenterMock, (VerificationMode)Mockito.times((int)1))).setSimpleJavaTypeFieldsMap((SortedMap)Matchers.isA(SortedMap.class));
        ((TestToolsPresenter)Mockito.verify((Object)this.testToolsPresenterMock, (VerificationMode)Mockito.times((int)1))).setHiddenFieldsMap((SortedMap)Matchers.eq(this.hiddenFactsLocal));
    }
}

