/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.businesscentral.client.editor.strategies;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Collectors;
import junit.framework.TestCase;
import org.apache.commons.lang3.RandomStringUtils;
import org.drools.workbench.screens.scenariosimulation.businesscentral.client.editor.strategies.BusinessCentralDMODataManagementStrategy;
import org.drools.workbench.screens.scenariosimulation.client.editor.strategies.AbstractDataManagementStrategy;
import org.drools.workbench.screens.scenariosimulation.client.editor.strategies.AbstractDataManagementStrategyTest;
import org.drools.workbench.screens.scenariosimulation.client.models.ScenarioGridModel;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.TestToolsView;
import org.drools.workbench.screens.scenariosimulation.model.typedescriptor.FactModelTree;
import org.drools.workbench.screens.scenariosimulation.model.typedescriptor.FactModelTuple;
import org.jgroups.util.Util;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.soup.project.datamodel.imports.HasImports;
import org.kie.soup.project.datamodel.oracle.FieldAccessorsAndMutators;
import org.kie.soup.project.datamodel.oracle.ModelField;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracle;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.backend.vfs.Path;
import org.uberfire.client.callbacks.Callback;

@RunWith(value=GwtMockitoTestRunner.class)
public class BusinessCentralDMODataManagementStrategyTest
extends AbstractDataManagementStrategyTest {
    private BusinessCentralDMODataManagementStrategy businessCentralDmoDataManagementStrategy;
    @Mock
    private AsyncPackageDataModelOracle oracleMock;
    private AbstractDataManagementStrategy.ResultHolder factModelTreeHolderlocal;
    private FactModelTuple factModelTupleLocal;

    @Before
    public void setup() {
        super.setup();
        this.factModelTupleLocal = new FactModelTuple(new TreeMap(), new TreeMap());
        this.factModelTreeHolderlocal = new AbstractDataManagementStrategy.ResultHolder();
        this.factModelTreeHolderlocal.setFactModelTuple(this.factModelTupleLocal);
        Mockito.when((Object)this.oracleMock.getFQCNByFactName("FACT_NAME")).thenReturn((Object)"FULL_FACT_CLASSNAME");
        Mockito.when((Object)this.oracleFactoryMock.makeAsyncPackageDataModelOracle((Path)this.observablePathMock, (HasImports)this.modelLocal, this.content.getDataModel())).thenReturn((Object)this.oracleMock);
        this.businessCentralDmoDataManagementStrategy = (BusinessCentralDMODataManagementStrategy)Mockito.spy((Object)new BusinessCentralDMODataManagementStrategy(this.oracleFactoryMock, this.scenarioSimulationContextLocal){
            {
                this.oracle = BusinessCentralDMODataManagementStrategyTest.this.oracleMock;
                this.factModelTreeHolder = BusinessCentralDMODataManagementStrategyTest.this.factModelTreeHolderlocal;
            }
        });
        this.abstractDataManagementStrategySpy = this.businessCentralDmoDataManagementStrategy;
    }

    @Test
    public void populateTestToolsWithFactTuple() {
        FactModelTuple factModelTupleMock = (FactModelTuple)Mockito.mock(FactModelTuple.class);
        this.factModelTreeHolderlocal.setFactModelTuple(factModelTupleMock);
        ((BusinessCentralDMODataManagementStrategy)Mockito.doNothing().when((Object)this.businessCentralDmoDataManagementStrategy)).storeData((FactModelTuple)Matchers.eq((Object)factModelTupleMock), (TestToolsView.Presenter)Matchers.eq((Object)this.testToolsPresenterMock), (ScenarioGridModel)Matchers.eq((Object)this.scenarioGridModelMock));
        this.businessCentralDmoDataManagementStrategy.populateTestTools((TestToolsView.Presenter)this.testToolsPresenterMock, this.scenarioGridModelMock);
        ((BusinessCentralDMODataManagementStrategy)Mockito.verify((Object)this.businessCentralDmoDataManagementStrategy, (VerificationMode)Mockito.times((int)1))).storeData((FactModelTuple)Matchers.eq((Object)factModelTupleMock), (TestToolsView.Presenter)Matchers.eq((Object)this.testToolsPresenterMock), (ScenarioGridModel)Matchers.eq((Object)this.scenarioGridModelMock));
    }

    @Test
    public void populateTestToolsWithoutFactTupleEmptyOracle() {
        this.factModelTreeHolderlocal.setFactModelTuple(null);
        HashMap alreadyAssignedProperties = new HashMap();
        ((BusinessCentralDMODataManagementStrategy)Mockito.doReturn(alreadyAssignedProperties).when((Object)this.businessCentralDmoDataManagementStrategy)).getPropertiesToHide(this.scenarioGridModelMock);
        String[] emptyFactTypes = new String[]{};
        Mockito.when((Object)this.oracleMock.getFactTypes()).thenReturn((Object)emptyFactTypes);
        this.businessCentralDmoDataManagementStrategy.populateTestTools((TestToolsView.Presenter)this.testToolsPresenterMock, this.scenarioGridModelMock);
        ((BusinessCentralDMODataManagementStrategy)Mockito.verify((Object)this.businessCentralDmoDataManagementStrategy, (VerificationMode)Mockito.never())).aggregatorCallback((TestToolsView.Presenter)Matchers.eq((Object)this.testToolsPresenterMock), Matchers.anyInt(), (SortedMap)Matchers.any(SortedMap.class), (ScenarioGridModel)Matchers.eq((Object)this.scenarioGridModelMock), (List)Matchers.isA(List.class));
        ((AsyncPackageDataModelOracle)Mockito.verify((Object)this.oracleMock, (VerificationMode)Mockito.never())).getFieldCompletions(Matchers.anyString(), (Callback)Matchers.any(Callback.class));
    }

    @Test
    public void populateTestToolsWithoutFactTupleWithOnlyDataObjects() {
        this.factModelTreeHolderlocal.setFactModelTuple(null);
        HashMap alreadyAssignedProperties = new HashMap();
        ((BusinessCentralDMODataManagementStrategy)Mockito.doReturn(alreadyAssignedProperties).when((Object)this.businessCentralDmoDataManagementStrategy)).getPropertiesToHide(this.scenarioGridModelMock);
        String[] notEmptyFactTypes = this.getRandomStringArray();
        Mockito.when((Object)this.oracleMock.getFactTypes()).thenReturn((Object)notEmptyFactTypes);
        this.businessCentralDmoDataManagementStrategy.populateTestTools((TestToolsView.Presenter)this.testToolsPresenterMock, this.scenarioGridModelMock);
        ((BusinessCentralDMODataManagementStrategy)Mockito.verify((Object)this.businessCentralDmoDataManagementStrategy, (VerificationMode)Mockito.times((int)1))).aggregatorCallback((TestToolsView.Presenter)Matchers.eq((Object)this.testToolsPresenterMock), Matchers.anyInt(), (SortedMap)Matchers.any(SortedMap.class), (ScenarioGridModel)Matchers.eq((Object)this.scenarioGridModelMock), (List)Matchers.isA(List.class));
        for (String factType : notEmptyFactTypes) {
            ((AsyncPackageDataModelOracle)Mockito.verify((Object)this.oracleMock, (VerificationMode)Mockito.times((int)1))).getFieldCompletions((String)Matchers.eq((Object)factType), (Callback)Matchers.any(Callback.class));
        }
    }

    @Test
    public void populateTestToolsWithoutFactTupleWithDataObjectsAndSimpleJavaTypes() {
        this.factModelTreeHolderlocal.setFactModelTuple(null);
        HashMap alreadyAssignedProperties = new HashMap();
        ((BusinessCentralDMODataManagementStrategy)Mockito.doReturn(alreadyAssignedProperties).when((Object)this.businessCentralDmoDataManagementStrategy)).getPropertiesToHide(this.scenarioGridModelMock);
        String[] dataObjectTypes = this.getRandomStringArray();
        String[] simpleJavaTypes = this.getSimpleTypeArray();
        String[] notEmptyFactTypes = this.mergeArrays(dataObjectTypes, simpleJavaTypes);
        Mockito.when((Object)this.oracleMock.getFactTypes()).thenReturn((Object)notEmptyFactTypes);
        this.businessCentralDmoDataManagementStrategy.populateTestTools((TestToolsView.Presenter)this.testToolsPresenterMock, this.scenarioGridModelMock);
        ((BusinessCentralDMODataManagementStrategy)Mockito.verify((Object)this.businessCentralDmoDataManagementStrategy, (VerificationMode)Mockito.times((int)1))).aggregatorCallback((TestToolsView.Presenter)Matchers.eq((Object)this.testToolsPresenterMock), Matchers.anyInt(), (SortedMap)Matchers.any(SortedMap.class), (ScenarioGridModel)Matchers.eq((Object)this.scenarioGridModelMock), (List)Matchers.isA(List.class));
        for (String factType : dataObjectTypes) {
            ((AsyncPackageDataModelOracle)Mockito.verify((Object)this.oracleMock, (VerificationMode)Mockito.times((int)1))).getFieldCompletions((String)Matchers.eq((Object)factType), (Callback)Matchers.any(Callback.class));
        }
    }

    @Test
    public void populateTestToolsWithoutFactTupleWithoutDataObjectsWithSimpleJavaTypes() {
        this.factModelTreeHolderlocal.setFactModelTuple(null);
        HashMap alreadyAssignedProperties = new HashMap();
        ((BusinessCentralDMODataManagementStrategy)Mockito.doReturn(alreadyAssignedProperties).when((Object)this.businessCentralDmoDataManagementStrategy)).getPropertiesToHide(this.scenarioGridModelMock);
        String[] notEmptyFactTypes = this.getSimpleTypeArray();
        List<String> simpleJavaTypes = Arrays.asList(notEmptyFactTypes);
        Mockito.when((Object)this.oracleMock.getFactTypes()).thenReturn((Object)notEmptyFactTypes);
        this.businessCentralDmoDataManagementStrategy.populateTestTools((TestToolsView.Presenter)this.testToolsPresenterMock, this.scenarioGridModelMock);
        ((BusinessCentralDMODataManagementStrategy)Mockito.verify((Object)this.businessCentralDmoDataManagementStrategy, (VerificationMode)Mockito.never())).aggregatorCallback((TestToolsView.Presenter)Matchers.eq((Object)this.testToolsPresenterMock), Matchers.anyInt(), (SortedMap)Matchers.any(SortedMap.class), (ScenarioGridModel)Matchers.eq((Object)this.scenarioGridModelMock), (List)Matchers.isA(List.class));
        ((BusinessCentralDMODataManagementStrategy)Mockito.verify((Object)this.businessCentralDmoDataManagementStrategy, (VerificationMode)Mockito.times((int)1))).aggregatorCallbackMethod((TestToolsView.Presenter)Matchers.eq((Object)this.testToolsPresenterMock), Matchers.eq((int)0), (SortedMap)Matchers.any(SortedMap.class), (ScenarioGridModel)Matchers.eq((Object)this.scenarioGridModelMock), (FactModelTree)Matchers.eq(null), (List)Matchers.eq(simpleJavaTypes));
    }

    @Test
    public void manageScenarioSimulationModelContent() {
        this.businessCentralDmoDataManagementStrategy.manageScenarioSimulationModelContent(this.observablePathMock, this.content);
        Assert.assertEquals((Object)this.businessCentralDmoDataManagementStrategy.oracle, (Object)this.oracleMock);
    }

    @Test
    public void isADataType() {
        Mockito.when((Object)this.oracleMock.getFactTypes()).thenReturn((Object)new String[0]);
        this.commonIsADataType("TEST", false);
        Mockito.when((Object)this.oracleMock.getFactTypes()).thenReturn((Object)new String[]{"TEST"});
        this.commonIsADataType("TOAST", false);
        this.commonIsADataType("TEST", true);
    }

    @Test
    public void fieldCompletionsCallbackMethod() {
        ModelField[] result = new ModelField[]{};
        Callback aggregatorCallbackMock = (Callback)Mockito.mock(Callback.class);
        this.businessCentralDmoDataManagementStrategy.fieldCompletionsCallbackMethod("FACT_NAME", result, aggregatorCallbackMock);
        ((BusinessCentralDMODataManagementStrategy)Mockito.verify((Object)this.businessCentralDmoDataManagementStrategy, (VerificationMode)Mockito.times((int)1))).getFactModelTree((String)Matchers.eq((Object)"FACT_NAME"), (ModelField[])Matchers.eq((Object)result));
        ((Callback)Mockito.verify((Object)aggregatorCallbackMock, (VerificationMode)Mockito.times((int)1))).callback(Matchers.isA(FactModelTree.class));
    }

    @Test
    public void getFactModelTree() {
        Map<String, String> simpleProperties = this.getSimplePropertiesInner();
        ModelField[] modelFields = this.getModelFieldsInner(simpleProperties);
        FactModelTree retrieved = this.businessCentralDmoDataManagementStrategy.getFactModelTree("FACT_NAME", modelFields);
        Assert.assertNotNull((Object)retrieved);
        Assert.assertEquals((Object)"FACT_NAME", (Object)retrieved.getFactName());
        Assert.assertEquals((Object)"", (Object)retrieved.getFullPackage());
    }

    @Test
    public void getSimpleClassFactModelTree() {
        Class[] expectedClazzes;
        for (Class expectedClazz : expectedClazzes = new Class[]{String.class, Boolean.class, Integer.class, Double.class, Number.class}) {
            FactModelTree retrieved = AbstractDataManagementStrategy.getSimpleClassFactModelTree((String)expectedClazz.getSimpleName(), (String)expectedClazz.getCanonicalName());
            Assert.assertNotNull((Object)retrieved);
            String key = expectedClazz.getSimpleName();
            Assert.assertEquals((Object)key, (Object)retrieved.getFactName());
            String fullName = expectedClazz.getCanonicalName();
            String packageName = fullName.substring(0, fullName.lastIndexOf("."));
            Assert.assertEquals((Object)packageName, (Object)retrieved.getFullPackage());
            Map simpleProperties = retrieved.getSimpleProperties();
            Assert.assertNotNull((Object)simpleProperties);
            Assert.assertEquals((long)1L, (long)simpleProperties.size());
            Util.assertTrue((boolean)simpleProperties.containsKey("value"));
            String simplePropertyValue = (String)simpleProperties.get("value");
            Assert.assertNotNull((Object)simplePropertyValue);
            Assert.assertEquals((Object)fullName, (Object)simplePropertyValue);
        }
    }

    @Test
    public void getInstanceMap() {
        FactModelTree toPopulate = this.getFactModelTreeInner(RandomStringUtils.randomAlphabetic((int)3));
        Map simpleProperties = toPopulate.getSimpleProperties();
        Collection<String> values = simpleProperties.values();
        SortedMap<String, FactModelTree> factTypeFieldsMap = this.getFactTypeFieldsMapInner(values);
        SortedMap retrieved = this.businessCentralDmoDataManagementStrategy.getInstanceMap(factTypeFieldsMap);
        Assert.assertNotNull((Object)retrieved);
    }

    @Test
    public void populateGenericTypeMap() {
        this.commonPopulateGenericTypeMap(true);
        this.commonPopulateGenericTypeMap(false);
    }

    @Test
    public void aggregatorCallbackMethodWithResultAllElements() {
        SortedMap<String, FactModelTree> factTypeFieldsMap = this.getRandomMap();
        String resultName = "RESULT_NAME";
        FactModelTree resultMock = (FactModelTree)Mockito.mock(FactModelTree.class);
        Mockito.when((Object)resultMock.getFactName()).thenReturn((Object)resultName);
        List<String> simpleJavaTypes = Arrays.asList(this.getSimpleTypeArray());
        this.factModelTreeHolderlocal.setFactModelTuple(null);
        this.businessCentralDmoDataManagementStrategy.aggregatorCallbackMethod((TestToolsView.Presenter)this.testToolsPresenterMock, factTypeFieldsMap.size() + 1, factTypeFieldsMap, this.scenarioGridModelMock, resultMock, simpleJavaTypes);
        ((FactModelTree)Mockito.verify((Object)resultMock, (VerificationMode)Mockito.times((int)1))).getFactName();
        Assert.assertTrue((boolean)factTypeFieldsMap.containsKey(resultName));
        Assert.assertEquals((Object)resultMock, factTypeFieldsMap.get(resultName));
        factTypeFieldsMap.values().forEach(factModelTree -> ((BusinessCentralDMODataManagementStrategy)Mockito.verify((Object)this.businessCentralDmoDataManagementStrategy, (VerificationMode)Mockito.times((int)1))).populateFactModelTree((FactModelTree)Matchers.eq((Object)factModelTree), (SortedMap)Matchers.eq((Object)factTypeFieldsMap)));
        Assert.assertNotNull((Object)this.factModelTreeHolderlocal.getFactModelTuple());
        ((BusinessCentralDMODataManagementStrategy)Mockito.verify((Object)this.businessCentralDmoDataManagementStrategy, (VerificationMode)Mockito.times((int)1))).storeData((FactModelTuple)Matchers.eq((Object)this.factModelTreeHolderlocal.getFactModelTuple()), (TestToolsView.Presenter)Matchers.eq((Object)this.testToolsPresenterMock), (ScenarioGridModel)Matchers.eq((Object)this.scenarioGridModelMock));
    }

    @Test
    public void aggregatorCallbackMethodWithResultNotAllElements() {
        SortedMap<String, FactModelTree> factTypeFieldsMap = this.getRandomMap();
        String resultName = "RESULT_NAME";
        FactModelTree resultMock = (FactModelTree)Mockito.mock(FactModelTree.class);
        Mockito.when((Object)resultMock.getFactName()).thenReturn((Object)resultName);
        List<String> simpleJavaTypes = Arrays.asList(this.getSimpleTypeArray());
        this.factModelTreeHolderlocal.setFactModelTuple(null);
        this.businessCentralDmoDataManagementStrategy.aggregatorCallbackMethod((TestToolsView.Presenter)this.testToolsPresenterMock, factTypeFieldsMap.size() + 10, factTypeFieldsMap, this.scenarioGridModelMock, resultMock, simpleJavaTypes);
        ((FactModelTree)Mockito.verify((Object)resultMock, (VerificationMode)Mockito.times((int)1))).getFactName();
        Assert.assertTrue((boolean)factTypeFieldsMap.containsKey(resultName));
        Assert.assertEquals((Object)resultMock, factTypeFieldsMap.get(resultName));
        ((BusinessCentralDMODataManagementStrategy)Mockito.verify((Object)this.businessCentralDmoDataManagementStrategy, (VerificationMode)Mockito.never())).populateFactModelTree((FactModelTree)Matchers.isA(FactModelTree.class), (SortedMap)Matchers.isA(SortedMap.class));
        Assert.assertNull((Object)this.factModelTreeHolderlocal.getFactModelTuple());
        ((BusinessCentralDMODataManagementStrategy)Mockito.verify((Object)this.businessCentralDmoDataManagementStrategy, (VerificationMode)Mockito.never())).storeData((FactModelTuple)Matchers.isA(FactModelTuple.class), (TestToolsView.Presenter)Matchers.eq((Object)this.testToolsPresenterMock), (ScenarioGridModel)Matchers.eq((Object)this.scenarioGridModelMock));
    }

    @Test
    public void aggregatorCallbackMethodWithoutResultAllElements() {
        SortedMap<String, FactModelTree> factTypeFieldsMap = this.getRandomMap();
        List<String> simpleJavaTypes = Arrays.asList(this.getSimpleTypeArray());
        this.factModelTreeHolderlocal.setFactModelTuple(null);
        int previousSizeMap = factTypeFieldsMap.size();
        this.businessCentralDmoDataManagementStrategy.aggregatorCallbackMethod((TestToolsView.Presenter)this.testToolsPresenterMock, factTypeFieldsMap.size(), factTypeFieldsMap, this.scenarioGridModelMock, null, simpleJavaTypes);
        Assert.assertEquals((long)previousSizeMap, (long)factTypeFieldsMap.size());
        factTypeFieldsMap.values().forEach(factModelTree -> ((BusinessCentralDMODataManagementStrategy)Mockito.verify((Object)this.businessCentralDmoDataManagementStrategy, (VerificationMode)Mockito.times((int)1))).populateFactModelTree((FactModelTree)Matchers.eq((Object)factModelTree), (SortedMap)Matchers.eq((Object)factTypeFieldsMap)));
        Assert.assertNotNull((Object)this.factModelTreeHolderlocal.getFactModelTuple());
        ((BusinessCentralDMODataManagementStrategy)Mockito.verify((Object)this.businessCentralDmoDataManagementStrategy, (VerificationMode)Mockito.times((int)1))).storeData((FactModelTuple)Matchers.eq((Object)this.factModelTreeHolderlocal.getFactModelTuple()), (TestToolsView.Presenter)Matchers.eq((Object)this.testToolsPresenterMock), (ScenarioGridModel)Matchers.eq((Object)this.scenarioGridModelMock));
    }

    @Test
    public void aggregatorCallbackMethodWithOutResultNotAllElements() {
        SortedMap<String, FactModelTree> factTypeFieldsMap = this.getRandomMap();
        List<String> simpleJavaTypes = Arrays.asList(this.getSimpleTypeArray());
        int previousSizeMap = factTypeFieldsMap.size();
        this.factModelTreeHolderlocal.setFactModelTuple(null);
        this.businessCentralDmoDataManagementStrategy.aggregatorCallbackMethod((TestToolsView.Presenter)this.testToolsPresenterMock, factTypeFieldsMap.size() + 10, factTypeFieldsMap, this.scenarioGridModelMock, null, simpleJavaTypes);
        Assert.assertEquals((long)previousSizeMap, (long)factTypeFieldsMap.size());
        ((BusinessCentralDMODataManagementStrategy)Mockito.verify((Object)this.businessCentralDmoDataManagementStrategy, (VerificationMode)Mockito.never())).populateFactModelTree((FactModelTree)Matchers.isA(FactModelTree.class), (SortedMap)Matchers.isA(SortedMap.class));
        Assert.assertNull((Object)this.factModelTreeHolderlocal.getFactModelTuple());
        ((BusinessCentralDMODataManagementStrategy)Mockito.verify((Object)this.businessCentralDmoDataManagementStrategy, (VerificationMode)Mockito.never())).storeData((FactModelTuple)Matchers.isA(FactModelTuple.class), (TestToolsView.Presenter)Matchers.eq((Object)this.testToolsPresenterMock), (ScenarioGridModel)Matchers.eq((Object)this.scenarioGridModelMock));
    }

    private void commonIsADataType(String value, boolean expected) {
        boolean retrieved = this.businessCentralDmoDataManagementStrategy.isADataType(value);
        if (expected) {
            TestCase.assertTrue((boolean)retrieved);
        } else {
            Assert.assertFalse((boolean)retrieved);
        }
    }

    private void commonPopulateGenericTypeMap(boolean isList) {
        HashMap toPopulate = new HashMap();
        String factName = "FACT_NAME";
        String propertyName = "PROPERTY_NAME";
        String factType = "Book";
        String fullFactType = "com." + factType;
        Mockito.when((Object)this.oracleMock.getParametricFieldType(factName, propertyName)).thenReturn((Object)factType);
        Mockito.when((Object)this.oracleMock.getFQCNByFactName(factType)).thenReturn((Object)fullFactType);
        this.businessCentralDmoDataManagementStrategy.populateGenericTypeMap(toPopulate, factName, propertyName, isList);
        Assert.assertTrue((boolean)toPopulate.containsKey(propertyName));
        List retrieved = (List)toPopulate.get(propertyName);
        if (!isList) {
            Assert.assertEquals((Object)String.class.getName(), retrieved.get(0));
        }
        Assert.assertEquals((Object)fullFactType, retrieved.get(retrieved.size() - 1));
    }

    private ModelField[] getModelFieldsInner(Map<String, String> simpleProperties) {
        ArrayList toReturn = new ArrayList();
        simpleProperties.forEach((key, value) -> toReturn.add(this.getModelFieldInner((String)key, (String)value, "String")));
        return toReturn.toArray(new ModelField[toReturn.size()]);
    }

    private ModelField getModelFieldInner(String name, String clazz, String type) {
        return new ModelField(name, clazz, ModelField.FIELD_CLASS_TYPE.REGULAR_CLASS, ModelField.FIELD_ORIGIN.DECLARED, FieldAccessorsAndMutators.BOTH, type);
    }

    private FactModelTree getFactModelTreeInner(String factName) {
        return new FactModelTree(factName, "scenario.package", this.getSimplePropertiesInner(), new HashMap());
    }

    private SortedMap<String, FactModelTree> getFactTypeFieldsMapInner(Collection<String> keys) {
        return new TreeMap<String, FactModelTree>(keys.stream().collect(Collectors.toMap(key -> key, key -> this.getFactModelTreeInner((String)key))));
    }

    private Map<String, String> getSimplePropertiesInner() {
        String[] keys = this.getRandomStringArray();
        return Arrays.stream(keys).collect(Collectors.toMap(key -> key, key -> {
            key = key + "_VALUE";
            return key;
        }));
    }

    private String[] getRandomStringArray() {
        return new String[]{RandomStringUtils.randomAlphabetic((int)3), RandomStringUtils.randomAlphabetic((int)4), RandomStringUtils.randomAlphabetic((int)5)};
    }

    private String[] getSimpleTypeArray() {
        return new String[]{"Integer", "String"};
    }

    private String[] mergeArrays(String[] first, String[] second) {
        int i;
        String[] toReturn = new String[first.length + second.length];
        for (i = 0; i < first.length; ++i) {
            toReturn[i] = first[i];
        }
        for (i = 0; i < second.length; ++i) {
            toReturn[i + first.length] = second[i];
        }
        return toReturn;
    }

    private SortedMap<String, FactModelTree> getRandomMap() {
        String[] dataObjects;
        TreeMap<String, FactModelTree> toReturn = new TreeMap<String, FactModelTree>();
        for (String factName : dataObjects = this.getRandomStringArray()) {
            toReturn.put(factName, this.getFactModelTreeInner(factName));
        }
        return toReturn;
    }
}

