/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.businesscentral.client.dropdown;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.drools.workbench.screens.scenariosimulation.client.dropdown.ScenarioSimulationAssetsDropdownProvider;
import org.drools.workbench.screens.scenariosimulation.service.ScenarioSimulationService;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.kie.workbench.common.screens.explorer.model.FolderItemType;
import org.kie.workbench.common.screens.library.api.AssetInfo;
import org.kie.workbench.common.screens.library.api.AssetQueryResult;
import org.kie.workbench.common.screens.library.api.ProjectAssetsQuery;
import org.kie.workbench.common.screens.library.client.screens.assets.AssetQueryService;
import org.kie.workbench.common.screens.library.client.util.LibraryPlaces;
import org.kie.workbench.common.widgets.client.assets.dropdown.KieAssetsDropdownItem;
import org.uberfire.backend.vfs.Path;
import org.uberfire.ext.widgets.common.client.callbacks.DefaultErrorCallback;
import org.uberfire.util.URIUtil;

@Dependent
public class ScenarioSimulationAssetsDropdownProviderBCImpl
implements ScenarioSimulationAssetsDropdownProvider {
    protected Caller<ScenarioSimulationService> scenarioSimulationService;
    protected LibraryPlaces libraryPlaces;
    protected AssetQueryService assetQueryService;

    @Inject
    public ScenarioSimulationAssetsDropdownProviderBCImpl(Caller<ScenarioSimulationService> scenarioSimulationService, LibraryPlaces libraryPlaces, AssetQueryService assetQueryService) {
        this.scenarioSimulationService = scenarioSimulationService;
        this.libraryPlaces = libraryPlaces;
        this.assetQueryService = assetQueryService;
    }

    public void getItems(Consumer<List<KieAssetsDropdownItem>> assetListConsumer) {
        this.updateAssets((RemoteCallback<AssetQueryResult>)((RemoteCallback)response -> this.addAssets((AssetQueryResult)response, assetListConsumer)));
    }

    protected void updateAssets(RemoteCallback<AssetQueryResult> callback) {
        ProjectAssetsQuery query = this.createProjectQuery();
        this.assetQueryService.getAssets(query).call(callback, (ErrorCallback)new DefaultErrorCallback());
    }

    protected ProjectAssetsQuery createProjectQuery() {
        List<String> suffixes = Collections.singletonList("dmn");
        return new ProjectAssetsQuery(this.libraryPlaces.getActiveWorkspace(), "", 0, 1000, suffixes);
    }

    protected void addAssets(AssetQueryResult result, Consumer<List<KieAssetsDropdownItem>> assetListConsumer) {
        if (Objects.equals(AssetQueryResult.ResultType.Normal, result.getResultType())) {
            result.getAssetInfos().ifPresent(assetInfos -> this.addAssets((List<AssetInfo>)assetInfos, assetListConsumer));
        }
    }

    protected void addAssets(List<AssetInfo> assetInfos, Consumer<List<KieAssetsDropdownItem>> assetListConsumer) {
        List kieAssetsDropdownItems = assetInfos.stream().filter(item -> item.getFolderItem().getType().equals((Object)FolderItemType.FILE)).map(this::getKieAssetsDropdownItem).collect(Collectors.toList());
        assetListConsumer.accept(kieAssetsDropdownItems);
    }

    protected KieAssetsDropdownItem getKieAssetsDropdownItem(AssetInfo asset) {
        String fullPath = ((Path)asset.getFolderItem().getItem()).toURI();
        String projectRootPath = this.libraryPlaces.getActiveWorkspace().getRootPath().toURI();
        String relativeAssetPath = fullPath.substring(projectRootPath.length());
        String decodedRelativeAssetPath = URIUtil.decode((String)relativeAssetPath);
        String fileName = ((Path)asset.getFolderItem().getItem()).getFileName();
        return new KieAssetsDropdownItem(fileName, decodedRelativeAssetPath, decodedRelativeAssetPath, new HashMap());
    }
}

