/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.businesscentral.client.dropdown;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.drools.workbench.screens.scenariosimulation.businesscentral.client.dropdown.ScenarioSimulationAssetsDropdownProviderBCImpl;
import org.drools.workbench.screens.scenariosimulation.service.ScenarioSimulationService;
import org.guvnor.common.services.project.model.WorkspaceProject;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.screens.explorer.model.FolderItem;
import org.kie.workbench.common.screens.explorer.model.FolderItemType;
import org.kie.workbench.common.screens.library.api.AssetInfo;
import org.kie.workbench.common.screens.library.api.AssetQueryResult;
import org.kie.workbench.common.screens.library.api.ProjectAssetsQuery;
import org.kie.workbench.common.screens.library.client.screens.assets.AssetQueryService;
import org.kie.workbench.common.screens.library.client.util.LibraryPlaces;
import org.kie.workbench.common.widgets.client.assets.dropdown.KieAssetsDropdownItem;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.backend.vfs.Path;
import org.uberfire.ext.widgets.common.client.callbacks.DefaultErrorCallback;

@RunWith(value=GwtMockitoTestRunner.class)
public class ScenarioSimulationAssetsDropdownProviderTest {
    @Mock
    private Caller<ScenarioSimulationService> scenarioSimulationServiceCallerMock;
    @Mock
    private ScenarioSimulationService scenarioSimulationServiceMock;
    @Mock
    private LibraryPlaces libraryPlacesMock;
    @Mock
    private AssetQueryService assetQueryServiceMock;
    @Mock
    private WorkspaceProject workspaceProjectMock;
    @Mock
    private Path rootPathMock;
    @Mock
    private AssetQueryService.Invoker<AssetQueryResult> invokerMock;
    @Mock
    private Consumer<List<KieAssetsDropdownItem>> assetListConsumerMock;
    private ScenarioSimulationAssetsDropdownProviderBCImpl scenarioSimulationAssetsDropdownProvider;
    private ProjectAssetsQuery projectAssetsQuery;

    @Before
    public void setup() {
        Mockito.when((Object)this.scenarioSimulationServiceCallerMock.call((RemoteCallback)Matchers.any())).thenReturn((Object)this.scenarioSimulationServiceMock);
        Mockito.when((Object)this.libraryPlacesMock.getActiveWorkspace()).thenReturn((Object)this.workspaceProjectMock);
        Mockito.when((Object)this.workspaceProjectMock.getRootPath()).thenReturn((Object)this.rootPathMock);
        Mockito.when((Object)this.rootPathMock.toURI()).thenReturn((Object)"project/");
        Mockito.when((Object)this.assetQueryServiceMock.getAssets((ProjectAssetsQuery)Matchers.eq((Object)this.projectAssetsQuery))).thenReturn(this.invokerMock);
        this.scenarioSimulationAssetsDropdownProvider = (ScenarioSimulationAssetsDropdownProviderBCImpl)Mockito.spy((Object)new ScenarioSimulationAssetsDropdownProviderBCImpl(this.scenarioSimulationServiceCallerMock, this.libraryPlacesMock, this.assetQueryServiceMock){

            protected ProjectAssetsQuery createProjectQuery() {
                return ScenarioSimulationAssetsDropdownProviderTest.this.projectAssetsQuery;
            }
        });
        this.projectAssetsQuery = this.scenarioSimulationAssetsDropdownProvider.createProjectQuery();
    }

    @Test
    public void getItems() {
        Consumer assetListConsumerMock = (Consumer)Mockito.mock(Consumer.class);
        ((ScenarioSimulationAssetsDropdownProviderBCImpl)Mockito.doAnswer(invocation -> null).when((Object)this.scenarioSimulationAssetsDropdownProvider)).updateAssets((RemoteCallback)Matchers.isA(RemoteCallback.class));
        this.scenarioSimulationAssetsDropdownProvider.getItems(assetListConsumerMock);
        ((ScenarioSimulationAssetsDropdownProviderBCImpl)Mockito.verify((Object)this.scenarioSimulationAssetsDropdownProvider, (VerificationMode)Mockito.times((int)1))).updateAssets((RemoteCallback)Matchers.isA(RemoteCallback.class));
    }

    @Test
    public void updateAssets() {
        RemoteCallback remoteCallbackMock = (RemoteCallback)Mockito.mock(RemoteCallback.class);
        this.scenarioSimulationAssetsDropdownProvider.updateAssets(remoteCallbackMock);
        ((AssetQueryService)Mockito.verify((Object)this.assetQueryServiceMock, (VerificationMode)Mockito.times((int)1))).getAssets((ProjectAssetsQuery)Matchers.eq((Object)this.projectAssetsQuery));
        ((AssetQueryService.Invoker)Mockito.verify(this.invokerMock, (VerificationMode)Mockito.times((int)1))).call((RemoteCallback)Matchers.eq((Object)remoteCallbackMock), (ErrorCallback)Matchers.isA(DefaultErrorCallback.class));
    }

    @Test
    public void createProjectQuery() {
        this.scenarioSimulationAssetsDropdownProvider = (ScenarioSimulationAssetsDropdownProviderBCImpl)Mockito.spy((Object)new ScenarioSimulationAssetsDropdownProviderBCImpl(this.scenarioSimulationServiceCallerMock, this.libraryPlacesMock, this.assetQueryServiceMock){});
        ProjectAssetsQuery retrieved = this.scenarioSimulationAssetsDropdownProvider.createProjectQuery();
        Assert.assertEquals((long)retrieved.getAmount(), (long)1000L);
        Assert.assertEquals((long)retrieved.getStartIndex(), (long)0L);
        Assert.assertEquals((Object)retrieved.getFilter(), (Object)"");
        Assert.assertEquals((Object)retrieved.getProject(), (Object)this.workspaceProjectMock);
    }

    @Test
    public void addAssets() {
        int size = 4;
        AssetQueryResult assetQueryResult = this.getAssetQueryResult(size);
        this.scenarioSimulationAssetsDropdownProvider.addAssets(assetQueryResult, this.assetListConsumerMock);
    }

    private AssetQueryResult getAssetQueryResult(int size) {
        return AssetQueryResult.normal(this.getAssetInfoList(size));
    }

    private List<AssetInfo> getAssetInfoList(int size) {
        return IntStream.range(0, size).mapToObj(i -> this.getAssetInfoMock()).collect(Collectors.toList());
    }

    private AssetInfo getAssetInfoMock() {
        AssetInfo toReturn = (AssetInfo)Mockito.mock(AssetInfo.class);
        FolderItem folderItemMock = this.getFolderItemMock();
        Mockito.when((Object)toReturn.getFolderItem()).thenReturn((Object)folderItemMock);
        return toReturn;
    }

    private FolderItem getFolderItemMock() {
        FolderItem toReturn = (FolderItem)Mockito.mock(FolderItem.class);
        Path path = (Path)Mockito.mock(Path.class);
        Mockito.when((Object)toReturn.getType()).thenReturn((Object)FolderItemType.FILE);
        Mockito.when((Object)toReturn.getItem()).thenReturn((Object)path);
        Mockito.when((Object)path.toURI()).thenReturn((Object)"project/test.dmn");
        return toReturn;
    }
}

