/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.businesscentral.client.rightpanel.coverage;

import elemental2.dom.DomGlobal;
import elemental2.dom.HTMLLIElement;
import elemental2.dom.HTMLUListElement;
import elemental2.dom.Node;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.drools.scenariosimulation.api.model.Scenario;
import org.drools.scenariosimulation.api.model.ScenarioSimulationModel;
import org.drools.scenariosimulation.api.model.ScenarioWithIndex;
import org.drools.workbench.screens.scenariosimulation.businesscentral.client.editor.ScenarioSimulationBusinessCentralViewsProvider;
import org.drools.workbench.screens.scenariosimulation.businesscentral.client.rightpanel.coverage.CoverageScenarioListView;
import org.drools.workbench.screens.scenariosimulation.client.resources.i18n.ScenarioSimulationEditorConstants;

@Dependent
public class CoverageScenarioListPresenter
implements CoverageScenarioListView.Presenter {
    @Inject
    protected ScenarioSimulationBusinessCentralViewsProvider viewsProvider;
    private HTMLUListElement scenarioList;

    @Override
    public void initScenarioList(HTMLUListElement scenarioList) {
        this.scenarioList = scenarioList;
    }

    @Override
    public void addScesimDataGroup(ScenarioWithIndex scenarioWithIndex, Map<String, Integer> resultCounter, ScenarioSimulationModel.Type type) {
        CoverageScenarioListView coverageScenarioListView = this.viewsProvider.getCoverageScenarioListView();
        coverageScenarioListView.setPresenter(this);
        coverageScenarioListView.setVisible(false);
        HTMLLIElement scenarioElement = coverageScenarioListView.getScenarioElement();
        String customText = ScenarioSimulationModel.Type.DMN.equals((Object)type) ? ScenarioSimulationEditorConstants.INSTANCE.decisionsEvaluated() : ScenarioSimulationEditorConstants.INSTANCE.rulesFired();
        String itemLabel = customText + " " + scenarioWithIndex.getIndex() + ": " + ((Scenario)scenarioWithIndex.getScesimData()).getDescription();
        coverageScenarioListView.setItemLabel(itemLabel);
        scenarioElement.appendChild((Node)this.createInternalList(resultCounter, coverageScenarioListView.getScenarioContentList()));
        this.scenarioList.appendChild((Node)scenarioElement);
    }

    @Override
    public void clear() {
        while (this.scenarioList.firstChild != null) {
            this.scenarioList.removeChild(this.scenarioList.firstChild);
        }
    }

    protected HTMLUListElement createInternalList(Map<String, Integer> elements, HTMLUListElement listGroup) {
        ArrayList<String> keys = new ArrayList<String>(elements.keySet());
        keys.sort(Comparator.naturalOrder());
        for (String key : keys) {
            Integer counter = elements.get(key);
            HTMLLIElement listElement = this.createElementLi();
            listElement.textContent = this.createContent(key, counter);
            listGroup.appendChild((Node)listElement);
        }
        return listGroup;
    }

    protected HTMLLIElement createElementLi() {
        HTMLLIElement li = (HTMLLIElement)DomGlobal.document.createElement("li");
        li.classList.add(new String[]{"list-group-item"});
        return li;
    }

    protected String createContent(String value, Integer counter) {
        return value + (counter != null && counter > 1 ? " (" + counter + ")" : "");
    }

    @Override
    public void onElementClick(CoverageScenarioListView coverageScenarioListView) {
        coverageScenarioListView.setVisible(!coverageScenarioListView.isVisible());
    }
}

