/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.businesscentral.client.rightpanel.coverage;

import com.google.gwtmockito.GwtMockitoTestRunner;
import elemental2.dom.HTMLButtonElement;
import elemental2.dom.HTMLDivElement;
import elemental2.dom.HTMLElement;
import elemental2.dom.HTMLUListElement;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.scenariosimulation.api.model.AuditLog;
import org.drools.scenariosimulation.api.model.Scenario;
import org.drools.scenariosimulation.api.model.ScenarioSimulationModel;
import org.drools.scenariosimulation.api.model.ScenarioWithIndex;
import org.drools.scenariosimulation.api.model.SimulationRunMetadata;
import org.drools.workbench.screens.scenariosimulation.businesscentral.client.rightpanel.coverage.CoverageElementPresenter;
import org.drools.workbench.screens.scenariosimulation.businesscentral.client.rightpanel.coverage.CoverageReportDonutPresenter;
import org.drools.workbench.screens.scenariosimulation.businesscentral.client.rightpanel.coverage.CoverageReportPresenter;
import org.drools.workbench.screens.scenariosimulation.businesscentral.client.rightpanel.coverage.CoverageReportView;
import org.drools.workbench.screens.scenariosimulation.businesscentral.client.rightpanel.coverage.CoverageScenarioListPresenter;
import org.drools.workbench.screens.scenariosimulation.client.resources.i18n.ScenarioSimulationEditorConstants;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.mvp.Command;

@RunWith(value=GwtMockitoTestRunner.class)
public class CoverageReportPresenterTest {
    @Mock
    protected CoverageReportDonutPresenter coverageReportDonutPresenterMock;
    @Mock
    protected CoverageElementPresenter coverageElementPresenterMock;
    @Mock
    protected CoverageScenarioListPresenter coverageScenarioListPresenterMock;
    @Mock
    protected CoverageReportView coverageReportViewMock;
    @Mock
    private HTMLDivElement donutChartMock;
    @Mock
    private HTMLElement list;
    @Mock
    private HTMLUListElement scenarioList;
    @Mock
    private HTMLButtonElement downloadReportButtonMock;
    @Mock
    private Command downloadReportCommandMock;
    @InjectMocks
    protected CoverageReportPresenter presenter;
    @Captor
    protected ArgumentCaptor<ScenarioWithIndex> scenarioWithIndexCaptor;
    @Captor
    protected ArgumentCaptor<Map<String, Integer>> resultCounterCaptor;
    @Captor
    protected ArgumentCaptor<String> descriptionCaptor;
    @Captor
    protected ArgumentCaptor<String> valueCaptor;
    protected CoverageReportPresenter presenterSpy;
    protected SimulationRunMetadata simulationRunMetadataLocal;
    private Map<String, Integer> outputCounterLocal;
    private Map<ScenarioWithIndex, Map<String, Integer>> scenarioCounterLocal;
    private AuditLog auditLog;
    private int availableLocal;
    private int executedLocal;
    private double coverageLocal;

    @Before
    public void setup() {
        this.presenterSpy = (CoverageReportPresenter)Mockito.spy((Object)this.presenter);
        this.presenterSpy.downloadReportCommand = this.downloadReportCommandMock;
        Mockito.when((Object)this.coverageReportViewMock.getDonutChart()).thenReturn((Object)this.donutChartMock);
        Mockito.when((Object)this.coverageReportViewMock.getList()).thenReturn((Object)this.list);
        Mockito.when((Object)this.coverageReportViewMock.getScenarioList()).thenReturn((Object)this.scenarioList);
        Mockito.when((Object)this.coverageReportViewMock.getDownloadReportButton()).thenReturn((Object)this.downloadReportButtonMock);
        this.availableLocal = 10;
        this.executedLocal = 6;
        this.coverageLocal = (double)this.executedLocal / (double)this.availableLocal * 100.0;
        this.outputCounterLocal = new HashMap<String, Integer>();
        this.outputCounterLocal.put("d1", 1);
        this.outputCounterLocal.put("d2", 2);
        this.scenarioCounterLocal = new HashMap<ScenarioWithIndex, Map<String, Integer>>();
        HashMap<String, Integer> scenario1Data = new HashMap<String, Integer>();
        scenario1Data.put("d1", 1);
        scenario1Data.put("d2", 1);
        HashMap<String, Integer> scenario2Data = new HashMap<String, Integer>();
        scenario2Data.put("d2", 1);
        this.scenarioCounterLocal.put(new ScenarioWithIndex(1, new Scenario()), scenario1Data);
        this.scenarioCounterLocal.put(new ScenarioWithIndex(2, new Scenario()), scenario2Data);
        this.simulationRunMetadataLocal = new SimulationRunMetadata(this.availableLocal, this.executedLocal, this.outputCounterLocal, this.scenarioCounterLocal, this.auditLog);
    }

    @Test
    public void init() {
        this.presenterSpy.init();
        ((CoverageReportDonutPresenter)Mockito.verify((Object)this.coverageReportDonutPresenterMock, (VerificationMode)Mockito.times((int)1))).init((HTMLDivElement)Matchers.eq((Object)this.donutChartMock));
        ((CoverageElementPresenter)Mockito.verify((Object)this.coverageElementPresenterMock, (VerificationMode)Mockito.times((int)1))).initElementList((HTMLElement)Matchers.eq((Object)this.list));
        ((CoverageScenarioListPresenter)Mockito.verify((Object)this.coverageScenarioListPresenterMock, (VerificationMode)Mockito.times((int)1))).initScenarioList((HTMLUListElement)Matchers.eq((Object)this.scenarioList));
        ((CoverageReportPresenter)Mockito.verify((Object)this.presenterSpy, (VerificationMode)Mockito.times((int)1))).resetDownload();
    }

    @Test
    public void populateCoverageReport() {
        this.presenterSpy.populateCoverageReport(ScenarioSimulationModel.Type.DMN, this.simulationRunMetadataLocal);
        ((CoverageReportPresenter)Mockito.verify((Object)this.presenterSpy, (VerificationMode)Mockito.times((int)1))).setSimulationRunMetadata((SimulationRunMetadata)Matchers.eq((Object)this.simulationRunMetadataLocal), (ScenarioSimulationModel.Type)Matchers.eq((Object)ScenarioSimulationModel.Type.DMN));
        Mockito.reset((Object[])new CoverageReportPresenter[]{this.presenterSpy});
        this.presenterSpy.populateCoverageReport(ScenarioSimulationModel.Type.DMN, null);
        ((CoverageReportPresenter)Mockito.verify((Object)this.presenterSpy, (VerificationMode)Mockito.times((int)1))).showEmptyStateMessage();
        Mockito.reset((Object[])new CoverageReportPresenter[]{this.presenterSpy});
        this.presenterSpy.populateCoverageReport(ScenarioSimulationModel.Type.RULE, this.simulationRunMetadataLocal);
        ((CoverageReportPresenter)Mockito.verify((Object)this.presenterSpy, (VerificationMode)Mockito.times((int)1))).setSimulationRunMetadata((SimulationRunMetadata)Matchers.eq((Object)this.simulationRunMetadataLocal), (ScenarioSimulationModel.Type)Matchers.eq((Object)ScenarioSimulationModel.Type.RULE));
    }

    @Test
    public void setSimulationRunMetadata() {
        this.presenterSpy.setSimulationRunMetadata(this.simulationRunMetadataLocal, ScenarioSimulationModel.Type.DMN);
        ((CoverageReportPresenter)Mockito.verify((Object)this.presenterSpy, (VerificationMode)Mockito.times((int)1))).populateSummary(Matchers.eq((int)this.availableLocal), Matchers.eq((int)this.executedLocal), Matchers.eq((double)this.coverageLocal));
        ((CoverageReportPresenter)Mockito.verify((Object)this.presenterSpy, (VerificationMode)Mockito.times((int)1))).populateList((Map)Matchers.eq(this.outputCounterLocal));
        ((CoverageReportPresenter)Mockito.verify((Object)this.presenterSpy, (VerificationMode)Mockito.times((int)1))).populateScenarioList((Map)Matchers.eq(this.scenarioCounterLocal), (ScenarioSimulationModel.Type)Matchers.eq((Object)ScenarioSimulationModel.Type.DMN));
        ((CoverageReportView)Mockito.verify((Object)this.coverageReportViewMock, (VerificationMode)Mockito.times((int)1))).show();
        ((CoverageReportView)Mockito.verify((Object)this.coverageReportViewMock, (VerificationMode)Mockito.never())).setEmptyStatusText(Matchers.anyString());
        ((CoverageReportView)Mockito.verify((Object)this.coverageReportViewMock, (VerificationMode)Mockito.never())).hide();
    }

    @Test
    public void setSimulationRunMetadataNoRuleOrDecisionDMN() {
        this.simulationRunMetadataLocal = new SimulationRunMetadata(0, this.executedLocal, this.outputCounterLocal, this.scenarioCounterLocal, this.auditLog);
        this.presenterSpy.setSimulationRunMetadata(this.simulationRunMetadataLocal, ScenarioSimulationModel.Type.DMN);
        ((CoverageReportView)Mockito.verify((Object)this.coverageReportViewMock, (VerificationMode)Mockito.times((int)1))).setEmptyStatusText((String)Matchers.eq((Object)ScenarioSimulationEditorConstants.INSTANCE.noDecisionsAvailable()));
        ((CoverageReportView)Mockito.verify((Object)this.coverageReportViewMock, (VerificationMode)Mockito.times((int)1))).hide();
        ((CoverageReportPresenter)Mockito.verify((Object)this.presenterSpy, (VerificationMode)Mockito.never())).populateSummary(Matchers.anyInt(), Matchers.anyInt(), Matchers.anyDouble());
        ((CoverageReportPresenter)Mockito.verify((Object)this.presenterSpy, (VerificationMode)Mockito.never())).populateList((Map)Matchers.any());
        ((CoverageReportPresenter)Mockito.verify((Object)this.presenterSpy, (VerificationMode)Mockito.never())).populateScenarioList((Map)Matchers.any(), (ScenarioSimulationModel.Type)Matchers.any());
        ((CoverageReportView)Mockito.verify((Object)this.coverageReportViewMock, (VerificationMode)Mockito.never())).show();
    }

    @Test
    public void setSimulationRunMetadataNoRuleOrDecisionRULE() {
        this.simulationRunMetadataLocal = new SimulationRunMetadata(0, this.executedLocal, this.outputCounterLocal, this.scenarioCounterLocal, this.auditLog);
        this.presenterSpy.setSimulationRunMetadata(this.simulationRunMetadataLocal, ScenarioSimulationModel.Type.RULE);
        ((CoverageReportView)Mockito.verify((Object)this.coverageReportViewMock, (VerificationMode)Mockito.times((int)1))).setEmptyStatusText((String)Matchers.eq((Object)ScenarioSimulationEditorConstants.INSTANCE.noRulesAvailable()));
        ((CoverageReportView)Mockito.verify((Object)this.coverageReportViewMock, (VerificationMode)Mockito.times((int)1))).hide();
        ((CoverageReportPresenter)Mockito.verify((Object)this.presenterSpy, (VerificationMode)Mockito.never())).populateSummary(Matchers.anyInt(), Matchers.anyInt(), Matchers.anyDouble());
        ((CoverageReportPresenter)Mockito.verify((Object)this.presenterSpy, (VerificationMode)Mockito.never())).populateList((Map)Matchers.any());
        ((CoverageReportPresenter)Mockito.verify((Object)this.presenterSpy, (VerificationMode)Mockito.never())).populateScenarioList((Map)Matchers.any(), (ScenarioSimulationModel.Type)Matchers.any());
        ((CoverageReportView)Mockito.verify((Object)this.coverageReportViewMock, (VerificationMode)Mockito.never())).show();
    }

    @Test
    public void populateSummary() {
        this.presenterSpy.populateSummary(this.availableLocal, this.executedLocal, this.coverageLocal);
        ((CoverageReportView)Mockito.verify((Object)this.coverageReportViewMock, (VerificationMode)Mockito.times((int)1))).setReportAvailable((String)Matchers.eq((Object)(this.availableLocal + "")));
        ((CoverageReportView)Mockito.verify((Object)this.coverageReportViewMock, (VerificationMode)Mockito.times((int)1))).setReportExecuted((String)Matchers.eq((Object)(this.executedLocal + "")));
        ((CoverageReportView)Mockito.verify((Object)this.coverageReportViewMock, (VerificationMode)Mockito.times((int)1))).setReportCoverage(Matchers.endsWith((String)"%"));
        int delta = this.availableLocal - this.executedLocal;
        ((CoverageReportDonutPresenter)Mockito.verify((Object)this.coverageReportDonutPresenterMock, (VerificationMode)Mockito.times((int)1))).showCoverageReport(Matchers.eq((int)this.executedLocal), Matchers.eq((int)delta), Matchers.endsWith((String)"%"));
        ((CoverageReportDonutPresenter)Mockito.verify((Object)this.coverageReportDonutPresenterMock, (VerificationMode)Mockito.times((int)1))).initializeCSS();
    }

    @Test
    public void populateList() {
        this.presenterSpy.populateList(this.outputCounterLocal);
        ((CoverageElementPresenter)Mockito.verify((Object)this.coverageElementPresenterMock, (VerificationMode)Mockito.times((int)1))).clear();
        ((CoverageElementPresenter)Mockito.verify((Object)this.coverageElementPresenterMock, (VerificationMode)Mockito.times((int)this.outputCounterLocal.size()))).addElementView((String)this.descriptionCaptor.capture(), (String)this.valueCaptor.capture());
        List descriptions = this.descriptionCaptor.getAllValues();
        Assert.assertEquals((long)2L, (long)descriptions.size());
        Assert.assertEquals((Object)"d1", descriptions.get(0));
        Assert.assertEquals((Object)"d2", descriptions.get(1));
        List values = this.valueCaptor.getAllValues();
        Assert.assertEquals((long)2L, (long)values.size());
        Assert.assertEquals((Object)"1", values.get(0));
        Assert.assertEquals((Object)"2", values.get(1));
    }

    @Test
    public void populateScenarioList() {
        this.presenterSpy.populateScenarioList(this.scenarioCounterLocal, ScenarioSimulationModel.Type.DMN);
        ((CoverageScenarioListPresenter)Mockito.verify((Object)this.coverageScenarioListPresenterMock, (VerificationMode)Mockito.times((int)1))).clear();
        ((CoverageScenarioListPresenter)Mockito.verify((Object)this.coverageScenarioListPresenterMock, (VerificationMode)Mockito.times((int)this.scenarioCounterLocal.size()))).addScesimDataGroup((ScenarioWithIndex)this.scenarioWithIndexCaptor.capture(), (Map)this.resultCounterCaptor.capture(), (ScenarioSimulationModel.Type)Matchers.eq((Object)ScenarioSimulationModel.Type.DMN));
        List scenarios = this.scenarioWithIndexCaptor.getAllValues();
        Assert.assertEquals((long)this.scenarioCounterLocal.size(), (long)scenarios.size());
        Assert.assertEquals((long)1L, (long)((ScenarioWithIndex)scenarios.get(0)).getIndex());
        Assert.assertEquals((long)2L, (long)((ScenarioWithIndex)scenarios.get(1)).getIndex());
        List resultCounters = this.resultCounterCaptor.getAllValues();
        Assert.assertEquals((long)this.scenarioCounterLocal.size(), (long)resultCounters.size());
        Assert.assertTrue((boolean)((Map)resultCounters.get(0)).keySet().contains("d1"));
        Assert.assertEquals((long)1L, (long)((Integer)((Map)resultCounters.get(0)).get("d1")).intValue());
        Assert.assertTrue((boolean)((Map)resultCounters.get(0)).keySet().contains("d2"));
        Assert.assertEquals((long)1L, (long)((Integer)((Map)resultCounters.get(0)).get("d2")).intValue());
        Assert.assertTrue((boolean)((Map)resultCounters.get(1)).keySet().contains("d2"));
        Assert.assertEquals((long)1L, (long)((Integer)((Map)resultCounters.get(1)).get("d2")).intValue());
    }

    @Test
    public void showEmptyStateMessage() {
        this.presenterSpy.showEmptyStateMessage();
        ((CoverageReportView)Mockito.verify((Object)this.coverageReportViewMock, (VerificationMode)Mockito.times((int)1))).setEmptyStatusText(Matchers.anyString());
        ((CoverageReportView)Mockito.verify((Object)this.coverageReportViewMock, (VerificationMode)Mockito.times((int)1))).hide();
    }

    @Test
    public void resetTest() {
        this.presenterSpy.reset();
        ((CoverageReportView)Mockito.verify((Object)this.coverageReportViewMock, (VerificationMode)Mockito.times((int)1))).reset();
        ((CoverageReportPresenter)Mockito.verify((Object)this.presenterSpy, (VerificationMode)Mockito.times((int)1))).resetDownload();
    }

    @Test
    public void onDownloadButtonClicked() {
        this.presenterSpy.onDownloadReportButtonClicked();
        ((Command)Mockito.verify((Object)this.downloadReportCommandMock, (VerificationMode)Mockito.times((int)1))).execute();
    }

    @Test
    public void onDownloadButtonClicked_NoCommandAssigned() {
        this.presenterSpy.downloadReportCommand = null;
        this.presenterSpy.onDownloadReportButtonClicked();
        ((Command)Mockito.verify((Object)this.downloadReportCommandMock, (VerificationMode)Mockito.never())).execute();
    }

    @Test
    public void setDownloadReportCommand() {
        this.presenterSpy.setDownloadReportCommand(this.downloadReportCommandMock);
        Assert.assertSame((Object)this.presenterSpy.downloadReportCommand, (Object)this.downloadReportCommandMock);
        Assert.assertFalse((boolean)this.downloadReportButtonMock.disabled);
    }

    @Test
    public void setDownloadReportCommandNull() {
        this.presenterSpy.setDownloadReportCommand(null);
        Assert.assertNull((Object)this.presenterSpy.downloadReportCommand);
        Assert.assertTrue((boolean)this.downloadReportButtonMock.disabled);
    }

    @Test
    public void resetDownload() {
        this.presenterSpy.resetDownload();
        Assert.assertTrue((boolean)this.downloadReportButtonMock.disabled);
        Assert.assertNull((Object)this.presenterSpy.downloadReportCommand);
    }
}

