/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.businesscentral.client.editor.strategies;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.commons.lang3.RandomStringUtils;
import org.drools.workbench.screens.scenariosimulation.businesscentral.client.editor.strategies.BusinessCentralDMODataManagementStrategy;
import org.drools.workbench.screens.scenariosimulation.client.commands.ScenarioSimulationContext;
import org.drools.workbench.screens.scenariosimulation.client.editor.AbstractScenarioSimulationEditorTest;
import org.drools.workbench.screens.scenariosimulation.client.editor.strategies.AbstractDataManagementStrategy;
import org.drools.workbench.screens.scenariosimulation.client.enums.GridWidget;
import org.drools.workbench.screens.scenariosimulation.client.models.AbstractScesimGridModel;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.TestToolsView;
import org.drools.workbench.screens.scenariosimulation.model.typedescriptor.FactModelTree;
import org.drools.workbench.screens.scenariosimulation.model.typedescriptor.FactModelTuple;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.soup.project.datamodel.imports.HasImports;
import org.kie.soup.project.datamodel.oracle.ModelField;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracle;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.backend.vfs.Path;
import org.uberfire.client.callbacks.Callback;

@RunWith(value=GwtMockitoTestRunner.class)
public class BusinessCentralDMODataManagementStrategyTest
extends AbstractScenarioSimulationEditorTest {
    private BusinessCentralDMODataManagementStrategy businessCentralDmoDataManagementStrategySpy;
    @Mock
    private AsyncPackageDataModelOracle oracleMock;
    @Mock
    private GridWidget gridWidgetMock;
    @Captor
    private ArgumentCaptor<Callback<String>> callbackArgumentCaptor;
    private AbstractDataManagementStrategy.ResultHolder factModelTreeHolderlocal;
    private FactModelTuple factModelTupleLocal;

    @Before
    public void setup() {
        super.setup();
        this.factModelTupleLocal = new FactModelTuple(new TreeMap(), new TreeMap());
        this.factModelTreeHolderlocal = new AbstractDataManagementStrategy.ResultHolder();
        this.factModelTreeHolderlocal.setFactModelTuple(this.factModelTupleLocal);
        Mockito.when((Object)this.oracleMock.getFQCNByFactName("FACT_NAME")).thenReturn((Object)"test.scesim.TestClass");
        Mockito.when((Object)this.oracleFactoryMock.makeAsyncPackageDataModelOracle((Path)this.observablePathMock, (HasImports)this.modelLocal, this.content.getDataModel())).thenReturn((Object)this.oracleMock);
        this.businessCentralDmoDataManagementStrategySpy = (BusinessCentralDMODataManagementStrategy)Mockito.spy((Object)new BusinessCentralDMODataManagementStrategy(this.oracleFactoryMock){
            {
                this.oracle = BusinessCentralDMODataManagementStrategyTest.this.oracleMock;
                this.factModelTreeHolder = BusinessCentralDMODataManagementStrategyTest.this.factModelTreeHolderlocal;
            }
        });
    }

    @Test
    public void populateTestToolsWithFactTuple() {
        FactModelTuple factModelTupleMock = (FactModelTuple)Mockito.mock(FactModelTuple.class);
        this.factModelTreeHolderlocal.setFactModelTuple(factModelTupleMock);
        ((BusinessCentralDMODataManagementStrategy)Mockito.doNothing().when((Object)this.businessCentralDmoDataManagementStrategySpy)).storeData((FactModelTuple)Matchers.eq((Object)factModelTupleMock), (TestToolsView.Presenter)Matchers.eq((Object)this.testToolsPresenterMock), (ScenarioSimulationContext)Matchers.eq((Object)this.scenarioSimulationContextLocal), (GridWidget)Matchers.eq((Object)GridWidget.SIMULATION));
        this.businessCentralDmoDataManagementStrategySpy.populateTestTools((TestToolsView.Presenter)this.testToolsPresenterMock, this.scenarioSimulationContextLocal, GridWidget.SIMULATION);
        ((BusinessCentralDMODataManagementStrategy)Mockito.verify((Object)this.businessCentralDmoDataManagementStrategySpy, (VerificationMode)Mockito.times((int)1))).storeData((FactModelTuple)Matchers.eq((Object)factModelTupleMock), (TestToolsView.Presenter)Matchers.eq((Object)this.testToolsPresenterMock), (ScenarioSimulationContext)Matchers.eq((Object)this.scenarioSimulationContextLocal), (GridWidget)Matchers.eq((Object)GridWidget.SIMULATION));
    }

    @Test
    public void populateTestToolsWithoutFactTupleEmptyOracle() {
        this.factModelTreeHolderlocal.setFactModelTuple(null);
        HashMap alreadyAssignedProperties = new HashMap();
        ((BusinessCentralDMODataManagementStrategy)Mockito.doReturn(alreadyAssignedProperties).when((Object)this.businessCentralDmoDataManagementStrategySpy)).getPropertiesToHide((AbstractScesimGridModel)this.scenarioGridModelMock);
        String[] emptyFactTypes = new String[]{};
        Mockito.when((Object)this.oracleMock.getFactTypes()).thenReturn((Object)emptyFactTypes);
        this.businessCentralDmoDataManagementStrategySpy.populateTestTools((TestToolsView.Presenter)this.testToolsPresenterMock, this.scenarioSimulationContextLocal, GridWidget.SIMULATION);
        ((BusinessCentralDMODataManagementStrategy)Mockito.verify((Object)this.businessCentralDmoDataManagementStrategySpy, (VerificationMode)Mockito.never())).aggregatorCallback((TestToolsView.Presenter)Matchers.eq((Object)this.testToolsPresenterMock), Matchers.anyInt(), (SortedMap)Matchers.any(SortedMap.class), (ScenarioSimulationContext)Matchers.eq((Object)this.scenarioSimulationContextLocal), (List)Matchers.isA(List.class), (GridWidget)Matchers.eq((Object)GridWidget.SIMULATION));
        ((AsyncPackageDataModelOracle)Mockito.verify((Object)this.oracleMock, (VerificationMode)Mockito.never())).getFieldCompletions(Matchers.anyString(), (Callback)Matchers.any(Callback.class));
    }

    @Test
    public void populateTestToolsWithoutFactTupleWithOnlyDataObjects() {
        this.factModelTreeHolderlocal.setFactModelTuple(null);
        HashMap alreadyAssignedProperties = new HashMap();
        ((BusinessCentralDMODataManagementStrategy)Mockito.doReturn(alreadyAssignedProperties).when((Object)this.businessCentralDmoDataManagementStrategySpy)).getPropertiesToHide((AbstractScesimGridModel)this.scenarioGridModelMock);
        String[] notEmptyFactTypes = this.getRandomStringArray();
        Mockito.when((Object)this.oracleMock.getFactTypes()).thenReturn((Object)notEmptyFactTypes);
        this.businessCentralDmoDataManagementStrategySpy.populateTestTools((TestToolsView.Presenter)this.testToolsPresenterMock, this.scenarioSimulationContextLocal, GridWidget.SIMULATION);
        for (String factType : notEmptyFactTypes) {
            ((AsyncPackageDataModelOracle)Mockito.verify((Object)this.oracleMock, (VerificationMode)Mockito.times((int)1))).getSuperType((String)Matchers.eq((Object)factType), (Callback)this.callbackArgumentCaptor.capture());
            ((Callback)this.callbackArgumentCaptor.getValue()).callback((Object)"");
        }
        ((BusinessCentralDMODataManagementStrategy)Mockito.verify((Object)this.businessCentralDmoDataManagementStrategySpy, (VerificationMode)Mockito.times((int)1))).aggregatorCallback((TestToolsView.Presenter)Matchers.eq((Object)this.testToolsPresenterMock), Matchers.anyInt(), (SortedMap)Matchers.any(SortedMap.class), (ScenarioSimulationContext)Matchers.eq((Object)this.scenarioSimulationContextLocal), (List)Matchers.isA(List.class), (GridWidget)Matchers.eq((Object)GridWidget.SIMULATION));
        for (String factType : notEmptyFactTypes) {
            ((AsyncPackageDataModelOracle)Mockito.verify((Object)this.oracleMock, (VerificationMode)Mockito.times((int)1))).getFieldCompletions((String)Matchers.eq((Object)factType), (Callback)Matchers.any(Callback.class));
        }
    }

    @Test
    public void populateTestToolsWithoutFactTupleWithDataObjectsAndSimpleJavaTypes() {
        this.factModelTreeHolderlocal.setFactModelTuple(null);
        HashMap alreadyAssignedProperties = new HashMap();
        ((BusinessCentralDMODataManagementStrategy)Mockito.doReturn(alreadyAssignedProperties).when((Object)this.businessCentralDmoDataManagementStrategySpy)).getPropertiesToHide((AbstractScesimGridModel)this.scenarioGridModelMock);
        String[] dataObjectTypes = this.getRandomStringArray();
        String[] simpleJavaTypes = this.getSimpleTypeArray();
        String[] notEmptyFactTypes = this.mergeArrays(dataObjectTypes, simpleJavaTypes);
        Mockito.when((Object)this.oracleMock.getFactTypes()).thenReturn((Object)notEmptyFactTypes);
        this.businessCentralDmoDataManagementStrategySpy.populateTestTools((TestToolsView.Presenter)this.testToolsPresenterMock, this.scenarioSimulationContextLocal, GridWidget.SIMULATION);
        for (String factType : dataObjectTypes) {
            ((AsyncPackageDataModelOracle)Mockito.verify((Object)this.oracleMock, (VerificationMode)Mockito.times((int)1))).getSuperType((String)Matchers.eq((Object)factType), (Callback)this.callbackArgumentCaptor.capture());
            ((Callback)this.callbackArgumentCaptor.getValue()).callback((Object)"");
        }
        ((BusinessCentralDMODataManagementStrategy)Mockito.verify((Object)this.businessCentralDmoDataManagementStrategySpy, (VerificationMode)Mockito.times((int)1))).aggregatorCallback((TestToolsView.Presenter)Matchers.eq((Object)this.testToolsPresenterMock), Matchers.anyInt(), (SortedMap)Matchers.any(SortedMap.class), (ScenarioSimulationContext)Matchers.eq((Object)this.scenarioSimulationContextLocal), (List)Matchers.isA(List.class), (GridWidget)Matchers.eq((Object)GridWidget.SIMULATION));
        for (String factType : dataObjectTypes) {
            ((AsyncPackageDataModelOracle)Mockito.verify((Object)this.oracleMock, (VerificationMode)Mockito.times((int)1))).getFieldCompletions((String)Matchers.eq((Object)factType), (Callback)Matchers.any(Callback.class));
        }
    }

    @Test
    public void populateTestToolsWithoutFactTupleWithoutDataObjectsWithSimpleJavaTypes() {
        this.factModelTreeHolderlocal.setFactModelTuple(null);
        HashMap alreadyAssignedProperties = new HashMap();
        ((BusinessCentralDMODataManagementStrategy)Mockito.doReturn(alreadyAssignedProperties).when((Object)this.businessCentralDmoDataManagementStrategySpy)).getPropertiesToHide((AbstractScesimGridModel)this.scenarioGridModelMock);
        String[] notEmptyFactTypes = this.getSimpleTypeArray();
        List<String> simpleJavaTypes = Arrays.asList(notEmptyFactTypes);
        Mockito.when((Object)this.oracleMock.getFactTypes()).thenReturn((Object)notEmptyFactTypes);
        this.businessCentralDmoDataManagementStrategySpy.populateTestTools((TestToolsView.Presenter)this.testToolsPresenterMock, this.scenarioSimulationContextLocal, GridWidget.SIMULATION);
        ((BusinessCentralDMODataManagementStrategy)Mockito.verify((Object)this.businessCentralDmoDataManagementStrategySpy, (VerificationMode)Mockito.never())).aggregatorCallback((TestToolsView.Presenter)Matchers.eq((Object)this.testToolsPresenterMock), Matchers.anyInt(), (SortedMap)Matchers.any(SortedMap.class), (ScenarioSimulationContext)Matchers.eq((Object)this.scenarioSimulationContextLocal), (List)Matchers.isA(List.class), (GridWidget)Matchers.eq((Object)GridWidget.SIMULATION));
        ((BusinessCentralDMODataManagementStrategy)Mockito.verify((Object)this.businessCentralDmoDataManagementStrategySpy, (VerificationMode)Mockito.times((int)1))).aggregatorCallbackMethod((TestToolsView.Presenter)Matchers.eq((Object)this.testToolsPresenterMock), Matchers.eq((int)0), (SortedMap)Matchers.any(SortedMap.class), (ScenarioSimulationContext)Matchers.eq((Object)this.scenarioSimulationContextLocal), (FactModelTree)Matchers.eq(null), (List)Matchers.eq(simpleJavaTypes), (GridWidget)Matchers.eq((Object)GridWidget.SIMULATION));
    }

    @Test
    public void manageScenarioSimulationModelContent() {
        this.businessCentralDmoDataManagementStrategySpy.manageScenarioSimulationModelContent(this.observablePathMock, this.content);
        Assert.assertEquals((Object)this.businessCentralDmoDataManagementStrategySpy.oracle, (Object)this.oracleMock);
    }

    @Test
    public void isADataTypeOracleNull() {
        this.businessCentralDmoDataManagementStrategySpy.oracle = null;
        this.commonIsADataType("TEST", false);
    }

    @Test
    public void isADataTypeOracleNotNull() {
        Mockito.when((Object)this.oracleMock.getFactTypes()).thenReturn((Object)new String[0]);
        this.commonIsADataType("TEST", false);
        Mockito.when((Object)this.oracleMock.getFactTypes()).thenReturn((Object)new String[]{"TEST"});
        this.commonIsADataType("TOAST", false);
        this.commonIsADataType("TEST", true);
    }

    @Test
    public void skipPopulateTestToolsOracleNull() {
        this.businessCentralDmoDataManagementStrategySpy.oracle = null;
        Assert.assertTrue((boolean)this.businessCentralDmoDataManagementStrategySpy.skipPopulateTestTools());
    }

    @Test
    public void skipPopulateTestToolsOracleNotNull() {
        Mockito.when((Object)this.oracleMock.getFactTypes()).thenReturn((Object)new String[0]);
        Assert.assertTrue((boolean)this.businessCentralDmoDataManagementStrategySpy.skipPopulateTestTools());
        Mockito.when((Object)this.oracleMock.getFactTypes()).thenReturn((Object)new String[]{"TEST"});
        Assert.assertFalse((boolean)this.businessCentralDmoDataManagementStrategySpy.skipPopulateTestTools());
    }

    @Test
    public void fieldCompletionsCallbackMethod() {
        ModelField[] result = new ModelField[]{};
        Map superTypesMap = Collections.emptyMap();
        Callback aggregatorCallbackMock = (Callback)Mockito.mock(Callback.class);
        this.businessCentralDmoDataManagementStrategySpy.fieldCompletionsCallbackMethod("FACT_NAME", superTypesMap, result, aggregatorCallbackMock);
        ((BusinessCentralDMODataManagementStrategy)Mockito.verify((Object)this.businessCentralDmoDataManagementStrategySpy, (VerificationMode)Mockito.times((int)1))).getFactModelTree((String)Matchers.eq((Object)"FACT_NAME"), (Map)Matchers.eq(superTypesMap), (ModelField[])Matchers.eq((Object)result));
        ((Callback)Mockito.verify((Object)aggregatorCallbackMock, (VerificationMode)Mockito.times((int)1))).callback((Object)((FactModelTree)Matchers.isA(FactModelTree.class)));
    }

    @Test
    public void fieldCompletionsCallback() {
        ModelField[] result = new ModelField[]{};
        Map superTypesMap = Collections.emptyMap();
        Callback aggregatorCallbackMock = (Callback)Mockito.mock(Callback.class);
        Callback returnCallback = this.businessCentralDmoDataManagementStrategySpy.fieldCompletionsCallback("FACT_NAME", superTypesMap, aggregatorCallbackMock);
        returnCallback.callback((Object)result);
        ((BusinessCentralDMODataManagementStrategy)Mockito.verify((Object)this.businessCentralDmoDataManagementStrategySpy, (VerificationMode)Mockito.times((int)1))).fieldCompletionsCallbackMethod((String)Matchers.eq((Object)"FACT_NAME"), (Map)Matchers.eq(superTypesMap), (ModelField[])Matchers.eq((Object)result), (Callback)Matchers.eq((Object)aggregatorCallbackMock));
    }

    @Test
    public void getInstanceMap() {
        FactModelTree toPopulate = this.getFactModelTreeInner(RandomStringUtils.randomAlphabetic((int)3));
        Map simpleProperties = toPopulate.getSimpleProperties();
        Collection<FactModelTree.PropertyTypeName> values = simpleProperties.values();
        SortedMap<String, FactModelTree> factTypeFieldsMap = this.getFactTypeFieldsMapInner(values);
        SortedMap retrieved = this.businessCentralDmoDataManagementStrategySpy.getInstanceMap(factTypeFieldsMap);
        Assert.assertNotNull((Object)retrieved);
    }

    @Test
    public void populateGenericTypeMap() {
        this.commonPopulateGenericTypeMap(true);
        this.commonPopulateGenericTypeMap(false);
    }

    @Test
    public void aggregatorCallbackMethodWithResultAllElements() {
        SortedMap<String, FactModelTree> factTypeFieldsMap = this.getRandomMap();
        String resultName = "RESULT_NAME";
        FactModelTree resultMock = (FactModelTree)Mockito.mock(FactModelTree.class);
        Mockito.when((Object)resultMock.getFactName()).thenReturn((Object)resultName);
        List<String> simpleJavaTypes = Arrays.asList(this.getSimpleTypeArray());
        this.factModelTreeHolderlocal.setFactModelTuple(null);
        this.businessCentralDmoDataManagementStrategySpy.aggregatorCallbackMethod((TestToolsView.Presenter)this.testToolsPresenterMock, factTypeFieldsMap.size() + 1, factTypeFieldsMap, this.scenarioSimulationContextLocal, resultMock, simpleJavaTypes, GridWidget.SIMULATION);
        ((FactModelTree)Mockito.verify((Object)resultMock, (VerificationMode)Mockito.times((int)1))).getFactName();
        Assert.assertTrue((boolean)factTypeFieldsMap.containsKey(resultName));
        Assert.assertEquals((Object)resultMock, factTypeFieldsMap.get(resultName));
        factTypeFieldsMap.values().forEach(factModelTree -> ((BusinessCentralDMODataManagementStrategy)Mockito.verify((Object)this.businessCentralDmoDataManagementStrategySpy, (VerificationMode)Mockito.times((int)1))).populateFactModelTree((FactModelTree)Matchers.eq((Object)factModelTree), (SortedMap)Matchers.eq((Object)factTypeFieldsMap)));
        Assert.assertNotNull((Object)this.factModelTreeHolderlocal.getFactModelTuple());
        ((BusinessCentralDMODataManagementStrategy)Mockito.verify((Object)this.businessCentralDmoDataManagementStrategySpy, (VerificationMode)Mockito.times((int)1))).storeData((FactModelTuple)Matchers.eq((Object)this.factModelTreeHolderlocal.getFactModelTuple()), (TestToolsView.Presenter)Matchers.eq((Object)this.testToolsPresenterMock), (ScenarioSimulationContext)Matchers.eq((Object)this.scenarioSimulationContextLocal), (GridWidget)Matchers.eq((Object)GridWidget.SIMULATION));
    }

    @Test
    public void aggregatorCallbackMethodWithResultNotAllElements() {
        SortedMap<String, FactModelTree> factTypeFieldsMap = this.getRandomMap();
        String resultName = "RESULT_NAME";
        FactModelTree resultMock = (FactModelTree)Mockito.mock(FactModelTree.class);
        Mockito.when((Object)resultMock.getFactName()).thenReturn((Object)resultName);
        List<String> simpleJavaTypes = Arrays.asList(this.getSimpleTypeArray());
        this.factModelTreeHolderlocal.setFactModelTuple(null);
        this.businessCentralDmoDataManagementStrategySpy.aggregatorCallbackMethod((TestToolsView.Presenter)this.testToolsPresenterMock, factTypeFieldsMap.size() + 10, factTypeFieldsMap, this.scenarioSimulationContextLocal, resultMock, simpleJavaTypes, GridWidget.SIMULATION);
        ((FactModelTree)Mockito.verify((Object)resultMock, (VerificationMode)Mockito.times((int)1))).getFactName();
        Assert.assertTrue((boolean)factTypeFieldsMap.containsKey(resultName));
        Assert.assertEquals((Object)resultMock, factTypeFieldsMap.get(resultName));
        ((BusinessCentralDMODataManagementStrategy)Mockito.verify((Object)this.businessCentralDmoDataManagementStrategySpy, (VerificationMode)Mockito.never())).populateFactModelTree((FactModelTree)Matchers.isA(FactModelTree.class), (SortedMap)Matchers.isA(SortedMap.class));
        Assert.assertNull((Object)this.factModelTreeHolderlocal.getFactModelTuple());
        ((BusinessCentralDMODataManagementStrategy)Mockito.verify((Object)this.businessCentralDmoDataManagementStrategySpy, (VerificationMode)Mockito.never())).storeData((FactModelTuple)Matchers.isA(FactModelTuple.class), (TestToolsView.Presenter)Matchers.eq((Object)this.testToolsPresenterMock), (ScenarioSimulationContext)Matchers.eq((Object)this.scenarioSimulationContextLocal), (GridWidget)Matchers.eq((Object)GridWidget.SIMULATION));
    }

    @Test
    public void aggregatorCallbackMethodWithoutResultAllElements() {
        SortedMap<String, FactModelTree> factTypeFieldsMap = this.getRandomMap();
        List<String> simpleJavaTypes = Arrays.asList(this.getSimpleTypeArray());
        this.factModelTreeHolderlocal.setFactModelTuple(null);
        int previousSizeMap = factTypeFieldsMap.size();
        this.businessCentralDmoDataManagementStrategySpy.aggregatorCallbackMethod((TestToolsView.Presenter)this.testToolsPresenterMock, factTypeFieldsMap.size(), factTypeFieldsMap, this.scenarioSimulationContextLocal, null, simpleJavaTypes, GridWidget.SIMULATION);
        Assert.assertEquals((long)previousSizeMap, (long)factTypeFieldsMap.size());
        factTypeFieldsMap.values().forEach(factModelTree -> ((BusinessCentralDMODataManagementStrategy)Mockito.verify((Object)this.businessCentralDmoDataManagementStrategySpy, (VerificationMode)Mockito.times((int)1))).populateFactModelTree((FactModelTree)Matchers.eq((Object)factModelTree), (SortedMap)Matchers.eq((Object)factTypeFieldsMap)));
        Assert.assertNotNull((Object)this.factModelTreeHolderlocal.getFactModelTuple());
        ((BusinessCentralDMODataManagementStrategy)Mockito.verify((Object)this.businessCentralDmoDataManagementStrategySpy, (VerificationMode)Mockito.times((int)1))).storeData((FactModelTuple)Matchers.eq((Object)this.factModelTreeHolderlocal.getFactModelTuple()), (TestToolsView.Presenter)Matchers.eq((Object)this.testToolsPresenterMock), (ScenarioSimulationContext)Matchers.eq((Object)this.scenarioSimulationContextLocal), (GridWidget)Matchers.eq((Object)GridWidget.SIMULATION));
    }

    @Test
    public void aggregatorCallbackMethodWithOutResultNotAllElements() {
        SortedMap<String, FactModelTree> factTypeFieldsMap = this.getRandomMap();
        List<String> simpleJavaTypes = Arrays.asList(this.getSimpleTypeArray());
        int previousSizeMap = factTypeFieldsMap.size();
        this.factModelTreeHolderlocal.setFactModelTuple(null);
        this.businessCentralDmoDataManagementStrategySpy.aggregatorCallbackMethod((TestToolsView.Presenter)this.testToolsPresenterMock, factTypeFieldsMap.size() + 10, factTypeFieldsMap, this.scenarioSimulationContextLocal, null, simpleJavaTypes, GridWidget.SIMULATION);
        Assert.assertEquals((long)previousSizeMap, (long)factTypeFieldsMap.size());
        ((BusinessCentralDMODataManagementStrategy)Mockito.verify((Object)this.businessCentralDmoDataManagementStrategySpy, (VerificationMode)Mockito.never())).populateFactModelTree((FactModelTree)Matchers.isA(FactModelTree.class), (SortedMap)Matchers.isA(SortedMap.class));
        Assert.assertNull((Object)this.factModelTreeHolderlocal.getFactModelTuple());
        ((BusinessCentralDMODataManagementStrategy)Mockito.verify((Object)this.businessCentralDmoDataManagementStrategySpy, (VerificationMode)Mockito.never())).storeData((FactModelTuple)Matchers.isA(FactModelTuple.class), (TestToolsView.Presenter)Matchers.eq((Object)this.testToolsPresenterMock), (ScenarioSimulationContext)Matchers.eq((Object)this.scenarioSimulationContextLocal), (GridWidget)Matchers.eq((Object)GridWidget.SIMULATION));
    }

    @Test
    public void retrieveFactModelTuple() {
        String factType = "factType";
        Callback callbackMock = (Callback)Mockito.mock(Callback.class);
        List<String> dataObjectsType = Arrays.asList(factType);
        TreeMap dataObjectsFieldMap = new TreeMap();
        Map superTypesMap = Collections.emptyMap();
        ArrayList javaSimpleType = new ArrayList();
        Mockito.when((Object)this.businessCentralDmoDataManagementStrategySpy.fieldCompletionsCallback((String)Matchers.eq((Object)"factType"), (Map)Matchers.eq(superTypesMap), (Callback)Matchers.isA(Callback.class))).thenReturn((Object)callbackMock);
        this.businessCentralDmoDataManagementStrategySpy.manageDataObjects(dataObjectsType, superTypesMap, (TestToolsView.Presenter)this.testToolsPresenterMock, 1, dataObjectsFieldMap, this.scenarioSimulationContextLocal, javaSimpleType, this.gridWidgetMock);
        ((AsyncPackageDataModelOracle)Mockito.verify((Object)this.oracleMock, (VerificationMode)Mockito.times((int)1))).getFieldCompletions((String)Matchers.eq((Object)factType), (Callback)Matchers.eq((Object)callbackMock));
    }

    @Test
    public void getSuperType() {
        Callback superTypeCallbackMock = (Callback)Mockito.mock(Callback.class);
        this.businessCentralDmoDataManagementStrategySpy.getSuperType("factType", superTypeCallbackMock);
        ((AsyncPackageDataModelOracle)Mockito.verify((Object)this.oracleMock, (VerificationMode)Mockito.times((int)1))).getSuperType((String)Matchers.eq((Object)"factType"), (Callback)Matchers.eq((Object)superTypeCallbackMock));
    }

    private void commonIsADataType(String value, boolean expected) {
        boolean retrieved = this.businessCentralDmoDataManagementStrategySpy.isADataType(value);
        if (expected) {
            Assert.assertTrue((boolean)retrieved);
        } else {
            Assert.assertFalse((boolean)retrieved);
        }
    }

    private void commonPopulateGenericTypeMap(boolean isList) {
        HashMap toPopulate = new HashMap();
        String factName = "FACT_NAME";
        String propertyName = "PROPERTY_NAME";
        String factType = "Book";
        String fullFactType = "com." + factType;
        Mockito.when((Object)this.oracleMock.getParametricFieldType(factName, propertyName)).thenReturn((Object)factType);
        Mockito.when((Object)this.oracleMock.getFQCNByFactName(factType)).thenReturn((Object)fullFactType);
        this.businessCentralDmoDataManagementStrategySpy.populateGenericTypeMap(toPopulate, factName, propertyName, isList);
        Assert.assertTrue((boolean)toPopulate.containsKey(propertyName));
        List retrieved = (List)toPopulate.get(propertyName);
        if (!isList) {
            Assert.assertEquals((Object)String.class.getName(), retrieved.get(0));
        }
        Assert.assertEquals((Object)fullFactType, retrieved.get(retrieved.size() - 1));
    }

    private FactModelTree getFactModelTreeInner(String factName) {
        return new FactModelTree(factName, "scenario.package", this.getSimplePropertiesInner(), new HashMap());
    }

    private SortedMap<String, FactModelTree> getFactTypeFieldsMapInner(Collection<FactModelTree.PropertyTypeName> keys) {
        return new TreeMap<String, FactModelTree>(keys.stream().collect(Collectors.toMap(key -> key.getTypeName(), key -> this.getFactModelTreeInner(key.getTypeName()))));
    }

    private Map<String, FactModelTree.PropertyTypeName> getSimplePropertiesInner() {
        String[] keys = this.getRandomStringArray();
        return Arrays.stream(keys).collect(Collectors.toMap(key -> key, key -> {
            key = key + "_VALUE";
            return new FactModelTree.PropertyTypeName(key);
        }));
    }

    private String[] getRandomStringArray() {
        return new String[]{RandomStringUtils.randomAlphabetic((int)3), RandomStringUtils.randomAlphabetic((int)4), RandomStringUtils.randomAlphabetic((int)5)};
    }

    private String[] getSimpleTypeArray() {
        return new String[]{"Integer", "String"};
    }

    private String[] mergeArrays(String[] first, String[] second) {
        int i;
        String[] toReturn = new String[first.length + second.length];
        for (i = 0; i < first.length; ++i) {
            toReturn[i] = first[i];
        }
        for (i = 0; i < second.length; ++i) {
            toReturn[i + first.length] = second[i];
        }
        return toReturn;
    }

    private SortedMap<String, FactModelTree> getRandomMap() {
        String[] dataObjects;
        TreeMap<String, FactModelTree> toReturn = new TreeMap<String, FactModelTree>();
        for (String factName : dataObjects = this.getRandomStringArray()) {
            toReturn.put(factName, this.getFactModelTreeInner(factName));
        }
        return toReturn;
    }
}

