/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.utils;

import com.ait.lienzo.client.core.event.NodeMouseClickEvent;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.drools.workbench.screens.scenariosimulation.client.factories.FactoryProvider;
import org.drools.workbench.screens.scenariosimulation.client.metadata.ScenarioHeaderMetaData;
import org.drools.workbench.screens.scenariosimulation.client.renderers.ScenarioGridColumnRenderer;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGrid;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGridColumn;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGridLayer;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGridPanel;
import org.gwtbootstrap3.client.ui.TextBox;
import org.uberfire.ext.wires.core.grids.client.model.GridCell;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.widget.dom.impl.TextBoxDOMElement;
import org.uberfire.ext.wires.core.grids.client.widget.dom.single.SingletonDOMElementFactory;
import org.uberfire.ext.wires.core.grids.client.widget.dom.single.impl.TextBoxSingletonDOMElementFactory;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.columns.GridColumnRenderer;

public class ScenarioSimulationUtils {
    public static GridCell<String> getSelectedCell(ScenarioGrid source) {
        GridData.SelectedCell selectedCell = (GridData.SelectedCell)source.getModel().getSelectedCells().get(0);
        return source.getModel().getCell(selectedCell.getRowIndex(), selectedCell.getColumnIndex());
    }

    public static String getScenarioGridSelectedCellString(ScenarioGrid source) {
        List selectedCells = source.getModel().getSelectedCells();
        return selectedCells.stream().map(selectedCell -> source.getModel().getCell(selectedCell.getRowIndex(), selectedCell.getColumnIndex())).map(selectedCell -> (String)selectedCell.getValue().getValue()).collect(Collectors.joining(","));
    }

    public static ScenarioGridColumn getScenarioGridColumn(String columnId, String columnTitle, ScenarioGridPanel scenarioGridPanel, ScenarioGridLayer gridLayer) {
        TextBoxSingletonDOMElementFactory factory = FactoryProvider.getHeaderHasNameTextBoxFactory(scenarioGridPanel, gridLayer);
        return new ScenarioGridColumn((GridColumn.HeaderMetaData)new ScenarioHeaderMetaData(columnId, columnTitle, "", (SingletonDOMElementFactory<TextBox, TextBoxDOMElement>)factory), (GridColumnRenderer<String>)new ScenarioGridColumnRenderer(), 100.0, false);
    }

    public static String getScenarioGridSelectedRowString(ScenarioGrid source) {
        GridData model = source.getModel();
        GridData.SelectedCell singleCell = (GridData.SelectedCell)model.getSelectedCells().get(0);
        Map cells = model.getRow(singleCell.getRowIndex()).getCells();
        return cells.values().stream().map(cell -> cell).map(cell -> (String)cell.getValue().getValue()).collect(Collectors.joining(","));
    }

    public static boolean isRightClick(NodeMouseClickEvent event) {
        return event.getMouseEvent().getNativeButton() == 2;
    }
}

