/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.editor;

import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwtmockito.GwtMockitoTestRunner;
import org.drools.workbench.screens.scenariosimulation.client.editor.AbstractScenarioSimulationEditorTest;
import org.drools.workbench.screens.scenariosimulation.client.editor.ScenarioSimulationEditorPresenter;
import org.drools.workbench.screens.scenariosimulation.client.editor.ScenarioSimulationView;
import org.drools.workbench.screens.scenariosimulation.client.handlers.ScenarioSimulationGridPanelClickHandler;
import org.drools.workbench.screens.scenariosimulation.client.type.ScenarioSimulationResourceType;
import org.drools.workbench.screens.scenariosimulation.model.ScenarioSimulationModel;
import org.drools.workbench.screens.scenariosimulation.model.ScenarioSimulationModelContent;
import org.drools.workbench.screens.scenariosimulation.service.ScenarioSimulationService;
import org.guvnor.common.services.shared.metadata.model.Overview;
import org.guvnor.messageconsole.client.console.widget.button.AlertsButtonMenuItemBuilder;
import org.jboss.errai.common.client.api.Caller;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.soup.project.datamodel.imports.HasImports;
import org.kie.workbench.common.services.datamodel.model.PackageDataModelOracleBaselinePayload;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracle;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracleFactory;
import org.kie.workbench.common.widgets.client.menu.FileMenuBuilder;
import org.kie.workbench.common.widgets.configresource.client.widget.bound.ImportsWidgetPresenter;
import org.kie.workbench.common.widgets.metadata.client.KieEditorWrapperView;
import org.kie.workbench.common.widgets.metadata.client.widget.OverviewWidgetPresenter;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.backend.vfs.ObservablePath;
import org.uberfire.backend.vfs.Path;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.mvp.PlaceStatus;
import org.uberfire.client.workbench.events.PlaceGainFocusEvent;
import org.uberfire.client.workbench.events.PlaceHiddenEvent;
import org.uberfire.ext.editor.commons.client.history.VersionRecordManager;
import org.uberfire.ext.editor.commons.client.validation.DefaultFileNameValidator;
import org.uberfire.mocks.CallerMock;
import org.uberfire.mocks.EventSourceMock;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.workbench.events.NotificationEvent;
import org.uberfire.workbench.model.menu.MenuItem;

@RunWith(value=GwtMockitoTestRunner.class)
public class ScenarioSimulationEditorPresenterTest
extends AbstractScenarioSimulationEditorTest {
    private ScenarioSimulationEditorPresenter presenter;
    private ScenarioSimulationEditorPresenter presenterSpy;
    @Mock
    private KieEditorWrapperView mockKieView;
    @Mock
    private OverviewWidgetPresenter mockOverviewWidget;
    @Mock
    private DefaultFileNameValidator mockFileNameValidator;
    @Mock
    private AlertsButtonMenuItemBuilder mockAlertsButtonMenuItemBuilder;
    @Mock
    private EventSourceMock<NotificationEvent> mockNotification;
    @Mock
    private ScenarioSimulationView mockScenarioSimulationView;
    @Mock
    private ScenarioSimulationGridPanelClickHandler mockScenarioSimulationGridPanelClickHandler;
    @Mock
    private ImportsWidgetPresenter mockImportsWidget;
    @Mock
    private AsyncPackageDataModelOracleFactory mockOracleFactory;
    @Mock
    private PlaceManager mockPlaceManager;
    @Mock
    private PlaceRequest mockPlaceRequest;

    @Override
    @Before
    public void setup() {
        super.setup();
        Mockito.when((Object)this.mockPlaceRequest.getIdentifier()).thenReturn((Object)"ScenarioSimulationEditor");
        this.presenter = new ScenarioSimulationEditorPresenter((Caller)new CallerMock((Object)this.scenarioSimulationService), this.mockScenarioSimulationView, (ScenarioSimulationResourceType)Mockito.mock(ScenarioSimulationResourceType.class), this.mockImportsWidget, this.mockOracleFactory, this.mockPlaceManager){
            {
                this.kieView = ScenarioSimulationEditorPresenterTest.this.mockKieView;
                this.overviewWidget = ScenarioSimulationEditorPresenterTest.this.mockOverviewWidget;
                this.fileMenuBuilder = ScenarioSimulationEditorPresenterTest.this.mockFileMenuBuilder;
                this.fileNameValidator = ScenarioSimulationEditorPresenterTest.this.mockFileNameValidator;
                this.versionRecordManager = ScenarioSimulationEditorPresenterTest.this.mockVersionRecordManager;
                this.notification = ScenarioSimulationEditorPresenterTest.this.mockNotification;
                this.workbenchContext = ScenarioSimulationEditorPresenterTest.this.mockWorkbenchContext;
                this.alertsButtonMenuItemBuilder = ScenarioSimulationEditorPresenterTest.this.mockAlertsButtonMenuItemBuilder;
            }

            protected MenuItem downloadMenuItem() {
                return (MenuItem)Mockito.mock(MenuItem.class);
            }

            protected Command getSaveAndRename() {
                return (Command)Mockito.mock(Command.class);
            }
        };
        this.presenterSpy = (ScenarioSimulationEditorPresenter)Mockito.spy((Object)this.presenter);
    }

    @Test
    public void testPresenterInit() throws Exception {
        ((ScenarioSimulationView)Mockito.verify((Object)this.mockScenarioSimulationView)).init(this.presenter);
    }

    @Test
    public void testOnStartup() {
        AsyncPackageDataModelOracle oracle = (AsyncPackageDataModelOracle)Mockito.mock(AsyncPackageDataModelOracle.class);
        Mockito.when((Object)this.mockOracleFactory.makeAsyncPackageDataModelOracle((Path)Mockito.any(), (HasImports)Matchers.eq((Object)this.model), (PackageDataModelOracleBaselinePayload)Matchers.eq((Object)this.content.getDataModel()))).thenReturn((Object)oracle);
        this.presenter.onStartup((ObservablePath)Mockito.mock(ObservablePath.class), (PlaceRequest)Mockito.mock(PlaceRequest.class));
        ((ImportsWidgetPresenter)Mockito.verify((Object)this.mockImportsWidget)).setContent(oracle, this.model.getImports(), false);
        ((KieEditorWrapperView)Mockito.verify((Object)this.mockKieView)).addImportsTab((IsWidget)this.mockImportsWidget);
        ((ScenarioSimulationView)Mockito.verify((Object)this.mockScenarioSimulationView)).showLoading();
        ((ScenarioSimulationView)Mockito.verify((Object)this.mockScenarioSimulationView)).hideBusyIndicator();
    }

    @Test
    public void validateButtonShouldNotBeAdded() {
        this.presenter.onStartup((ObservablePath)Mockito.mock(ObservablePath.class), (PlaceRequest)Mockito.mock(PlaceRequest.class));
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.presenterSpy, (VerificationMode)Mockito.never())).getValidateCommand();
    }

    @Test
    public void runScenarioButtonIsAdded() throws Exception {
        MenuItem menuItem = (MenuItem)Mockito.mock(MenuItem.class);
        ((ScenarioSimulationView)Mockito.doReturn((Object)menuItem).when((Object)this.mockScenarioSimulationView)).getRunScenarioMenuItem();
        this.presenter.onStartup((ObservablePath)Mockito.mock(ObservablePath.class), (PlaceRequest)Mockito.mock(PlaceRequest.class));
        ((FileMenuBuilder)Mockito.verify((Object)this.mockFileMenuBuilder)).addNewTopLevelMenu(menuItem);
    }

    @Test
    public void save() {
        this.presenter.onStartup((ObservablePath)Mockito.mock(ObservablePath.class), (PlaceRequest)Mockito.mock(PlaceRequest.class));
        Mockito.reset((Object[])new ScenarioSimulationView[]{this.mockScenarioSimulationView});
        this.presenter.save("save message");
        ((ScenarioSimulationView)Mockito.verify((Object)this.mockScenarioSimulationView)).hideBusyIndicator();
        ((EventSourceMock)Mockito.verify(this.mockNotification)).fire(Mockito.any(NotificationEvent.class));
        ((VersionRecordManager)Mockito.verify((Object)this.mockVersionRecordManager)).reloadVersions((Path)Mockito.any(Path.class));
    }

    @Test
    public void onPlaceGainFocusEvent() {
        PlaceGainFocusEvent mockPlaceGainFocusEvent = (PlaceGainFocusEvent)Mockito.mock(PlaceGainFocusEvent.class);
        Mockito.when((Object)mockPlaceGainFocusEvent.getPlace()).thenReturn((Object)this.mockPlaceRequest);
        Mockito.when((Object)this.mockPlaceManager.getStatus("org.drools.scenariosimulation.RightPanel")).thenReturn((Object)PlaceStatus.CLOSE);
        this.presenter.onPlaceGainFocusEvent(mockPlaceGainFocusEvent);
        ((PlaceManager)Mockito.verify((Object)this.mockPlaceManager, (VerificationMode)Mockito.times((int)1))).goTo("org.drools.scenariosimulation.RightPanel");
    }

    @Test
    public void onPlaceHiddenEvent() {
        PlaceHiddenEvent mockPlaceHiddenEvent = (PlaceHiddenEvent)Mockito.mock(PlaceHiddenEvent.class);
        Mockito.when((Object)mockPlaceHiddenEvent.getPlace()).thenReturn((Object)this.mockPlaceRequest);
        Mockito.when((Object)this.mockPlaceManager.getStatus("org.drools.scenariosimulation.RightPanel")).thenReturn((Object)PlaceStatus.OPEN);
        this.presenter.onPlaceHiddenEvent(mockPlaceHiddenEvent);
        ((PlaceManager)Mockito.verify((Object)this.mockPlaceManager, (VerificationMode)Mockito.times((int)1))).closePlace("org.drools.scenariosimulation.RightPanel");
    }

    @Test
    public void onClose() {
        Mockito.when((Object)this.mockPlaceManager.getStatus("org.drools.scenariosimulation.RightPanel")).thenReturn((Object)PlaceStatus.OPEN);
        this.presenter.onClose();
        this.onClosePlaceStatusOpen();
        Mockito.reset((Object[])new VersionRecordManager[]{this.mockVersionRecordManager});
        Mockito.reset((Object[])new PlaceManager[]{this.mockPlaceManager});
        Mockito.reset((Object[])new ScenarioSimulationView[]{this.mockScenarioSimulationView});
        Mockito.when((Object)this.mockPlaceManager.getStatus("org.drools.scenariosimulation.RightPanel")).thenReturn((Object)PlaceStatus.CLOSE);
        this.presenter.onClose();
        this.onClosePlaceStatusClose();
    }

    @Test
    public void menusAdded() throws Exception {
        ((ScenarioSimulationView)Mockito.verify((Object)this.mockScenarioSimulationView)).addGridMenuItem((String)Matchers.eq((Object)"one"), (String)Matchers.eq((Object)"ONE"), (String)Matchers.eq((Object)""), (com.google.gwt.user.client.Command)Mockito.any(com.google.gwt.user.client.Command.class));
        ((ScenarioSimulationView)Mockito.verify((Object)this.mockScenarioSimulationView)).addGridMenuItem((String)Matchers.eq((Object)"two"), (String)Matchers.eq((Object)"TWO"), (String)Matchers.eq((Object)""), (com.google.gwt.user.client.Command)Mockito.any(com.google.gwt.user.client.Command.class));
        ((ScenarioSimulationView)Mockito.verify((Object)this.mockScenarioSimulationView)).addHeaderMenuItem((String)Matchers.eq((Object)"one"), (String)Matchers.eq((Object)"HEADER-ONE"), (String)Matchers.eq((Object)""), (com.google.gwt.user.client.Command)Mockito.any(com.google.gwt.user.client.Command.class));
        ((ScenarioSimulationView)Mockito.verify((Object)this.mockScenarioSimulationView)).addHeaderMenuItem((String)Matchers.eq((Object)"two"), (String)Matchers.eq((Object)"HEADER-TWO"), (String)Matchers.eq((Object)""), (com.google.gwt.user.client.Command)Mockito.any(com.google.gwt.user.client.Command.class));
    }

    private void onClosePlaceStatusOpen() {
        ((VersionRecordManager)Mockito.verify((Object)this.mockVersionRecordManager, (VerificationMode)Mockito.times((int)1))).clear();
        ((PlaceManager)Mockito.verify((Object)this.mockPlaceManager, (VerificationMode)Mockito.times((int)1))).closePlace("org.drools.scenariosimulation.RightPanel");
        ((ScenarioSimulationView)Mockito.verify((Object)this.presenter.getView())).showLoading();
        ((ScenarioSimulationView)Mockito.verify((Object)this.mockScenarioSimulationView, (VerificationMode)Mockito.times((int)1))).clear();
    }

    private void onClosePlaceStatusClose() {
        ((VersionRecordManager)Mockito.verify((Object)this.mockVersionRecordManager, (VerificationMode)Mockito.times((int)1))).clear();
        ((PlaceManager)Mockito.verify((Object)this.mockPlaceManager, (VerificationMode)Mockito.times((int)0))).closePlace("org.drools.scenariosimulation.RightPanel");
        ((ScenarioSimulationView)Mockito.verify((Object)this.mockScenarioSimulationView, (VerificationMode)Mockito.times((int)1))).clear();
    }

    @Test
    public void onRunTest() throws Exception {
        ScenarioSimulationModel model = new ScenarioSimulationModel();
        ((ScenarioSimulationService)Mockito.doReturn((Object)new ScenarioSimulationModelContent(model, new Overview(), new PackageDataModelOracleBaselinePayload())).when((Object)this.scenarioSimulationService)).loadContent((Path)Mockito.any());
        this.presenter.onStartup((ObservablePath)Mockito.mock(ObservablePath.class), (PlaceRequest)Mockito.mock(PlaceRequest.class));
        this.presenter.onRunScenario();
        ((ScenarioSimulationService)Mockito.verify((Object)this.scenarioSimulationService)).runScenario((Path)Mockito.any(), (ScenarioSimulationModel)Matchers.eq((Object)model));
    }
}

