/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.models;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.List;
import java.util.stream.IntStream;
import org.drools.workbench.screens.scenariosimulation.client.TestUtils;
import org.drools.workbench.screens.scenariosimulation.client.models.ScenarioGridModel;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGridColumn;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGridRow;
import org.drools.workbench.screens.scenariosimulation.model.FactMappingValue;
import org.drools.workbench.screens.scenariosimulation.model.Scenario;
import org.drools.workbench.screens.scenariosimulation.model.Simulation;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.ext.wires.core.grids.client.model.GridCellValue;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.model.GridRow;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridCell;

@RunWith(value=GwtMockitoTestRunner.class)
public class ScenarioGridModelTest {
    private ScenarioGridModel scenarioGridModel;
    @Mock
    private GridColumn<String> mockGridColumn;
    @Mock
    private List<GridColumn.HeaderMetaData> mockHeaderMetaDataList;
    @Mock
    private GridColumn.HeaderMetaData mockHeaderMetaData;
    @Mock
    private GridColumn<String> mockGridColumnAppend;
    @Mock
    private List<GridColumn.HeaderMetaData> mockHeaderMetaDataListAppend;
    @Mock
    private GridColumn.HeaderMetaData mockHeaderMetaDataAppend;
    @Mock
    private BaseGridCell<String> mockGridCell;
    @Mock
    private GridCellValue<String> mockGridCellValue;
    private Simulation simulation;
    private final String GRID_COLUMN_TITLE = TestUtils.getColName(1);
    private final String GRID_CELL_TEXT = TestUtils.getCellValue(1, 1);

    @Before
    public void setup() {
        int cols = 1;
        int rows = 1;
        this.scenarioGridModel = new ScenarioGridModel();
        this.simulation = TestUtils.getSimulation(cols, rows);
        this.scenarioGridModel.bindContent(this.simulation);
        Mockito.when((Object)this.mockGridColumn.getHeaderMetaData()).thenReturn(this.mockHeaderMetaDataList);
        Mockito.when((Object)this.mockHeaderMetaDataList.get(0)).thenReturn((Object)this.mockHeaderMetaData);
        Mockito.when((Object)this.mockHeaderMetaData.getTitle()).thenReturn((Object)this.GRID_COLUMN_TITLE);
        Mockito.when((Object)this.mockGridCell.getValue()).thenReturn(this.mockGridCellValue);
        Mockito.when((Object)this.mockGridCellValue.getValue()).thenReturn((Object)this.GRID_CELL_TEXT);
        ScenarioGridColumn scenarioGridColumn = (ScenarioGridColumn)Mockito.mock(ScenarioGridColumn.class);
        Mockito.when((Object)scenarioGridColumn.getIndex()).thenReturn((Object)1);
        this.scenarioGridModel.appendColumn(this.mockGridColumn);
        IntStream.range(0, rows).forEach(i -> this.scenarioGridModel.appendRow((GridRow)new ScenarioGridRow()));
    }

    @Test
    public void bindContent() {
        Assert.assertTrue((boolean)this.scenarioGridModel.getSimulation().isPresent());
    }

    @Test
    public void appendColumn() {
        String colName = TestUtils.getColName(2);
        Mockito.when((Object)this.mockGridColumnAppend.getHeaderMetaData()).thenReturn(this.mockHeaderMetaDataListAppend);
        Mockito.when((Object)this.mockHeaderMetaDataListAppend.get(0)).thenReturn((Object)this.mockHeaderMetaDataAppend);
        Mockito.when((Object)this.mockHeaderMetaDataAppend.getTitle()).thenReturn((Object)colName);
        int expectedColumnCount = this.scenarioGridModel.getColumnCount() + 1;
        this.scenarioGridModel.appendColumn(this.mockGridColumnAppend);
        int currentColumnCount = this.scenarioGridModel.getColumnCount();
        Assert.assertEquals((long)currentColumnCount, (long)expectedColumnCount);
        int insertedColumnIndex = currentColumnCount - 1;
        String insertedString = this.simulation.getSimulationDescriptor().getFactMappingByIndex(insertedColumnIndex).getExpressionIdentifier().getName();
        Assert.assertNotNull((Object)insertedString);
        Assert.assertEquals((Object)insertedString, (Object)colName);
    }

    @Test
    public void testSetCell() {
        int insertedRowIndex = 0;
        int insertedColumnIndex = 0;
        GridData.Range r = this.scenarioGridModel.setCell(insertedRowIndex, insertedColumnIndex, () -> this.mockGridCell);
        Assert.assertEquals((long)insertedRowIndex, (long)r.getMinRowIndex());
        Assert.assertEquals((long)insertedRowIndex, (long)r.getMaxRowIndex());
        Assert.assertEquals(this.mockGridCell, (Object)this.scenarioGridModel.getCell(insertedRowIndex, insertedColumnIndex));
        Scenario scenarioByIndex = this.simulation.getScenarioByIndex(insertedRowIndex);
        Assert.assertNotNull((Object)scenarioByIndex);
        String insertedString = (String)((FactMappingValue)scenarioByIndex.getFactMappingValueByIndex(insertedColumnIndex).get()).getRawValue();
        Assert.assertNotNull((Object)insertedString);
        Assert.assertNotNull((Object)insertedString);
        Assert.assertEquals((Object)insertedString, (Object)this.GRID_CELL_TEXT);
    }

    @Test
    public void clear() {
        Assert.assertNotEquals((long)0L, (long)this.scenarioGridModel.getRowCount());
        Assert.assertNotEquals((long)0L, (long)this.scenarioGridModel.getColumnCount());
        this.scenarioGridModel.clear();
        Assert.assertTrue((boolean)this.simulation.getScenarios().isEmpty());
        Assert.assertTrue((boolean)this.simulation.getSimulationDescriptor().getFactMappings().isEmpty());
        Assert.assertEquals((long)0L, (long)this.scenarioGridModel.getRowCount());
        Assert.assertEquals((long)0L, (long)this.scenarioGridModel.getColumnCount());
    }
}

