/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.models;

import com.google.gwt.event.shared.EventBus;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.List;
import java.util.function.Supplier;
import org.drools.workbench.screens.scenariosimulation.client.metadata.ScenarioHeaderMetaData;
import org.drools.workbench.screens.scenariosimulation.client.models.ScenarioGridModel;
import org.drools.workbench.screens.scenariosimulation.model.ExpressionIdentifier;
import org.drools.workbench.screens.scenariosimulation.model.FactIdentifier;
import org.drools.workbench.screens.scenariosimulation.model.FactMapping;
import org.drools.workbench.screens.scenariosimulation.model.FactMappingValue;
import org.drools.workbench.screens.scenariosimulation.model.Scenario;
import org.drools.workbench.screens.scenariosimulation.model.Simulation;
import org.drools.workbench.screens.scenariosimulation.model.SimulationDescriptor;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.wires.core.grids.client.model.GridCell;
import org.uberfire.ext.wires.core.grids.client.model.GridCellValue;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridRow;

@RunWith(value=GwtMockitoTestRunner.class)
public class ScenarioGridModelTest {
    private ScenarioGridModel scenarioGridModel;
    @Mock
    private GridColumn<String> mockGridStringColumn;
    @Mock
    private GridColumn<?> mockGridColumn;
    @Mock
    private GridRow mockGridRow;
    @Mock
    private List<GridColumn.HeaderMetaData> mockHeaderMetaDataList;
    @Mock
    private ScenarioHeaderMetaData mockHeaderMetaData;
    @Mock
    private List<GridColumn<String>> mockGridStringColumns;
    @Mock
    private GridCell<String> mockGridCell;
    @Mock
    private GridCellValue<String> mockGridCellValue;
    @Mock
    private EventBus mockEventBus;
    @Mock
    private Simulation mockSimulation;
    @Mock
    private SimulationDescriptor mockSimulationDescriptor;
    @Mock
    private Scenario mockScenario;
    @Mock
    private FactMapping mockFactMapping;
    @Mock
    private List<FactMappingValue> mockFactMappingValues;
    @Mock
    private List<GridRow> mockRows;
    @Mock
    private List<GridColumn<?>> mockGridColumns;
    private Supplier<GridCell<?>> gridCellSupplier;
    private final String GRID_COLUMN_TITLE = "GRID_COLUMN_TITLE";
    private final String GRID_COLUMN_GROUP = "GIVEN";
    private final String GRID_COLUMN_ID = "GRID_COLUMN_ID";
    private final String GRID_CELL_TEXT = "GRID_CELL_TEXT";
    private final String FULL_PACKAGE = "test.scesim";
    private final String VALUE = "VALUE";
    private final String VALUE_CLASS_NAME = String.class.getName();
    private final int ROW_COUNT = 4;
    private final int ROW_INDEX = 3;
    private final int COLUMN_INDEX = 5;

    @Before
    public void setup() {
        Mockito.when(this.mockGridStringColumns.get(5)).thenReturn(this.mockGridStringColumn);
        Mockito.when((Object)this.mockRows.get(3)).thenReturn((Object)this.mockGridRow);
        Mockito.when((Object)this.mockSimulationDescriptor.getFactMappingByIndex(5)).thenReturn((Object)this.mockFactMapping);
        Mockito.when((Object)this.mockSimulation.getSimulationDescriptor()).thenReturn((Object)this.mockSimulationDescriptor);
        Mockito.when((Object)this.mockGridStringColumn.getHeaderMetaData()).thenReturn(this.mockHeaderMetaDataList);
        Mockito.when((Object)this.mockHeaderMetaDataList.get(1)).thenReturn((Object)this.mockHeaderMetaData);
        Mockito.when((Object)this.mockHeaderMetaData.getTitle()).thenReturn((Object)"GRID_COLUMN_TITLE");
        Mockito.when((Object)this.mockHeaderMetaData.getColumnGroup()).thenReturn((Object)"GIVEN");
        Mockito.when((Object)this.mockHeaderMetaData.getColumnId()).thenReturn((Object)"GRID_COLUMN_ID");
        Mockito.when((Object)this.mockGridColumn.getHeaderMetaData()).thenReturn(this.mockHeaderMetaDataList);
        Mockito.when((Object)this.mockGridCell.getValue()).thenReturn(this.mockGridCellValue);
        Mockito.when((Object)this.mockGridCellValue.getValue()).thenReturn((Object)"GRID_CELL_TEXT");
        Mockito.when((Object)this.mockScenario.getUnmodifiableFactMappingValues()).thenReturn(this.mockFactMappingValues);
        Mockito.when((Object)this.mockSimulation.getScenarioByIndex(3)).thenReturn((Object)this.mockScenario);
        Mockito.when((Object)this.mockSimulation.cloneScenario(3, 4)).thenReturn((Object)this.mockScenario);
        Mockito.when((Object)this.mockSimulation.cloneScenario(3, 4)).thenReturn((Object)this.mockScenario);
        this.gridCellSupplier = () -> this.mockGridCell;
        this.scenarioGridModel = (ScenarioGridModel)Mockito.spy((Object)new ScenarioGridModel(){
            {
                this.simulation = ScenarioGridModelTest.this.mockSimulation;
                this.eventBus = ScenarioGridModelTest.this.mockEventBus;
                this.rows = ScenarioGridModelTest.this.mockRows;
                this.columns = ScenarioGridModelTest.this.mockGridColumns;
            }

            public int getRowCount() {
                return 4;
            }

            public void deleteColumn(GridColumn<?> column) {
            }
        });
    }

    @Test
    public void bindContent() {
        Assert.assertTrue((boolean)this.scenarioGridModel.getSimulation().isPresent());
    }

    @Test
    public void setEventBus() {
        this.scenarioGridModel.setEventBus(this.mockEventBus);
        Assert.assertEquals((Object)this.mockEventBus, (Object)this.scenarioGridModel.eventBus);
    }

    @Test
    public void appendNewColumn() {
        Mockito.reset((Object[])new ScenarioGridModel[]{this.scenarioGridModel});
        this.scenarioGridModel.appendNewColumn(this.mockGridStringColumn);
        ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModel, (VerificationMode)Mockito.times((int)1))).commonAddColumn(Matchers.eq((int)-1), (GridColumn)Matchers.eq(this.mockGridStringColumn));
    }

    @Test
    public void appendNewRow() {
        Mockito.reset((Object[])new ScenarioGridModel[]{this.scenarioGridModel});
        this.scenarioGridModel.appendNewRow(this.mockGridRow);
        ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModel, (VerificationMode)Mockito.times((int)1))).checkSimulation();
        ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModel, (VerificationMode)Mockito.times((int)1))).commonAddRow(Matchers.eq((int)3));
    }

    @Test
    public void insertRow() {
        Mockito.reset((Object[])new ScenarioGridModel[]{this.scenarioGridModel});
        this.scenarioGridModel.insertRow(3, this.mockGridRow, this.mockScenario);
        ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModel, (VerificationMode)Mockito.times((int)1))).insertRow(Matchers.eq((int)3), (GridRow)Matchers.eq((Object)this.mockGridRow));
    }

    @Test
    public void insertNewRow() {
        Mockito.reset((Object[])new ScenarioGridModel[]{this.scenarioGridModel});
        this.scenarioGridModel.insertNewRow(3, this.mockGridRow);
        ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModel, (VerificationMode)Mockito.times((int)1))).checkSimulation();
        ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModel, (VerificationMode)Mockito.times((int)1))).commonAddRow(Matchers.eq((int)3));
    }

    @Test
    public void deleteNewRow() {
        Mockito.reset((Object[])new ScenarioGridModel[]{this.scenarioGridModel});
        this.scenarioGridModel.deleteNewRow(3);
        ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModel, (VerificationMode)Mockito.times((int)1))).checkSimulation();
        ((Simulation)Mockito.verify((Object)this.mockSimulation, (VerificationMode)Mockito.times((int)1))).removeScenarioByIndex(Matchers.eq((int)3));
    }

    @Test
    public void duplicateNewRow() {
        Mockito.reset((Object[])new ScenarioGridModel[]{this.scenarioGridModel});
        this.scenarioGridModel.duplicateNewRow(3, this.mockGridRow);
        ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModel, (VerificationMode)Mockito.times((int)2))).checkSimulation();
        ((Simulation)Mockito.verify((Object)this.mockSimulation, (VerificationMode)Mockito.times((int)1))).cloneScenario(Matchers.eq((int)3), Matchers.eq((int)4));
        ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModel, (VerificationMode)Mockito.times((int)1))).insertRow(Matchers.eq((int)4), (GridRow)Matchers.eq((Object)this.mockGridRow), (Scenario)Matchers.isA(Scenario.class));
    }

    @Test
    public void insertColumn() {
        Mockito.reset((Object[])new ScenarioGridModel[]{this.scenarioGridModel});
        this.scenarioGridModel.insertColumn(5, this.mockGridStringColumn);
        ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModel, (VerificationMode)Mockito.times((int)1))).checkSimulation();
    }

    @Test
    public void insertNewColumn() {
        Mockito.reset((Object[])new ScenarioGridModel[]{this.scenarioGridModel});
        this.scenarioGridModel.insertNewColumn(5, this.mockGridStringColumn);
        ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModel, (VerificationMode)Mockito.times((int)1))).checkSimulation();
        ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModel, (VerificationMode)Mockito.times((int)1))).commonAddColumn(Matchers.eq((int)5), (GridColumn)Matchers.eq(this.mockGridStringColumn));
    }

    @Test
    public void deleteNewColumn() {
        this.scenarioGridModel.deleteNewColumn(5);
        ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModel, (VerificationMode)Mockito.times((int)1))).checkSimulation();
        ((Simulation)Mockito.verify((Object)this.mockSimulation, (VerificationMode)Mockito.times((int)1))).removeFactMappingByIndex(Matchers.eq((int)5));
    }

    @Test
    public void updateColumnType() {
        Mockito.reset((Object[])new ScenarioGridModel[]{this.scenarioGridModel});
        this.scenarioGridModel.updateColumnType(5, this.mockGridColumn, "test.scesim", "VALUE", this.VALUE_CLASS_NAME);
        ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModel, (VerificationMode)Mockito.times((int)2))).checkSimulation();
        ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModel, (VerificationMode)Mockito.times((int)1))).deleteNewColumn(Matchers.eq((int)5));
        ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModel, (VerificationMode)Mockito.times((int)1))).commonAddColumn(Matchers.eq((int)5), (GridColumn)Matchers.eq(this.mockGridColumn), (FactIdentifier)Matchers.isA(FactIdentifier.class), (ExpressionIdentifier)Matchers.isA(ExpressionIdentifier.class));
        ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModel, (VerificationMode)Mockito.times((int)1))).selectColumn(Matchers.eq((int)5));
    }

    @Test
    public void setCell() {
        this.scenarioGridModel.setCell(3, 5, this.gridCellSupplier);
        ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModel, (VerificationMode)Mockito.times((int)1))).checkSimulation();
    }

    @Test
    public void setNewCell() {
        this.scenarioGridModel.setNewCell(3, 5, this.gridCellSupplier);
        ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModel, (VerificationMode)Mockito.times((int)1))).setCell(Matchers.eq((int)3), Matchers.eq((int)5), (Supplier)Matchers.eq(this.gridCellSupplier));
    }

    @Test
    public void commonAddColumn() {
        Mockito.reset((Object[])new ScenarioGridModel[]{this.scenarioGridModel});
        this.scenarioGridModel.commonAddColumn(5, this.mockGridStringColumn);
        ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModel, (VerificationMode)Mockito.times((int)0))).checkSimulation();
    }

    @Test
    public void commonAddRow() {
        this.scenarioGridModel.commonAddRow(3);
    }
}

