/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.rightpanel;

import com.google.gwt.dom.client.DivElement;
import com.google.gwt.dom.client.Node;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwtmockito.GwtMockitoTestRunner;
import org.drools.workbench.screens.scenariosimulation.client.events.SetColumnValueEvent;
import org.drools.workbench.screens.scenariosimulation.client.models.FactModelTree;
import org.drools.workbench.screens.scenariosimulation.client.resources.i18n.ScenarioSimulationEditorConstants;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.AbstractRightPanelTest;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.ListGroupItemPresenter;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.RightPanelPresenter;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.RightPanelView;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=GwtMockitoTestRunner.class)
public class RightPanelPresenterTest
extends AbstractRightPanelTest {
    @Mock
    private RightPanelView mockRightPanelView;
    @Mock
    private DivElement mockListContainer;
    @Mock
    private ListGroupItemPresenter mockListGroupItemPresenter;
    @Mock
    private EventBus mockEventBus;
    private RightPanelPresenter rightPanelPresenter;
    private RightPanelPresenter rightPanelPresenterSpy;

    @Override
    @Before
    public void setup() {
        super.setup();
        Mockito.when((Object)this.mockRightPanelView.getListContainer()).thenReturn((Object)this.mockListContainer);
        Mockito.when((Object)this.mockListGroupItemPresenter.getDivElement(this.FACT_NAME, this.FACT_MODEL_TREE)).thenReturn((Object)this.mockListContainer);
        this.rightPanelPresenter = new RightPanelPresenter(this.mockRightPanelView, this.mockListGroupItemPresenter);
        this.rightPanelPresenter.factTypeFieldsMap = this.mockTopLevelMap;
        this.rightPanelPresenter.eventBus = this.mockEventBus;
        this.rightPanelPresenterSpy = (RightPanelPresenter)Mockito.spy((Object)this.rightPanelPresenter);
    }

    @Test
    public void onSetup() {
        this.rightPanelPresenter.setup();
        ((RightPanelView)Mockito.verify((Object)this.mockRightPanelView, (VerificationMode)Mockito.times((int)1))).init((Object)this.rightPanelPresenter);
    }

    @Test
    public void getTitle() {
        Assert.assertEquals((Object)ScenarioSimulationEditorConstants.INSTANCE.testTools(), (Object)this.rightPanelPresenter.getTitle());
    }

    @Test
    public void onClearSearch() {
        this.rightPanelPresenterSpy.onClearSearch();
        ((RightPanelView)Mockito.verify((Object)this.mockRightPanelView, (VerificationMode)Mockito.times((int)1))).clearInputSearch();
        ((RightPanelView)Mockito.verify((Object)this.mockRightPanelView, (VerificationMode)Mockito.times((int)1))).hideClearButton();
    }

    @Test
    public void onClearNameField() {
        this.rightPanelPresenterSpy.onClearNameField();
        ((RightPanelView)Mockito.verify((Object)this.mockRightPanelView, (VerificationMode)Mockito.times((int)1))).clearNameField();
    }

    @Test
    public void onClearStatus() {
        this.rightPanelPresenterSpy.onClearStatus();
        ((RightPanelPresenter)Mockito.verify((Object)this.rightPanelPresenterSpy, (VerificationMode)Mockito.times((int)1))).onClearSearch();
        ((RightPanelPresenter)Mockito.verify((Object)this.rightPanelPresenterSpy, (VerificationMode)Mockito.times((int)1))).onClearNameField();
        ((RightPanelPresenter)Mockito.verify((Object)this.rightPanelPresenterSpy, (VerificationMode)Mockito.times((int)1))).clearList();
    }

    @Test
    public void getFactModelTree() {
        this.rightPanelPresenter.setFactTypeFieldsMap(this.mockTopLevelMap);
        String factName = this.getRandomFactModelTree(this.mockTopLevelMap, 0);
        FactModelTree retrieved = this.rightPanelPresenter.getFactModelTree(factName);
        Assert.assertNotNull((Object)retrieved);
        Assert.assertEquals(this.mockTopLevelMap.get(factName), (Object)retrieved);
    }

    @Test
    public void setFactTypeFieldsMap() {
        this.rightPanelPresenterSpy.setFactTypeFieldsMap(this.mockTopLevelMap);
        ((RightPanelPresenter)Mockito.verify((Object)this.rightPanelPresenterSpy, (VerificationMode)Mockito.times((int)this.mockTopLevelMap.size()))).addListGroupItemView(Matchers.anyString(), (FactModelTree)Matchers.anyObject());
    }

    @Test
    public void onShowClearButton() {
        this.rightPanelPresenter.onShowClearButton();
        ((RightPanelView)Mockito.verify((Object)this.mockRightPanelView, (VerificationMode)Mockito.times((int)1))).showClearButton();
    }

    @Test
    public void setEventBus() {
        this.rightPanelPresenterSpy.setEventBus(this.mockEventBus);
        Assert.assertEquals((Object)this.mockEventBus, (Object)this.rightPanelPresenterSpy.eventBus);
    }

    @Test
    public void addListGroupItemView() {
        this.rightPanelPresenter.addListGroupItemView(this.FACT_NAME, this.FACT_MODEL_TREE);
        ((RightPanelView)Mockito.verify((Object)this.mockRightPanelView, (VerificationMode)Mockito.times((int)1))).getListContainer();
        ((ListGroupItemPresenter)Mockito.verify((Object)this.mockListGroupItemPresenter, (VerificationMode)Mockito.times((int)1))).getDivElement((String)Matchers.eq((Object)this.FACT_NAME), (FactModelTree)Matchers.eq((Object)this.FACT_MODEL_TREE));
        ((DivElement)Mockito.verify((Object)this.mockListContainer, (VerificationMode)Mockito.times((int)1))).appendChild((Node)Matchers.anyObject());
    }

    @Test
    public void onEnableEditorTab() {
        this.rightPanelPresenter.onEnableEditorTab(5);
        ((ListGroupItemPresenter)Mockito.verify((Object)this.mockListGroupItemPresenter, (VerificationMode)Mockito.times((int)1))).setDisabled(Matchers.eq((boolean)false));
        Assert.assertEquals((long)5L, (long)this.rightPanelPresenter.editingColumnIndex);
        ((RightPanelView)Mockito.verify((Object)this.mockRightPanelView, (VerificationMode)Mockito.times((int)1))).enableEditorTab();
    }

    @Test
    public void onDisableEditorTab() {
        this.rightPanelPresenter.onDisableEditorTab();
        ((ListGroupItemPresenter)Mockito.verify((Object)this.mockListGroupItemPresenter, (VerificationMode)Mockito.times((int)1))).setDisabled(Matchers.eq((boolean)true));
        Assert.assertEquals((long)-1L, (long)this.rightPanelPresenter.editingColumnIndex);
        ((RightPanelView)Mockito.verify((Object)this.mockRightPanelView, (VerificationMode)Mockito.times((int)1))).disableEditorTab();
    }

    @Test
    public void onModifyColumn() {
        this.rightPanelPresenter.editingColumnIndex = 5;
        this.rightPanelPresenter.onModifyColumn(this.FACT_NAME, "VALUE", this.VALUE_CLASS_NAME);
        ((EventBus)Mockito.verify((Object)this.mockEventBus, (VerificationMode)Mockito.times((int)1))).fireEvent((GwtEvent)Matchers.isA(SetColumnValueEvent.class));
    }
}

