/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.handlers;

import com.ait.lienzo.client.core.types.Point2D;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.NativeEvent;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.ContextMenuEvent;
import com.google.gwt.event.dom.client.ContextMenuHandler;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.GwtEvent;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.context.Dependent;
import org.drools.workbench.screens.scenariosimulation.client.editor.menu.AbstractHeaderMenuPresenter;
import org.drools.workbench.screens.scenariosimulation.client.editor.menu.BaseMenu;
import org.drools.workbench.screens.scenariosimulation.client.editor.menu.ExpectedContextMenu;
import org.drools.workbench.screens.scenariosimulation.client.editor.menu.GivenContextMenu;
import org.drools.workbench.screens.scenariosimulation.client.editor.menu.GridContextMenu;
import org.drools.workbench.screens.scenariosimulation.client.editor.menu.HeaderExpectedContextMenu;
import org.drools.workbench.screens.scenariosimulation.client.editor.menu.HeaderGivenContextMenu;
import org.drools.workbench.screens.scenariosimulation.client.editor.menu.OtherContextMenu;
import org.drools.workbench.screens.scenariosimulation.client.editor.menu.UnmodifiableColumnGridContextMenu;
import org.drools.workbench.screens.scenariosimulation.client.events.DisableRightPanelEvent;
import org.drools.workbench.screens.scenariosimulation.client.events.EnableRightPanelEvent;
import org.drools.workbench.screens.scenariosimulation.client.metadata.ScenarioHeaderMetaData;
import org.drools.workbench.screens.scenariosimulation.client.utils.ScenarioSimulationGridHeaderUtilities;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGrid;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.util.CoordinateUtilities;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;

@Dependent
public class ScenarioSimulationGridPanelClickHandler
implements ClickHandler,
ContextMenuHandler {
    ScenarioGrid scenarioGrid;
    OtherContextMenu otherContextMenu;
    HeaderGivenContextMenu headerGivenContextMenu;
    HeaderExpectedContextMenu headerExpectedContextMenu;
    GivenContextMenu givenContextMenu;
    ExpectedContextMenu expectedContextMenu;
    GridContextMenu gridContextMenu;
    UnmodifiableColumnGridContextMenu unmodifiableColumnGridContextMenu;
    Set<AbstractHeaderMenuPresenter> managedMenus = new HashSet<AbstractHeaderMenuPresenter>();
    EventBus eventBus;

    public void setScenarioGrid(ScenarioGrid scenarioGrid) {
        this.scenarioGrid = scenarioGrid;
    }

    public void setOtherContextMenu(OtherContextMenu otherContextMenu) {
        this.otherContextMenu = otherContextMenu;
        this.managedMenus.add(otherContextMenu);
    }

    public void setHeaderGivenContextMenu(HeaderGivenContextMenu headerGivenContextMenu) {
        this.headerGivenContextMenu = headerGivenContextMenu;
        this.managedMenus.add(headerGivenContextMenu);
    }

    public void setHeaderExpectedContextMenu(HeaderExpectedContextMenu headerExpectedContextMenu) {
        this.headerExpectedContextMenu = headerExpectedContextMenu;
        this.managedMenus.add(headerExpectedContextMenu);
    }

    public void setGivenContextMenu(GivenContextMenu givenContextMenu) {
        this.givenContextMenu = givenContextMenu;
        this.managedMenus.add(givenContextMenu);
    }

    public void setExpectedContextMenu(ExpectedContextMenu expectedContextMenu) {
        this.expectedContextMenu = expectedContextMenu;
        this.managedMenus.add(expectedContextMenu);
    }

    public void setGridContextMenu(GridContextMenu gridContextMenu) {
        this.gridContextMenu = gridContextMenu;
        this.managedMenus.add(gridContextMenu);
    }

    public void setUnmodifiableColumnGridContextMenu(UnmodifiableColumnGridContextMenu unmodifiableColumnGridContextMenu) {
        this.unmodifiableColumnGridContextMenu = unmodifiableColumnGridContextMenu;
        this.managedMenus.add(unmodifiableColumnGridContextMenu);
    }

    public void setEventBus(EventBus eventBus) {
        this.eventBus = eventBus;
        this.managedMenus.forEach(menu -> menu.setEventBus(eventBus));
    }

    public void onClick(ClickEvent event) {
        this.hideMenus();
        this.scenarioGrid.clearSelections();
        if (this.manageLeftClick(event)) {
            event.preventDefault();
            event.stopPropagation();
        } else {
            this.eventBus.fireEvent((GwtEvent)new DisableRightPanelEvent());
        }
    }

    public void onContextMenu(ContextMenuEvent event) {
        this.hideMenus();
        if (this.manageRightClick(event)) {
            event.preventDefault();
            event.stopPropagation();
        }
    }

    protected boolean manageRightClick(ContextMenuEvent event) {
        int canvasX = this.getRelativeX(event);
        int canvasY = this.getRelativeY(event);
        boolean isShiftKeyDown = event.getNativeEvent().getShiftKey();
        boolean isControlKeyDown = event.getNativeEvent().getCtrlKey();
        Point2D ap = CoordinateUtilities.convertDOMToGridCoordinate((GridWidget)this.scenarioGrid, (Point2D)new Point2D((double)canvasX, (double)canvasY));
        Integer uiColumnIndex = CoordinateUtilities.getUiColumnIndex((GridWidget)this.scenarioGrid, (double)ap.getX());
        if (uiColumnIndex == null) {
            return false;
        }
        if (!this.manageHeaderRightClick(this.scenarioGrid, event.getNativeEvent().getClientX(), event.getNativeEvent().getClientY(), ap.getY(), uiColumnIndex)) {
            return this.manageBodyRightClick(this.scenarioGrid, event.getNativeEvent().getClientX(), event.getNativeEvent().getClientY(), ap.getY(), uiColumnIndex, isShiftKeyDown, isControlKeyDown);
        }
        return true;
    }

    protected int getRelativeX(ContextMenuEvent event) {
        NativeEvent e = event.getNativeEvent();
        Element target = event.getRelativeElement();
        return e.getClientX() - target.getAbsoluteLeft() + target.getScrollLeft() + target.getOwnerDocument().getScrollLeft();
    }

    protected int getRelativeY(ContextMenuEvent event) {
        NativeEvent e = event.getNativeEvent();
        Element target = event.getRelativeElement();
        return e.getClientY() - target.getAbsoluteTop() + target.getScrollTop() + target.getOwnerDocument().getScrollTop();
    }

    protected int getRelativeX(ClickEvent event) {
        NativeEvent e = event.getNativeEvent();
        Element target = event.getRelativeElement();
        return e.getClientX() - target.getAbsoluteLeft() + target.getScrollLeft() + target.getOwnerDocument().getScrollLeft();
    }

    protected int getRelativeY(ClickEvent event) {
        NativeEvent e = event.getNativeEvent();
        Element target = event.getRelativeElement();
        return e.getClientY() - target.getAbsoluteTop() + target.getScrollTop() + target.getOwnerDocument().getScrollTop();
    }

    public void hideMenus() {
        this.managedMenus.forEach(BaseMenu::hide);
    }

    private boolean manageHeaderRightClick(ScenarioGrid scenarioGrid, int left, int top, double gridY, Integer uiColumnIndex) {
        String group;
        ScenarioHeaderMetaData columnMetadata = ScenarioSimulationGridHeaderUtilities.getColumnScenarioHeaderMetaData((GridWidget)scenarioGrid, (GridColumn)scenarioGrid.getModel().getColumns().get(uiColumnIndex), gridY);
        if (columnMetadata == null) {
            return false;
        }
        block5 : switch (group = columnMetadata.getColumnGroup()) {
            case "": {
                switch (columnMetadata.getTitle()) {
                    case "GIVEN": {
                        this.headerGivenContextMenu.show(left, top);
                        break block5;
                    }
                    case "EXPECTED": {
                        this.headerExpectedContextMenu.show(left, top);
                        break block5;
                    }
                }
                this.otherContextMenu.show(left, top);
                break;
            }
            case "GIVEN": {
                this.givenContextMenu.show(left, top, uiColumnIndex, group);
                break;
            }
            case "EXPECTED": {
                this.expectedContextMenu.show(left, top, uiColumnIndex, group);
                break;
            }
            default: {
                this.otherContextMenu.show(left, top);
            }
        }
        return true;
    }

    private boolean manageBodyRightClick(ScenarioGrid scenarioGrid, int left, int top, double gridY, Integer uiColumnIndex, boolean isShiftKeyDown, boolean isControlKeyDown) {
        String group;
        scenarioGrid.deselect();
        Integer uiRowIndex = CoordinateUtilities.getUiRowIndex((GridWidget)scenarioGrid, (double)gridY);
        if (uiRowIndex == null) {
            return false;
        }
        ScenarioHeaderMetaData columnMetadata = (ScenarioHeaderMetaData)((Object)((GridColumn)scenarioGrid.getModel().getColumns().get(uiColumnIndex)).getHeaderMetaData().get(1));
        if (columnMetadata == null) {
            return false;
        }
        switch (group = columnMetadata.getColumnGroup()) {
            case "GIVEN": 
            case "EXPECTED": {
                this.gridContextMenu.show(left, top, uiColumnIndex, uiRowIndex, group);
                break;
            }
            default: {
                this.unmodifiableColumnGridContextMenu.show(left, top, uiRowIndex);
            }
        }
        return true;
    }

    protected boolean manageLeftClick(ClickEvent event) {
        int canvasX = this.getRelativeX(event);
        int canvasY = this.getRelativeY(event);
        boolean isShiftKeyDown = event.getNativeEvent().getShiftKey();
        boolean isControlKeyDown = event.getNativeEvent().getCtrlKey();
        Point2D ap = CoordinateUtilities.convertDOMToGridCoordinate((GridWidget)this.scenarioGrid, (Point2D)new Point2D((double)canvasX, (double)canvasY));
        Integer uiColumnIndex = CoordinateUtilities.getUiColumnIndex((GridWidget)this.scenarioGrid, (double)ap.getX());
        if (uiColumnIndex == null) {
            return false;
        }
        return this.manageHeaderLeftClick(this.scenarioGrid, event.getNativeEvent().getClientX(), event.getNativeEvent().getClientY(), ap.getY(), uiColumnIndex);
    }

    private boolean manageHeaderLeftClick(ScenarioGrid scenarioGrid, int left, int top, double gridY, Integer uiColumnIndex) {
        String group;
        ScenarioHeaderMetaData columnMetadata = ScenarioSimulationGridHeaderUtilities.getColumnScenarioHeaderMetaData((GridWidget)scenarioGrid, (GridColumn)scenarioGrid.getModel().getColumns().get(uiColumnIndex), gridY);
        if (columnMetadata == null) {
            return false;
        }
        switch (group = columnMetadata.getColumnGroup()) {
            case "GIVEN": 
            case "EXPECTED": {
                scenarioGrid.selectColumn(uiColumnIndex);
                this.eventBus.fireEvent((GwtEvent)new EnableRightPanelEvent(uiColumnIndex));
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }
}

