/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.models;

import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.GwtEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import org.drools.workbench.screens.scenariosimulation.client.events.ScenarioGridReloadEvent;
import org.drools.workbench.screens.scenariosimulation.client.metadata.ScenarioHeaderMetaData;
import org.drools.workbench.screens.scenariosimulation.client.values.ScenarioGridCellValue;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGridCell;
import org.drools.workbench.screens.scenariosimulation.model.ExpressionIdentifier;
import org.drools.workbench.screens.scenariosimulation.model.FactIdentifier;
import org.drools.workbench.screens.scenariosimulation.model.FactMapping;
import org.drools.workbench.screens.scenariosimulation.model.FactMappingType;
import org.drools.workbench.screens.scenariosimulation.model.FactMappingValue;
import org.drools.workbench.screens.scenariosimulation.model.Scenario;
import org.drools.workbench.screens.scenariosimulation.model.Simulation;
import org.drools.workbench.screens.scenariosimulation.model.SimulationDescriptor;
import org.uberfire.ext.wires.core.grids.client.model.GridCell;
import org.uberfire.ext.wires.core.grids.client.model.GridCellValue;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.model.GridRow;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridData;

public class ScenarioGridModel
extends BaseGridData {
    Simulation simulation;
    EventBus eventBus;
    AtomicInteger columnCounter = new AtomicInteger(0);

    public ScenarioGridModel() {
    }

    public ScenarioGridModel(boolean isMerged) {
        super(isMerged);
    }

    public void bindContent(Simulation simulation) {
        this.simulation = simulation;
        this.checkSimulation();
        this.columnCounter.set(simulation.getSimulationDescriptor().getUnmodifiableFactMappings().size());
    }

    public void setEventBus(EventBus eventBus) {
        this.eventBus = eventBus;
    }

    public int nextColumnCount() {
        return this.columnCounter.getAndIncrement();
    }

    public void appendNewColumn(GridColumn<?> column) {
        this.checkSimulation();
        this.commonAddColumn(-1, column);
    }

    public void appendNewRow(GridRow row) {
        this.checkSimulation();
        super.appendRow(row);
        int rowIndex = this.getRowCount() - 1;
        this.commonAddRow(rowIndex);
    }

    public void insertRow(int rowIndex, GridRow row, Scenario scenario) {
        this.checkSimulation();
        this.insertRow(rowIndex, row);
        scenario.getUnmodifiableFactMappingValues().forEach(value -> {
            FactIdentifier factIdentifier = value.getFactIdentifier();
            ExpressionIdentifier expressionIdentifier = value.getExpressionIdentifier();
            if (!(value.getRawValue() instanceof String)) {
                throw new UnsupportedOperationException("Only string is supported at the moment");
            }
            String stringValue = (String)value.getRawValue();
            int columnIndex = this.simulation.getSimulationDescriptor().getIndexByIdentifier(factIdentifier, expressionIdentifier);
            this.setCell(rowIndex, columnIndex, () -> new ScenarioGridCell((GridCellValue<String>)new ScenarioGridCellValue(stringValue)));
        });
    }

    public void insertNewRow(int rowIndex, GridRow row) {
        this.checkSimulation();
        super.insertRow(rowIndex, row);
        this.commonAddRow(rowIndex);
    }

    public GridData.Range deleteNewRow(int rowIndex) {
        this.checkSimulation();
        GridData.Range toReturn = super.deleteRow(rowIndex);
        this.simulation.removeScenarioByIndex(rowIndex);
        return toReturn;
    }

    public void duplicateNewRow(int rowIndex, GridRow row) {
        this.checkSimulation();
        int newRowIndex = rowIndex + 1;
        Scenario toDuplicate = this.simulation.cloneScenario(rowIndex, newRowIndex);
        this.insertRow(newRowIndex, row, toDuplicate);
    }

    public void insertColumn(int index, GridColumn<?> column) {
        this.checkSimulation();
        super.insertColumn(index, column);
    }

    public void insertNewColumn(int index, GridColumn<?> column) {
        this.checkSimulation();
        this.commonAddColumn(index, column);
    }

    public void deleteNewColumn(int columnIndex) {
        this.checkSimulation();
        GridColumn toDelete = (GridColumn)this.getColumns().get(columnIndex);
        this.deleteColumn(toDelete);
        this.simulation.removeFactMappingByIndex(columnIndex);
    }

    public void updateColumnType(int columnIndex, GridColumn<?> column, String fullPackage, String value, String lastLevelClassName) {
        this.checkSimulation();
        this.deleteNewColumn(columnIndex);
        ScenarioHeaderMetaData scenarioHeaderMetaData = (ScenarioHeaderMetaData)((Object)column.getHeaderMetaData().get(1));
        String group = scenarioHeaderMetaData.getColumnGroup();
        String columnId = scenarioHeaderMetaData.getColumnId();
        String[] elements = value.split("\\.");
        if (!fullPackage.endsWith(".")) {
            fullPackage = fullPackage + ".";
        }
        String canonicalClassName = fullPackage + elements[0];
        FactIdentifier factIdentifier = FactIdentifier.create((String)columnId, (String)canonicalClassName);
        ExpressionIdentifier ei = ExpressionIdentifier.create((String)columnId, (FactMappingType)FactMappingType.valueOf((String)group));
        this.commonAddColumn(columnIndex, column, factIdentifier, ei);
        FactMapping factMappingByIndex = this.simulation.getSimulationDescriptor().getFactMappingByIndex(columnIndex);
        factMappingByIndex.setExpressionAlias(value);
        IntStream.range(1, elements.length).forEach(stepIndex -> factMappingByIndex.addExpressionElement(elements[stepIndex], lastLevelClassName));
        this.selectColumn(columnIndex);
    }

    public GridData.Range setCell(int rowIndex, int columnIndex, Supplier<GridCell<?>> cellSupplier) {
        this.checkSimulation();
        return super.setCell(rowIndex, columnIndex, cellSupplier);
    }

    public GridData.Range setNewCell(int rowIndex, int columnIndex, Supplier<GridCell<?>> cellSupplier) {
        this.checkSimulation();
        GridData.Range toReturn = this.setCell(rowIndex, columnIndex, cellSupplier);
        try {
            Optional<?> optionalValue = this.getCellValue(this.getCell(rowIndex, columnIndex));
            if (!optionalValue.isPresent()) {
                return toReturn;
            }
            Object rawValue = optionalValue.get();
            if (!(rawValue instanceof String)) {
                throw new IllegalArgumentException("Type not supported " + rawValue.getClass().getCanonicalName());
            }
            String cellValue = (String)rawValue;
            Scenario scenarioByIndex = this.simulation.getScenarioByIndex(rowIndex);
            FactMapping factMappingByIndex = this.simulation.getSimulationDescriptor().getFactMappingByIndex(columnIndex);
            FactIdentifier factIdentifier = factMappingByIndex.getFactIdentifier();
            ExpressionIdentifier expressionIdentifier = factMappingByIndex.getExpressionIdentifier();
            scenarioByIndex.addOrUpdateMappingValue(factIdentifier, expressionIdentifier, (Object)cellValue);
        }
        catch (Throwable t) {
            toReturn = super.deleteCell(rowIndex, columnIndex);
            this.eventBus.fireEvent((GwtEvent)new ScenarioGridReloadEvent());
        }
        return toReturn;
    }

    public int getFirstIndexLeftOfGroup(String groupName) {
        Optional<Integer> first = this.getColumns().stream().filter(gridColumn -> ((GridColumn.HeaderMetaData)gridColumn.getHeaderMetaData().get(1)).getColumnGroup().equals(groupName)).findFirst().map(gridColumn -> {
            int indexOfColumn = this.getColumns().indexOf(gridColumn);
            return indexOfColumn > -1 ? indexOfColumn : 0;
        });
        return first.orElseGet(() -> 0);
    }

    public int getFirstIndexRightOfGroup(String groupName) {
        Optional<Integer> last = this.getColumns().stream().filter(gridColumn -> ((GridColumn.HeaderMetaData)gridColumn.getHeaderMetaData().get(1)).getColumnGroup().equals(groupName)).reduce((first, second) -> second).map(gridColumn -> {
            int indexOfColumn = this.getColumns().indexOf(gridColumn);
            return indexOfColumn > -1 ? indexOfColumn + 1 : this.getColumnCount();
        });
        return last.orElseGet(() -> ((ScenarioGridModel)this).getColumnCount());
    }

    public long getGroupSize(String groupName) {
        return this.getColumns().stream().filter(gridColumn -> ((GridColumn.HeaderMetaData)gridColumn.getHeaderMetaData().get(1)).getColumnGroup().equals(groupName)).count();
    }

    public void clear() {
        int to = this.getRowCount();
        IntStream.range(0, to).map(i -> to - i - 1).forEach(arg_0 -> ((ScenarioGridModel)this).deleteRow(arg_0));
        ArrayList copyList = new ArrayList(this.getColumns());
        copyList.forEach(arg_0 -> ((ScenarioGridModel)this).deleteColumn(arg_0));
        if (this.simulation != null) {
            this.simulation.clear();
        }
    }

    public void selectColumn(int columnIndex) {
        if (columnIndex > this.getColumnCount() - 1) {
            return;
        }
        int rows = this.getRowCount();
        IntStream.range(0, rows).forEach(rowIndex -> this.selectCell(rowIndex, columnIndex));
    }

    public void selectRow(int rowIndex) {
        if (rowIndex > this.getRowCount() - 1) {
            return;
        }
        int columns = this.getColumnCount();
        IntStream.range(0, columns).forEach(columnIndex -> this.selectCell(rowIndex, columnIndex));
    }

    public Optional<Simulation> getSimulation() {
        return Optional.ofNullable(this.simulation);
    }

    protected void commonAddColumn(int index, GridColumn<?> column) {
        ScenarioHeaderMetaData scenarioHeaderMetaData = (ScenarioHeaderMetaData)((Object)column.getHeaderMetaData().get(1));
        String group = scenarioHeaderMetaData.getColumnGroup();
        String columnId = scenarioHeaderMetaData.getColumnId();
        FactIdentifier factIdentifier = FactIdentifier.create((String)columnId, (String)String.class.getCanonicalName());
        ExpressionIdentifier ei = ExpressionIdentifier.create((String)columnId, (FactMappingType)FactMappingType.valueOf((String)group));
        this.commonAddColumn(index, column, factIdentifier, ei);
    }

    protected void commonAddColumn(int index, GridColumn<?> column, FactIdentifier factIdentifier, ExpressionIdentifier ei) {
        SimulationDescriptor simulationDescriptor = this.simulation.getSimulationDescriptor();
        ScenarioHeaderMetaData scenarioHeaderMetaData = (ScenarioHeaderMetaData)((Object)column.getHeaderMetaData().get(1));
        String title = scenarioHeaderMetaData.getTitle();
        int columnIndex = index == -1 ? this.getColumnCount() : index;
        try {
            simulationDescriptor.addFactMapping(columnIndex, title, factIdentifier, ei);
            if (index == -1) {
                super.appendColumn(column);
            } else {
                super.insertColumn(index, column);
            }
        }
        catch (Throwable t) {
            this.eventBus.fireEvent((GwtEvent)new ScenarioGridReloadEvent());
            return;
        }
        List scenarios = this.simulation.getUnmodifiableScenarios();
        IntStream.range(0, scenarios.size()).forEach(rowIndex -> {
            String value = FactMappingValue.getPlaceHolder((int)rowIndex, (int)columnIndex);
            this.setNewCell(rowIndex, columnIndex, () -> new ScenarioGridCell((GridCellValue<String>)new ScenarioGridCellValue(value)));
        });
    }

    protected void commonAddRow(int rowIndex) {
        Scenario scenario = this.simulation.addScenario(rowIndex);
        SimulationDescriptor simulationDescriptor = this.simulation.getSimulationDescriptor();
        IntStream.range(0, this.getColumnCount()).forEach(columnIndex -> {
            FactMapping factMappingByIndex = simulationDescriptor.getFactMappingByIndex(columnIndex);
            String value = FactMappingValue.getPlaceHolder((int)rowIndex, (int)columnIndex);
            scenario.addMappingValue(factMappingByIndex.getFactIdentifier(), factMappingByIndex.getExpressionIdentifier(), (Object)value);
            this.setNewCell(rowIndex, columnIndex, () -> new ScenarioGridCell((GridCellValue<String>)new ScenarioGridCellValue(value)));
        });
    }

    void checkSimulation() {
        Objects.requireNonNull(this.simulation, "Bind a simulation to the ScenarioGridModel to use it");
    }

    private Optional<?> getCellValue(GridCell<?> gridCell) {
        if (gridCell == null || gridCell.getValue() == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(gridCell.getValue().getValue());
    }
}

