/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.rightpanel;

import com.google.gwt.dom.client.DivElement;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.drools.workbench.screens.scenariosimulation.client.models.FactModelTree;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.FieldItemPresenter;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.ListGroupItemView;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.RightPanelView;
import org.drools.workbench.screens.scenariosimulation.client.utils.ViewsProvider;

@Dependent
public class ListGroupItemPresenter
implements ListGroupItemView.Presenter {
    @Inject
    ViewsProvider viewsProvider;
    @Inject
    FieldItemPresenter fieldItemPresenter;
    RightPanelView.Presenter rightPanelPresenter;
    List<ListGroupItemView> listGroupItemViewList = new ArrayList<ListGroupItemView>();
    private AtomicBoolean disabled = new AtomicBoolean(true);

    public void setDisabled(boolean disabled) {
        this.disabled.set(disabled);
        if (disabled) {
            this.listGroupItemViewList.forEach(ListGroupItemView::closeRow);
        }
    }

    @Override
    public void init(RightPanelView.Presenter rightPanelPresenter) {
        this.rightPanelPresenter = rightPanelPresenter;
        this.fieldItemPresenter.setRightPanelPresenter(rightPanelPresenter);
    }

    @Override
    public DivElement getDivElement(String factName, FactModelTree factModelTree) {
        ListGroupItemView listGroupItemView = this.commonGetListGroupItemView("", false);
        this.populateListGroupItemView(listGroupItemView, "", factName, factModelTree);
        return listGroupItemView.getDivElement();
    }

    @Override
    public DivElement getDivElement(String fullPath, String factName, String factModelTreeClass) {
        ListGroupItemView listGroupItemView = this.commonGetListGroupItemView(fullPath, true);
        this.populateListGroupItemView(listGroupItemView, factName, factModelTreeClass);
        return listGroupItemView.getDivElement();
    }

    @Override
    public void onToggleRowExpansion(ListGroupItemView listGroupItemView, boolean currentlyShown) {
        if (this.disabled.get()) {
            return;
        }
        if (this.listGroupItemViewList.contains(listGroupItemView)) {
            if (currentlyShown) {
                listGroupItemView.closeRow();
            } else {
                if (listGroupItemView.isToExpand()) {
                    FactModelTree factModelTree = this.rightPanelPresenter.getFactModelTree(listGroupItemView.getFactType());
                    this.populateListGroupItemView(listGroupItemView, listGroupItemView.getParentPath(), listGroupItemView.getFactName(), factModelTree);
                    listGroupItemView.setToExpand(false);
                }
                listGroupItemView.expandRow();
            }
        }
    }

    protected void populateListGroupItemView(ListGroupItemView toPopulate, String parentPath, String factName, FactModelTree factModelTree) {
        if (factName.equals(factModelTree.getFactName())) {
            toPopulate.setFactName(factName);
        } else {
            toPopulate.setFactNameAndType(factName, factModelTree.getFactName());
        }
        String fullPath = parentPath.isEmpty() ? factName : parentPath + "." + factName;
        factModelTree.getSimpleProperties().forEach((key, value) -> toPopulate.addFactField(this.fieldItemPresenter.getLIElement(fullPath, factName, (String)key, (String)value)));
        factModelTree.getExpandableProperties().forEach((key, value) -> toPopulate.addExpandableFactField(this.getDivElement(fullPath, (String)key, (String)value)));
    }

    protected void populateListGroupItemView(ListGroupItemView toPopulate, String factName, String factType) {
        toPopulate.setFactNameAndType(factName, factType);
    }

    protected ListGroupItemView commonGetListGroupItemView(String parentPath, boolean toExpand) {
        ListGroupItemView listGroupItemView = this.viewsProvider.getListGroupItemView();
        listGroupItemView.init(this);
        listGroupItemView.setToExpand(toExpand);
        listGroupItemView.setParentPath(parentPath);
        this.listGroupItemViewList.add(listGroupItemView);
        return listGroupItemView;
    }
}

