/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.models;

import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.GwtEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import org.drools.workbench.screens.scenariosimulation.client.events.ScenarioGridReloadEvent;
import org.drools.workbench.screens.scenariosimulation.client.resources.i18n.ScenarioSimulationEditorConstants;
import org.drools.workbench.screens.scenariosimulation.client.values.ScenarioGridCellValue;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGridCell;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGridColumn;
import org.drools.workbench.screens.scenariosimulation.model.ExpressionIdentifier;
import org.drools.workbench.screens.scenariosimulation.model.FactIdentifier;
import org.drools.workbench.screens.scenariosimulation.model.FactMapping;
import org.drools.workbench.screens.scenariosimulation.model.FactMappingType;
import org.drools.workbench.screens.scenariosimulation.model.Scenario;
import org.drools.workbench.screens.scenariosimulation.model.Simulation;
import org.drools.workbench.screens.scenariosimulation.model.SimulationDescriptor;
import org.uberfire.ext.wires.core.grids.client.model.GridCell;
import org.uberfire.ext.wires.core.grids.client.model.GridCellValue;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.model.GridRow;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridData;

public class ScenarioGridModel
extends BaseGridData {
    Simulation simulation;
    EventBus eventBus;
    AtomicInteger columnCounter = new AtomicInteger(0);
    GridColumn<?> selectedColumn = null;

    public ScenarioGridModel() {
    }

    public ScenarioGridModel(boolean isMerged) {
        super(isMerged);
    }

    public void bindContent(Simulation simulation) {
        this.simulation = simulation;
        this.checkSimulation();
        this.columnCounter.set(simulation.getSimulationDescriptor().getUnmodifiableFactMappings().size());
    }

    public void setEventBus(EventBus eventBus) {
        this.eventBus = eventBus;
    }

    public int nextColumnCount() {
        return this.columnCounter.getAndIncrement();
    }

    public void appendRow(GridRow row) {
        this.checkSimulation();
        super.appendRow(row);
        int rowIndex = this.getRowCount() - 1;
        this.commonAddRow(rowIndex);
    }

    public void insertRowGridOnly(int rowIndex, GridRow row, Scenario scenario) {
        this.checkSimulation();
        super.insertRow(rowIndex, row);
        scenario.getUnmodifiableFactMappingValues().forEach(value -> {
            FactIdentifier factIdentifier = value.getFactIdentifier();
            ExpressionIdentifier expressionIdentifier = value.getExpressionIdentifier();
            if (value.getRawValue() != null && !(value.getRawValue() instanceof String)) {
                throw new UnsupportedOperationException("Only string is supported at the moment");
            }
            String stringValue = (String)value.getRawValue();
            int columnIndex = this.simulation.getSimulationDescriptor().getIndexByIdentifier(factIdentifier, expressionIdentifier);
            String placeHolder = FactIdentifier.EMPTY.equals((Object)factIdentifier) ? ScenarioSimulationEditorConstants.INSTANCE.defineValidType() : ScenarioSimulationEditorConstants.INSTANCE.insertValue();
            this.setCell(rowIndex, columnIndex, () -> new ScenarioGridCell(new ScenarioGridCellValue(stringValue, placeHolder)));
        });
        this.updateIndexColumn();
    }

    public void insertRow(int rowIndex, GridRow row) {
        this.checkSimulation();
        super.insertRow(rowIndex, row);
        this.commonAddRow(rowIndex);
    }

    public GridData.Range deleteRow(int rowIndex) {
        this.checkSimulation();
        GridData.Range toReturn = super.deleteRow(rowIndex);
        this.simulation.removeScenarioByIndex(rowIndex);
        this.updateIndexColumn();
        return toReturn;
    }

    public void duplicateRow(int rowIndex, GridRow row) {
        this.checkSimulation();
        int newRowIndex = rowIndex + 1;
        Scenario toDuplicate = this.simulation.cloneScenario(rowIndex, newRowIndex);
        this.insertRowGridOnly(newRowIndex, row, toDuplicate);
    }

    public void insertColumnGridOnly(int index, GridColumn<?> column) {
        this.checkSimulation();
        super.insertColumn(index, column);
    }

    public void insertColumn(int index, GridColumn<?> column) {
        this.checkSimulation();
        this.commonAddColumn(index, column);
    }

    public void deleteColumn(int columnIndex) {
        this.checkSimulation();
        GridColumn toDelete = (GridColumn)this.getColumns().get(columnIndex);
        this.deleteColumn(toDelete);
        this.simulation.removeFactMappingByIndex(columnIndex);
    }

    public void updateColumnType(int columnIndex, GridColumn<?> column, String fullPackage, String value, String lastLevelClassName, boolean keepData) {
        this.checkSimulation();
        ArrayList originalValues = new ArrayList();
        if (keepData) {
            IntStream.range(0, this.getRowCount()).forEach(rowIndex -> originalValues.add(this.getCell(rowIndex, columnIndex).getValue()));
        }
        this.deleteColumn(columnIndex);
        String group = ((ScenarioGridColumn)column).getInformationHeaderMetaData().getColumnGroup();
        String columnId = ((ScenarioGridColumn)column).getInformationHeaderMetaData().getColumnId();
        String[] elements = value.split("\\.");
        if (!fullPackage.endsWith(".")) {
            fullPackage = fullPackage + ".";
        }
        String canonicalClassName = fullPackage + elements[0];
        FactIdentifier factIdentifier = FactIdentifier.create((String)canonicalClassName, (String)canonicalClassName);
        ExpressionIdentifier ei = ExpressionIdentifier.create((String)columnId, (FactMappingType)FactMappingType.valueOf((String)group));
        this.commonAddColumn(columnIndex, column, factIdentifier, ei);
        FactMapping factMappingByIndex = this.simulation.getSimulationDescriptor().getFactMappingByIndex(columnIndex);
        factMappingByIndex.setExpressionAlias(value);
        IntStream.range(1, elements.length).forEach(stepIndex -> factMappingByIndex.addExpressionElement(elements[stepIndex], lastLevelClassName));
        if (keepData) {
            IntStream.range(0, this.getRowCount()).forEach(rowIndex -> this.setCellValue(rowIndex, columnIndex, (GridCellValue)originalValues.get(rowIndex)));
        }
        this.selectColumn(columnIndex);
    }

    public GridData.Range setCellGridOnly(int rowIndex, int columnIndex, Supplier<GridCell<?>> cellSupplier) {
        this.checkSimulation();
        return super.setCell(rowIndex, columnIndex, cellSupplier);
    }

    public GridData.Range setCell(int rowIndex, int columnIndex, Supplier<GridCell<?>> cellSupplier) {
        this.checkSimulation();
        GridData.Range toReturn = super.setCell(rowIndex, columnIndex, cellSupplier);
        try {
            Optional<?> optionalValue = this.getCellValue(this.getCell(rowIndex, columnIndex));
            Object rawValue = optionalValue.isPresent() ? optionalValue.get() : null;
            String cellValue = rawValue != null && rawValue instanceof String ? (String)rawValue : null;
            Scenario scenarioByIndex = this.simulation.getScenarioByIndex(rowIndex);
            FactMapping factMappingByIndex = this.simulation.getSimulationDescriptor().getFactMappingByIndex(columnIndex);
            FactIdentifier factIdentifier = factMappingByIndex.getFactIdentifier();
            ExpressionIdentifier expressionIdentifier = factMappingByIndex.getExpressionIdentifier();
            scenarioByIndex.addOrUpdateMappingValue(factIdentifier, expressionIdentifier, (Object)cellValue);
        }
        catch (Throwable t) {
            toReturn = super.deleteCell(rowIndex, columnIndex);
            this.eventBus.fireEvent((GwtEvent)new ScenarioGridReloadEvent());
        }
        return toReturn;
    }

    public GridData.Range setCellValue(int rowIndex, int columnIndex, GridCellValue<?> value) {
        return this.setCell(rowIndex, columnIndex, () -> new ScenarioGridCell((ScenarioGridCellValue)value));
    }

    public GridData.Range deleteCell(int rowIndex, int columnIndex) {
        FactMapping factMapping = this.simulation.getSimulationDescriptor().getFactMappingByIndex(columnIndex);
        this.simulation.getScenarioByIndex(rowIndex).removeFactMappingValueByIdentifiers(factMapping.getFactIdentifier(), factMapping.getExpressionIdentifier());
        return super.deleteCell(rowIndex, columnIndex);
    }

    public int getFirstIndexLeftOfGroup(String groupName) {
        Optional<Integer> first = this.getColumns().stream().filter(gridColumn -> ((ScenarioGridColumn)((Object)gridColumn)).getInformationHeaderMetaData().getColumnGroup().equals(groupName)).findFirst().map(gridColumn -> {
            int indexOfColumn = this.getColumns().indexOf(gridColumn);
            return indexOfColumn > -1 ? indexOfColumn : 0;
        });
        return first.orElseGet(() -> 0);
    }

    public int getFirstIndexRightOfGroup(String groupName) {
        Optional<Integer> last = this.getColumns().stream().filter(gridColumn -> ((ScenarioGridColumn)((Object)gridColumn)).getInformationHeaderMetaData().getColumnGroup().equals(groupName)).reduce((first, second) -> second).map(gridColumn -> {
            int indexOfColumn = this.getColumns().indexOf(gridColumn);
            return indexOfColumn > -1 ? indexOfColumn + 1 : this.getColumnCount();
        });
        return last.orElseGet(() -> ((ScenarioGridModel)this).getColumnCount());
    }

    public long getGroupSize(String groupName) {
        return this.getColumns().stream().filter(gridColumn -> ((ScenarioGridColumn)((Object)gridColumn)).getInformationHeaderMetaData().getColumnGroup().equals(groupName)).count();
    }

    public void updateHeader(int columnIndex, int rowIndex, String value) {
        ((GridColumn.HeaderMetaData)((GridColumn)this.getColumns().get(columnIndex)).getHeaderMetaData().get(rowIndex)).setTitle(value);
        this.simulation.getSimulationDescriptor().getFactMappingByIndex(columnIndex).setExpressionAlias(value);
    }

    public void clear() {
        int to = this.getRowCount();
        IntStream.range(0, to).map(i -> to - i - 1).forEach(x$0 -> super.deleteRow(x$0));
        ArrayList copyList = new ArrayList(this.getColumns());
        copyList.forEach(x$0 -> super.deleteColumn(x$0));
        if (this.simulation != null) {
            this.simulation.clear();
        }
    }

    public void clearSelections() {
        super.clearSelections();
        this.selectedColumn = null;
    }

    public void selectColumn(int columnIndex) {
        if (columnIndex > this.getColumnCount() - 1) {
            return;
        }
        this.selectedColumn = (GridColumn)this.getColumns().get(columnIndex);
        int rows = this.getRowCount();
        IntStream.range(0, rows).forEach(rowIndex -> this.selectCell(rowIndex, columnIndex));
    }

    public void selectRow(int rowIndex) {
        if (rowIndex > this.getRowCount() - 1) {
            return;
        }
        int columns = this.getColumnCount();
        IntStream.range(0, columns).forEach(columnIndex -> this.selectCell(rowIndex, columnIndex));
    }

    public GridColumn<?> getSelectedColumn() {
        return this.selectedColumn;
    }

    public Optional<Simulation> getSimulation() {
        return Optional.ofNullable(this.simulation);
    }

    public boolean isSelectedColumnEmpty() {
        return this.selectedColumn == null ? true : this.isColumnEmpty(this.getColumns().indexOf(this.selectedColumn));
    }

    public boolean isColumnEmpty(int columnIndex) {
        return !IntStream.range(0, this.getRowCount()).filter(rowIndex -> this.getCellValue(this.getCell(rowIndex, columnIndex)).isPresent()).findFirst().isPresent();
    }

    public boolean isSameSelectedColumnProperty(String propertyName) {
        return this.selectedColumn == null ? true : this.isSameSelectedColumnProperty(this.getColumns().indexOf(this.selectedColumn), propertyName);
    }

    public boolean isSameSelectedColumnProperty(int columnIndex, String propertyName) {
        SimulationDescriptor simulationDescriptor = this.simulation.getSimulationDescriptor();
        FactMapping factMappingByIndex = simulationDescriptor.getFactMappingByIndex(columnIndex);
        return factMappingByIndex.getExpressionAlias().equals(propertyName);
    }

    public boolean isSameSelectedColumnType(String className) {
        return this.selectedColumn == null ? true : this.isSameSelectedColumnType(this.getColumns().indexOf(this.selectedColumn), className);
    }

    public boolean isSameSelectedColumnType(int columnIndex, String className) {
        SimulationDescriptor simulationDescriptor = this.simulation.getSimulationDescriptor();
        FactMapping factMappingByIndex = simulationDescriptor.getFactMappingByIndex(columnIndex);
        return factMappingByIndex.getClassName().equals(className);
    }

    protected void commonAddColumn(int index, GridColumn<?> column) {
        String group = ((ScenarioGridColumn)column).getInformationHeaderMetaData().getColumnGroup();
        String columnId = ((ScenarioGridColumn)column).getInformationHeaderMetaData().getColumnId();
        ExpressionIdentifier ei = ExpressionIdentifier.create((String)columnId, (FactMappingType)FactMappingType.valueOf((String)group));
        this.commonAddColumn(index, column, FactIdentifier.EMPTY, ei);
    }

    protected void commonAddColumn(int index, GridColumn<?> column, FactIdentifier factIdentifier, ExpressionIdentifier ei) {
        SimulationDescriptor simulationDescriptor = this.simulation.getSimulationDescriptor();
        String title = ((ScenarioGridColumn)column).getInformationHeaderMetaData().getTitle();
        int columnIndex = index == -1 ? this.getColumnCount() : index;
        try {
            simulationDescriptor.addFactMapping(columnIndex, title, factIdentifier, ei);
            if (index == -1) {
                super.appendColumn(column);
            } else {
                super.insertColumn(index, column);
            }
        }
        catch (Throwable t) {
            this.eventBus.fireEvent((GwtEvent)new ScenarioGridReloadEvent());
            return;
        }
        List scenarios = this.simulation.getUnmodifiableScenarios();
        IntStream.range(0, scenarios.size()).forEach(rowIndex -> {
            String placeHolder = FactIdentifier.EMPTY.equals((Object)factIdentifier) ? ScenarioSimulationEditorConstants.INSTANCE.defineValidType() : ScenarioSimulationEditorConstants.INSTANCE.insertValue();
            this.setCell(rowIndex, columnIndex, () -> new ScenarioGridCell(new ScenarioGridCellValue(null, placeHolder)));
        });
    }

    protected void commonAddRow(int rowIndex) {
        Scenario scenario = this.simulation.addScenario(rowIndex);
        SimulationDescriptor simulationDescriptor = this.simulation.getSimulationDescriptor();
        IntStream.range(1, this.getColumnCount()).forEach(columnIndex -> {
            FactMapping factMappingByIndex = simulationDescriptor.getFactMappingByIndex(columnIndex);
            scenario.addMappingValue(factMappingByIndex.getFactIdentifier(), factMappingByIndex.getExpressionIdentifier(), null);
            String placeHolder = FactIdentifier.EMPTY.equals((Object)factMappingByIndex.getFactIdentifier()) ? ScenarioSimulationEditorConstants.INSTANCE.defineValidType() : ScenarioSimulationEditorConstants.INSTANCE.insertValue();
            this.setCell(rowIndex, columnIndex, () -> new ScenarioGridCell(new ScenarioGridCellValue(null, placeHolder)));
        });
        this.updateIndexColumn();
    }

    protected void updateIndexColumn() {
        Optional<GridColumn> indexColumn = this.getColumns().stream().filter(gridColumn -> ((ScenarioGridColumn)((Object)gridColumn)).getInformationHeaderMetaData().getTitle().equals(ExpressionIdentifier.INDEX.getName())).findFirst();
        indexColumn.ifPresent(column -> {
            int indexOfColumn = this.getColumns().indexOf(column);
            IntStream.range(0, this.getRowCount()).forEach(rowIndex -> {
                String value = String.valueOf(rowIndex + 1);
                this.setCellValue(rowIndex, indexOfColumn, (GridCellValue<?>)new ScenarioGridCellValue(value));
            });
        });
    }

    void checkSimulation() {
        Objects.requireNonNull(this.simulation, "Bind a simulation to the ScenarioGridModel to use it");
    }

    private Optional<?> getCellValue(GridCell<?> gridCell) {
        if (gridCell == null || gridCell.getValue() == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(gridCell.getValue().getValue());
    }
}

