/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.widgets;

import com.ait.lienzo.client.core.event.NodeMouseDoubleClickHandler;
import com.ait.lienzo.shared.core.types.EventPropagationMode;
import java.util.List;
import java.util.stream.IntStream;
import org.drools.workbench.screens.scenariosimulation.client.factories.FactoryProvider;
import org.drools.workbench.screens.scenariosimulation.client.factories.ScenarioHeaderTextBoxSingletonDOMElementFactory;
import org.drools.workbench.screens.scenariosimulation.client.handlers.ScenarioSimulationGridPanelDoubleClickHandler;
import org.drools.workbench.screens.scenariosimulation.client.models.ScenarioGridModel;
import org.drools.workbench.screens.scenariosimulation.client.renderers.ScenarioGridRenderer;
import org.drools.workbench.screens.scenariosimulation.client.resources.i18n.ScenarioSimulationEditorConstants;
import org.drools.workbench.screens.scenariosimulation.client.utils.ScenarioSimulationBuilders;
import org.drools.workbench.screens.scenariosimulation.client.utils.ScenarioSimulationUtils;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGridColumn;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGridLayer;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGridPanel;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGridRow;
import org.drools.workbench.screens.scenariosimulation.model.FactIdentifier;
import org.drools.workbench.screens.scenariosimulation.model.FactMapping;
import org.drools.workbench.screens.scenariosimulation.model.FactMappingType;
import org.drools.workbench.screens.scenariosimulation.model.Scenario;
import org.drools.workbench.screens.scenariosimulation.model.Simulation;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.model.GridRow;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;
import org.uberfire.ext.wires.core.grids.client.widget.grid.impl.BaseGridWidget;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.GridRenderer;
import org.uberfire.ext.wires.core.grids.client.widget.layer.GridSelectionManager;
import org.uberfire.ext.wires.core.grids.client.widget.layer.pinning.GridPinnedModeManager;

public class ScenarioGrid
extends BaseGridWidget {
    private final ScenarioGridLayer scenarioGridLayer;
    private final ScenarioGridPanel scenarioGridPanel;

    public ScenarioGrid(ScenarioGridModel model, ScenarioGridLayer scenarioGridLayer, ScenarioGridRenderer renderer, ScenarioGridPanel scenarioGridPanel) {
        super((GridData)model, (GridSelectionManager)scenarioGridLayer, (GridPinnedModeManager)scenarioGridLayer, (GridRenderer)renderer);
        this.scenarioGridLayer = scenarioGridLayer;
        this.scenarioGridPanel = scenarioGridPanel;
        this.setDraggable(false);
        this.setEventPropagationMode(EventPropagationMode.NO_ANCESTORS);
    }

    public void setContent(Simulation simulation) {
        ((ScenarioGridModel)this.model).clear();
        ((ScenarioGridModel)this.model).bindContent(simulation);
        this.setHeaderColumns(simulation);
        this.appendRows(simulation);
    }

    public ScenarioGridModel getModel() {
        return (ScenarioGridModel)this.model;
    }

    public void clearSelections() {
        this.model.clearSelections();
    }

    public void selectColumn(int columnIndex) {
        ((ScenarioGridModel)this.model).selectColumn(columnIndex);
    }

    public void selectRow(int rowIndex) {
        ((ScenarioGridModel)this.model).selectRow(rowIndex);
    }

    protected NodeMouseDoubleClickHandler getGridMouseDoubleClickHandler(GridSelectionManager selectionManager, GridPinnedModeManager pinnedModeManager) {
        return new ScenarioSimulationGridPanelDoubleClickHandler((GridWidget)this, selectionManager, pinnedModeManager, this.renderer);
    }

    protected void setHeaderColumns(Simulation simulation) {
        List factMappings = simulation.getSimulationDescriptor().getUnmodifiableFactMappings();
        IntStream.range(0, factMappings.size()).forEach(columnIndex -> this.setHeaderColumn(columnIndex, (FactMapping)factMappings.get(columnIndex)));
    }

    protected void setHeaderColumn(int columnIndex, FactMapping factMapping) {
        String columnId = factMapping.getExpressionIdentifier().getName();
        String columnTitle = factMapping.getExpressionAlias();
        String columnGroup = factMapping.getExpressionIdentifier().getType().name();
        ScenarioHeaderTextBoxSingletonDOMElementFactory factoryHeader = this.getScenarioHeaderTextBoxSingletonDOMElementFactory();
        ScenarioSimulationBuilders.HeaderBuilder headerBuilder = this.getHeaderBuilderLocal(columnTitle, columnId, columnGroup, factMapping.getExpressionIdentifier().getType(), factoryHeader);
        boolean readOnly = FactIdentifier.EMPTY.equals((Object)factMapping.getFactIdentifier()) || FactIdentifier.INDEX.equals((Object)factMapping.getFactIdentifier());
        String placeHolder = readOnly ? ScenarioSimulationEditorConstants.INSTANCE.defineValidType() : ScenarioSimulationEditorConstants.INSTANCE.insertValue();
        ScenarioGridColumn scenarioGridColumn = this.getScenarioGridColumnLocal(headerBuilder, readOnly, placeHolder);
        ((ScenarioGridModel)this.model).insertColumnGridOnly(columnIndex, (GridColumn<?>)scenarioGridColumn);
    }

    protected ScenarioHeaderTextBoxSingletonDOMElementFactory getScenarioHeaderTextBoxSingletonDOMElementFactory() {
        return FactoryProvider.getHeaderTextBoxFactory(this.scenarioGridPanel, this.scenarioGridLayer);
    }

    protected ScenarioSimulationBuilders.HeaderBuilder getHeaderBuilderLocal(String columnTitle, String columnId, String columnGroup, FactMappingType factMappingType, ScenarioHeaderTextBoxSingletonDOMElementFactory factoryHeader) {
        return ScenarioSimulationUtils.getHeaderBuilder(columnTitle, columnId, columnGroup, factMappingType, factoryHeader);
    }

    protected ScenarioGridColumn getScenarioGridColumnLocal(ScenarioSimulationBuilders.HeaderBuilder headerBuilder, boolean readOnly, String placeHolder) {
        return ScenarioSimulationUtils.getScenarioGridColumn(headerBuilder, this.scenarioGridPanel, this.scenarioGridLayer, readOnly, placeHolder);
    }

    protected void appendRows(Simulation simulation) {
        List scenarios = simulation.getUnmodifiableScenarios();
        IntStream.range(0, scenarios.size()).forEach(rowIndex -> this.appendRow(rowIndex, (Scenario)scenarios.get(rowIndex)));
    }

    protected void appendRow(int rowIndex, Scenario scenario) {
        ((ScenarioGridModel)this.model).insertRowGridOnly(rowIndex, (GridRow)new ScenarioGridRow(), scenario);
    }
}

