/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.editor.menu;

import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Node;
import com.google.gwt.dom.client.Style;
import com.google.gwt.dom.client.UListElement;
import com.google.gwt.event.dom.client.ContextMenuEvent;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwtmockito.GwtMockitoTestRunner;
import com.google.web.bindery.event.shared.Event;
import org.drools.workbench.screens.scenariosimulation.client.editor.menu.BaseMenu;
import org.drools.workbench.screens.scenariosimulation.client.editor.menu.BaseMenuView;
import org.drools.workbench.screens.scenariosimulation.client.editor.menu.ExecutableMenuItemPresenter;
import org.drools.workbench.screens.scenariosimulation.client.editor.menu.MenuItemPresenter;
import org.drools.workbench.screens.scenariosimulation.client.events.RefreshMenusEvent;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=GwtMockitoTestRunner.class)
public class BaseMenuTest {
    @Mock
    private RootPanel mockRootPanel;
    @Mock
    private MenuItemPresenter mockMenuItemPresenter;
    @Mock
    private ExecutableMenuItemPresenter mockExecutableMenuItemPresenter;
    @Mock
    private BaseMenuView mockView;
    @Mock
    private UListElement mockContextMenuDropdown;
    @Mock
    private Style mockStyle;
    private BaseMenu baseMenu;

    @Before
    public void setup() {
        Mockito.when((Object)this.mockContextMenuDropdown.getStyle()).thenReturn((Object)this.mockStyle);
        Mockito.when((Object)this.mockView.getContextMenuDropdown()).thenReturn((Object)this.mockContextMenuDropdown);
        this.baseMenu = (BaseMenu)Mockito.spy((Object)new BaseMenu(){
            {
                this.view = BaseMenuTest.this.mockView;
                this.menuItemPresenter = BaseMenuTest.this.mockMenuItemPresenter;
                this.executableMenuItemPresenter = BaseMenuTest.this.mockExecutableMenuItemPresenter;
            }

            protected RootPanel getRootPanel() {
                return BaseMenuTest.this.mockRootPanel;
            }
        });
    }

    @Test
    public void initialise() {
        this.baseMenu.initialise();
        ((BaseMenuView)Mockito.verify((Object)this.mockView, (VerificationMode)Mockito.times((int)1))).init((Object)this.baseMenu);
    }

    @Test
    public void addMenuItem() {
        String id = "TEST-ID";
        String label = "TEST-LABEL";
        String i18n = "TEST-i18n";
        this.baseMenu.addMenuItem(id, label, i18n);
        ((UListElement)Mockito.verify((Object)this.mockContextMenuDropdown, (VerificationMode)Mockito.times((int)1))).appendChild((Node)this.mockMenuItemPresenter.getLabelMenuElement(id, label));
    }

    @Test
    public void addExecutableMenuItem() {
        Event mockEvent = (Event)Mockito.mock(Event.class);
        String id = "TEST-ID";
        String label = "TEST-LABEL";
        String i18n = "TEST-i18n";
        this.baseMenu.addExecutableMenuItem(id, label, i18n, mockEvent);
        ((UListElement)Mockito.verify((Object)this.mockContextMenuDropdown, (VerificationMode)Mockito.times((int)1))).appendChild((Node)this.mockExecutableMenuItemPresenter.getLExecutableMenuElement(id, label, mockEvent));
    }

    @Test
    public void onRefreshMenusEvent() {
        this.baseMenu.onRefreshMenusEvent((RefreshMenusEvent)Mockito.mock(RefreshMenusEvent.class));
        ((BaseMenu)Mockito.verify((Object)this.baseMenu, (VerificationMode)Mockito.times((int)1))).initialise();
    }

    @Test
    public void asWidget() {
        this.baseMenu.asWidget();
        ((BaseMenuView)Mockito.verify((Object)this.mockView, (VerificationMode)Mockito.times((int)1))).asWidget();
    }

    @Test
    public void show() {
        int x = 10;
        int y = 20;
        this.baseMenu.show(x, y);
        ((BaseMenu)Mockito.verify((Object)this.baseMenu, (VerificationMode)Mockito.times((int)1))).hide();
        ((Style)Mockito.verify((Object)this.mockStyle, (VerificationMode)Mockito.times((int)1))).setLeft((double)x, Style.Unit.PX);
        ((Style)Mockito.verify((Object)this.mockStyle, (VerificationMode)Mockito.times((int)1))).setTop((double)y, Style.Unit.PX);
        ((Style)Mockito.verify((Object)this.mockStyle, (VerificationMode)Mockito.times((int)1))).setDisplay(Style.Display.BLOCK);
    }

    @Test
    public void hide() {
        Mockito.when((Object)this.mockRootPanel.getWidgetIndex((IsWidget)this.mockView)).thenReturn((Object)1);
        this.baseMenu.hide();
        ((BaseMenu)Mockito.verify((Object)this.baseMenu, (VerificationMode)Mockito.times((int)1))).isShown();
        ((Style)Mockito.verify((Object)this.mockStyle, (VerificationMode)Mockito.times((int)1))).setDisplay(Style.Display.NONE);
        Mockito.when((Object)this.mockRootPanel.getWidgetIndex((IsWidget)this.mockView)).thenReturn((Object)-1);
        Mockito.reset((Object[])new BaseMenu[]{this.baseMenu});
        Mockito.reset((Object[])new Style[]{this.mockStyle});
        this.baseMenu.hide();
        ((BaseMenu)Mockito.verify((Object)this.baseMenu, (VerificationMode)Mockito.times((int)1))).isShown();
        ((Style)Mockito.verify((Object)this.mockStyle, (VerificationMode)Mockito.times((int)0))).setDisplay(Style.Display.NONE);
    }

    @Test
    public void getView() {
        BaseMenuView retrieved = this.baseMenu.getView();
        Assert.assertNotNull((Object)retrieved);
    }

    @Test
    public void isShown() {
        Mockito.when((Object)this.mockRootPanel.getWidgetIndex((IsWidget)this.mockView)).thenReturn((Object)1);
        Assert.assertTrue((boolean)this.baseMenu.isShown());
        Mockito.when((Object)this.mockRootPanel.getWidgetIndex((IsWidget)this.mockView)).thenReturn((Object)-1);
        Assert.assertFalse((boolean)this.baseMenu.isShown());
    }

    @Test
    public void onContextMenuEvent() {
        ContextMenuEvent mockEvent = (ContextMenuEvent)Mockito.mock(ContextMenuEvent.class);
        this.baseMenu.onContextMenuEvent(mockEvent);
        ((ContextMenuEvent)Mockito.verify((Object)mockEvent, (VerificationMode)Mockito.times((int)1))).preventDefault();
        ((ContextMenuEvent)Mockito.verify((Object)mockEvent, (VerificationMode)Mockito.times((int)1))).stopPropagation();
        ((BaseMenu)Mockito.verify((Object)this.baseMenu, (VerificationMode)Mockito.times((int)1))).hide();
    }

    @Test
    public void enableElement() {
        Element mockElement = (Element)Mockito.mock(Element.class);
        this.baseMenu.enableElement(mockElement, true);
        ((Element)Mockito.verify((Object)mockElement, (VerificationMode)Mockito.times((int)1))).removeClassName("disabled");
        Mockito.reset((Object[])new Element[]{mockElement});
        this.baseMenu.enableElement(mockElement, false);
        ((Element)Mockito.verify((Object)mockElement, (VerificationMode)Mockito.times((int)1))).addClassName("disabled");
    }
}

