/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.handlers;

import com.ait.lienzo.client.core.event.AbstractNodeMouseEvent;
import com.ait.lienzo.client.core.event.NodeMouseClickEvent;
import com.ait.lienzo.client.core.event.NodeMouseDoubleClickEvent;
import com.ait.lienzo.client.core.shape.Viewport;
import com.ait.lienzo.client.core.types.Point2D;
import com.ait.lienzo.test.LienzoMockitoTestRunner;
import com.google.gwt.event.dom.client.DoubleClickEvent;
import com.google.gwt.event.dom.client.MouseEvent;
import java.util.Collections;
import org.drools.workbench.screens.scenariosimulation.client.handlers.AbstractScenarioSimulationGridPanelClickHandlerTest;
import org.drools.workbench.screens.scenariosimulation.client.handlers.ScenarioSimulationGridWidgetMouseEventHandler;
import org.drools.workbench.screens.scenariosimulation.client.metadata.ScenarioHeaderMetaData;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.wires.core.grids.client.model.GridCellEditAction;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseHeaderMetaData;
import org.uberfire.ext.wires.core.grids.client.widget.context.GridBodyCellEditContext;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.impl.BaseGridRendererHelper;

@RunWith(value=LienzoMockitoTestRunner.class)
public class ScenarioSimulationGridWidgetMouseEventHandlerTest
extends AbstractScenarioSimulationGridPanelClickHandlerTest {
    private static final int MOUSE_EVENT_X = 32;
    private static final int MOUSE_EVENT_Y = 64;
    private static final double GRID_COMPUTED_LOCATION_X = 100.0;
    private static final double GRID_COMPUTED_LOCATION_Y = 200.0;
    @Mock
    private Viewport viewport;
    @Mock
    private MouseEvent nativeClickEvent;
    @Mock
    private DoubleClickEvent nativeDoubleClickEvent;
    @Mock
    private BaseGridRendererHelper rendererHelper;
    @Mock
    private BaseGridRendererHelper.RenderingInformation renderingInformation;
    @Mock
    private BaseGridRendererHelper.ColumnInformation columnInformation;
    @Mock
    private BaseGridRendererHelper.RenderingBlockInformation renderingBlockInformation;
    @Captor
    private ArgumentCaptor<GridBodyCellEditContext> gridBodyCellEditContextCaptor;
    private NodeMouseClickEvent clickEvent;
    private NodeMouseDoubleClickEvent doubleClickEvent;
    private ScenarioSimulationGridWidgetMouseEventHandler handler;
    private Point2D relativeLocation = new Point2D(32.0, 64.0);
    private Point2D computedLocation = new Point2D(100.0, 200.0);

    @Before
    public void setup() throws Exception {
        super.setUp();
        this.clickEvent = new NodeMouseClickEvent(this.nativeClickEvent);
        this.doubleClickEvent = new NodeMouseDoubleClickEvent(this.nativeDoubleClickEvent);
        Mockito.when((Object)this.scenarioGridMock.getRendererHelper()).thenReturn((Object)this.rendererHelper);
        Mockito.when((Object)this.scenarioGridMock.getViewport()).thenReturn((Object)this.viewport);
        Mockito.when((Object)this.scenarioGridMock.getComputedLocation()).thenReturn((Object)this.computedLocation);
        Mockito.when((Object)this.rendererHelper.getRenderingInformation()).thenReturn((Object)this.renderingInformation);
        Mockito.when((Object)this.rendererHelper.getColumnInformation(Matchers.anyDouble())).thenReturn((Object)this.columnInformation);
        Mockito.when((Object)this.columnInformation.getColumn()).thenReturn((Object)this.scenarioGridColumnMock);
        Mockito.when((Object)this.renderingInformation.getBodyBlockInformation()).thenReturn((Object)this.renderingBlockInformation);
        Mockito.when((Object)this.renderingInformation.getFloatingBlockInformation()).thenReturn((Object)this.renderingBlockInformation);
        Mockito.when((Object)this.headerMetaDataMock.getSupportedEditAction()).thenReturn((Object)GridCellEditAction.SINGLE_CLICK);
        this.handler = new ScenarioSimulationGridWidgetMouseEventHandler();
    }

    @Test
    public void testHandleHeaderCell_NonEditableColumn() {
        Assert.assertFalse((boolean)this.handler.handleHeaderCell((GridWidget)this.scenarioGridMock, this.relativeLocation, 0, 0, (AbstractNodeMouseEvent)this.clickEvent));
        ((ScenarioHeaderMetaData)Mockito.verify((Object)this.headerMetaDataMock, (VerificationMode)Mockito.never())).edit((GridBodyCellEditContext)Matchers.any(GridBodyCellEditContext.class));
    }

    @Test
    public void testHandleHeaderCell_EditableColumn_NotEditableRow() {
        Mockito.when((Object)this.scenarioGridColumnMock.getHeaderMetaData()).thenReturn(Collections.singletonList(new BaseHeaderMetaData("column")));
        Assert.assertFalse((boolean)this.handler.handleHeaderCell((GridWidget)this.scenarioGridMock, this.relativeLocation, 0, 0, (AbstractNodeMouseEvent)this.clickEvent));
        ((ScenarioHeaderMetaData)Mockito.verify((Object)this.headerMetaDataMock, (VerificationMode)Mockito.never())).edit((GridBodyCellEditContext)Matchers.any(GridBodyCellEditContext.class));
    }

    @Test
    public void testHandleHeaderCell_EditableColumn_EditableRow_ClickEvent() {
        Mockito.when((Object)this.scenarioGridColumnMock.getHeaderMetaData()).thenReturn(Collections.singletonList(this.headerMetaDataMock));
        Mockito.when((Object)this.scenarioGridModelMock.getSelectedHeaderCells()).thenReturn(Collections.singletonList(Mockito.mock(GridData.SelectedCell.class)));
        Assert.assertTrue((boolean)this.handler.handleHeaderCell((GridWidget)this.scenarioGridMock, this.relativeLocation, 0, 0, (AbstractNodeMouseEvent)this.clickEvent));
        ((ScenarioHeaderMetaData)Mockito.verify((Object)this.headerMetaDataMock)).edit((GridBodyCellEditContext)this.gridBodyCellEditContextCaptor.capture());
        GridBodyCellEditContext gridBodyCellEditContext = (GridBodyCellEditContext)this.gridBodyCellEditContextCaptor.getValue();
        Assert.assertNotNull((Object)gridBodyCellEditContext);
        Assert.assertTrue((boolean)gridBodyCellEditContext.getRelativeLocation().isPresent());
        Point2D relativeLocation = (Point2D)gridBodyCellEditContext.getRelativeLocation().get();
        Assert.assertEquals((double)132.0, (double)relativeLocation.getX(), (double)0.0);
        Assert.assertEquals((double)264.0, (double)relativeLocation.getY(), (double)0.0);
    }

    @Test
    public void testHandleHeaderCell_EditableColumn_EditableRow_DoubleClickEvent() {
        Mockito.when((Object)this.scenarioGridColumnMock.getHeaderMetaData()).thenReturn(Collections.singletonList(this.headerMetaDataMock));
        this.scenarioGridModelMock.selectHeaderCell(0, 0);
        Assert.assertFalse((boolean)this.handler.handleHeaderCell((GridWidget)this.scenarioGridMock, this.relativeLocation, 0, 0, (AbstractNodeMouseEvent)this.doubleClickEvent));
        ((ScenarioHeaderMetaData)Mockito.verify((Object)this.headerMetaDataMock, (VerificationMode)Mockito.never())).edit((GridBodyCellEditContext)Matchers.any(GridBodyCellEditContext.class));
    }
}

