/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.widgets;

import com.ait.lienzo.test.LienzoMockitoTestRunner;
import java.util.List;
import java.util.stream.IntStream;
import org.drools.workbench.screens.scenariosimulation.client.factories.ScenarioHeaderTextBoxSingletonDOMElementFactory;
import org.drools.workbench.screens.scenariosimulation.client.handlers.ScenarioSimulationGridWidgetMouseEventHandler;
import org.drools.workbench.screens.scenariosimulation.client.metadata.ScenarioHeaderMetaData;
import org.drools.workbench.screens.scenariosimulation.client.models.ScenarioGridModel;
import org.drools.workbench.screens.scenariosimulation.client.renderers.ScenarioGridRenderer;
import org.drools.workbench.screens.scenariosimulation.client.resources.i18n.ScenarioSimulationEditorConstants;
import org.drools.workbench.screens.scenariosimulation.client.utils.ScenarioSimulationBuilders;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGrid;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGridColumn;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGridLayer;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGridPanel;
import org.drools.workbench.screens.scenariosimulation.model.ExpressionElement;
import org.drools.workbench.screens.scenariosimulation.model.ExpressionIdentifier;
import org.drools.workbench.screens.scenariosimulation.model.FactIdentifier;
import org.drools.workbench.screens.scenariosimulation.model.FactMapping;
import org.drools.workbench.screens.scenariosimulation.model.FactMappingType;
import org.drools.workbench.screens.scenariosimulation.model.Scenario;
import org.drools.workbench.screens.scenariosimulation.model.Simulation;
import org.drools.workbench.screens.scenariosimulation.model.SimulationDescriptor;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.wires.core.grids.client.widget.grid.impl.DefaultGridWidgetCellSelectorMouseEventHandler;
import org.uberfire.ext.wires.core.grids.client.widget.layer.GridSelectionManager;
import org.uberfire.ext.wires.core.grids.client.widget.layer.pinning.GridPinnedModeManager;

@RunWith(value=LienzoMockitoTestRunner.class)
public class ScenarioGridTest {
    @Mock
    private ScenarioGridModel mockScenarioGridModel;
    @Mock
    private ScenarioGridLayer mockScenarioGridLayer;
    @Mock
    private ScenarioGridRenderer mockScenarioGridRenderer;
    @Mock
    private ScenarioGridPanel mockScenarioGridPanel;
    @Mock
    private ScenarioHeaderTextBoxSingletonDOMElementFactory scenarioHeaderTextBoxSingletonDOMElementFactoryMock;
    @Mock
    private ScenarioSimulationBuilders.HeaderBuilder headerBuilderMock;
    @Mock
    private ScenarioGridColumn scenarioGridColumnMock;
    @Mock
    private ScenarioHeaderMetaData propertyHeaderMetadataMock;
    private final FactMappingType factMappingType = FactMappingType.valueOf((String)"OTHER");
    private final String EXPRESSION_ALIAS_DESCRIPTION = "EXPRESSION_ALIAS_DESCRIPTION";
    private final String EXPRESSION_ALIAS_GIVEN = "EXPRESSION_ALIAS_GIVEN";
    private final String EXPRESSION_ALIAS_INDEX = "EXPRESSION_ALIAS_INDEX";
    private FactMapping factMappingDescription;
    private FactMapping factMappingIndex;
    private FactMapping factMappingGiven;
    private FactIdentifier factIdentifierGiven;
    private Simulation simulation = new Simulation();
    private final int COLUMNS = 6;
    private ScenarioGrid scenarioGrid;

    @Before
    public void setup() {
        Mockito.when((Object)this.scenarioGridColumnMock.getPropertyHeaderMetaData()).thenReturn((Object)this.propertyHeaderMetadataMock);
        this.factIdentifierGiven = new FactIdentifier("GIVEN", "GIVEN");
        this.factMappingDescription = new FactMapping("EXPRESSION_ALIAS_DESCRIPTION", FactIdentifier.DESCRIPTION, ExpressionIdentifier.DESCRIPTION);
        this.factMappingGiven = new FactMapping("EXPRESSION_ALIAS_GIVEN", this.factIdentifierGiven, new ExpressionIdentifier("GIVEN", FactMappingType.GIVEN));
        this.factMappingIndex = new FactMapping("EXPRESSION_ALIAS_INDEX", FactIdentifier.INDEX, ExpressionIdentifier.INDEX);
        this.simulation = this.getSimulation();
        this.scenarioGrid = (ScenarioGrid)Mockito.spy((Object)new ScenarioGrid(this.mockScenarioGridModel, this.mockScenarioGridLayer, this.mockScenarioGridRenderer, this.mockScenarioGridPanel){

            protected void appendRow(int rowIndex, Scenario scenario) {
            }

            protected ScenarioHeaderTextBoxSingletonDOMElementFactory getScenarioHeaderTextBoxSingletonDOMElementFactory() {
                return ScenarioGridTest.this.scenarioHeaderTextBoxSingletonDOMElementFactoryMock;
            }

            protected ScenarioSimulationBuilders.HeaderBuilder getHeaderBuilderLocal(String instanceTitle, String propertyTitle, String columnId, String columnGroup, FactMappingType factMappingType, ScenarioHeaderTextBoxSingletonDOMElementFactory factoryHeader) {
                return ScenarioGridTest.this.headerBuilderMock;
            }

            protected ScenarioGridColumn getScenarioGridColumnLocal(ScenarioSimulationBuilders.HeaderBuilder headerBuilder, String placeHolder) {
                return ScenarioGridTest.this.scenarioGridColumnMock;
            }
        });
    }

    @Test
    public void testDefaultNodeMouseClickHandlers() {
        List handlers = this.scenarioGrid.getNodeMouseClickEventHandlers((GridSelectionManager)this.mockScenarioGridLayer);
        Assert.assertEquals((long)1L, (long)handlers.size());
        Assert.assertTrue((boolean)(handlers.get(0) instanceof DefaultGridWidgetCellSelectorMouseEventHandler));
    }

    @Test
    public void testDefaultNodeMouseDoubleClickHandlers() {
        List handlers = this.scenarioGrid.getNodeMouseDoubleClickEventHandlers((GridSelectionManager)this.mockScenarioGridLayer, (GridPinnedModeManager)this.mockScenarioGridLayer);
        Assert.assertEquals((long)1L, (long)handlers.size());
        Assert.assertTrue((boolean)(handlers.get(0) instanceof ScenarioSimulationGridWidgetMouseEventHandler));
    }

    @Test
    public void setContent() {
        this.scenarioGrid.setContent(this.simulation);
        ((ScenarioGridModel)Mockito.verify((Object)this.mockScenarioGridModel, (VerificationMode)Mockito.times((int)1))).clear();
        ((ScenarioGridModel)Mockito.verify((Object)this.mockScenarioGridModel, (VerificationMode)Mockito.times((int)1))).bindContent((Simulation)Matchers.eq((Object)this.simulation));
        ((ScenarioGrid)Mockito.verify((Object)this.scenarioGrid, (VerificationMode)Mockito.times((int)1))).setHeaderColumns((Simulation)Matchers.eq((Object)this.simulation));
        ((ScenarioGrid)Mockito.verify((Object)this.scenarioGrid, (VerificationMode)Mockito.times((int)1))).appendRows((Simulation)Matchers.eq((Object)this.simulation));
    }

    @Test
    public void setHeaderColumns() {
        this.scenarioGrid.setHeaderColumns(this.simulation);
        ((ScenarioGrid)Mockito.verify((Object)this.scenarioGrid, (VerificationMode)Mockito.times((int)6))).setHeaderColumn(Matchers.anyInt(), (FactMapping)Matchers.isA(FactMapping.class));
    }

    @Test
    public void setHeaderColumn() {
        String columnId = this.factMappingDescription.getExpressionIdentifier().getName();
        FactMappingType type = this.factMappingDescription.getExpressionIdentifier().getType();
        String columnGroup = type.name();
        this.scenarioGrid.setHeaderColumn(1, this.factMappingDescription);
        ((ScenarioGrid)Mockito.verify((Object)this.scenarioGrid, (VerificationMode)Mockito.times((int)1))).isPropertyAssigned(Matchers.eq((boolean)true), (FactMapping)Matchers.eq((Object)this.factMappingDescription));
        ((ScenarioGrid)Mockito.verify((Object)this.scenarioGrid, (VerificationMode)Mockito.times((int)1))).getPlaceholder(Matchers.eq((boolean)true));
        ((ScenarioGrid)Mockito.verify((Object)this.scenarioGrid, (VerificationMode)Mockito.times((int)1))).getScenarioGridColumnLocal((String)Matchers.eq((Object)"EXPRESSION_ALIAS_DESCRIPTION"), (String)Matchers.any(), (String)Matchers.eq((Object)columnId), (String)Matchers.eq((Object)columnGroup), (FactMappingType)Matchers.eq((Object)type), (String)Matchers.eq((Object)ScenarioSimulationEditorConstants.INSTANCE.insertValue()));
        Mockito.reset((Object[])new ScenarioGrid[]{this.scenarioGrid});
        columnId = this.factMappingGiven.getExpressionIdentifier().getName();
        type = this.factMappingGiven.getExpressionIdentifier().getType();
        columnGroup = type.name();
        this.scenarioGrid.setHeaderColumn(1, this.factMappingGiven);
        ((ScenarioGrid)Mockito.verify((Object)this.scenarioGrid, (VerificationMode)Mockito.times((int)1))).isPropertyAssigned(Matchers.eq((boolean)true), (FactMapping)Matchers.eq((Object)this.factMappingGiven));
        ((ScenarioGrid)Mockito.verify((Object)this.scenarioGrid, (VerificationMode)Mockito.times((int)1))).getPlaceholder(Matchers.eq((boolean)false));
        ((ScenarioGrid)Mockito.verify((Object)this.scenarioGrid, (VerificationMode)Mockito.times((int)1))).getScenarioGridColumnLocal((String)Matchers.eq((Object)"EXPRESSION_ALIAS_GIVEN"), (String)Matchers.any(), (String)Matchers.eq((Object)columnId), (String)Matchers.eq((Object)columnGroup), (FactMappingType)Matchers.eq((Object)type), (String)Matchers.eq((Object)ScenarioSimulationEditorConstants.INSTANCE.defineValidType()));
    }

    @Test
    public void getScenarioGridColumnLocal() {
        String columnId = this.factMappingDescription.getExpressionIdentifier().getName();
        String instanceTitle = this.factMappingDescription.getFactIdentifier().getName();
        String propertyTitle = "PROPERTY TITLE";
        FactMappingType type = this.factMappingDescription.getExpressionIdentifier().getType();
        String columnGroup = type.name();
        this.scenarioGrid.getScenarioGridColumnLocal(instanceTitle, propertyTitle, columnId, columnGroup, type, ScenarioSimulationEditorConstants.INSTANCE.insertValue());
        ((ScenarioGrid)Mockito.verify((Object)this.scenarioGrid, (VerificationMode)Mockito.times((int)1))).getScenarioHeaderTextBoxSingletonDOMElementFactory();
        ((ScenarioGrid)Mockito.verify((Object)this.scenarioGrid, (VerificationMode)Mockito.times((int)1))).getHeaderBuilderLocal((String)Matchers.eq((Object)instanceTitle), (String)Matchers.eq((Object)propertyTitle), (String)Matchers.eq((Object)columnId), (String)Matchers.eq((Object)columnGroup), (FactMappingType)Matchers.eq((Object)type), (ScenarioHeaderTextBoxSingletonDOMElementFactory)Matchers.eq((Object)this.scenarioHeaderTextBoxSingletonDOMElementFactoryMock));
    }

    @Test
    public void isInstanceAssigned() {
        Assert.assertTrue((boolean)this.scenarioGrid.isInstanceAssigned(FactIdentifier.DESCRIPTION));
        Assert.assertFalse((boolean)this.scenarioGrid.isInstanceAssigned(FactIdentifier.INDEX));
        Assert.assertFalse((boolean)this.scenarioGrid.isInstanceAssigned(FactIdentifier.EMPTY));
        Assert.assertTrue((boolean)this.scenarioGrid.isInstanceAssigned(this.factIdentifierGiven));
    }

    @Test
    public void isPropertyAssigned() {
        this.factMappingDescription.getExpressionElements().clear();
        Assert.assertTrue((boolean)this.scenarioGrid.isPropertyAssigned(false, this.factMappingDescription));
        Assert.assertTrue((boolean)this.scenarioGrid.isPropertyAssigned(true, this.factMappingDescription));
        this.factMappingDescription.getExpressionElements().add(new ExpressionElement("test"));
        Assert.assertTrue((boolean)this.scenarioGrid.isPropertyAssigned(false, this.factMappingDescription));
        Assert.assertTrue((boolean)this.scenarioGrid.isPropertyAssigned(true, this.factMappingDescription));
        this.factMappingGiven.getExpressionElements().clear();
        Assert.assertFalse((boolean)this.scenarioGrid.isPropertyAssigned(false, this.factMappingGiven));
        Assert.assertFalse((boolean)this.scenarioGrid.isPropertyAssigned(true, this.factMappingGiven));
        this.factMappingGiven.getExpressionElements().add(new ExpressionElement("test"));
        Assert.assertFalse((boolean)this.scenarioGrid.isPropertyAssigned(false, this.factMappingGiven));
        Assert.assertTrue((boolean)this.scenarioGrid.isPropertyAssigned(true, this.factMappingGiven));
    }

    @Test
    public void getPlaceholder() {
        Assert.assertEquals((Object)ScenarioSimulationEditorConstants.INSTANCE.insertValue(), (Object)this.scenarioGrid.getPlaceholder(true));
        Assert.assertEquals((Object)ScenarioSimulationEditorConstants.INSTANCE.defineValidType(), (Object)this.scenarioGrid.getPlaceholder(false));
    }

    @Test
    public void appendRows() {
        this.scenarioGrid.appendRows(this.simulation);
        ((ScenarioGrid)Mockito.verify((Object)this.scenarioGrid, (VerificationMode)Mockito.times((int)1))).appendRow(Matchers.anyInt(), (Scenario)Matchers.isA(Scenario.class));
    }

    private Simulation getSimulation() {
        Simulation toReturn = new Simulation();
        SimulationDescriptor simulationDescriptor = toReturn.getSimulationDescriptor();
        simulationDescriptor.addFactMapping(FactIdentifier.INDEX.getName(), FactIdentifier.INDEX, ExpressionIdentifier.INDEX);
        simulationDescriptor.addFactMapping(FactIdentifier.DESCRIPTION.getName(), FactIdentifier.DESCRIPTION, ExpressionIdentifier.DESCRIPTION);
        Scenario scenario = toReturn.addScenario();
        int row = toReturn.getUnmodifiableScenarios().indexOf(scenario);
        scenario.setDescription(null);
        IntStream.range(2, 4).forEach(id -> {
            ExpressionIdentifier givenExpression = ExpressionIdentifier.create((String)(row + "|" + id), (FactMappingType)FactMappingType.GIVEN);
            simulationDescriptor.addFactMapping(FactMapping.getInstancePlaceHolder((int)id), FactIdentifier.EMPTY, givenExpression);
            scenario.addMappingValue(FactIdentifier.EMPTY, givenExpression, null);
        });
        IntStream.range(2, 4).forEach(id -> {
            ExpressionIdentifier expectedExpression = ExpressionIdentifier.create((String)(row + "|" + (id += 2)), (FactMappingType)FactMappingType.EXPECT);
            simulationDescriptor.addFactMapping(FactMapping.getInstancePlaceHolder((int)id), FactIdentifier.EMPTY, expectedExpression);
            scenario.addMappingValue(FactIdentifier.EMPTY, expectedExpression, null);
        });
        return toReturn;
    }
}

