/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.commands;

import java.util.stream.IntStream;
import javax.enterprise.context.Dependent;
import org.drools.workbench.screens.scenariosimulation.client.commands.AbstractCommand;
import org.drools.workbench.screens.scenariosimulation.client.models.ScenarioGridModel;
import org.drools.workbench.screens.scenariosimulation.client.resources.i18n.ScenarioSimulationEditorConstants;
import org.drools.workbench.screens.scenariosimulation.client.utils.ScenarioSimulationUtils;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGridColumn;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGridLayer;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGridPanel;
import org.drools.workbench.screens.scenariosimulation.model.FactIdentifier;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridData;

@Dependent
public class SetPropertyHeaderCommand
extends AbstractCommand {
    private ScenarioGridModel model;
    private String fullPackage;
    private String value;
    private String valueClassName;
    protected boolean keepData;

    public SetPropertyHeaderCommand() {
    }

    public SetPropertyHeaderCommand(ScenarioGridModel model, String fullPackage, String value, String valueClassName, ScenarioGridPanel scenarioGridPanel, ScenarioGridLayer scenarioGridLayer, boolean keepData) {
        super(scenarioGridPanel, scenarioGridLayer);
        this.model = model;
        this.fullPackage = fullPackage;
        this.value = value;
        this.valueClassName = valueClassName;
        this.keepData = keepData;
    }

    public void execute() {
        ScenarioGridColumn selectedColumn = (ScenarioGridColumn)this.model.getSelectedColumn();
        if (selectedColumn == null) {
            return;
        }
        int columnIndex = this.model.getColumns().indexOf((Object)selectedColumn);
        String title = this.value.substring(this.value.indexOf(".") + 1);
        String className = this.value.split("\\.")[0];
        if (!this.fullPackage.endsWith(".")) {
            this.fullPackage = this.fullPackage + ".";
        }
        String canonicalClassName = this.fullPackage + className;
        FactIdentifier factIdentifier = this.getFactIdentifierByColumnTitle(className).orElse(FactIdentifier.create((String)selectedColumn.getInformationHeaderMetaData().getColumnId(), (String)canonicalClassName));
        GridData.Range instanceLimits = this.model.getInstanceLimits(columnIndex);
        IntStream.range(instanceLimits.getMinRowIndex(), instanceLimits.getMaxRowIndex() + 1).forEach(index -> {
            ScenarioGridColumn scenarioGridColumn = (ScenarioGridColumn)((Object)((Object)this.model.getColumns().get(index)));
            if (!scenarioGridColumn.isInstanceAssigned()) {
                scenarioGridColumn.getInformationHeaderMetaData().setTitle(className);
                scenarioGridColumn.setInstanceAssigned(true);
                scenarioGridColumn.setFactIdentifier(factIdentifier);
            }
        });
        String placeHolder = ScenarioSimulationEditorConstants.INSTANCE.insertValue();
        selectedColumn.setPlaceHolder(placeHolder);
        selectedColumn.getPropertyHeaderMetaData().setColumnGroup(ScenarioSimulationUtils.getPropertyMetaDataGroup(selectedColumn.getInformationHeaderMetaData().getColumnGroup()));
        selectedColumn.getPropertyHeaderMetaData().setTitle(title);
        selectedColumn.getPropertyHeaderMetaData().setReadOnly(false);
        selectedColumn.setPropertyAssigned(true);
        this.model.updateColumnProperty(columnIndex, (GridColumn<?>)selectedColumn, this.value, this.valueClassName, this.keepData);
    }
}

