/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.editor;

import com.google.gwt.event.shared.EventBus;
import com.google.gwt.user.client.ui.IsWidget;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Optional;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Supplier;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.drools.workbench.screens.scenariosimulation.client.commands.CommandExecutor;
import org.drools.workbench.screens.scenariosimulation.client.editor.ScenarioSimulationView;
import org.drools.workbench.screens.scenariosimulation.client.handlers.ScenarioSimulationDocksHandler;
import org.drools.workbench.screens.scenariosimulation.client.models.FactModelTree;
import org.drools.workbench.screens.scenariosimulation.client.producers.ScenarioSimulationProducer;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.RightPanelView;
import org.drools.workbench.screens.scenariosimulation.client.type.ScenarioSimulationResourceType;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGridPanel;
import org.drools.workbench.screens.scenariosimulation.model.ScenarioSimulationModel;
import org.drools.workbench.screens.scenariosimulation.model.ScenarioSimulationModelContent;
import org.drools.workbench.screens.scenariosimulation.model.SimulationDescriptor;
import org.drools.workbench.screens.scenariosimulation.service.ScenarioSimulationService;
import org.guvnor.common.services.shared.metadata.model.Metadata;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jboss.errai.enterprise.client.jaxrs.MarshallingWrapper;
import org.kie.soup.project.datamodel.imports.HasImports;
import org.kie.soup.project.datamodel.oracle.ModelField;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracle;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracleFactory;
import org.kie.workbench.common.widgets.client.menu.FileMenuBuilder;
import org.kie.workbench.common.widgets.configresource.client.widget.bound.ImportsWidgetPresenter;
import org.kie.workbench.common.widgets.metadata.client.KieEditor;
import org.kie.workbench.common.widgets.metadata.client.KieEditorView;
import org.kie.workbench.common.workbench.client.test.TestRunnerReportingScreen;
import org.uberfire.backend.vfs.ObservablePath;
import org.uberfire.backend.vfs.Path;
import org.uberfire.client.annotations.WorkbenchEditor;
import org.uberfire.client.annotations.WorkbenchMenu;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartTitleDecoration;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.callbacks.Callback;
import org.uberfire.client.mvp.AbstractWorkbenchActivity;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.mvp.PlaceStatus;
import org.uberfire.client.workbench.events.PlaceGainFocusEvent;
import org.uberfire.client.workbench.events.PlaceHiddenEvent;
import org.uberfire.client.workbench.type.ClientResourceType;
import org.uberfire.ext.editor.commons.service.support.SupportsCopy;
import org.uberfire.ext.editor.commons.service.support.SupportsDelete;
import org.uberfire.ext.editor.commons.service.support.SupportsRename;
import org.uberfire.ext.editor.commons.service.support.SupportsSaveAndRename;
import org.uberfire.ext.widgets.common.client.callbacks.HasBusyIndicatorDefaultErrorCallback;
import org.uberfire.ext.widgets.common.client.common.HasBusyIndicator;
import org.uberfire.lifecycle.OnClose;
import org.uberfire.lifecycle.OnMayClose;
import org.uberfire.lifecycle.OnStartup;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;
import org.uberfire.mvp.impl.PathPlaceRequest;
import org.uberfire.workbench.model.menu.Menus;

@Dependent
@WorkbenchEditor(identifier="ScenarioSimulationEditor", supportedTypes={ScenarioSimulationResourceType.class})
public class ScenarioSimulationEditorPresenter
extends KieEditor<ScenarioSimulationModel> {
    public static final String IDENTIFIER = "ScenarioSimulationEditor";
    protected AsyncPackageDataModelOracle oracle;
    protected String packageName = "";
    protected PlaceRequest rightPanelRequest;
    protected ObservablePath path;
    protected EventBus eventBus;
    protected ScenarioGridPanel scenarioGridPanel;
    private ImportsWidgetPresenter importsWidget;
    private AsyncPackageDataModelOracleFactory oracleFactory;
    private ScenarioSimulationModel model;
    private Caller<ScenarioSimulationService> service;
    private ScenarioSimulationResourceType type;
    private ScenarioSimulationView view;
    private CommandExecutor commandExecutor;
    private Command populateRightPanelCommand;
    private TestRunnerReportingScreen testRunnerReportingScreen;
    private ScenarioSimulationDocksHandler scenarioSimulationDocksHandler;

    public ScenarioSimulationEditorPresenter() {
    }

    @Inject
    public ScenarioSimulationEditorPresenter(Caller<ScenarioSimulationService> service, ScenarioSimulationProducer scenarioSimulationProducer, ScenarioSimulationResourceType type, ImportsWidgetPresenter importsWidget, AsyncPackageDataModelOracleFactory oracleFactory, PlaceManager placeManager, TestRunnerReportingScreen testRunnerReportingScreen, ScenarioSimulationDocksHandler scenarioSimulationDocksHandler) {
        super((KieEditorView)scenarioSimulationProducer.getScenarioSimulationView());
        this.testRunnerReportingScreen = testRunnerReportingScreen;
        this.scenarioSimulationDocksHandler = scenarioSimulationDocksHandler;
        this.view = (ScenarioSimulationView)this.baseView;
        this.service = service;
        this.type = type;
        this.importsWidget = importsWidget;
        this.oracleFactory = oracleFactory;
        this.placeManager = placeManager;
        this.commandExecutor = scenarioSimulationProducer.getCommandExecutor();
        this.eventBus = scenarioSimulationProducer.getEventBus();
        this.scenarioGridPanel = this.view.getScenarioGridPanel();
        this.commandExecutor.setScenarioGridPanel(this.scenarioGridPanel);
        this.commandExecutor.setScenarioSimulationEditorPresenter(this);
        this.view.init(this);
        this.populateRightPanelCommand = this.getPopulateRightPanelCommand();
        this.scenarioGridPanel.select();
    }

    @OnStartup
    public void onStartup(ObservablePath path, PlaceRequest place) {
        super.init(path, place, (ClientResourceType)this.type);
        this.path = path;
    }

    @OnClose
    public void onClose() {
        this.versionRecordManager.clear();
        this.scenarioGridPanel.unregister();
    }

    @OnMayClose
    public boolean mayClose() {
        return !this.isDirty();
    }

    @WorkbenchPartTitle
    public String getTitleText() {
        return super.getTitleText();
    }

    @WorkbenchPartTitleDecoration
    public IsWidget getTitle() {
        return super.getTitle();
    }

    @WorkbenchPartView
    public IsWidget getWidget() {
        return super.getWidget();
    }

    @WorkbenchMenu
    public Menus getMenus() {
        return this.menus;
    }

    public void onPlaceGainFocusEvent(@Observes PlaceGainFocusEvent placeGainFocusEvent) {
        if (!(placeGainFocusEvent.getPlace() instanceof PathPlaceRequest)) {
            return;
        }
        PathPlaceRequest placeRequest = (PathPlaceRequest)placeGainFocusEvent.getPlace();
        if (placeRequest.getIdentifier().equals(IDENTIFIER) && placeRequest.getPath().equals(this.path)) {
            this.scenarioSimulationDocksHandler.addDocks();
            this.expandToolsDock();
            this.registerRightPanelCallback();
            this.populateRightPanel();
        }
    }

    public void onPlaceHiddenEvent(@Observes PlaceHiddenEvent placeHiddenEvent) {
        if (!(placeHiddenEvent.getPlace() instanceof PathPlaceRequest)) {
            return;
        }
        PathPlaceRequest placeRequest = (PathPlaceRequest)placeHiddenEvent.getPlace();
        if (placeRequest.getIdentifier().equals(IDENTIFIER) && placeRequest.getPath().equals(this.path)) {
            this.scenarioSimulationDocksHandler.removeDocks();
            this.view.getScenarioGridLayer().getScenarioGrid().clearSelections();
            this.unRegisterRightPanelCallback();
            this.clearRightPanelStatus();
            this.testRunnerReportingScreen.reset();
        }
    }

    public void expandToolsDock() {
        this.scenarioSimulationDocksHandler.expandToolsDock();
    }

    public ScenarioSimulationView getView() {
        return this.view;
    }

    public ScenarioSimulationModel getModel() {
        return this.model;
    }

    public void reloadRightPanel(boolean disable) {
        this.populateRightPanelCommand.execute();
        if (disable) {
            this.getRightPanelPresenter().ifPresent(RightPanelView.Presenter::onDisableEditorTab);
        }
    }

    public void onRunScenario() {
        this.view.getScenarioGridPanel().getScenarioGrid().getModel().resetErrors();
        ((ScenarioSimulationService)this.service.call(this.refreshModel())).runScenario((Path)this.versionRecordManager.getCurrentPath(), this.model);
    }

    RemoteCallback<ScenarioSimulationModel> refreshModel() {
        return newModel -> {
            this.model = newModel;
            this.view.refreshContent(newModel.getSimulation());
            this.scenarioSimulationDocksHandler.expandTestResultsDock();
        };
    }

    protected void registerRightPanelCallback() {
        this.placeManager.registerOnOpenCallback((PlaceRequest)new DefaultPlaceRequest("org.drools.scenariosimulation.RightPanel"), this.populateRightPanelCommand);
    }

    protected void unRegisterRightPanelCallback() {
        this.placeManager.getOnOpenCallbacks((PlaceRequest)new DefaultPlaceRequest("org.drools.scenariosimulation.RightPanel")).remove(this.populateRightPanelCommand);
    }

    protected void makeMenuBar() {
        this.fileMenuBuilder.addNewTopLevelMenu(this.view.getRunScenarioMenuItem());
        super.makeMenuBar();
    }

    protected Supplier<ScenarioSimulationModel> getContentSupplier() {
        return () -> this.model;
    }

    protected void save(String commitMessage) {
        ((ScenarioSimulationService)this.service.call(this.getSaveSuccessCallback(this.getJsonModel(this.model).hashCode()), (ErrorCallback)new HasBusyIndicatorDefaultErrorCallback((HasBusyIndicator)this.baseView))).save((Path)this.versionRecordManager.getCurrentPath(), (Object)this.model, (Object)this.metadata, commitMessage);
    }

    protected void addCommonActions(FileMenuBuilder fileMenuBuilder) {
        fileMenuBuilder.addNewTopLevelMenu(this.versionRecordManager.buildMenu()).addNewTopLevelMenu(this.alertsButtonMenuItemBuilder.build());
    }

    protected void loadContent() {
        ((ScenarioSimulationService)this.service.call(this.getModelSuccessCallback(), (ErrorCallback)this.getNoSuchFileExceptionErrorCallback())).loadContent((Path)this.versionRecordManager.getCurrentPath());
    }

    void populateRightPanel() {
        this.getRightPanelPresenter().ifPresent(presenter -> {
            this.commandExecutor.setRightPanelPresenter((RightPanelView.Presenter)presenter);
            presenter.setEventBus(this.eventBus);
            this.populateRightPanel((RightPanelView.Presenter)presenter);
        });
    }

    void populateRightPanel(RightPanelView.Presenter rightPanelPresenter) {
        TreeMap<String, FactModelTree> factTypeFieldsMap = new TreeMap<String, FactModelTree>();
        if (this.oracle == null) {
            if (rightPanelPresenter != null) {
                rightPanelPresenter.setDataObjectFieldsMap(factTypeFieldsMap);
            }
            return;
        }
        String[] factTypes = this.oracle.getFactTypes();
        if (factTypes.length == 0) {
            if (rightPanelPresenter != null) {
                rightPanelPresenter.setDataObjectFieldsMap(factTypeFieldsMap);
            }
            return;
        }
        Callback<FactModelTree> aggregatorCallback = this.aggregatorCallback(rightPanelPresenter, factTypes.length, factTypeFieldsMap);
        for (String factType : factTypes) {
            this.oracle.getFieldCompletions(factType, this.fieldCompletionsCallback(factType, aggregatorCallback));
        }
    }

    void clearRightPanelStatus() {
        this.getRightPanelPresenter().ifPresent(RightPanelView.Presenter::onClearStatus);
    }

    String getJsonModel(ScenarioSimulationModel model) {
        return MarshallingWrapper.toJSON((Object)model);
    }

    protected Callback<ModelField[]> fieldCompletionsCallback(String factName, Callback<FactModelTree> aggregatorCallback) {
        return result -> {
            FactModelTree toSend = this.getFactModelTree(factName, (ModelField[])result);
            aggregatorCallback.callback((Object)toSend);
        };
    }

    protected FactModelTree getFactModelTree(String factName, ModelField[] modelFields) {
        HashMap<String, String> simpleProperties = new HashMap<String, String>();
        for (ModelField modelField : modelFields) {
            if (modelField.getName().equals("this")) continue;
            simpleProperties.put(modelField.getName(), modelField.getClassName());
        }
        String factPackageName = this.packageName;
        String fullFactClassName = this.oracle.getFQCNByFactName(factName);
        if (fullFactClassName != null && fullFactClassName.contains(".")) {
            factPackageName = fullFactClassName.substring(0, fullFactClassName.lastIndexOf("."));
        }
        return new FactModelTree(factName, factPackageName, simpleProperties);
    }

    private RemoteCallback<ScenarioSimulationModelContent> getModelSuccessCallback() {
        return content -> {
            if (this.versionRecordManager.getCurrentPath() == null) {
                return;
            }
            this.packageName = content.getDataModel().getPackageName();
            this.resetEditorPages(content.getOverview());
            this.model = content.getModel();
            this.oracle = this.oracleFactory.makeAsyncPackageDataModelOracle((Path)this.versionRecordManager.getCurrentPath(), (HasImports)this.model, content.getDataModel());
            this.populateRightPanel();
            this.importsWidget.setContent(this.oracle, this.model.getImports(), this.isReadOnly);
            this.addImportsTab((IsWidget)this.importsWidget);
            this.baseView.hideBusyIndicator();
            this.view.setContent(this.model.getSimulation());
            this.setOriginalHash(this.getJsonModel(this.model).hashCode());
        };
    }

    private Callback<FactModelTree> aggregatorCallback(RightPanelView.Presenter rightPanelPresenter, int expectedElements, SortedMap<String, FactModelTree> factTypeFieldsMap) {
        return result -> {
            factTypeFieldsMap.put(result.getFactName(), (FactModelTree)result);
            if (factTypeFieldsMap.size() == expectedElements) {
                factTypeFieldsMap.values().forEach(factModelTree -> this.populateFactModel((FactModelTree)factModelTree, factTypeFieldsMap));
                rightPanelPresenter.setDataObjectFieldsMap(factTypeFieldsMap);
                TreeMap<String, FactModelTree> instanceFieldsMap = new TreeMap<String, FactModelTree>();
                if (this.model != null) {
                    SimulationDescriptor simulationDescriptor = this.model.getSimulation().getSimulationDescriptor();
                    simulationDescriptor.getUnmodifiableFactMappings().forEach(factMapping -> {
                        FactModelTree factModelTree;
                        String instanceName;
                        String dataObjectName = factMapping.getFactIdentifier().getClassName();
                        if (dataObjectName.contains(".")) {
                            dataObjectName = dataObjectName.substring(dataObjectName.lastIndexOf(".") + 1);
                        }
                        if (!(instanceName = factMapping.getFactAlias()).equals(dataObjectName) && (factModelTree = (FactModelTree)factTypeFieldsMap.get(dataObjectName)) != null) {
                            instanceFieldsMap.put(instanceName, factModelTree);
                        }
                    });
                }
                rightPanelPresenter.setInstanceFieldsMap(instanceFieldsMap);
                HashSet<String> dataObjectsInstancesName = new HashSet<String>(factTypeFieldsMap.keySet());
                dataObjectsInstancesName.addAll(instanceFieldsMap.keySet());
                this.scenarioGridPanel.getScenarioGrid().getModel().setDataObjectsInstancesName(dataObjectsInstancesName);
            }
        };
    }

    private void populateFactModel(FactModelTree toPopulate, SortedMap<String, FactModelTree> factTypeFieldsMap) {
        ArrayList toRemove = new ArrayList();
        toPopulate.getSimpleProperties().forEach((key, value) -> {
            if (factTypeFieldsMap.containsKey(value)) {
                toRemove.add(key);
                toPopulate.addExpandableProperty((String)key, ((FactModelTree)factTypeFieldsMap.get(value)).getFactName());
            }
        });
        toRemove.forEach(toPopulate::removeSimpleProperty);
    }

    private Optional<RightPanelView> getRightPanelView() {
        DefaultPlaceRequest placeRequest = new DefaultPlaceRequest("org.drools.scenariosimulation.RightPanel");
        if (PlaceStatus.OPEN.equals((Object)this.placeManager.getStatus((PlaceRequest)placeRequest))) {
            AbstractWorkbenchActivity rightPanelActivity = (AbstractWorkbenchActivity)this.placeManager.getActivity((PlaceRequest)placeRequest);
            return Optional.of((RightPanelView)rightPanelActivity.getWidget());
        }
        return Optional.empty();
    }

    private Optional<RightPanelView.Presenter> getRightPanelPresenter() {
        return this.getRightPanelView().isPresent() ? Optional.of(this.getRightPanelView().get().getPresenter()) : Optional.empty();
    }

    private Command getPopulateRightPanelCommand() {
        return this::populateRightPanel;
    }

    boolean isDirty() {
        try {
            this.view.getScenarioGridPanel().getScenarioGrid().getModel().resetErrors();
            int currentHashcode = MarshallingWrapper.toJSON((Object)this.model).hashCode();
            return this.originalHash != currentHashcode;
        }
        catch (Exception ignored) {
            return false;
        }
    }

    protected Caller<? extends SupportsDelete> getDeleteServiceCaller() {
        return this.service;
    }

    protected Caller<? extends SupportsRename> getRenameServiceCaller() {
        return this.service;
    }

    protected Caller<? extends SupportsCopy> getCopyServiceCaller() {
        return this.service;
    }

    protected Caller<? extends SupportsSaveAndRename<ScenarioSimulationModel, Metadata>> getSaveAndRenameServiceCaller() {
        return this.service;
    }
}

