/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.handlers;

import com.ait.lienzo.client.core.types.Point2D;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.NativeEvent;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.ContextMenuEvent;
import com.google.gwt.event.dom.client.ContextMenuHandler;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.GwtEvent;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.enterprise.context.Dependent;
import org.drools.workbench.screens.scenariosimulation.client.editor.menu.AbstractHeaderMenuPresenter;
import org.drools.workbench.screens.scenariosimulation.client.editor.menu.BaseMenu;
import org.drools.workbench.screens.scenariosimulation.client.editor.menu.ExpectedContextMenu;
import org.drools.workbench.screens.scenariosimulation.client.editor.menu.GivenContextMenu;
import org.drools.workbench.screens.scenariosimulation.client.editor.menu.GridContextMenu;
import org.drools.workbench.screens.scenariosimulation.client.editor.menu.HeaderExpectedContextMenu;
import org.drools.workbench.screens.scenariosimulation.client.editor.menu.HeaderGivenContextMenu;
import org.drools.workbench.screens.scenariosimulation.client.editor.menu.OtherContextMenu;
import org.drools.workbench.screens.scenariosimulation.client.editor.menu.UnmodifiableColumnGridContextMenu;
import org.drools.workbench.screens.scenariosimulation.client.events.EnableRightPanelEvent;
import org.drools.workbench.screens.scenariosimulation.client.events.ReloadRightPanelEvent;
import org.drools.workbench.screens.scenariosimulation.client.metadata.ScenarioHeaderMetaData;
import org.drools.workbench.screens.scenariosimulation.client.models.ScenarioGridModel;
import org.drools.workbench.screens.scenariosimulation.client.utils.ScenarioSimulationGridHeaderUtilities;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGrid;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGridCell;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGridColumn;
import org.drools.workbench.screens.scenariosimulation.model.ExpressionElement;
import org.drools.workbench.screens.scenariosimulation.model.Simulation;
import org.uberfire.ext.wires.core.grids.client.model.GridCell;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.util.CoordinateUtilities;
import org.uberfire.ext.wires.core.grids.client.widget.context.GridBodyCellEditContext;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.impl.BaseGridRendererHelper;

@Dependent
public class ScenarioSimulationGridPanelClickHandler
implements ClickHandler,
ContextMenuHandler {
    ScenarioGrid scenarioGrid;
    OtherContextMenu otherContextMenu;
    HeaderGivenContextMenu headerGivenContextMenu;
    HeaderExpectedContextMenu headerExpectedContextMenu;
    GivenContextMenu givenContextMenu;
    ExpectedContextMenu expectedContextMenu;
    GridContextMenu gridContextMenu;
    UnmodifiableColumnGridContextMenu unmodifiableColumnGridContextMenu;
    Set<AbstractHeaderMenuPresenter> managedMenus = new HashSet<AbstractHeaderMenuPresenter>();
    EventBus eventBus;
    AtomicInteger clickReceived = new AtomicInteger(0);
    BaseGridRendererHelper rendererHelper;

    public void setScenarioGrid(ScenarioGrid scenarioGrid) {
        this.scenarioGrid = scenarioGrid;
        this.rendererHelper = scenarioGrid.getRendererHelper();
    }

    public void setOtherContextMenu(OtherContextMenu otherContextMenu) {
        this.otherContextMenu = otherContextMenu;
        this.managedMenus.add(otherContextMenu);
    }

    public void setHeaderGivenContextMenu(HeaderGivenContextMenu headerGivenContextMenu) {
        this.headerGivenContextMenu = headerGivenContextMenu;
        this.managedMenus.add(headerGivenContextMenu);
    }

    public void setHeaderExpectedContextMenu(HeaderExpectedContextMenu headerExpectedContextMenu) {
        this.headerExpectedContextMenu = headerExpectedContextMenu;
        this.managedMenus.add(headerExpectedContextMenu);
    }

    public void setGivenContextMenu(GivenContextMenu givenContextMenu) {
        this.givenContextMenu = givenContextMenu;
        this.managedMenus.add(givenContextMenu);
    }

    public void setExpectedContextMenu(ExpectedContextMenu expectedContextMenu) {
        this.expectedContextMenu = expectedContextMenu;
        this.managedMenus.add(expectedContextMenu);
    }

    public void setGridContextMenu(GridContextMenu gridContextMenu) {
        this.gridContextMenu = gridContextMenu;
        this.managedMenus.add(gridContextMenu);
    }

    public void setUnmodifiableColumnGridContextMenu(UnmodifiableColumnGridContextMenu unmodifiableColumnGridContextMenu) {
        this.unmodifiableColumnGridContextMenu = unmodifiableColumnGridContextMenu;
        this.managedMenus.add(unmodifiableColumnGridContextMenu);
    }

    public void setEventBus(EventBus eventBus) {
        this.eventBus = eventBus;
        this.managedMenus.forEach(menu -> menu.setEventBus(eventBus));
    }

    public void onClick(ClickEvent event) {
        this.clickReceived.getAndIncrement();
        int canvasX = this.getRelativeX(event);
        int canvasY = this.getRelativeY(event);
        boolean isShiftKeyDown = event.getNativeEvent().getShiftKey();
        boolean isControlKeyDown = event.getNativeEvent().getCtrlKey();
        this.hideMenus();
        this.scenarioGrid.clearSelections();
        if (!this.manageLeftClick(canvasX, canvasY, isShiftKeyDown, isControlKeyDown)) {
            this.eventBus.fireEvent((GwtEvent)new ReloadRightPanelEvent(true));
        }
    }

    public void onContextMenu(ContextMenuEvent event) {
        this.hideMenus();
        if (this.manageRightClick(event)) {
            event.preventDefault();
            event.stopPropagation();
        }
    }

    protected boolean manageRightClick(ContextMenuEvent event) {
        int canvasX = this.getRelativeX(event);
        int canvasY = this.getRelativeY(event);
        boolean isShiftKeyDown = event.getNativeEvent().getShiftKey();
        boolean isControlKeyDown = event.getNativeEvent().getCtrlKey();
        Point2D ap = CoordinateUtilities.convertDOMToGridCoordinate((GridWidget)this.scenarioGrid, (Point2D)new Point2D((double)canvasX, (double)canvasY));
        Integer uiColumnIndex = CoordinateUtilities.getUiColumnIndex((GridWidget)this.scenarioGrid, (double)ap.getX());
        if (uiColumnIndex == null) {
            return false;
        }
        if (!this.manageHeaderRightClick(this.scenarioGrid, event.getNativeEvent().getClientX(), event.getNativeEvent().getClientY(), ap.getY(), uiColumnIndex)) {
            return this.manageBodyRightClick(this.scenarioGrid, event.getNativeEvent().getClientX(), event.getNativeEvent().getClientY(), ap.getY(), uiColumnIndex, isShiftKeyDown, isControlKeyDown);
        }
        return true;
    }

    protected int getRelativeX(ContextMenuEvent event) {
        NativeEvent e = event.getNativeEvent();
        Element target = event.getRelativeElement();
        return e.getClientX() - target.getAbsoluteLeft() + target.getScrollLeft() + target.getOwnerDocument().getScrollLeft();
    }

    protected int getRelativeY(ContextMenuEvent event) {
        NativeEvent e = event.getNativeEvent();
        Element target = event.getRelativeElement();
        return e.getClientY() - target.getAbsoluteTop() + target.getScrollTop() + target.getOwnerDocument().getScrollTop();
    }

    protected int getRelativeX(ClickEvent event) {
        NativeEvent e = event.getNativeEvent();
        Element target = event.getRelativeElement();
        return e.getClientX() - target.getAbsoluteLeft() + target.getScrollLeft() + target.getOwnerDocument().getScrollLeft();
    }

    protected int getRelativeY(ClickEvent event) {
        NativeEvent e = event.getNativeEvent();
        Element target = event.getRelativeElement();
        return e.getClientY() - target.getAbsoluteTop() + target.getScrollTop() + target.getOwnerDocument().getScrollTop();
    }

    public void hideMenus() {
        this.managedMenus.forEach(BaseMenu::hide);
    }

    protected boolean manageHeaderRightClick(ScenarioGrid scenarioGrid, int left, int top, double gridY, Integer uiColumnIndex) {
        GridColumn scenarioGridColumn = (GridColumn)scenarioGrid.getModel().getColumns().get(uiColumnIndex);
        ScenarioHeaderMetaData columnMetadata = this.getColumnScenarioHeaderMetaDataLocal(scenarioGrid, scenarioGridColumn, gridY);
        if (columnMetadata == null) {
            return false;
        }
        Integer uiHeaderRowIndex = this.getUiHeaderRowIndexLocal(scenarioGrid, scenarioGridColumn, gridY);
        if (uiHeaderRowIndex == null) {
            return false;
        }
        String group = columnMetadata.getColumnGroup();
        if (group.contains("-")) {
            group = group.substring(0, group.indexOf("-"));
        }
        block5 : switch (group) {
            case "": {
                switch (columnMetadata.getTitle()) {
                    case "GIVEN": {
                        this.headerGivenContextMenu.show(left, top);
                        break block5;
                    }
                    case "EXPECT": {
                        this.headerExpectedContextMenu.show(left, top);
                        break block5;
                    }
                }
                this.otherContextMenu.show(left, top);
                break;
            }
            case "GIVEN": {
                this.givenContextMenu.show(left, top, uiColumnIndex, group, columnMetadata.isPropertyHeader());
                break;
            }
            case "EXPECT": {
                this.expectedContextMenu.show(left, top, uiColumnIndex, group, columnMetadata.isPropertyHeader());
                break;
            }
            default: {
                this.otherContextMenu.show(left, top);
            }
        }
        scenarioGrid.setSelectedColumnAndHeader(uiHeaderRowIndex, uiColumnIndex);
        return true;
    }

    protected boolean manageBodyRightClick(ScenarioGrid scenarioGrid, int left, int top, double gridY, Integer uiColumnIndex, boolean isShiftKeyDown, boolean isControlKeyDown) {
        String group;
        scenarioGrid.deselect();
        Integer uiRowIndex = CoordinateUtilities.getUiRowIndex((GridWidget)scenarioGrid, (double)gridY);
        if (uiRowIndex == null) {
            return false;
        }
        ScenarioGridColumn scenarioGridColumn = (ScenarioGridColumn)((Object)scenarioGrid.getModel().getColumns().get(uiColumnIndex));
        if (scenarioGridColumn == null) {
            return false;
        }
        switch (group = scenarioGridColumn.getInformationHeaderMetaData().getColumnGroup()) {
            case "GIVEN": 
            case "EXPECT": {
                this.gridContextMenu.show(left, top, uiColumnIndex, uiRowIndex, group, true);
                break;
            }
            default: {
                this.unmodifiableColumnGridContextMenu.show(left, top, uiRowIndex);
            }
        }
        return true;
    }

    protected boolean manageLeftClick(int canvasX, int canvasY, boolean isShiftKeyDown, boolean isControlKeyDown) {
        Point2D ap = CoordinateUtilities.convertDOMToGridCoordinate((GridWidget)this.scenarioGrid, (Point2D)new Point2D((double)canvasX, (double)canvasY));
        Integer uiColumnIndex = CoordinateUtilities.getUiColumnIndex((GridWidget)this.scenarioGrid, (double)ap.getX());
        if (uiColumnIndex == null) {
            return false;
        }
        ScenarioGridColumn scenarioGridColumn = (ScenarioGridColumn)((Object)this.scenarioGrid.getModel().getColumns().get(uiColumnIndex));
        if (scenarioGridColumn == null) {
            return false;
        }
        if (!this.manageHeaderLeftClick(this.scenarioGrid, uiColumnIndex, scenarioGridColumn, ap)) {
            Integer uiRowIndex = CoordinateUtilities.getUiRowIndex((GridWidget)this.scenarioGrid, (double)ap.getY());
            if (uiRowIndex == null) {
                return false;
            }
            return this.manageGridLeftClick(this.scenarioGrid, uiRowIndex, uiColumnIndex, scenarioGridColumn);
        }
        return true;
    }

    protected boolean manageHeaderLeftClick(ScenarioGrid scenarioGrid, Integer uiColumnIndex, ScenarioGridColumn scenarioGridColumn, Point2D rp) {
        double gridY = rp.getY();
        if (!this.hasEditableHeaderLocal((GridColumn<?>)scenarioGridColumn)) {
            return false;
        }
        Integer uiHeaderRowIndex = this.getUiHeaderRowIndexLocal(scenarioGrid, (GridColumn<?>)scenarioGridColumn, gridY);
        if (uiHeaderRowIndex == null) {
            return false;
        }
        if (!this.isEditableHeaderLocal((GridColumn<?>)scenarioGridColumn, uiHeaderRowIndex)) {
            return false;
        }
        ScenarioHeaderMetaData clickedScenarioHeaderMetadata = this.getColumnScenarioHeaderMetaDataLocal(scenarioGrid, (GridColumn<?>)scenarioGridColumn, gridY);
        if (clickedScenarioHeaderMetadata == null) {
            return false;
        }
        String group = clickedScenarioHeaderMetadata.getColumnGroup();
        if (group.contains("-")) {
            group = group.substring(0, group.indexOf("-"));
        }
        switch (group) {
            case "GIVEN": 
            case "EXPECT": {
                return this.manageGivenExpectHeaderLeftClick(clickedScenarioHeaderMetadata, scenarioGridColumn, group, uiColumnIndex, uiHeaderRowIndex, rp);
            }
        }
        return false;
    }

    protected boolean manageGivenExpectHeaderLeftClick(ScenarioHeaderMetaData clickedScenarioHeaderMetadata, ScenarioGridColumn scenarioGridColumn, String group, Integer uiColumnIndex, Integer uiHeaderRowIndex, Point2D rp) {
        EnableRightPanelEvent toFire;
        String complexSearch;
        if (this.isHeaderEditable(clickedScenarioHeaderMetadata, scenarioGridColumn)) {
            BaseGridRendererHelper.RenderingInformation ri = this.rendererHelper.getRenderingInformation();
            BaseGridRendererHelper.ColumnInformation ci = this.rendererHelper.getColumnInformation(rp.getX());
            GridBodyCellEditContext context = ScenarioSimulationGridHeaderUtilities.makeRenderContext((GridWidget)this.scenarioGrid, ri, ci, rp, uiHeaderRowIndex);
            clickedScenarioHeaderMetadata.edit(context);
        }
        if (scenarioGridColumn.isInstanceAssigned() && clickedScenarioHeaderMetadata.isInstanceHeader()) {
            this.eventBus.fireEvent((GwtEvent)new ReloadRightPanelEvent(true, true));
            return true;
        }
        this.scenarioGrid.setSelectedColumnAndHeader(scenarioGridColumn.getHeaderMetaData().indexOf((Object)clickedScenarioHeaderMetadata), uiColumnIndex);
        if (!scenarioGridColumn.isInstanceAssigned()) {
            complexSearch = this.getExistingInstances(group, this.scenarioGrid.getModel());
            toFire = new EnableRightPanelEvent(complexSearch, true);
        } else if (clickedScenarioHeaderMetadata.isPropertyHeader()) {
            String propertyName = null;
            if (scenarioGridColumn.isPropertyAssigned()) {
                Optional<Simulation> optionalSimulation = this.scenarioGrid.getModel().getSimulation();
                propertyName = optionalSimulation.map(simulation -> this.getPropertyName((Simulation)simulation, uiColumnIndex)).orElse(null);
            }
            toFire = propertyName != null ? new EnableRightPanelEvent(scenarioGridColumn.getInformationHeaderMetaData().getTitle(), propertyName) : new EnableRightPanelEvent(scenarioGridColumn.getInformationHeaderMetaData().getTitle());
        } else {
            complexSearch = this.getExistingInstances(group, this.scenarioGrid.getModel());
            toFire = new EnableRightPanelEvent(complexSearch, true);
        }
        this.eventBus.fireEvent((GwtEvent)toFire);
        return true;
    }

    protected boolean manageGridLeftClick(ScenarioGrid scenarioGrid, Integer uiRowIndex, Integer uiColumnIndex, ScenarioGridColumn scenarioGridColumn) {
        GridCell cell = scenarioGrid.getModel().getCell(uiRowIndex, uiColumnIndex);
        if (cell == null) {
            return false;
        }
        if (((ScenarioGridCell)cell).isEditingMode()) {
            return true;
        }
        ((ScenarioGridCell)cell).setEditingMode(!scenarioGridColumn.isReadOnly() && scenarioGrid.startEditingCell(uiRowIndex, uiColumnIndex));
        return ((ScenarioGridCell)cell).isEditingMode();
    }

    protected String getExistingInstances(String group, ScenarioGridModel scenarioGridModel) {
        return String.join((CharSequence)";", scenarioGridModel.getColumns().stream().filter(gridColumn -> group.equals(((ScenarioGridColumn)((Object)gridColumn)).getInformationHeaderMetaData().getColumnGroup())).map(gridColumn -> ((ScenarioGridColumn)((Object)gridColumn)).getInformationHeaderMetaData().getTitle()).collect(Collectors.toSet()));
    }

    protected String getPropertyName(Simulation simulation, int columnIndex) {
        return String.join((CharSequence)".", simulation.getSimulationDescriptor().getFactMappingByIndex(columnIndex).getExpressionElements().stream().map(ExpressionElement::getStep).collect(Collectors.toSet()));
    }

    protected ScenarioHeaderMetaData getColumnScenarioHeaderMetaDataLocal(ScenarioGrid scenarioGrid, GridColumn<?> scenarioGridColumn, double gridY) {
        return ScenarioSimulationGridHeaderUtilities.getColumnScenarioHeaderMetaData((GridWidget)scenarioGrid, scenarioGridColumn, gridY);
    }

    protected Integer getUiHeaderRowIndexLocal(ScenarioGrid scenarioGrid, GridColumn<?> scenarioGridColumn, double gridY) {
        return ScenarioSimulationGridHeaderUtilities.getUiHeaderRowIndex((GridWidget)scenarioGrid, scenarioGridColumn, gridY);
    }

    protected boolean hasEditableHeaderLocal(GridColumn<?> scenarioGridColumn) {
        return ScenarioSimulationGridHeaderUtilities.hasEditableHeader(scenarioGridColumn);
    }

    protected boolean isEditableHeaderLocal(GridColumn<?> scenarioGridColumn, Integer uiHeaderRowIndex) {
        return ScenarioSimulationGridHeaderUtilities.isEditableHeader(scenarioGridColumn, uiHeaderRowIndex);
    }

    protected boolean isHeaderEditable(ScenarioHeaderMetaData clickedScenarioHeaderMetadata, ScenarioGridColumn scenarioGridColumn) {
        if (this.rendererHelper == null || clickedScenarioHeaderMetadata.isEditingMode() || !scenarioGridColumn.isInstanceAssigned()) {
            return false;
        }
        return clickedScenarioHeaderMetadata.isInstanceHeader() || clickedScenarioHeaderMetadata.isPropertyHeader() && scenarioGridColumn.isPropertyAssigned();
    }
}

