/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.rightpanel;

import com.google.gwt.dom.client.DivElement;
import com.google.gwt.dom.client.Node;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.user.client.ui.Widget;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.drools.workbench.screens.scenariosimulation.client.events.SetInstanceHeaderEvent;
import org.drools.workbench.screens.scenariosimulation.client.events.SetPropertyHeaderEvent;
import org.drools.workbench.screens.scenariosimulation.client.models.FactModelTree;
import org.drools.workbench.screens.scenariosimulation.client.resources.i18n.ScenarioSimulationEditorConstants;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.FieldItemView;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.ListGroupItemPresenter;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.ListGroupItemView;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.RightPanelView;
import org.uberfire.client.annotations.DefaultPosition;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.annotations.WorkbenchScreen;
import org.uberfire.workbench.model.CompassPosition;
import org.uberfire.workbench.model.Position;

@Dependent
@WorkbenchScreen(identifier="org.drools.scenariosimulation.RightPanel", preferredWidth=300)
public class RightPanelPresenter
implements RightPanelView.Presenter {
    public static final int DEFAULT_PREFERRED_WIDHT = 300;
    public static final String IDENTIFIER = "org.drools.scenariosimulation.RightPanel";
    private RightPanelView view;
    private ListGroupItemPresenter listGroupItemPresenter;
    protected Map<String, FactModelTree> dataObjectFieldsMap;
    protected Map<String, FactModelTree> instanceFieldsMap;
    protected EventBus eventBus;
    protected boolean editingColumnEnabled = false;
    protected ListGroupItemView selectedListGroupItemView;
    protected FieldItemView selectedFieldItemView;

    public RightPanelPresenter() {
    }

    @Inject
    public RightPanelPresenter(RightPanelView view, ListGroupItemPresenter listGroupItemPresenter) {
        this.view = view;
        this.listGroupItemPresenter = listGroupItemPresenter;
        this.listGroupItemPresenter.init(this);
    }

    @PostConstruct
    public void setup() {
        this.view.init(this);
        this.view.disableEditorTab();
    }

    @DefaultPosition
    public Position getDefaultPosition() {
        return CompassPosition.EAST;
    }

    @WorkbenchPartTitle
    public String getTitle() {
        return ScenarioSimulationEditorConstants.INSTANCE.testTools();
    }

    @WorkbenchPartView
    public Widget asWidget() {
        return this.view.asWidget();
    }

    @Override
    public void onClearSearch() {
        this.view.clearInputSearch();
        this.view.hideClearButton();
        this.onSearchedEvent("");
    }

    @Override
    public void onClearNameField() {
        this.view.clearNameField();
    }

    @Override
    public void onClearStatus() {
        this.onClearSearch();
        this.onClearNameField();
    }

    @Override
    public void clearDataObjectList() {
        this.view.getDataObjectListContainer().removeAllChildren();
    }

    @Override
    public void clearInstanceList() {
        this.view.getInstanceListContainer().removeAllChildren();
    }

    @Override
    public FactModelTree getFactModelTreeFromFactTypeMap(String factName) {
        return this.dataObjectFieldsMap.get(factName);
    }

    @Override
    public FactModelTree getFactModelTreeFromInstanceMap(String factName) {
        return this.instanceFieldsMap.get(factName);
    }

    @Override
    public void setDataObjectFieldsMap(SortedMap<String, FactModelTree> dataObjectFieldsMap) {
        this.clearDataObjectList();
        this.dataObjectFieldsMap = dataObjectFieldsMap;
        this.dataObjectFieldsMap.forEach(this::addDataObjectListGroupItemView);
    }

    @Override
    public void setInstanceFieldsMap(SortedMap<String, FactModelTree> instanceFieldsMap) {
        this.clearInstanceList();
        this.instanceFieldsMap = instanceFieldsMap;
        this.instanceFieldsMap.forEach(this::addInstanceListGroupItemView);
    }

    @Override
    public void onShowClearButton() {
        this.view.showClearButton();
    }

    @Override
    public void setEventBus(EventBus eventBus) {
        this.eventBus = eventBus;
    }

    @Override
    public void onSearchedEvent(String search) {
        this.clearDataObjectList();
        this.clearInstanceList();
        if (this.dataObjectFieldsMap.isEmpty()) {
            return;
        }
        this.dataObjectFieldsMap.entrySet().stream().filter(entry -> ((String)entry.getKey()).toLowerCase().contains(search.toLowerCase())).forEach(filteredEntry -> this.addDataObjectListGroupItemView((String)filteredEntry.getKey(), (FactModelTree)filteredEntry.getValue()));
        this.instanceFieldsMap.entrySet().stream().filter(entry -> ((String)entry.getKey()).toLowerCase().contains(search.toLowerCase())).forEach(filteredEntry -> this.addInstanceListGroupItemView((String)filteredEntry.getKey(), (FactModelTree)filteredEntry.getValue()));
    }

    @Override
    public void onPerfectMatchSearchedEvent(String search, boolean notEqualsSearch) {
        this.clearDataObjectList();
        this.clearInstanceList();
        if (this.dataObjectFieldsMap.isEmpty()) {
            return;
        }
        this.dataObjectFieldsMap.entrySet().stream().filter(entry -> this.filterTerm((String)entry.getKey(), search, notEqualsSearch)).forEach(filteredEntry -> this.addDataObjectListGroupItemView((String)filteredEntry.getKey(), (FactModelTree)filteredEntry.getValue()));
        this.instanceFieldsMap.entrySet().stream().filter(entry -> this.filterTerm((String)entry.getKey(), search, notEqualsSearch)).forEach(filteredEntry -> this.addInstanceListGroupItemView((String)filteredEntry.getKey(), (FactModelTree)filteredEntry.getValue()));
    }

    @Override
    public void addDataObjectListGroupItemView(String factName, FactModelTree factModelTree) {
        DivElement toAdd = this.listGroupItemPresenter.getDivElement(factName, factModelTree);
        this.view.getDataObjectListContainer().appendChild((Node)toAdd);
    }

    @Override
    public void addInstanceListGroupItemView(String instanceName, FactModelTree factModelTree) {
        DivElement toAdd = this.listGroupItemPresenter.getDivElement(instanceName, factModelTree);
        this.view.getInstanceListContainer().appendChild((Node)toAdd);
    }

    @Override
    public void onEnableEditorTab() {
        this.onDisableEditorTab();
        this.onSearchedEvent("");
        this.listGroupItemPresenter.enable();
        this.editingColumnEnabled = true;
        this.view.enableEditorTab();
    }

    @Override
    public void onEnableEditorTab(String factName, String propertyName, boolean notEqualsSearch) {
        this.onDisableEditorTab();
        this.onPerfectMatchSearchedEvent(factName, notEqualsSearch);
        this.listGroupItemPresenter.enable(factName);
        this.editingColumnEnabled = true;
        this.view.enableEditorTab();
        if (propertyName != null && !notEqualsSearch) {
            this.listGroupItemPresenter.selectProperty(factName, propertyName);
        }
    }

    @Override
    public void onDisableEditorTab() {
        this.listGroupItemPresenter.disable();
        this.editingColumnEnabled = false;
        this.view.disableEditorTab();
        this.selectedFieldItemView = null;
        this.selectedListGroupItemView = null;
    }

    @Override
    public void setSelectedElement(ListGroupItemView selected) {
        this.selectedListGroupItemView = selected;
        this.selectedFieldItemView = null;
        this.view.enableAddButton();
    }

    @Override
    public void setSelectedElement(FieldItemView selected) {
        this.selectedFieldItemView = selected;
        this.selectedListGroupItemView = null;
        this.view.enableAddButton();
    }

    @Override
    public void onModifyColumn() {
        if (this.editingColumnEnabled) {
            if (this.selectedListGroupItemView != null) {
                String className = this.selectedListGroupItemView.getActualClassName();
                FactModelTree factModelTree = this.getFactModelTreeFromFactTypeMap(className);
                if (factModelTree == null) {
                    factModelTree = this.getFactModelTreeFromInstanceMap(className);
                }
                String fullPackage = factModelTree.getFullPackage();
                this.eventBus.fireEvent((GwtEvent)new SetInstanceHeaderEvent(fullPackage, className));
            } else if (this.selectedFieldItemView != null) {
                String value = this.selectedFieldItemView.getFullPath() + "." + this.selectedFieldItemView.getFieldName();
                String baseClass = this.selectedFieldItemView.getFullPath().split("\\.")[0];
                FactModelTree factModelTree = this.getFactModelTreeFromFactTypeMap(baseClass);
                if (factModelTree == null) {
                    factModelTree = this.getFactModelTreeFromInstanceMap(baseClass);
                }
                String fullPackage = factModelTree.getFullPackage();
                this.eventBus.fireEvent((GwtEvent)new SetPropertyHeaderEvent(fullPackage, value, this.selectedFieldItemView.getClassName()));
            }
        }
    }

    protected boolean filterTerm(String key, String search, boolean notEqualsSearch) {
        List<String> terms = Arrays.asList(search.split(";"));
        if (notEqualsSearch) {
            return !terms.contains(key);
        }
        return terms.contains(key);
    }
}

