/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.commands.actualcommands;

import com.google.gwt.event.shared.EventBus;
import org.drools.workbench.screens.scenariosimulation.client.AbstractScenarioSimulationTest;
import org.drools.workbench.screens.scenariosimulation.client.commands.ScenarioSimulationContext;
import org.drools.workbench.screens.scenariosimulation.client.commands.actualcommands.AbstractScenarioSimulationCommand;
import org.drools.workbench.screens.scenariosimulation.client.editor.ScenarioSimulationEditorPresenter;
import org.drools.workbench.screens.scenariosimulation.client.editor.ScenarioSimulationView;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.RightPanelPresenter;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGridPanel;
import org.drools.workbench.screens.scenariosimulation.model.ScenarioSimulationModel;
import org.drools.workbench.screens.scenariosimulation.model.Simulation;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public abstract class AbstractScenarioSimulationCommandTest
extends AbstractScenarioSimulationTest {
    @Mock
    protected ScenarioSimulationEditorPresenter scenarioSimulationEditorPresenterMock;
    @Mock
    protected RightPanelPresenter rightPanelPresenterMock;
    @Mock
    protected EventBus eventBusMock;
    protected AbstractScenarioSimulationCommand command;

    @Override
    @Before
    public void setup() {
        super.setup();
    }

    @Test
    public void undoOnUndoable() {
        if (this.command.isUndoable()) {
            this.command.restorableStatus = this.scenarioSimulationContext.getStatus();
            this.command.undo(this.scenarioSimulationContext);
            ((AbstractScenarioSimulationCommand)Mockito.verify((Object)this.command, (VerificationMode)Mockito.times((int)1))).setCurrentContext((ScenarioSimulationContext)Matchers.eq((Object)this.scenarioSimulationContext));
        }
    }

    @Test(expected=UnsupportedOperationException.class)
    public void undoOnNotUndoable() {
        if (this.command.isUndoable()) {
            throw new UnsupportedOperationException();
        }
        this.command.undo(this.scenarioSimulationContext);
    }

    @Test
    public void redoOnRedoable() {
        if (this.command.isUndoable()) {
            this.command.restorableStatus = this.scenarioSimulationContext.getStatus();
            this.command.redo(this.scenarioSimulationContext);
            ((AbstractScenarioSimulationCommand)Mockito.verify((Object)this.command, (VerificationMode)Mockito.times((int)1))).setCurrentContext((ScenarioSimulationContext)Matchers.eq((Object)this.scenarioSimulationContext));
        }
    }

    @Test(expected=UnsupportedOperationException.class)
    public void redoOnNotUndoable() {
        if (this.command.isUndoable()) {
            throw new UnsupportedOperationException();
        }
        this.command.redo(this.scenarioSimulationContext);
    }

    @Test
    public void execute() {
        ScenarioSimulationContext.Status status = this.scenarioSimulationContext.getStatus();
        this.command.execute(this.scenarioSimulationContext);
        ((AbstractScenarioSimulationCommand)Mockito.verify((Object)this.command, (VerificationMode)Mockito.times((int)1))).internalExecute((ScenarioSimulationContext)Matchers.eq((Object)this.scenarioSimulationContext));
        Assert.assertNotEquals((Object)status, (Object)this.command.restorableStatus);
    }

    @Test
    public void setCurrentContext() {
        if (this.command.isUndoable()) {
            ScenarioSimulationContext.Status status;
            this.command.restorableStatus = status = this.scenarioSimulationContext.getStatus();
            this.command.setCurrentContext(this.scenarioSimulationContext);
            ((ScenarioSimulationView)Mockito.verify((Object)this.scenarioSimulationViewMock, (VerificationMode)Mockito.times((int)1))).setContent((Simulation)Matchers.eq((Object)this.simulationMock));
            ((ScenarioSimulationModel)Mockito.verify((Object)this.scenarioSimulationModelMock, (VerificationMode)Mockito.times((int)1))).setSimulation((Simulation)Matchers.eq((Object)this.simulationMock));
            Assert.assertNotEquals((Object)status, (Object)this.command.restorableStatus);
        }
    }

    @Test
    public void commonExecution() {
        if (this.command.isUndoable()) {
            this.command.commonExecution(this.scenarioSimulationContext);
            ((ScenarioGridPanel)Mockito.verify((Object)this.scenarioGridPanelMock, (VerificationMode)Mockito.times((int)1))).onResize();
            ((ScenarioGridPanel)Mockito.verify((Object)this.scenarioGridPanelMock, (VerificationMode)Mockito.times((int)1))).select();
        }
    }
}

