/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.commands.actualcommands;

import com.google.gwtmockito.GwtMockitoTestRunner;
import org.drools.workbench.screens.scenariosimulation.client.commands.actualcommands.AbstractScenarioSimulationCommand;
import org.drools.workbench.screens.scenariosimulation.client.commands.actualcommands.AbstractScenarioSimulationCommandTest;
import org.drools.workbench.screens.scenariosimulation.client.commands.actualcommands.ReloadRightPanelCommand;
import org.drools.workbench.screens.scenariosimulation.client.editor.ScenarioSimulationEditorPresenter;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=GwtMockitoTestRunner.class)
public class ReloadRightPanelCommandTest
extends AbstractScenarioSimulationCommandTest {
    @Override
    @Before
    public void setup() {
        super.setup();
        this.command = (AbstractScenarioSimulationCommand)Mockito.spy((Object)new ReloadRightPanelCommand());
        this.scenarioSimulationContext.setScenarioSimulationEditorPresenter(this.scenarioSimulationEditorPresenterMock);
        Assert.assertFalse((boolean)this.command.isUndoable());
    }

    @Test
    public void executeDisableOpen() {
        this.scenarioSimulationContext.getStatus().setDisable(true);
        this.scenarioSimulationContext.getStatus().setOpenDock(true);
        this.command.execute(this.scenarioSimulationContext);
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.scenarioSimulationEditorPresenterMock, (VerificationMode)Mockito.times((int)1))).expandToolsDock();
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.scenarioSimulationEditorPresenterMock, (VerificationMode)Mockito.times((int)1))).reloadRightPanel(Matchers.eq((boolean)true));
    }

    @Test
    public void executeNotDisableOpen() {
        this.scenarioSimulationContext.getStatus().setDisable(false);
        this.scenarioSimulationContext.getStatus().setOpenDock(true);
        this.command.execute(this.scenarioSimulationContext);
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.scenarioSimulationEditorPresenterMock, (VerificationMode)Mockito.times((int)1))).expandToolsDock();
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.scenarioSimulationEditorPresenterMock, (VerificationMode)Mockito.times((int)1))).reloadRightPanel(Matchers.eq((boolean)false));
    }

    @Test
    public void executeDisableNotOpen() {
        this.scenarioSimulationContext.getStatus().setDisable(true);
        this.scenarioSimulationContext.getStatus().setOpenDock(false);
        this.command.execute(this.scenarioSimulationContext);
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.scenarioSimulationEditorPresenterMock, (VerificationMode)Mockito.never())).expandToolsDock();
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.scenarioSimulationEditorPresenterMock, (VerificationMode)Mockito.times((int)1))).reloadRightPanel(Matchers.eq((boolean)true));
    }
}

