/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.editor;

import java.util.Optional;
import org.drools.workbench.screens.scenariosimulation.client.AbstractScenarioSimulationTest;
import org.drools.workbench.screens.scenariosimulation.client.editor.menu.BaseMenuView;
import org.drools.workbench.screens.scenariosimulation.client.editor.menu.GridContextMenu;
import org.drools.workbench.screens.scenariosimulation.client.editor.menu.HeaderGivenContextMenu;
import org.drools.workbench.screens.scenariosimulation.client.models.ScenarioGridModel;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.RightPanelPresenter;
import org.drools.workbench.screens.scenariosimulation.model.ExpressionIdentifier;
import org.drools.workbench.screens.scenariosimulation.model.FactIdentifier;
import org.drools.workbench.screens.scenariosimulation.model.FactMapping;
import org.drools.workbench.screens.scenariosimulation.model.FactMappingType;
import org.drools.workbench.screens.scenariosimulation.model.Scenario;
import org.drools.workbench.screens.scenariosimulation.model.ScenarioSimulationModel;
import org.drools.workbench.screens.scenariosimulation.model.ScenarioSimulationModelContent;
import org.drools.workbench.screens.scenariosimulation.model.Simulation;
import org.drools.workbench.screens.scenariosimulation.model.SimulationDescriptor;
import org.drools.workbench.screens.scenariosimulation.service.DMNTypeService;
import org.drools.workbench.screens.scenariosimulation.service.ScenarioSimulationService;
import org.guvnor.common.services.project.client.context.WorkspaceProjectContext;
import org.guvnor.common.services.shared.metadata.model.Overview;
import org.kie.workbench.common.services.datamodel.model.PackageDataModelOracleBaselinePayload;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracleFactory;
import org.kie.workbench.common.widgets.client.menu.FileMenuBuilder;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.backend.vfs.ObservablePath;
import org.uberfire.backend.vfs.Path;
import org.uberfire.ext.editor.commons.client.history.VersionRecordManager;
import org.uberfire.ext.editor.commons.client.validation.DefaultFileNameValidator;
import org.uberfire.ext.editor.commons.client.validation.Validator;
import org.uberfire.mvp.Command;
import org.uberfire.workbench.model.menu.MenuItem;

public abstract class AbstractScenarioSimulationEditorTest
extends AbstractScenarioSimulationTest {
    protected static final String SCENARIO_PACKAGE = "scenario.package";
    @Mock
    protected VersionRecordManager versionRecordManagerMock;
    @Mock
    protected FileMenuBuilder fileMenuBuilderMock;
    @Mock
    protected ScenarioSimulationService scenarioSimulationServiceMock;
    @Mock
    protected DMNTypeService dmnTypeServiceMock;
    @Mock
    protected ObservablePath observablePathMock;
    @Mock
    protected Overview overviewMock;
    @Mock
    protected GridContextMenu gridContextMenuMock;
    @Mock
    protected HeaderGivenContextMenu headerGivenContextMenuMock;
    @Mock
    protected BaseMenuView gridContextMenuViewMock;
    @Mock
    protected BaseMenuView headerContextMenuViewMock;
    @Mock
    protected WorkspaceProjectContext workbenchContextMock;
    @Mock
    protected RightPanelPresenter rightPanelPresenterMock;
    @Mock
    protected AsyncPackageDataModelOracleFactory oracleFactoryMock;
    @Mock
    protected ScenarioGridModel scenarioGridModelMock;
    protected ScenarioSimulationModelContent content;
    protected ScenarioSimulationModel model;

    @Override
    public void setup() {
        Mockito.when((Object)this.fileMenuBuilderMock.addSave((MenuItem)Mockito.any(MenuItem.class))).thenReturn((Object)this.fileMenuBuilderMock);
        Mockito.when((Object)this.fileMenuBuilderMock.addCopy((Path)Mockito.any(ObservablePath.class), (Validator)Mockito.any(DefaultFileNameValidator.class))).thenReturn((Object)this.fileMenuBuilderMock);
        Mockito.when((Object)this.fileMenuBuilderMock.addRename((Command)Mockito.any(Command.class))).thenReturn((Object)this.fileMenuBuilderMock);
        Mockito.when((Object)this.fileMenuBuilderMock.addDelete((Path)Mockito.any(ObservablePath.class))).thenReturn((Object)this.fileMenuBuilderMock);
        Mockito.when((Object)this.fileMenuBuilderMock.addValidate((Command)Mockito.any(Command.class))).thenReturn((Object)this.fileMenuBuilderMock);
        Mockito.when((Object)this.fileMenuBuilderMock.addNewTopLevelMenu((MenuItem)Mockito.any(MenuItem.class))).thenReturn((Object)this.fileMenuBuilderMock);
        Mockito.when((Object)this.versionRecordManagerMock.getCurrentPath()).thenReturn((Object)this.observablePathMock);
        Mockito.when((Object)this.versionRecordManagerMock.getPathToLatest()).thenReturn((Object)this.observablePathMock);
        Mockito.when((Object)this.workbenchContextMock.getActiveWorkspaceProject()).thenReturn(Optional.empty());
        Mockito.when((Object)this.gridContextMenuMock.getView()).thenReturn((Object)this.gridContextMenuViewMock);
        Mockito.when((Object)this.headerGivenContextMenuMock.getView()).thenReturn((Object)this.headerContextMenuViewMock);
        this.model = new ScenarioSimulationModel();
        this.model.setSimulation(this.getSimulation(ScenarioSimulationModel.Type.RULE, "default"));
        this.content = new ScenarioSimulationModelContent(this.model, this.overviewMock, (PackageDataModelOracleBaselinePayload)Mockito.mock(PackageDataModelOracleBaselinePayload.class));
        Mockito.when((Object)this.scenarioSimulationServiceMock.loadContent((Path)this.observablePathMock)).thenReturn((Object)this.content);
    }

    protected Simulation getSimulation(ScenarioSimulationModel.Type selectedType, String value) {
        Simulation toReturn = new Simulation();
        SimulationDescriptor simulationDescriptor = toReturn.getSimulationDescriptor();
        simulationDescriptor.setType(selectedType);
        switch (selectedType) {
            case DMN: {
                simulationDescriptor.setDmnFilePath(value);
                break;
            }
            default: {
                simulationDescriptor.setDmoSession(value);
            }
        }
        simulationDescriptor.addFactMapping(FactIdentifier.INDEX.getName(), FactIdentifier.INDEX, ExpressionIdentifier.INDEX);
        simulationDescriptor.addFactMapping(FactIdentifier.DESCRIPTION.getName(), FactIdentifier.DESCRIPTION, ExpressionIdentifier.DESCRIPTION);
        Scenario scenario = toReturn.addScenario();
        int row = toReturn.getUnmodifiableScenarios().indexOf(scenario);
        scenario.setDescription(null);
        int id = 1;
        ExpressionIdentifier givenExpression = ExpressionIdentifier.create((String)(row + "|" + id), (FactMappingType)FactMappingType.GIVEN);
        FactMapping givenFactMapping = simulationDescriptor.addFactMapping(FactMapping.getInstancePlaceHolder((int)id), FactIdentifier.EMPTY, givenExpression);
        givenFactMapping.setExpressionAlias(FactMapping.getPropertyPlaceHolder((int)id));
        scenario.addMappingValue(FactIdentifier.EMPTY, givenExpression, null);
        id = 2;
        ExpressionIdentifier expectedExpression = ExpressionIdentifier.create((String)(row + "|" + id), (FactMappingType)FactMappingType.EXPECT);
        FactMapping expectedFactMapping = simulationDescriptor.addFactMapping(FactMapping.getInstancePlaceHolder((int)id), FactIdentifier.EMPTY, expectedExpression);
        expectedFactMapping.setExpressionAlias(FactMapping.getPropertyPlaceHolder((int)id));
        scenario.addMappingValue(FactIdentifier.EMPTY, expectedExpression, null);
        return toReturn;
    }
}

