/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.editor.strategies;

import org.drools.workbench.screens.scenariosimulation.client.editor.strategies.DMNDataManagementStrategy;
import org.drools.workbench.screens.scenariosimulation.client.models.ScenarioGridModel;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.RightPanelView;
import org.drools.workbench.screens.scenariosimulation.model.ScenarioSimulationModel;
import org.drools.workbench.screens.scenariosimulation.model.ScenarioSimulationModelContent;
import org.drools.workbench.screens.scenariosimulation.model.Simulation;
import org.drools.workbench.screens.scenariosimulation.model.SimulationDescriptor;
import org.drools.workbench.screens.scenariosimulation.model.typedescriptor.FactModelTuple;
import org.drools.workbench.screens.scenariosimulation.service.DMNTypeService;
import org.jboss.errai.common.client.api.Caller;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.backend.vfs.ObservablePath;
import org.uberfire.backend.vfs.Path;
import org.uberfire.mocks.CallerMock;

@RunWith(value=MockitoJUnitRunner.class)
public class DMNDataManagementStrategyTest {
    @Mock
    protected DMNTypeService dmnTypeServiceMock;
    DMNDataManagementStrategy dmnDataManagementStrategy;

    @Before
    public void init() {
        Mockito.when((Object)this.dmnTypeServiceMock.retrieveType((Path)Matchers.any(), Matchers.anyString())).thenReturn(Mockito.mock(FactModelTuple.class));
        this.dmnDataManagementStrategy = new DMNDataManagementStrategy((Caller)new CallerMock((Object)this.dmnTypeServiceMock));
    }

    @Test
    public void populateRightPanel() {
        ScenarioSimulationModelContent scenarioSimulationModelContentMock = (ScenarioSimulationModelContent)Mockito.mock(ScenarioSimulationModelContent.class);
        ScenarioSimulationModel scenarioSimulationModel = (ScenarioSimulationModel)Mockito.mock(ScenarioSimulationModel.class);
        Mockito.when((Object)scenarioSimulationModelContentMock.getModel()).thenReturn((Object)scenarioSimulationModel);
        Simulation simulationMock = (Simulation)Mockito.mock(Simulation.class);
        Mockito.when((Object)scenarioSimulationModel.getSimulation()).thenReturn((Object)simulationMock);
        SimulationDescriptor simulationDescriptorMock = (SimulationDescriptor)Mockito.mock(SimulationDescriptor.class);
        Mockito.when((Object)simulationMock.getSimulationDescriptor()).thenReturn((Object)simulationDescriptorMock);
        this.dmnDataManagementStrategy.manageScenarioSimulationModelContent((ObservablePath)Mockito.mock(ObservablePath.class), scenarioSimulationModelContentMock);
        this.dmnDataManagementStrategy.populateRightPanel((RightPanelView.Presenter)Mockito.mock(RightPanelView.Presenter.class), (ScenarioGridModel)Mockito.mock(ScenarioGridModel.class));
        ((DMNTypeService)Mockito.verify((Object)this.dmnTypeServiceMock, (VerificationMode)Mockito.times((int)1))).retrieveType((Path)Matchers.any(), Matchers.anyString());
    }

    @Test
    public void manageScenarioSimulationModelContent() {
        ObservablePath observablePathMock = (ObservablePath)Mockito.mock(ObservablePath.class);
        ScenarioSimulationModelContent scenarioSimulationModelContentMock = (ScenarioSimulationModelContent)Mockito.mock(ScenarioSimulationModelContent.class);
        this.dmnDataManagementStrategy.manageScenarioSimulationModelContent(observablePathMock, scenarioSimulationModelContentMock);
        ((ObservablePath)Mockito.verify((Object)observablePathMock, (VerificationMode)Mockito.times((int)1))).getOriginal();
        ((ScenarioSimulationModelContent)Mockito.verify((Object)scenarioSimulationModelContentMock, (VerificationMode)Mockito.times((int)1))).getModel();
    }
}

