/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.factories;

import com.ait.lienzo.test.LienzoMockitoTestRunner;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.GwtEvent;
import org.drools.workbench.screens.scenariosimulation.client.events.SetCellValueEvent;
import org.drools.workbench.screens.scenariosimulation.client.factories.AbstractFactoriesTest;
import org.drools.workbench.screens.scenariosimulation.client.factories.ScenarioHeaderTextAreaDOMElement;
import org.drools.workbench.screens.scenariosimulation.client.metadata.ScenarioHeaderMetaData;
import org.drools.workbench.screens.scenariosimulation.client.models.ScenarioGridModel;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;
import org.uberfire.ext.wires.core.grids.client.widget.layer.GridLayer;

@RunWith(value=LienzoMockitoTestRunner.class)
public class ScenarioHeaderTextAreaDOMElementTest
extends AbstractFactoriesTest {
    private ScenarioHeaderTextAreaDOMElement scenarioHeaderTextAreaDOMElement;
    @Mock
    private ScenarioHeaderMetaData scenarioHeaderMetaDataMock;
    private final String VALUE = "VALUE";

    @Override
    @Before
    public void setup() {
        super.setup();
        this.scenarioHeaderTextAreaDOMElement = (ScenarioHeaderTextAreaDOMElement)Mockito.spy((Object)new ScenarioHeaderTextAreaDOMElement(this.textAreaMock, (GridLayer)this.scenarioGridLayerMock, (GridWidget)this.scenarioGridMock){
            {
                this.context = ScenarioHeaderTextAreaDOMElementTest.this.contextMock;
            }
        });
    }

    @Test
    public void flushMetadataEqualsValue() {
        Mockito.when((Object)this.scenarioHeaderMetaDataMock.getTitle()).thenReturn((Object)"VALUE");
        this.scenarioHeaderTextAreaDOMElement.setScenarioHeaderMetaData(this.scenarioHeaderMetaDataMock);
        this.scenarioHeaderTextAreaDOMElement.flush("VALUE");
        ((ScenarioHeaderTextAreaDOMElement)Mockito.verify((Object)this.scenarioHeaderTextAreaDOMElement, (VerificationMode)Mockito.never())).internalFlush((String)Matchers.eq((Object)"VALUE"));
    }

    @Test
    public void flushMetadataNotEqualsValue() {
        Mockito.when((Object)this.scenarioHeaderMetaDataMock.getTitle()).thenReturn((Object)"NOT_VALUE");
        this.scenarioHeaderTextAreaDOMElement.setScenarioHeaderMetaData(this.scenarioHeaderMetaDataMock);
        this.scenarioHeaderTextAreaDOMElement.flush("VALUE");
        ((ScenarioHeaderTextAreaDOMElement)Mockito.verify((Object)this.scenarioHeaderTextAreaDOMElement, (VerificationMode)Mockito.times((int)1))).internalFlush((String)Matchers.eq((Object)"VALUE"));
    }

    @Test
    public void flushNullMetadata() {
        this.scenarioHeaderTextAreaDOMElement.setScenarioHeaderMetaData(null);
        this.scenarioHeaderTextAreaDOMElement.flush("VALUE");
        ((ScenarioHeaderTextAreaDOMElement)Mockito.verify((Object)this.scenarioHeaderTextAreaDOMElement, (VerificationMode)Mockito.times((int)1))).internalFlush((String)Matchers.eq((Object)"VALUE"));
    }

    @Test
    public void internalFlushInvalidHeader() {
        Mockito.when((Object)this.scenarioGridModelMock.validateHeaderUpdate((String)Matchers.eq((Object)"VALUE"), Matchers.eq((int)1), Matchers.eq((int)2))).thenReturn((Object)false);
        this.scenarioHeaderTextAreaDOMElement.internalFlush("VALUE");
        ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModelMock, (VerificationMode)Mockito.never())).updateHeader(Matchers.eq((int)2), Matchers.eq((int)1), (String)Matchers.eq((Object)"VALUE"));
    }

    @Test
    public void internalFlushValidHeader() {
        Mockito.when((Object)this.scenarioGridModelMock.validateHeaderUpdate((String)Matchers.eq((Object)"VALUE"), Matchers.eq((int)1), Matchers.eq((int)2))).thenReturn((Object)true);
        this.scenarioHeaderTextAreaDOMElement.internalFlush("VALUE");
        ((EventBus)Mockito.verify((Object)this.eventBusMock, (VerificationMode)Mockito.times((int)1))).fireEvent((GwtEvent)Matchers.isA(SetCellValueEvent.class));
    }
}

