/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.handlers;

import com.google.gwtmockito.GwtMockitoTestRunner;
import javax.enterprise.event.Event;
import org.drools.workbench.screens.scenariosimulation.client.handlers.AbstractNewScenarioTest;
import org.drools.workbench.screens.scenariosimulation.client.handlers.NewScenarioSimulationHandler;
import org.drools.workbench.screens.scenariosimulation.client.type.ScenarioSimulationResourceType;
import org.drools.workbench.screens.scenariosimulation.service.ScenarioSimulationService;
import org.guvnor.common.services.project.model.Package;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.security.shared.api.identity.User;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.screens.library.client.screens.assets.AssetQueryService;
import org.kie.workbench.common.widgets.client.handlers.NewResourcePresenter;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.backend.vfs.Path;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.ext.widgets.common.client.common.BusyIndicatorView;
import org.uberfire.mocks.CallerMock;
import org.uberfire.mocks.EventSourceMock;
import org.uberfire.rpc.SessionInfo;
import org.uberfire.security.Resource;
import org.uberfire.security.ResourceAction;
import org.uberfire.security.ResourceRef;
import org.uberfire.security.authz.AuthorizationManager;
import org.uberfire.workbench.events.NotificationEvent;
import org.uberfire.workbench.model.ActivityResourceType;

@RunWith(value=GwtMockitoTestRunner.class)
public class NewScenarioSimulationHandlerTest
extends AbstractNewScenarioTest {
    @Mock
    private BusyIndicatorView busyIndicatorViewMock;
    @Mock
    private ScenarioSimulationService scenarioSimulationServiceMock;
    @Mock
    private ScenarioSimulationResourceType resourceTypeMock;
    @Mock
    private EventSourceMock notificationEventMock;
    @Mock
    private EventSourceMock newResourceSuccessEventMock;
    @Mock
    private PlaceManager placeManagerMock;
    @Mock
    private AuthorizationManager authorizationManagerMock;
    @Mock
    private SessionInfo sessionInfoMock;
    @Mock
    private AssetQueryService assetQueryServiceMock;
    @Mock
    private User userMock;
    @Captor
    private ArgumentCaptor<ResourceRef> refArgumentCaptor;
    private NewScenarioSimulationHandler handler;

    @Override
    @Before
    public void setUp() throws Exception {
        this.handler = new NewScenarioSimulationHandler(this.resourceTypeMock, this.busyIndicatorViewMock, (Event)this.notificationEventMock, (Event)this.newResourceSuccessEventMock, this.placeManagerMock, (Caller)new CallerMock((Object)this.scenarioSimulationServiceMock), this.authorizationManagerMock, this.sessionInfoMock, this.libraryPlacesMock, this.assetQueryServiceMock);
        this.handler.setupExtensions();
        Mockito.when((Object)this.sessionInfoMock.getIdentity()).thenReturn((Object)this.userMock);
    }

    @Test
    public void checkCanCreateWhenFeatureDisabled() {
        Mockito.when((Object)this.authorizationManagerMock.authorize((Resource)Matchers.any(ResourceRef.class), (ResourceAction)Matchers.eq((Object)ResourceAction.READ), (User)Matchers.eq((Object)this.userMock))).thenReturn((Object)false);
        Assert.assertFalse((boolean)this.handler.canCreate());
        this.assertResourceRef();
    }

    @Test
    public void checkCanCreateWhenFeatureEnabled() {
        Mockito.when((Object)this.authorizationManagerMock.authorize((Resource)Matchers.any(ResourceRef.class), (ResourceAction)Matchers.eq((Object)ResourceAction.READ), (User)Matchers.eq((Object)this.userMock))).thenReturn((Object)true);
        Assert.assertTrue((boolean)this.handler.canCreate());
        this.assertResourceRef();
    }

    @Test
    public void checkRightResourceType() throws Exception {
        this.handler.create(new Package(), "newfile.scesim", (NewResourcePresenter)Mockito.mock(NewResourcePresenter.class));
        ((BusyIndicatorView)Mockito.verify((Object)this.busyIndicatorViewMock)).showBusyIndicator("Saving");
        ((BusyIndicatorView)Mockito.verify((Object)this.busyIndicatorViewMock)).hideBusyIndicator();
        ((EventSourceMock)Mockito.verify((Object)this.notificationEventMock)).fire(Matchers.any(NotificationEvent.class));
        ((EventSourceMock)Mockito.verify((Object)this.newResourceSuccessEventMock)).fire(Matchers.any(NewResourcePresenter.class));
        ((PlaceManager)Mockito.verify((Object)this.placeManagerMock)).goTo((Path)Matchers.any(Path.class));
    }

    private void assertResourceRef() {
        ((AuthorizationManager)Mockito.verify((Object)this.authorizationManagerMock)).authorize((Resource)this.refArgumentCaptor.capture(), (ResourceAction)Matchers.eq((Object)ResourceAction.READ), (User)Matchers.eq((Object)this.userMock));
        Assert.assertEquals((Object)"ScenarioSimulationEditor", (Object)((ResourceRef)this.refArgumentCaptor.getValue()).getIdentifier());
        Assert.assertEquals((Object)ActivityResourceType.EDITOR, (Object)((ResourceRef)this.refArgumentCaptor.getValue()).getResourceType());
    }
}

