/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.handlers;

import com.ait.lienzo.client.core.event.AbstractNodeMouseEvent;
import com.ait.lienzo.client.core.event.NodeMouseClickEvent;
import com.ait.lienzo.client.core.event.NodeMouseDoubleClickEvent;
import com.ait.lienzo.client.core.types.Point2D;
import com.ait.lienzo.test.LienzoMockitoTestRunner;
import com.google.gwt.event.dom.client.DoubleClickEvent;
import com.google.gwt.event.dom.client.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.drools.workbench.screens.scenariosimulation.client.handlers.AbstractScenarioSimulationGridHandlerTest;
import org.drools.workbench.screens.scenariosimulation.client.handlers.ScenarioSimulationGridWidgetMouseEventHandler;
import org.drools.workbench.screens.scenariosimulation.client.metadata.ScenarioHeaderMetaData;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.wires.core.grids.client.model.GridCellEditAction;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.widget.context.GridBodyCellEditContext;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.impl.BaseGridRendererHelper;

@RunWith(value=LienzoMockitoTestRunner.class)
public class ScenarioSimulationGridWidgetMouseEventHandlerTest
extends AbstractScenarioSimulationGridHandlerTest {
    private static final int MOUSE_EVENT_X = 32;
    private static final int MOUSE_EVENT_Y = 64;
    private static final double GRID_COMPUTED_LOCATION_X = 100.0;
    private static final double GRID_COMPUTED_LOCATION_Y = 200.0;
    @Mock
    private MouseEvent nativeClickEvent;
    @Mock
    private DoubleClickEvent nativeDoubleClickEvent;
    @Mock
    private BaseGridRendererHelper rendererHelper;
    @Mock
    private BaseGridRendererHelper.RenderingInformation renderingInformation;
    @Mock
    private BaseGridRendererHelper.ColumnInformation columnInformation;
    @Mock
    private BaseGridRendererHelper.RenderingBlockInformation renderingBlockInformation;
    private NodeMouseClickEvent clickEvent;
    private NodeMouseDoubleClickEvent doubleClickEvent;
    private ScenarioSimulationGridWidgetMouseEventHandler handler;
    private Point2D relativeLocation = new Point2D(32.0, 64.0);
    private Point2D computedLocation = new Point2D(100.0, 200.0);

    @Override
    @Before
    public void setup() {
        super.setUp();
        this.clickEvent = new NodeMouseClickEvent(this.nativeClickEvent);
        this.doubleClickEvent = new NodeMouseDoubleClickEvent(this.nativeDoubleClickEvent);
        Mockito.when((Object)this.scenarioGridMock.getRendererHelper()).thenReturn((Object)this.rendererHelper);
        Mockito.when((Object)this.scenarioGridMock.getViewport()).thenReturn((Object)this.viewportMock);
        Mockito.when((Object)this.scenarioGridMock.getComputedLocation()).thenReturn((Object)this.computedLocation);
        Mockito.when((Object)this.rendererHelper.getRenderingInformation()).thenReturn((Object)this.renderingInformation);
        Mockito.when((Object)this.rendererHelper.getColumnInformation(Matchers.anyDouble())).thenReturn((Object)this.columnInformation);
        Mockito.when((Object)this.columnInformation.getColumn()).thenReturn((Object)this.gridColumnMock);
        Mockito.when((Object)this.renderingInformation.getBodyBlockInformation()).thenReturn((Object)this.renderingBlockInformation);
        Mockito.when((Object)this.renderingInformation.getFloatingBlockInformation()).thenReturn((Object)this.renderingBlockInformation);
        Mockito.when((Object)this.informationHeaderMetaDataMock.getSupportedEditAction()).thenReturn((Object)GridCellEditAction.SINGLE_CLICK);
        this.handler = (ScenarioSimulationGridWidgetMouseEventHandler)Mockito.spy((Object)new ScenarioSimulationGridWidgetMouseEventHandler());
    }

    @Test
    public void testHandleHeaderCell_NullColumn() {
        Mockito.when((Object)this.columnInformation.getColumn()).thenReturn(null);
        Assert.assertFalse((boolean)this.handler.handleHeaderCell((GridWidget)this.scenarioGridMock, this.relativeLocation, 0, 0, (AbstractNodeMouseEvent)this.clickEvent));
    }

    @Test
    public void testHandleHeaderCell_NonEditableColumn() {
        ((ScenarioSimulationGridWidgetMouseEventHandler)Mockito.doReturn((Object)false).when((Object)this.handler)).isEditableHeaderLocal((GridColumn)Matchers.eq((Object)this.gridColumnMock), Integer.valueOf(Matchers.anyInt()));
        Assert.assertTrue((boolean)this.handler.handleHeaderCell((GridWidget)this.scenarioGridMock, this.relativeLocation, 0, 0, (AbstractNodeMouseEvent)this.clickEvent));
        ((ScenarioHeaderMetaData)Mockito.verify((Object)this.informationHeaderMetaDataMock, (VerificationMode)Mockito.never())).edit((GridBodyCellEditContext)Matchers.any(GridBodyCellEditContext.class));
    }

    @Test
    public void testHandleHeaderCell_EditableColumn_NotEditableRow() {
        ((ScenarioSimulationGridWidgetMouseEventHandler)Mockito.doReturn((Object)true).when((Object)this.handler)).isEditableHeaderLocal((GridColumn)Matchers.eq((Object)this.gridColumnMock), Integer.valueOf(Matchers.anyInt()));
        Assert.assertTrue((boolean)this.handler.handleHeaderCell((GridWidget)this.scenarioGridMock, this.relativeLocation, 0, 0, (AbstractNodeMouseEvent)this.clickEvent));
        ((ScenarioHeaderMetaData)Mockito.verify((Object)this.informationHeaderMetaDataMock, (VerificationMode)Mockito.never())).edit((GridBodyCellEditContext)Matchers.any(GridBodyCellEditContext.class));
    }

    @Test
    public void testHandleHeaderCell_EditableColumn_EditableRow_DoubleClickEvent() {
        ((ScenarioSimulationGridWidgetMouseEventHandler)Mockito.doReturn((Object)true).when((Object)this.handler)).isEditableHeaderLocal((GridColumn)Matchers.eq((Object)this.gridColumnMock), Integer.valueOf(Matchers.anyInt()));
        Mockito.when((Object)this.gridColumnMock.getHeaderMetaData()).thenReturn(Collections.singletonList(this.informationHeaderMetaDataMock));
        List selectedCellsMock = (List)Mockito.mock(ArrayList.class);
        Mockito.when((Object)selectedCellsMock.size()).thenReturn((Object)1);
        Mockito.when((Object)this.informationHeaderMetaDataMock.getSupportedEditAction()).thenReturn((Object)GridCellEditAction.DOUBLE_CLICK);
        Mockito.when((Object)this.informationHeaderMetaDataMock.isInstanceHeader()).thenReturn((Object)true);
        Mockito.when((Object)this.scenarioGridModelMock.getSelectedHeaderCells()).thenReturn((Object)selectedCellsMock);
        Mockito.when((Object)this.gridColumnMock.isInstanceAssigned()).thenReturn((Object)true);
        Mockito.when((Object)this.gridColumnMock.isEditableHeaders()).thenReturn((Object)true);
        this.scenarioGridModelMock.selectHeaderCell(0, 0);
        Assert.assertTrue((boolean)this.handler.handleHeaderCell((GridWidget)this.scenarioGridMock, this.relativeLocation, 0, 0, (AbstractNodeMouseEvent)this.doubleClickEvent));
        ((ScenarioHeaderMetaData)Mockito.verify((Object)this.informationHeaderMetaDataMock, (VerificationMode)Mockito.times((int)1))).edit((GridBodyCellEditContext)Matchers.any(GridBodyCellEditContext.class));
    }
}

