/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.handlers;

import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.drools.workbench.screens.scenariosimulation.client.handlers.AbstractNewScenarioTest;
import org.drools.workbench.screens.scenariosimulation.client.handlers.TitledAttachmentFileWidget;
import org.drools.workbench.screens.scenariosimulation.client.resources.i18n.ScenarioSimulationEditorConstants;
import org.gwtbootstrap3.client.ui.FormLabel;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.screens.examples.client.wizard.widgets.ComboBox;
import org.kie.workbench.common.screens.explorer.model.FolderItem;
import org.kie.workbench.common.screens.explorer.model.FolderItemType;
import org.kie.workbench.common.screens.library.api.AssetInfo;
import org.kie.workbench.common.screens.library.api.AssetQueryResult;
import org.kie.workbench.common.screens.library.api.ProjectAssetsQuery;
import org.kie.workbench.common.screens.library.client.screens.assets.AssetQueryService;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.widgets.common.client.callbacks.DefaultErrorCallback;

@RunWith(value=GwtMockitoTestRunner.class)
public class TitledAttachmentFileWidgetTest
extends AbstractNewScenarioTest {
    @Mock
    private VerticalPanel fieldsMock;
    @Mock
    private FormLabel titleLabelMock;
    @Mock
    private ComboBox comboBoxMock;
    private TitledAttachmentFileWidget titledAttachmentFileWidget;

    @Before
    public void setup() {
        this.titledAttachmentFileWidget = (TitledAttachmentFileWidget)Mockito.spy((Object)new TitledAttachmentFileWidget(ScenarioSimulationEditorConstants.INSTANCE.chooseDMN(), this.libraryPlacesMock, this.assetQueryServiceMock){
            {
                this.fields = TitledAttachmentFileWidgetTest.this.fieldsMock;
                this.titleLabel = TitledAttachmentFileWidgetTest.this.titleLabelMock;
                this.comboBox = TitledAttachmentFileWidgetTest.this.comboBoxMock;
            }

            protected String getAssetPath(AssetInfo asset) {
                return "TEST";
            }
        });
    }

    @Test
    public void updateAssetList() {
        this.titledAttachmentFileWidget.updateAssetList();
        ((ComboBox)Mockito.verify((Object)this.comboBoxMock, (VerificationMode)Mockito.times((int)1))).clear();
        ((TitledAttachmentFileWidget)Mockito.verify((Object)this.titledAttachmentFileWidget, (VerificationMode)Mockito.times((int)1))).getAssets((RemoteCallback)Matchers.isA(RemoteCallback.class));
    }

    @Test
    public void getAssets() {
        RemoteCallback callbackMock = (RemoteCallback)Mockito.mock(RemoteCallback.class);
        this.titledAttachmentFileWidget.getAssets(callbackMock);
        ((TitledAttachmentFileWidget)Mockito.verify((Object)this.titledAttachmentFileWidget, (VerificationMode)Mockito.times((int)1))).createProjectQuery();
        ((AssetQueryService)Mockito.verify((Object)this.assetQueryServiceMock, (VerificationMode)Mockito.times((int)1))).getAssets((ProjectAssetsQuery)Matchers.isA(ProjectAssetsQuery.class));
        ((AssetQueryService.Invoker)Mockito.verify((Object)this.invokerMock, (VerificationMode)Mockito.times((int)1))).call((RemoteCallback)Matchers.eq((Object)callbackMock), (ErrorCallback)Matchers.isA(DefaultErrorCallback.class));
    }

    @Test
    public void createProjectQuery() {
        ProjectAssetsQuery retrieved = this.titledAttachmentFileWidget.createProjectQuery();
        Assert.assertNotNull((Object)retrieved);
    }

    @Test
    public void addAssets() {
        int size = 4;
        AssetQueryResult assetQueryResult = this.getAssetQueryResult(size);
        this.titledAttachmentFileWidget.addAssets(assetQueryResult);
        ((ComboBox)Mockito.verify((Object)this.comboBoxMock, (VerificationMode)Mockito.times((int)size))).addItem(Matchers.anyString());
    }

    private AssetQueryResult getAssetQueryResult(int size) {
        return AssetQueryResult.normal(this.getAssetInfoList(size));
    }

    private List<AssetInfo> getAssetInfoList(int size) {
        return IntStream.range(0, size).mapToObj(i -> this.getAssetInfoMock()).collect(Collectors.toList());
    }

    private AssetInfo getAssetInfoMock() {
        AssetInfo toReturn = (AssetInfo)Mockito.mock(AssetInfo.class);
        FolderItem folderItemMock = this.getFolderItemMock();
        Mockito.when((Object)toReturn.getFolderItem()).thenReturn((Object)folderItemMock);
        return toReturn;
    }

    private FolderItem getFolderItemMock() {
        FolderItem toReturn = (FolderItem)Mockito.mock(FolderItem.class);
        Mockito.when((Object)toReturn.getType()).thenReturn((Object)FolderItemType.FILE);
        return toReturn;
    }
}

