/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.rightpanel;

import com.google.gwt.dom.client.LIElement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.IntStream;
import org.drools.workbench.screens.scenariosimulation.client.editor.strategies.DataManagementStrategy;
import org.drools.workbench.screens.scenariosimulation.client.utils.ViewsProvider;
import org.drools.workbench.screens.scenariosimulation.model.typedescriptor.FactModelTree;
import org.junit.Before;
import org.mockito.Mock;

abstract class AbstractRightPanelTest {
    @Mock
    protected LIElement lIElementMock;
    @Mock
    protected ViewsProvider viewsProviderMock;
    protected SortedMap<String, FactModelTree> dataObjectFactTreeMap;
    protected SortedMap<String, FactModelTree> simpleJavaTypeTreeMap;
    protected SortedMap<String, FactModelTree> instanceFactTreeMap;
    protected SortedMap<String, FactModelTree> simpleJavaInstanceFactTreeMap;
    protected String FACT_NAME;
    protected String FACT_PACKAGE = "test.scesim.package";
    protected final String GRID_COLUMN_TITLE = "GRID_COLUMN_TITLE";
    protected final String GRID_COLUMN_GROUP = "GIVEN";
    protected final String GRID_COLUMN_ID = "GRID_COLUMN_ID";
    protected final String GRID_CELL_TEXT = "GRID_CELL_TEXT";
    protected final String FULL_PACKAGE = "test.scesim";
    protected final String VALUE = "VALUE";
    protected final String VALUE_CLASS_NAME = String.class.getName();
    protected final int ROW_COUNT = 4;
    protected final int ROW_INDEX = 3;
    protected final int COLUMN_INDEX = 5;
    protected FactModelTree FACT_MODEL_TREE;

    AbstractRightPanelTest() {
    }

    @Before
    public void setup() {
        this.dataObjectFactTreeMap = this.getDataObjectFactTreeMap();
        this.simpleJavaTypeTreeMap = this.getSimpleJavaTypeFieldsMap();
        this.instanceFactTreeMap = new TreeMap<String, FactModelTree>();
        this.dataObjectFactTreeMap.keySet().forEach(key -> {
            FactModelTree cfr_ignored_0 = (FactModelTree)this.instanceFactTreeMap.put(this.getRandomString(), (FactModelTree)this.dataObjectFactTreeMap.get(key));
        });
        this.simpleJavaInstanceFactTreeMap = new TreeMap<String, FactModelTree>();
        this.FACT_NAME = new ArrayList<String>(this.dataObjectFactTreeMap.keySet()).get(0);
        this.FACT_MODEL_TREE = (FactModelTree)this.dataObjectFactTreeMap.get(this.FACT_NAME);
    }

    protected String getRandomFactModelTree(Map<String, FactModelTree> source, int position) {
        return new ArrayList<String>(source.keySet()).get(position);
    }

    protected SortedMap<String, FactModelTree> getDataObjectFactTreeMap() {
        TreeMap<String, FactModelTree> toReturn = new TreeMap<String, FactModelTree>();
        IntStream.range(0, 3).forEach(id -> {
            String key = this.getRandomString();
            FactModelTree value = new FactModelTree(key, this.FACT_PACKAGE, this.getMockSimpleProperties());
            toReturn.put(key, value);
            if (id == 1) {
                value.addSimpleProperty(this.getRandomString(), this.getRandomFactModelTree(toReturn, 0));
            }
            if (id == 2) {
                value.addSimpleProperty(this.getRandomString(), this.getRandomFactModelTree(toReturn, 1));
                value.addSimpleProperty(this.getRandomString(), value.getFactName());
            }
        });
        return toReturn;
    }

    protected SortedMap<String, FactModelTree> getSimpleJavaTypeFieldsMap() {
        TreeMap<String, FactModelTree> toReturn = new TreeMap<String, FactModelTree>();
        for (String key : DataManagementStrategy.SIMPLE_CLASSES_MAP.keySet()) {
            HashMap<String, String> simpleProperties = new HashMap<String, String>();
            String fullName = ((Class)DataManagementStrategy.SIMPLE_CLASSES_MAP.get(key)).getCanonicalName();
            simpleProperties.put("value", fullName);
            String packageName = fullName.substring(0, fullName.lastIndexOf("."));
            FactModelTree value = new FactModelTree(key, packageName, simpleProperties);
            toReturn.put(key, value);
        }
        return toReturn;
    }

    protected Map<String, String> getMockSimpleProperties() {
        HashMap<String, String> toReturn = new HashMap<String, String>();
        IntStream.range(0, 3).forEach(id -> toReturn.put(this.getRandomString(), this.getRandomType()));
        return toReturn;
    }

    protected String getRandomString() {
        String letters = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
        StringBuilder builder = new StringBuilder();
        int numberOfLetters = letters.length();
        Random random = new Random();
        int sizeOfRandomString = random.nextInt(6) + 3;
        IntStream.range(0, sizeOfRandomString).forEach(position -> builder.append(letters.charAt(random.nextInt(numberOfLetters))));
        return builder.toString();
    }

    protected String getRandomType() {
        int type = new Random().nextInt(4);
        switch (type) {
            case 0: {
                return "lava.lang.String";
            }
            case 1: {
                return "byte";
            }
            case 2: {
                return "java.lang.Integer";
            }
            case 3: {
                return "java.lang.Boolean";
            }
        }
        return "int";
    }
}

