/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.commands.actualcommands;

import javax.enterprise.context.Dependent;
import org.drools.workbench.screens.scenariosimulation.client.commands.ScenarioSimulationContext;
import org.drools.workbench.screens.scenariosimulation.client.commands.actualcommands.AbstractScenarioSimulationCommand;
import org.drools.workbench.screens.scenariosimulation.client.metadata.ScenarioHeaderMetaData;
import org.drools.workbench.screens.scenariosimulation.client.resources.i18n.ScenarioSimulationEditorConstants;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGridColumn;
import org.drools.workbench.screens.scenariosimulation.model.FactIdentifier;
import org.drools.workbench.screens.scenariosimulation.model.FactMapping;
import org.drools.workbench.screens.scenariosimulation.model.ScenarioSimulationModel;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;

@Dependent
public class SetInstanceHeaderCommand
extends AbstractScenarioSimulationCommand {
    public SetInstanceHeaderCommand() {
        super(true);
    }

    @Override
    protected void internalExecute(ScenarioSimulationContext context) {
        ScenarioSimulationContext.Status status = context.getStatus();
        ScenarioGridColumn selectedColumn = (ScenarioGridColumn)context.getModel().getSelectedColumn();
        if (selectedColumn == null) {
            return;
        }
        int columnIndex = context.getModel().getColumns().indexOf((Object)selectedColumn);
        String fullPackage = status.getFullPackage();
        if (!fullPackage.endsWith(".")) {
            fullPackage = fullPackage + ".";
        }
        String className = status.getClassName();
        String canonicalClassName = fullPackage + className;
        String nameToUseForCreation = context.getModel().getSimulation().get().getSimulationDescriptor().getType().equals((Object)ScenarioSimulationModel.Type.DMN) ? className : selectedColumn.getInformationHeaderMetaData().getColumnId();
        FactIdentifier factIdentifier = this.getFactIdentifierByColumnTitle(className, context).orElse(FactIdentifier.create((String)nameToUseForCreation, (String)canonicalClassName));
        ScenarioHeaderMetaData informationHeaderMetaData = selectedColumn.getInformationHeaderMetaData();
        informationHeaderMetaData.setTitle(className);
        selectedColumn.setInstanceAssigned(true);
        ScenarioHeaderMetaData propertyHeaderMetaData = selectedColumn.getPropertyHeaderMetaData();
        selectedColumn.setPlaceHolder(ScenarioSimulationEditorConstants.INSTANCE.defineValidType());
        propertyHeaderMetaData.setTitle(FactMapping.getPropertyPlaceHolder((int)columnIndex));
        propertyHeaderMetaData.setReadOnly(false);
        selectedColumn.setFactIdentifier(factIdentifier);
        context.getModel().updateColumnInstance(columnIndex, (GridColumn<?>)selectedColumn);
    }
}

