/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.editor;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.user.client.ui.IsWidget;
import elemental2.dom.DomGlobal;
import java.util.Optional;
import java.util.function.Supplier;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.drools.workbench.screens.scenariosimulation.client.commands.ScenarioSimulationContext;
import org.drools.workbench.screens.scenariosimulation.client.editor.ScenarioSimulationView;
import org.drools.workbench.screens.scenariosimulation.client.editor.strategies.DMNDataManagementStrategy;
import org.drools.workbench.screens.scenariosimulation.client.editor.strategies.DMODataManagementStrategy;
import org.drools.workbench.screens.scenariosimulation.client.editor.strategies.DataManagementStrategy;
import org.drools.workbench.screens.scenariosimulation.client.events.RedoEvent;
import org.drools.workbench.screens.scenariosimulation.client.events.UndoEvent;
import org.drools.workbench.screens.scenariosimulation.client.handlers.ScenarioSimulationDocksHandler;
import org.drools.workbench.screens.scenariosimulation.client.producers.ScenarioSimulationProducer;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.RightPanelView;
import org.drools.workbench.screens.scenariosimulation.client.type.ScenarioSimulationResourceType;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGridPanel;
import org.drools.workbench.screens.scenariosimulation.model.ScenarioSimulationModel;
import org.drools.workbench.screens.scenariosimulation.model.ScenarioSimulationModelContent;
import org.drools.workbench.screens.scenariosimulation.model.Simulation;
import org.drools.workbench.screens.scenariosimulation.service.DMNTypeService;
import org.drools.workbench.screens.scenariosimulation.service.ScenarioSimulationService;
import org.guvnor.common.services.shared.metadata.model.Metadata;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jboss.errai.enterprise.client.jaxrs.MarshallingWrapper;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracleFactory;
import org.kie.workbench.common.widgets.client.menu.FileMenuBuilder;
import org.kie.workbench.common.widgets.configresource.client.widget.bound.ImportsWidgetPresenter;
import org.kie.workbench.common.widgets.metadata.client.KieEditor;
import org.kie.workbench.common.widgets.metadata.client.KieEditorView;
import org.kie.workbench.common.workbench.client.test.TestRunnerReportingScreen;
import org.uberfire.backend.vfs.ObservablePath;
import org.uberfire.backend.vfs.Path;
import org.uberfire.client.annotations.WorkbenchEditor;
import org.uberfire.client.annotations.WorkbenchMenu;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartTitleDecoration;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.mvp.AbstractWorkbenchActivity;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.mvp.PlaceStatus;
import org.uberfire.client.workbench.events.PlaceGainFocusEvent;
import org.uberfire.client.workbench.events.PlaceHiddenEvent;
import org.uberfire.client.workbench.type.ClientResourceType;
import org.uberfire.ext.editor.commons.service.support.SupportsCopy;
import org.uberfire.ext.editor.commons.service.support.SupportsDelete;
import org.uberfire.ext.editor.commons.service.support.SupportsRename;
import org.uberfire.ext.editor.commons.service.support.SupportsSaveAndRename;
import org.uberfire.ext.widgets.common.client.callbacks.HasBusyIndicatorDefaultErrorCallback;
import org.uberfire.ext.widgets.common.client.common.HasBusyIndicator;
import org.uberfire.lifecycle.OnClose;
import org.uberfire.lifecycle.OnMayClose;
import org.uberfire.lifecycle.OnStartup;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;
import org.uberfire.mvp.impl.PathPlaceRequest;
import org.uberfire.workbench.model.menu.Menus;

@Dependent
@WorkbenchEditor(identifier="ScenarioSimulationEditor", supportedTypes={ScenarioSimulationResourceType.class})
public class ScenarioSimulationEditorPresenter
extends KieEditor<ScenarioSimulationModel> {
    public static final String IDENTIFIER = "ScenarioSimulationEditor";
    protected String packageName = "";
    protected ObservablePath path;
    protected EventBus eventBus;
    protected ScenarioGridPanel scenarioGridPanel;
    protected DataManagementStrategy dataManagementStrategy;
    private ImportsWidgetPresenter importsWidget;
    private AsyncPackageDataModelOracleFactory oracleFactory;
    private ScenarioSimulationModel model;
    private Caller<ScenarioSimulationService> service;
    private Caller<DMNTypeService> dmnTypeService;
    private ScenarioSimulationResourceType type;
    private ScenarioSimulationView view;
    protected ScenarioSimulationContext context;
    private Command populateRightPanelCommand;
    private TestRunnerReportingScreen testRunnerReportingScreen;
    private ScenarioSimulationDocksHandler scenarioSimulationDocksHandler;

    public ScenarioSimulationEditorPresenter() {
    }

    @Inject
    public ScenarioSimulationEditorPresenter(Caller<ScenarioSimulationService> service, ScenarioSimulationProducer scenarioSimulationProducer, ScenarioSimulationResourceType type, ImportsWidgetPresenter importsWidget, AsyncPackageDataModelOracleFactory oracleFactory, PlaceManager placeManager, TestRunnerReportingScreen testRunnerReportingScreen, ScenarioSimulationDocksHandler scenarioSimulationDocksHandler, Caller<DMNTypeService> dmnTypeService) {
        super((KieEditorView)scenarioSimulationProducer.getScenarioSimulationView());
        this.testRunnerReportingScreen = testRunnerReportingScreen;
        this.scenarioSimulationDocksHandler = scenarioSimulationDocksHandler;
        this.dmnTypeService = dmnTypeService;
        this.view = (ScenarioSimulationView)this.baseView;
        this.service = service;
        this.type = type;
        this.importsWidget = importsWidget;
        this.oracleFactory = oracleFactory;
        this.placeManager = placeManager;
        this.context = scenarioSimulationProducer.getScenarioSimulationContext();
        this.eventBus = scenarioSimulationProducer.getEventBus();
        this.scenarioGridPanel = this.view.getScenarioGridPanel();
        this.context.setScenarioSimulationEditorPresenter(this);
        this.view.init(this);
        this.populateRightPanelCommand = this.getPopulateRightPanelCommand();
        this.scenarioGridPanel.select();
    }

    @OnStartup
    public void onStartup(ObservablePath path, PlaceRequest place) {
        super.init(path, place, (ClientResourceType)this.type);
        this.path = path;
    }

    @OnClose
    public void onClose() {
        this.versionRecordManager.clear();
        this.scenarioGridPanel.unregister();
    }

    @OnMayClose
    public boolean mayClose() {
        return !this.isDirty();
    }

    @WorkbenchPartTitle
    public String getTitleText() {
        return super.getTitleText();
    }

    @WorkbenchPartTitleDecoration
    public IsWidget getTitle() {
        return super.getTitle();
    }

    @WorkbenchPartView
    public IsWidget getWidget() {
        return super.getWidget();
    }

    @WorkbenchMenu
    public Menus getMenus() {
        return this.menus;
    }

    public void onPlaceGainFocusEvent(@Observes PlaceGainFocusEvent placeGainFocusEvent) {
        if (!(placeGainFocusEvent.getPlace() instanceof PathPlaceRequest)) {
            return;
        }
        PathPlaceRequest placeRequest = (PathPlaceRequest)placeGainFocusEvent.getPlace();
        if (placeRequest.getIdentifier().equals(IDENTIFIER) && placeRequest.getPath().equals(this.path)) {
            this.scenarioSimulationDocksHandler.addDocks();
            this.expandToolsDock();
            this.registerRightPanelCallback();
            this.populateRightPanel();
        }
    }

    public void onPlaceHiddenEvent(@Observes PlaceHiddenEvent placeHiddenEvent) {
        if (!(placeHiddenEvent.getPlace() instanceof PathPlaceRequest)) {
            return;
        }
        PathPlaceRequest placeRequest = (PathPlaceRequest)placeHiddenEvent.getPlace();
        if (placeRequest.getIdentifier().equals(IDENTIFIER) && placeRequest.getPath().equals(this.path)) {
            this.scenarioSimulationDocksHandler.removeDocks();
            this.view.getScenarioGridLayer().getScenarioGrid().clearSelections();
            this.unRegisterRightPanelCallback();
            this.clearRightPanelStatus();
            this.testRunnerReportingScreen.reset();
        }
    }

    public void expandToolsDock() {
        this.scenarioSimulationDocksHandler.expandToolsDock();
    }

    public ScenarioSimulationView getView() {
        return this.view;
    }

    public ScenarioSimulationModel getModel() {
        return this.model;
    }

    public void reloadRightPanel(boolean disable) {
        this.populateRightPanelCommand.execute();
        if (disable) {
            this.getRightPanelPresenter().ifPresent(RightPanelView.Presenter::onDisableEditorTab);
        }
    }

    public void onRunScenario() {
        this.view.getScenarioGridPanel().getScenarioGrid().getModel().resetErrors();
        ((ScenarioSimulationService)this.service.call(this.refreshModel())).runScenario((Path)this.versionRecordManager.getCurrentPath(), this.model);
    }

    public void onUndo() {
        this.eventBus.fireEvent((GwtEvent)new UndoEvent());
    }

    public void onRedo() {
        this.eventBus.fireEvent((GwtEvent)new RedoEvent());
    }

    public void setUndoButtonEnabledStatus(boolean enabled) {
        this.view.getUndoMenuItem().setEnabled(enabled);
    }

    public void setRedoButtonEnabledStatus(boolean enabled) {
        this.view.getRedoMenuItem().setEnabled(enabled);
    }

    public void addDownloadMenuItem(FileMenuBuilder fileMenuBuilder) {
        fileMenuBuilder.addNewTopLevelMenu(this.view.getDownloadMenuItem(this.getPathSupplier()));
    }

    protected RemoteCallback<ScenarioSimulationModel> refreshModel() {
        return this::refreshModelContent;
    }

    protected void refreshModelContent(ScenarioSimulationModel newModel) {
        this.model = newModel;
        Simulation simulation = newModel.getSimulation();
        this.view.refreshContent(simulation);
        this.context.getStatus().setSimulation(simulation);
        this.scenarioSimulationDocksHandler.expandTestResultsDock();
    }

    protected void registerRightPanelCallback() {
        this.placeManager.registerOnOpenCallback((PlaceRequest)new DefaultPlaceRequest("org.drools.scenariosimulation.RightPanel"), this.populateRightPanelCommand);
    }

    protected void unRegisterRightPanelCallback() {
        this.placeManager.getOnOpenCallbacks((PlaceRequest)new DefaultPlaceRequest("org.drools.scenariosimulation.RightPanel")).remove(this.populateRightPanelCommand);
    }

    protected void makeMenuBar() {
        this.fileMenuBuilder.addNewTopLevelMenu(this.view.getRunScenarioMenuItem());
        this.fileMenuBuilder.addNewTopLevelMenu(this.view.getUndoMenuItem());
        this.fileMenuBuilder.addNewTopLevelMenu(this.view.getRedoMenuItem());
        this.view.getUndoMenuItem().setEnabled(false);
        this.view.getRedoMenuItem().setEnabled(false);
        super.makeMenuBar();
    }

    protected Supplier<ScenarioSimulationModel> getContentSupplier() {
        return () -> this.model;
    }

    protected void save(String commitMessage) {
        ((ScenarioSimulationService)this.service.call(this.getSaveSuccessCallback(this.getJsonModel(this.model).hashCode()), (ErrorCallback)new HasBusyIndicatorDefaultErrorCallback((HasBusyIndicator)this.baseView))).save((Path)this.versionRecordManager.getCurrentPath(), (Object)this.model, (Object)this.metadata, commitMessage);
    }

    protected void addCommonActions(FileMenuBuilder fileMenuBuilder) {
        fileMenuBuilder.addNewTopLevelMenu(this.versionRecordManager.buildMenu()).addNewTopLevelMenu(this.alertsButtonMenuItemBuilder.build());
    }

    protected void loadContent() {
        ((ScenarioSimulationService)this.service.call(this.getModelSuccessCallback(), (ErrorCallback)this.getNoSuchFileExceptionErrorCallback())).loadContent((Path)this.versionRecordManager.getCurrentPath());
    }

    protected void onDownload(Supplier<Path> pathSupplier) {
        String downloadURL = this.getFileDownloadURL(pathSupplier);
        this.open(downloadURL);
    }

    protected void open(String downloadURL) {
        DomGlobal.window.open((Object)downloadURL);
    }

    protected void populateRightPanel() {
        if (this.dataManagementStrategy != null) {
            this.getRightPanelPresenter().ifPresent(presenter -> {
                this.context.setRightPanelPresenter((RightPanelView.Presenter)presenter);
                presenter.setEventBus(this.eventBus);
                this.dataManagementStrategy.populateRightPanel((RightPanelView.Presenter)presenter, this.scenarioGridPanel.getScenarioGrid().getModel());
            });
        }
    }

    protected void clearRightPanelStatus() {
        this.getRightPanelPresenter().ifPresent(RightPanelView.Presenter::onClearStatus);
    }

    protected String getJsonModel(ScenarioSimulationModel model) {
        return MarshallingWrapper.toJSON((Object)model);
    }

    private String getFileDownloadURL(Supplier<Path> pathSupplier) {
        return GWT.getModuleBaseURL() + "defaulteditor/download?path=" + pathSupplier.get().toURI();
    }

    private RemoteCallback<ScenarioSimulationModelContent> getModelSuccessCallback() {
        return content -> {
            if (this.versionRecordManager.getCurrentPath() == null) {
                return;
            }
            this.packageName = content.getDataModel().getPackageName();
            this.resetEditorPages(content.getOverview());
            this.dataManagementStrategy = ScenarioSimulationModel.Type.RULE.equals((Object)content.getModel().getSimulation().getSimulationDescriptor().getType()) ? new DMODataManagementStrategy(this.oracleFactory) : new DMNDataManagementStrategy(this.dmnTypeService);
            this.dataManagementStrategy.manageScenarioSimulationModelContent(this.versionRecordManager.getCurrentPath(), (ScenarioSimulationModelContent)content);
            this.populateRightPanel();
            this.model = content.getModel();
            if (this.dataManagementStrategy instanceof DMODataManagementStrategy) {
                this.importsWidget.setContent(((DMODataManagementStrategy)this.dataManagementStrategy).getOracle(), this.model.getImports(), this.isReadOnly);
                this.addImportsTab((IsWidget)this.importsWidget);
            }
            this.baseView.hideBusyIndicator();
            this.view.setContent(this.model.getSimulation());
            this.setOriginalHash(this.getJsonModel(this.model).hashCode());
        };
    }

    private Optional<RightPanelView> getRightPanelView() {
        DefaultPlaceRequest placeRequest = new DefaultPlaceRequest("org.drools.scenariosimulation.RightPanel");
        if (PlaceStatus.OPEN.equals((Object)this.placeManager.getStatus((PlaceRequest)placeRequest))) {
            AbstractWorkbenchActivity rightPanelActivity = (AbstractWorkbenchActivity)this.placeManager.getActivity((PlaceRequest)placeRequest);
            return Optional.of((RightPanelView)rightPanelActivity.getWidget());
        }
        return Optional.empty();
    }

    private Optional<RightPanelView.Presenter> getRightPanelPresenter() {
        return this.getRightPanelView().isPresent() ? Optional.of(this.getRightPanelView().get().getPresenter()) : Optional.empty();
    }

    private Command getPopulateRightPanelCommand() {
        return this::populateRightPanel;
    }

    protected boolean isDirty() {
        try {
            this.view.getScenarioGridPanel().getScenarioGrid().getModel().resetErrors();
            int currentHashcode = MarshallingWrapper.toJSON((Object)this.model).hashCode();
            return this.originalHash != currentHashcode;
        }
        catch (Exception ignored) {
            return false;
        }
    }

    protected Caller<? extends SupportsDelete> getDeleteServiceCaller() {
        return this.service;
    }

    protected Caller<? extends SupportsRename> getRenameServiceCaller() {
        return this.service;
    }

    protected Caller<? extends SupportsCopy> getCopyServiceCaller() {
        return this.service;
    }

    protected Caller<? extends SupportsSaveAndRename<ScenarioSimulationModel, Metadata>> getSaveAndRenameServiceCaller() {
        return this.service;
    }
}

