/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.rightpanel;

import com.google.gwt.dom.client.DivElement;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.FieldItemPresenter;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.FieldItemView;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.ListGroupItemView;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.RightPanelView;
import org.drools.workbench.screens.scenariosimulation.client.utils.ViewsProvider;
import org.drools.workbench.screens.scenariosimulation.model.typedescriptor.FactModelTree;

@Dependent
public class ListGroupItemPresenter
implements ListGroupItemView.Presenter {
    @Inject
    protected ViewsProvider viewsProvider;
    @Inject
    protected FieldItemPresenter fieldItemPresenter;
    protected RightPanelView.Presenter rightPanelPresenter;
    protected Map<String, ListGroupItemView> listGroupItemViewMap = new HashMap<String, ListGroupItemView>();
    private AtomicBoolean disabled = new AtomicBoolean(true);
    private String factName = null;

    @Override
    public void enable() {
        this.disabled.set(false);
        this.factName = null;
        this.listGroupItemViewMap.values().forEach(ListGroupItemView::disable);
    }

    @Override
    public void enable(String factName) {
        this.disabled.set(false);
        this.factName = factName;
        this.listGroupItemViewMap.values().forEach(ListGroupItemView::enable);
    }

    @Override
    public void unselectAll() {
        this.listGroupItemViewMap.values().forEach(ListGroupItemView::unselect);
    }

    @Override
    public void selectProperty(String factName, String propertyName) {
        String key;
        ListGroupItemView subListGroupItemView;
        ListGroupItemView listGroupItemView = this.listGroupItemViewMap.get(factName);
        if (!listGroupItemView.isShown()) {
            this.onToggleRowExpansion(listGroupItemView, false);
        }
        if (propertyName.contains(".") && !(subListGroupItemView = this.listGroupItemViewMap.get(key = factName + "." + propertyName.substring(0, propertyName.indexOf(".")))).isShown()) {
            this.onToggleRowExpansion(subListGroupItemView, false);
        }
        if (this.fieldItemPresenter.fieldItemMap.containsKey(key = factName + "." + propertyName)) {
            this.fieldItemPresenter.fieldItemMap.get(key).onFieldElementClick();
        }
    }

    @Override
    public void disable() {
        this.disabled.set(true);
        this.factName = null;
        this.listGroupItemViewMap.values().forEach(ListGroupItemView::closeRow);
        this.unselectAll();
        this.fieldItemPresenter.unselectAll();
    }

    @Override
    public void init(RightPanelView.Presenter rightPanelPresenter) {
        this.rightPanelPresenter = rightPanelPresenter;
        this.fieldItemPresenter.setListGroupItemPresenter(this);
    }

    @Override
    public DivElement getDivElement(String factName, FactModelTree factModelTree) {
        if (this.listGroupItemViewMap.containsKey(factName)) {
            return this.listGroupItemViewMap.get(factName).getListGroupItem();
        }
        ListGroupItemView listGroupItemView = this.commonGetListGroupItemView("", factName, false);
        this.populateListGroupItemView(listGroupItemView, "", factName, factModelTree);
        return listGroupItemView.getListGroupItem();
    }

    @Override
    public DivElement getDivElement(String fullPath, String factName, String factModelTreeClass) {
        String key;
        String string = key = fullPath.isEmpty() ? factName : fullPath + "." + factName;
        if (this.listGroupItemViewMap.containsKey(key)) {
            return this.listGroupItemViewMap.get(key).getListGroupItem();
        }
        ListGroupItemView listGroupItemView = this.commonGetListGroupItemView(fullPath, factName, true);
        this.populateListGroupItemView(listGroupItemView, factName, factModelTreeClass);
        return listGroupItemView.getListGroupExpansion();
    }

    @Override
    public void onToggleRowExpansion(ListGroupItemView listGroupItemView, boolean currentlyShown) {
        if (this.disabled.get()) {
            return;
        }
        if (currentlyShown) {
            listGroupItemView.closeRow();
        } else {
            if (listGroupItemView.isToExpand()) {
                FactModelTree factModelTree = this.rightPanelPresenter.getFactModelTreeFromFactTypeMap(listGroupItemView.getFactType()).orElse(this.rightPanelPresenter.getFactModelTreeFromHiddenMap(listGroupItemView.getFactType()));
                if (factModelTree != null) {
                    this.populateListGroupItemView(listGroupItemView, listGroupItemView.getParentPath(), listGroupItemView.getFactName(), factModelTree);
                    listGroupItemView.setToExpand(false);
                }
                if (this.factName != null) {
                    listGroupItemView.disable();
                } else {
                    listGroupItemView.enable();
                }
            }
            listGroupItemView.expandRow();
        }
    }

    @Override
    public void onSelectedElement(ListGroupItemView selected) {
        this.rightPanelPresenter.setSelectedElement(selected);
        this.listGroupItemViewMap.values().stream().filter(listGroupItemView -> !listGroupItemView.equals(selected)).forEach(ListGroupItemView::unselect);
        this.fieldItemPresenter.unselectAll();
    }

    @Override
    public void onSelectedElement(FieldItemView selected) {
        this.rightPanelPresenter.setSelectedElement(selected);
        this.listGroupItemViewMap.values().forEach(ListGroupItemView::unselect);
    }

    protected void populateListGroupItemView(ListGroupItemView toPopulate, String parentPath, String factName, FactModelTree factModelTree) {
        if (factName.equals(factModelTree.getFactName())) {
            toPopulate.setFactName(factName);
        } else {
            toPopulate.setFactNameAndType(factName, factModelTree.getFactName());
        }
        String fullPath = parentPath.isEmpty() ? factName : parentPath + "." + factName;
        factModelTree.getSimpleProperties().forEach((key, value) -> toPopulate.addFactField(this.fieldItemPresenter.getLIElement(fullPath, factName, (String)key, (String)value)));
        factModelTree.getExpandableProperties().forEach((key, value) -> toPopulate.addExpandableFactField(this.getDivElement(fullPath, (String)key, (String)value)));
    }

    protected void populateListGroupItemView(ListGroupItemView toPopulate, String factName, String factType) {
        toPopulate.setFactNameAndType(factName, factType);
    }

    protected ListGroupItemView commonGetListGroupItemView(String parentPath, String factName, boolean toExpand) {
        String key = parentPath.isEmpty() ? factName : parentPath + "." + factName;
        ListGroupItemView toReturn = this.viewsProvider.getListGroupItemView();
        toReturn.init(this);
        toReturn.setToExpand(toExpand);
        toReturn.setParentPath(parentPath);
        this.listGroupItemViewMap.put(key, toReturn);
        return toReturn;
    }
}

