/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.commands.actualcommands;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Map;
import java.util.SortedMap;
import org.drools.workbench.screens.scenariosimulation.client.commands.ScenarioSimulationContext;
import org.drools.workbench.screens.scenariosimulation.client.commands.actualcommands.AbstractScenarioSimulationCommand;
import org.drools.workbench.screens.scenariosimulation.client.commands.actualcommands.AbstractScenarioSimulationCommandTest;
import org.drools.workbench.screens.scenariosimulation.client.commands.actualcommands.SetHeaderCellValueCommand;
import org.drools.workbench.screens.scenariosimulation.client.models.ScenarioGridModel;
import org.drools.workbench.screens.scenariosimulation.model.SimulationDescriptor;
import org.drools.workbench.screens.scenariosimulation.model.typedescriptor.FactModelTree;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=GwtMockitoTestRunner.class)
public class SetHeaderCellValueCommandTest
extends AbstractScenarioSimulationCommandTest {
    @Override
    @Before
    public void setup() {
        super.setup();
        this.command = (AbstractScenarioSimulationCommand)Mockito.spy((Object)new SetHeaderCellValueCommand());
        this.scenarioSimulationContextLocal.getStatus().setRowIndex(2);
        this.scenarioSimulationContextLocal.getStatus().setColumnIndex(3);
        this.scenarioSimulationContextLocal.getStatus().setCellValue("value");
        Assert.assertTrue((boolean)this.command.isUndoable());
    }

    @Test
    public void executeInstanceHeaderValid() {
        this.commonExecute(true, false, true);
    }

    @Test
    public void executeInstanceHeaderInvalid() {
        this.commonExecute(true, false, false);
    }

    @Test
    public void executePropertyHeaderValid() {
        this.commonExecute(false, true, true);
    }

    @Test
    public void executePropertyHeaderInvalid() {
        this.commonExecute(false, true, false);
    }

    @Test
    public void executeOtherHeader() {
        this.commonExecute(false, false, false);
    }

    @Test
    public void validateInstanceHeader() {
        this.commonValidateInstanceHeader(false);
        this.commonValidateInstanceHeader(true);
    }

    @Test
    public void validatePropertyHeaderNoFactModelMapped() {
        this.commonValidatePropertyHeader(false, false);
    }

    @Test
    public void validatePropertyHeaderFactModelMappedNoProperty() {
        this.commonValidatePropertyHeader(true, true);
    }

    @Test
    public void validatePropertyHeaderFactModelMappedProperty() {
        this.commonValidatePropertyHeader(true, true);
    }

    private void commonExecute(boolean isInstanceHeader, boolean isPropertyHeader, boolean isValid) {
        ((SetHeaderCellValueCommand)this.command).isInstanceHeader = isInstanceHeader;
        ((SetHeaderCellValueCommand)this.command).isPropertyHeader = isPropertyHeader;
        ((SetHeaderCellValueCommand)Mockito.doReturn((Object)isValid).when((Object)((SetHeaderCellValueCommand)this.command))).validateInstanceHeader((ScenarioSimulationContext)Matchers.eq((Object)this.scenarioSimulationContextLocal), (String)Matchers.eq((Object)"value"), Matchers.eq((int)3));
        ((SetHeaderCellValueCommand)Mockito.doReturn((Object)isValid).when((Object)((SetHeaderCellValueCommand)this.command))).validatePropertyHeader((ScenarioSimulationContext)Matchers.eq((Object)this.scenarioSimulationContextLocal), (String)Matchers.eq((Object)"value"), Matchers.eq((int)3));
        this.command.execute(this.scenarioSimulationContextLocal);
        if (isInstanceHeader) {
            ((SetHeaderCellValueCommand)Mockito.verify((Object)((SetHeaderCellValueCommand)this.command), (VerificationMode)Mockito.times((int)1))).validateInstanceHeader((ScenarioSimulationContext)Matchers.eq((Object)this.scenarioSimulationContextLocal), (String)Matchers.eq((Object)"value"), Matchers.eq((int)3));
        } else if (isPropertyHeader) {
            ((SetHeaderCellValueCommand)Mockito.verify((Object)((SetHeaderCellValueCommand)this.command), (VerificationMode)Mockito.times((int)1))).validatePropertyHeader((ScenarioSimulationContext)Matchers.eq((Object)this.scenarioSimulationContextLocal), (String)Matchers.eq((Object)"value"), Matchers.eq((int)3));
        } else {
            ((SetHeaderCellValueCommand)Mockito.verify((Object)((SetHeaderCellValueCommand)this.command), (VerificationMode)Mockito.never())).validateInstanceHeader((ScenarioSimulationContext)Matchers.eq((Object)this.scenarioSimulationContextLocal), (String)Matchers.eq((Object)"value"), Matchers.eq((int)3));
            ((SetHeaderCellValueCommand)Mockito.verify((Object)((SetHeaderCellValueCommand)this.command), (VerificationMode)Mockito.never())).validateInstanceHeader((ScenarioSimulationContext)Matchers.eq((Object)this.scenarioSimulationContextLocal), (String)Matchers.eq((Object)"value"), Matchers.eq((int)3));
        }
        if (isValid) {
            ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModelMock, (VerificationMode)Mockito.times((int)1))).updateHeader(Matchers.eq((int)3), Matchers.eq((int)2), (String)Matchers.eq((Object)"value"));
        }
    }

    private void commonValidateInstanceHeader(boolean isADataType) {
        ((SortedMap)Mockito.doReturn((Object)isADataType).when((Object)this.dataObjectFieldsMapMock)).containsKey("value");
        ((SetHeaderCellValueCommand)this.command).validateInstanceHeader(this.scenarioSimulationContextLocal, "value", 3);
        ((SortedMap)Mockito.verify((Object)this.dataObjectFieldsMapMock, (VerificationMode)Mockito.times((int)1))).containsKey(Matchers.eq((Object)"value"));
        ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModelMock, (VerificationMode)Mockito.times((int)1))).validateInstanceHeaderUpdate((String)Matchers.eq((Object)"value"), Matchers.eq((int)3), Matchers.eq((boolean)isADataType));
        Mockito.reset((Object[])new SortedMap[]{this.dataObjectFieldsMapMock});
        Mockito.reset((Object[])new ScenarioGridModel[]{this.scenarioGridModelMock});
    }

    private void commonValidatePropertyHeader(boolean factModelPresent, boolean simplePropertyPresent) {
        FactModelTree factModelTreeMock = (FactModelTree)Mockito.mock(FactModelTree.class);
        if (factModelPresent) {
            Map simplePropertiesMock = (Map)Mockito.mock(SortedMap.class);
            Mockito.when((Object)factModelTreeMock.getSimpleProperties()).thenReturn((Object)simplePropertiesMock);
            Mockito.when((Object)factModelTreeMock.getExpandableProperties()).thenReturn(Mockito.mock(SortedMap.class));
            Mockito.when(this.dataObjectFieldsMapMock.get(Matchers.anyString())).thenReturn((Object)factModelTreeMock);
            ((Map)Mockito.doReturn((Object)simplePropertyPresent).when((Object)simplePropertiesMock)).containsKey(Matchers.eq((Object)"value"));
        } else {
            Mockito.when(this.dataObjectFieldsMapMock.get(Matchers.anyString())).thenReturn(null);
        }
        boolean isPropertyType = factModelPresent && simplePropertyPresent;
        ((SetHeaderCellValueCommand)this.command).validatePropertyHeader(this.scenarioSimulationContextLocal, "value", 3);
        ((SimulationDescriptor)Mockito.verify((Object)this.simulationDescriptorMock, (VerificationMode)Mockito.times((int)1))).getFactMappingByIndex(Matchers.eq((int)3));
        ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModelMock, (VerificationMode)Mockito.times((int)1))).validatePropertyHeaderUpdate((String)Matchers.eq((Object)"value"), Matchers.eq((int)3), Matchers.eq((boolean)isPropertyType));
        Mockito.reset((Object[])new SimulationDescriptor[]{this.simulationDescriptorMock});
        Mockito.reset((Object[])new ScenarioGridModel[]{this.scenarioGridModelMock});
    }
}

