/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.editor;

import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import junit.framework.TestCase;
import org.drools.workbench.screens.scenariosimulation.client.commands.ScenarioSimulationContext;
import org.drools.workbench.screens.scenariosimulation.client.editor.AbstractScenarioSimulationEditorTest;
import org.drools.workbench.screens.scenariosimulation.client.editor.ScenarioMenuItem;
import org.drools.workbench.screens.scenariosimulation.client.editor.ScenarioSimulationEditorPresenter;
import org.drools.workbench.screens.scenariosimulation.client.editor.ScenarioSimulationView;
import org.drools.workbench.screens.scenariosimulation.client.editor.strategies.DataManagementStrategy;
import org.drools.workbench.screens.scenariosimulation.client.events.RedoEvent;
import org.drools.workbench.screens.scenariosimulation.client.events.UndoEvent;
import org.drools.workbench.screens.scenariosimulation.client.handlers.ScenarioSimulationDocksHandler;
import org.drools.workbench.screens.scenariosimulation.client.models.ScenarioGridModel;
import org.drools.workbench.screens.scenariosimulation.client.producers.ScenarioSimulationProducer;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.RightPanelPresenter;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.RightPanelView;
import org.drools.workbench.screens.scenariosimulation.client.type.ScenarioSimulationResourceType;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGrid;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGridLayer;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGridPanel;
import org.drools.workbench.screens.scenariosimulation.model.Scenario;
import org.drools.workbench.screens.scenariosimulation.model.ScenarioSimulationModel;
import org.drools.workbench.screens.scenariosimulation.model.ScenarioSimulationModelContent;
import org.drools.workbench.screens.scenariosimulation.model.Simulation;
import org.drools.workbench.screens.scenariosimulation.model.SimulationDescriptor;
import org.drools.workbench.screens.scenariosimulation.service.ScenarioSimulationService;
import org.guvnor.common.services.shared.metadata.model.Overview;
import org.guvnor.messageconsole.client.console.widget.button.AlertsButtonMenuItemBuilder;
import org.jboss.errai.common.client.api.Caller;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.soup.project.datamodel.imports.HasImports;
import org.kie.workbench.common.services.datamodel.model.PackageDataModelOracleBaselinePayload;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracle;
import org.kie.workbench.common.widgets.client.menu.FileMenuBuilder;
import org.kie.workbench.common.widgets.configresource.client.widget.bound.ImportsWidgetPresenter;
import org.kie.workbench.common.widgets.metadata.client.KieEditorWrapperView;
import org.kie.workbench.common.widgets.metadata.client.widget.OverviewWidgetPresenter;
import org.kie.workbench.common.workbench.client.test.TestRunnerReportingScreen;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.backend.vfs.ObservablePath;
import org.uberfire.backend.vfs.Path;
import org.uberfire.client.mvp.AbstractWorkbenchActivity;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.mvp.PlaceStatus;
import org.uberfire.client.workbench.events.PlaceGainFocusEvent;
import org.uberfire.client.workbench.events.PlaceHiddenEvent;
import org.uberfire.ext.editor.commons.client.history.VersionRecordManager;
import org.uberfire.ext.editor.commons.client.validation.DefaultFileNameValidator;
import org.uberfire.mocks.CallerMock;
import org.uberfire.mocks.EventSourceMock;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.PathPlaceRequest;
import org.uberfire.workbench.events.NotificationEvent;
import org.uberfire.workbench.model.menu.MenuItem;

@RunWith(value=GwtMockitoTestRunner.class)
public class ScenarioSimulationEditorPresenterTest
extends AbstractScenarioSimulationEditorTest {
    private ScenarioSimulationEditorPresenter presenter;
    private ScenarioSimulationEditorPresenter presenterSpy;
    @Mock
    private KieEditorWrapperView kieViewMock;
    @Mock
    private OverviewWidgetPresenter overviewWidgetPresenterMock;
    @Mock
    private DefaultFileNameValidator fileNameValidatorMock;
    @Mock
    private AlertsButtonMenuItemBuilder alertsButtonMenuItemBuilderMock;
    @Mock
    private EventSourceMock<NotificationEvent> notificationMock;
    @Mock
    private ScenarioGrid scenarioGridMock;
    @Mock
    private ScenarioGridLayer scenarioGridLayerMock;
    @Mock
    private ScenarioSimulationView scenarioSimulationViewMock;
    @Mock
    private ScenarioGridModel scenarioGridModelMock;
    @Mock
    private ScenarioSimulationProducer scenarioSimulationProducerMock;
    @Mock
    private ImportsWidgetPresenter importsWidgetPresenterMock;
    @Mock
    private PlaceManager placeManagerMock;
    @Mock
    private AbstractWorkbenchActivity rightPanelActivityMock;
    @Mock
    private RightPanelView rightPanelViewMock;
    @Mock
    private ObservablePath pathMock;
    @Mock
    private PathPlaceRequest placeRequestMock;
    @Mock
    private ScenarioSimulationContext contextMock;
    @Mock
    private ScenarioSimulationContext.Status statusMock;
    @Mock
    private TestRunnerReportingScreen testRunnerReportingScreenMock;
    @Mock
    private ScenarioSimulationDocksHandler scenarioSimulationDocksHandlerMock;
    @Mock
    private ScenarioMenuItem runScenarioMenuItemMock;
    @Mock
    private ScenarioMenuItem undoMenuItemMock;
    @Mock
    private ScenarioMenuItem redoMenuItemMock;
    @Mock
    private DataManagementStrategy dataManagementStrategyMock;

    @Override
    @Before
    public void setup() {
        super.setup();
        Mockito.when((Object)this.scenarioGridLayerMock.getScenarioGrid()).thenReturn((Object)this.scenarioGridMock);
        Mockito.when((Object)this.scenarioSimulationViewMock.getScenarioGridPanel()).thenReturn((Object)this.scenarioGridPanelMock);
        Mockito.when((Object)this.scenarioSimulationViewMock.getScenarioGridLayer()).thenReturn((Object)this.scenarioGridLayerMock);
        Mockito.when((Object)this.scenarioSimulationViewMock.getRunScenarioMenuItem()).thenReturn((Object)this.runScenarioMenuItemMock);
        Mockito.when((Object)this.scenarioSimulationViewMock.getUndoMenuItem()).thenReturn((Object)this.undoMenuItemMock);
        Mockito.when((Object)this.scenarioSimulationViewMock.getRedoMenuItem()).thenReturn((Object)this.redoMenuItemMock);
        Mockito.when((Object)this.scenarioGridPanelMock.getScenarioGrid()).thenReturn((Object)this.scenarioGridMock);
        Mockito.when((Object)this.scenarioGridMock.getModel()).thenReturn((Object)this.scenarioGridModelMock);
        Mockito.when((Object)this.scenarioSimulationProducerMock.getScenarioSimulationView()).thenReturn((Object)this.scenarioSimulationViewMock);
        Mockito.when((Object)this.scenarioSimulationProducerMock.getScenarioSimulationContext()).thenReturn((Object)this.contextMock);
        Mockito.when((Object)this.placeRequestMock.getIdentifier()).thenReturn((Object)"ScenarioSimulationEditor");
        Mockito.when((Object)this.rightPanelViewMock.getPresenter()).thenReturn((Object)this.rightPanelPresenterMock);
        Mockito.when((Object)this.rightPanelActivityMock.getWidget()).thenReturn((Object)this.rightPanelViewMock);
        Mockito.when((Object)this.placeRequestMock.getPath()).thenReturn((Object)this.pathMock);
        Mockito.when((Object)this.contextMock.getStatus()).thenReturn((Object)this.statusMock);
        this.presenter = new ScenarioSimulationEditorPresenter((Caller)new CallerMock((Object)this.scenarioSimulationServiceMock), this.scenarioSimulationProducerMock, (ScenarioSimulationResourceType)Mockito.mock(ScenarioSimulationResourceType.class), this.importsWidgetPresenterMock, this.oracleFactoryMock, this.placeManagerMock, this.testRunnerReportingScreenMock, this.scenarioSimulationDocksHandlerMock, (Caller)new CallerMock((Object)this.dmnTypeServiceMock)){
            {
                this.kieView = ScenarioSimulationEditorPresenterTest.this.kieViewMock;
                this.overviewWidget = ScenarioSimulationEditorPresenterTest.this.overviewWidgetPresenterMock;
                this.fileMenuBuilder = ScenarioSimulationEditorPresenterTest.this.fileMenuBuilderMock;
                this.fileNameValidator = ScenarioSimulationEditorPresenterTest.this.fileNameValidatorMock;
                this.versionRecordManager = ScenarioSimulationEditorPresenterTest.this.versionRecordManagerMock;
                this.notification = ScenarioSimulationEditorPresenterTest.this.notificationMock;
                this.workbenchContext = ScenarioSimulationEditorPresenterTest.this.workbenchContextMock;
                this.alertsButtonMenuItemBuilder = ScenarioSimulationEditorPresenterTest.this.alertsButtonMenuItemBuilderMock;
                this.path = ScenarioSimulationEditorPresenterTest.this.pathMock;
                this.scenarioGridPanel = ScenarioSimulationEditorPresenterTest.this.scenarioGridPanelMock;
                this.packageName = "scenario.package";
                this.eventBus = ScenarioSimulationEditorPresenterTest.this.eventBusMock;
                this.context = ScenarioSimulationEditorPresenterTest.this.contextMock;
                this.dataManagementStrategy = ScenarioSimulationEditorPresenterTest.this.dataManagementStrategyMock;
                this.model = ScenarioSimulationEditorPresenterTest.this.scenarioSimulationModelMock;
            }

            protected MenuItem downloadMenuItem() {
                return (MenuItem)Mockito.mock(MenuItem.class);
            }

            protected Command getSaveAndRename() {
                return (Command)Mockito.mock(Command.class);
            }

            protected void populateRightPanel() {
            }

            protected void clearRightPanelStatus() {
            }

            protected String getJsonModel(ScenarioSimulationModel model) {
                return "";
            }
        };
        this.presenterSpy = (ScenarioSimulationEditorPresenter)Mockito.spy((Object)this.presenter);
    }

    @Test
    public void testPresenterInit() throws Exception {
        ((ScenarioSimulationView)Mockito.verify((Object)this.scenarioSimulationViewMock)).init(this.presenter);
    }

    @Test
    public void testOnStartup() {
        AsyncPackageDataModelOracle oracle = (AsyncPackageDataModelOracle)Mockito.mock(AsyncPackageDataModelOracle.class);
        Mockito.when((Object)this.oracleFactoryMock.makeAsyncPackageDataModelOracle((Path)Mockito.any(), (HasImports)Matchers.eq((Object)this.modelLocal), (PackageDataModelOracleBaselinePayload)Matchers.eq((Object)this.content.getDataModel()))).thenReturn((Object)oracle);
        this.presenter.onStartup((ObservablePath)Mockito.mock(ObservablePath.class), (PlaceRequest)Mockito.mock(PlaceRequest.class));
        ((ImportsWidgetPresenter)Mockito.verify((Object)this.importsWidgetPresenterMock)).setContent(oracle, this.modelLocal.getImports(), false);
        ((KieEditorWrapperView)Mockito.verify((Object)this.kieViewMock)).addImportsTab((IsWidget)this.importsWidgetPresenterMock);
        ((ScenarioSimulationView)Mockito.verify((Object)this.scenarioSimulationViewMock)).showLoading();
        ((ScenarioSimulationView)Mockito.verify((Object)this.scenarioSimulationViewMock)).hideBusyIndicator();
    }

    @Test
    public void validateButtonShouldNotBeAdded() {
        this.presenter.onStartup((ObservablePath)Mockito.mock(ObservablePath.class), (PlaceRequest)Mockito.mock(PlaceRequest.class));
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.presenterSpy, (VerificationMode)Mockito.never())).getValidateCommand();
    }

    @Test
    public void runScenarioButtonIsAdded() throws Exception {
        MenuItem menuItem = (MenuItem)Mockito.mock(MenuItem.class);
        ((ScenarioSimulationView)Mockito.doReturn((Object)menuItem).when((Object)this.scenarioSimulationViewMock)).getRunScenarioMenuItem();
        this.presenter.onStartup((ObservablePath)Mockito.mock(ObservablePath.class), (PlaceRequest)Mockito.mock(PlaceRequest.class));
        ((FileMenuBuilder)Mockito.verify((Object)this.fileMenuBuilderMock)).addNewTopLevelMenu(menuItem);
    }

    @Test
    public void onUndo() {
        this.presenter.onUndo();
        ((EventBus)Mockito.verify((Object)this.eventBusMock, (VerificationMode)Mockito.times((int)1))).fireEvent((GwtEvent)Matchers.isA(UndoEvent.class));
    }

    @Test
    public void onRedo() {
        this.presenter.onRedo();
        ((EventBus)Mockito.verify((Object)this.eventBusMock, (VerificationMode)Mockito.times((int)1))).fireEvent((GwtEvent)Matchers.isA(RedoEvent.class));
    }

    @Test
    public void setUndoButtonEnabledStatus() {
        this.presenter.setUndoButtonEnabledStatus(true);
        ((ScenarioMenuItem)Mockito.verify((Object)this.undoMenuItemMock, (VerificationMode)Mockito.times((int)1))).setEnabled(Matchers.eq((boolean)true));
        Mockito.reset((Object[])new ScenarioMenuItem[]{this.undoMenuItemMock});
        this.presenter.setUndoButtonEnabledStatus(false);
        ((ScenarioMenuItem)Mockito.verify((Object)this.undoMenuItemMock, (VerificationMode)Mockito.times((int)1))).setEnabled(Matchers.eq((boolean)false));
    }

    @Test
    public void setRedoButtonEnabledStatus() {
        this.presenter.setRedoButtonEnabledStatus(true);
        ((ScenarioMenuItem)Mockito.verify((Object)this.redoMenuItemMock, (VerificationMode)Mockito.times((int)1))).setEnabled(Matchers.eq((boolean)true));
        Mockito.reset((Object[])new ScenarioMenuItem[]{this.redoMenuItemMock});
        this.presenter.setRedoButtonEnabledStatus(false);
        ((ScenarioMenuItem)Mockito.verify((Object)this.redoMenuItemMock, (VerificationMode)Mockito.times((int)1))).setEnabled(Matchers.eq((boolean)false));
    }

    @Test
    public void makeMenuBar() {
        this.presenter.makeMenuBar();
        ((FileMenuBuilder)Mockito.verify((Object)this.fileMenuBuilderMock, (VerificationMode)Mockito.times((int)1))).addNewTopLevelMenu((MenuItem)this.runScenarioMenuItemMock);
        ((FileMenuBuilder)Mockito.verify((Object)this.fileMenuBuilderMock, (VerificationMode)Mockito.times((int)1))).addNewTopLevelMenu((MenuItem)this.undoMenuItemMock);
        ((FileMenuBuilder)Mockito.verify((Object)this.fileMenuBuilderMock, (VerificationMode)Mockito.times((int)1))).addNewTopLevelMenu((MenuItem)this.redoMenuItemMock);
        ((ScenarioMenuItem)Mockito.verify((Object)this.undoMenuItemMock, (VerificationMode)Mockito.times((int)1))).setEnabled(Matchers.eq((boolean)false));
        ((ScenarioMenuItem)Mockito.verify((Object)this.redoMenuItemMock, (VerificationMode)Mockito.times((int)1))).setEnabled(Matchers.eq((boolean)false));
    }

    @Test
    public void save() {
        this.presenter.onStartup((ObservablePath)Mockito.mock(ObservablePath.class), (PlaceRequest)Mockito.mock(PlaceRequest.class));
        Mockito.reset((Object[])new ScenarioSimulationView[]{this.scenarioSimulationViewMock});
        this.presenter.save("save message");
        ((ScenarioSimulationView)Mockito.verify((Object)this.scenarioSimulationViewMock)).hideBusyIndicator();
        ((EventSourceMock)Mockito.verify(this.notificationMock)).fire(Mockito.any(NotificationEvent.class));
        ((VersionRecordManager)Mockito.verify((Object)this.versionRecordManagerMock)).reloadVersions((Path)Mockito.any(Path.class));
    }

    @Test
    public void onPlaceGainFocusEvent() {
        PlaceGainFocusEvent mockPlaceGainFocusEvent = (PlaceGainFocusEvent)Mockito.mock(PlaceGainFocusEvent.class);
        Mockito.when((Object)mockPlaceGainFocusEvent.getPlace()).thenReturn((Object)this.placeRequestMock);
        Mockito.when((Object)this.placeManagerMock.getStatus((PlaceRequest)this.placeRequestMock)).thenReturn((Object)PlaceStatus.CLOSE);
        this.presenter.onPlaceGainFocusEvent(mockPlaceGainFocusEvent);
        ((ScenarioSimulationDocksHandler)Mockito.verify((Object)this.scenarioSimulationDocksHandlerMock)).addDocks();
        ((ScenarioSimulationDocksHandler)Mockito.verify((Object)this.scenarioSimulationDocksHandlerMock)).expandToolsDock();
    }

    @Test
    public void onPlaceHiddenEvent() {
        PlaceHiddenEvent mockPlaceHiddenEvent = (PlaceHiddenEvent)Mockito.mock(PlaceHiddenEvent.class);
        Mockito.when((Object)mockPlaceHiddenEvent.getPlace()).thenReturn((Object)this.placeRequestMock);
        Mockito.when((Object)this.placeManagerMock.getStatus((PlaceRequest)this.placeRequestMock)).thenReturn((Object)PlaceStatus.OPEN);
        this.presenter.onPlaceHiddenEvent(mockPlaceHiddenEvent);
        ((ScenarioSimulationDocksHandler)Mockito.verify((Object)this.scenarioSimulationDocksHandlerMock)).removeDocks();
        ((TestRunnerReportingScreen)Mockito.verify((Object)this.testRunnerReportingScreenMock)).reset();
        ((ScenarioGrid)Mockito.verify((Object)this.scenarioGridMock, (VerificationMode)Mockito.times((int)1))).clearSelections();
    }

    @Test
    public void onClose() {
        Mockito.when((Object)this.placeManagerMock.getStatus((PlaceRequest)this.placeRequestMock)).thenReturn((Object)PlaceStatus.OPEN);
        this.presenter.onClose();
        this.onClosePlaceStatusOpen();
        Mockito.reset((Object[])new ScenarioGridPanel[]{this.scenarioGridPanelMock});
        Mockito.reset((Object[])new VersionRecordManager[]{this.versionRecordManagerMock});
        Mockito.reset((Object[])new PlaceManager[]{this.placeManagerMock});
        Mockito.reset((Object[])new ScenarioSimulationView[]{this.scenarioSimulationViewMock});
        Mockito.when((Object)this.placeManagerMock.getStatus((PlaceRequest)this.placeRequestMock)).thenReturn((Object)PlaceStatus.CLOSE);
        this.presenter.onClose();
        this.onClosePlaceStatusClose();
    }

    @Test
    public void onRunTest() throws Exception {
        ((ScenarioSimulationService)Mockito.doReturn((Object)new ScenarioSimulationModelContent(this.modelLocal, new Overview(), new PackageDataModelOracleBaselinePayload())).when((Object)this.scenarioSimulationServiceMock)).loadContent((Path)Mockito.any());
        Mockito.when((Object)this.scenarioSimulationServiceMock.runScenario((Path)Mockito.any(), (SimulationDescriptor)Mockito.any(), (Map)Mockito.any())).thenReturn((Object)this.scenarioMapMock);
        Mockito.when((Object)this.statusMock.getSimulation()).thenReturn((Object)this.simulationMock);
        Mockito.when((Object)this.contextMock.getStatus()).thenReturn((Object)this.statusMock);
        Assert.assertFalse((boolean)this.modelLocal.getSimulation().equals(this.simulationMock));
        this.presenter.onStartup(this.observablePathMock, (PlaceRequest)this.placeRequestMock);
        this.presenter.onRunScenario();
        ((ScenarioSimulationService)Mockito.verify((Object)this.scenarioSimulationServiceMock, (VerificationMode)Mockito.times((int)1))).runScenario((Path)Mockito.any(), (SimulationDescriptor)Mockito.any(), (Map)Mockito.any());
        ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModelMock, (VerificationMode)Mockito.times((int)1))).resetErrors();
        ((ScenarioSimulationView)Mockito.verify((Object)this.scenarioSimulationViewMock, (VerificationMode)Mockito.times((int)1))).refreshContent((Simulation)Mockito.any());
        ((ScenarioSimulationDocksHandler)Mockito.verify((Object)this.scenarioSimulationDocksHandlerMock)).expandTestResultsDock();
        TestCase.assertTrue((boolean)this.modelLocal.getSimulation().equals(this.simulationMock));
    }

    @Test
    public void onRunTestById() throws Exception {
        Mockito.when((Object)this.simulationMock.getScenarioByIndex(Matchers.anyInt())).thenReturn(Mockito.mock(Scenario.class));
        this.presenter.onRunScenario(Collections.singletonList(0));
        ((ScenarioSimulationService)Mockito.verify((Object)this.scenarioSimulationServiceMock, (VerificationMode)Mockito.times((int)1))).runScenario((Path)Mockito.any(), (SimulationDescriptor)Mockito.any(), (Map)Mockito.any());
        ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModelMock, (VerificationMode)Mockito.times((int)1))).resetErrors();
        ((ScenarioSimulationView)Mockito.verify((Object)this.scenarioSimulationViewMock, (VerificationMode)Mockito.times((int)1))).refreshContent((Simulation)Mockito.any());
        ((ScenarioSimulationDocksHandler)Mockito.verify((Object)this.scenarioSimulationDocksHandlerMock)).expandTestResultsDock();
    }

    @Test
    public void refreshModelContent() {
        Mockito.when((Object)this.scenarioSimulationModelMock.getSimulation()).thenReturn((Object)this.simulationMock);
        HashSet<AbstractMap.SimpleEntry<Integer, Scenario>> entries = new HashSet<AbstractMap.SimpleEntry<Integer, Scenario>>();
        int scenarioNumber = 1;
        int scenarioIndex = scenarioNumber - 1;
        entries.add(new AbstractMap.SimpleEntry<Integer, Scenario>(scenarioNumber, new Scenario()));
        Mockito.when(this.scenarioMapMock.entrySet()).thenReturn(entries);
        this.presenter.refreshModelContent(this.scenarioMapMock);
        ((Simulation)Mockito.verify((Object)this.simulationMock, (VerificationMode)Mockito.times((int)1))).replaceScenario(Matchers.eq((int)scenarioIndex), (Scenario)Mockito.any());
        Assert.assertEquals((Object)this.scenarioSimulationModelMock, (Object)this.presenter.getModel());
        ((ScenarioSimulationView)Mockito.verify((Object)this.scenarioSimulationViewMock, (VerificationMode)Mockito.times((int)1))).refreshContent((Simulation)Matchers.eq((Object)this.simulationMock));
        ((ScenarioSimulationContext.Status)Mockito.verify((Object)this.statusMock, (VerificationMode)Mockito.times((int)1))).setSimulation((Simulation)Matchers.eq((Object)this.simulationMock));
        ((DataManagementStrategy)Mockito.verify((Object)this.dataManagementStrategyMock, (VerificationMode)Mockito.times((int)1))).setModel((ScenarioSimulationModel)Matchers.eq((Object)this.scenarioSimulationModelMock));
    }

    @Test
    public void isDirty() {
        Mockito.when((Object)this.scenarioSimulationViewMock.getScenarioGridPanel()).thenThrow(new Throwable[]{new RuntimeException()});
        Assert.assertFalse((boolean)this.presenter.isDirty());
    }

    @Test
    public void setRightPanel() {
        this.presenter.setRightPanel((RightPanelView.Presenter)this.rightPanelPresenterMock);
        ((ScenarioSimulationContext)Mockito.verify((Object)this.contextMock, (VerificationMode)Mockito.times((int)1))).setRightPanelPresenter((RightPanelView.Presenter)this.rightPanelPresenterMock);
        ((RightPanelPresenter)Mockito.verify((Object)this.rightPanelPresenterMock, (VerificationMode)Mockito.times((int)1))).setEventBus(this.eventBusMock);
        ((DataManagementStrategy)Mockito.verify((Object)this.dataManagementStrategyMock, (VerificationMode)Mockito.times((int)1))).populateRightPanel((RightPanelView.Presenter)this.rightPanelPresenterMock, this.scenarioGridModelMock);
        ((RightPanelPresenter)Mockito.verify((Object)this.rightPanelPresenterMock, (VerificationMode)Mockito.times((int)1))).initCheatSheet((ScenarioSimulationModel.Type)Mockito.any());
    }

    @Test
    public void getModelSuccessCallbackMethod() {
        this.presenterSpy.getModelSuccessCallbackMethod(this.content);
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.presenterSpy, (VerificationMode)Mockito.times((int)1))).populateRightPanel();
        ((ScenarioSimulationView)Mockito.verify((Object)this.scenarioSimulationViewMock, (VerificationMode)Mockito.times((int)1))).hideBusyIndicator();
        ((ScenarioSimulationView)Mockito.verify((Object)this.scenarioSimulationViewMock, (VerificationMode)Mockito.times((int)1))).setContent((Simulation)Matchers.eq((Object)this.content.getModel().getSimulation()));
        ((ScenarioSimulationContext.Status)Mockito.verify((Object)this.statusMock, (VerificationMode)Mockito.times((int)1))).setSimulation((Simulation)Matchers.eq((Object)this.content.getModel().getSimulation()));
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.presenterSpy, (VerificationMode)Mockito.times((int)1))).setOriginalHash(Integer.valueOf(Matchers.anyInt()));
    }

    private void onClosePlaceStatusOpen() {
        ((VersionRecordManager)Mockito.verify((Object)this.versionRecordManagerMock, (VerificationMode)Mockito.times((int)1))).clear();
        ((ScenarioGridPanel)Mockito.verify((Object)this.scenarioGridPanelMock, (VerificationMode)Mockito.times((int)1))).unregister();
    }

    private void onClosePlaceStatusClose() {
        ((VersionRecordManager)Mockito.verify((Object)this.versionRecordManagerMock, (VerificationMode)Mockito.times((int)1))).clear();
        ((PlaceManager)Mockito.verify((Object)this.placeManagerMock, (VerificationMode)Mockito.times((int)0))).closePlace((PlaceRequest)this.placeRequestMock);
        ((ScenarioGridPanel)Mockito.verify((Object)this.scenarioGridPanelMock, (VerificationMode)Mockito.times((int)1))).unregister();
    }
}

