/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.handlers;

import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.drools.workbench.screens.scenariosimulation.client.handlers.AbstractNewScenarioTest;
import org.drools.workbench.screens.scenariosimulation.client.handlers.TitledAttachmentFileWidget;
import org.drools.workbench.screens.scenariosimulation.client.resources.i18n.ScenarioSimulationEditorConstants;
import org.gwtbootstrap3.client.ui.FormLabel;
import org.gwtbootstrap3.client.ui.html.Span;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.screens.examples.client.wizard.widgets.ComboBox;
import org.kie.workbench.common.screens.explorer.model.FolderItem;
import org.kie.workbench.common.screens.explorer.model.FolderItemType;
import org.kie.workbench.common.screens.library.api.AssetInfo;
import org.kie.workbench.common.screens.library.api.AssetQueryResult;
import org.kie.workbench.common.screens.library.api.ProjectAssetsQuery;
import org.kie.workbench.common.screens.library.client.screens.assets.AssetQueryService;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.widgets.common.client.callbacks.DefaultErrorCallback;

@RunWith(value=GwtMockitoTestRunner.class)
public class TitledAttachmentFileWidgetTest
extends AbstractNewScenarioTest {
    @Mock
    private VerticalPanel fieldsMock;
    @Mock
    private FormLabel titleLabelMock;
    @Mock
    private ComboBox comboBoxMock;
    @Mock
    private Span errorLabelMock;
    private TitledAttachmentFileWidget titledAttachmentFileWidget;

    @Override
    @Before
    public void setup() throws Exception {
        super.setup();
        this.titledAttachmentFileWidget = (TitledAttachmentFileWidget)Mockito.spy((Object)new TitledAttachmentFileWidget(ScenarioSimulationEditorConstants.INSTANCE.chooseDMN(), this.libraryPlacesMock, this.assetQueryServiceMock){
            {
                this.fields = TitledAttachmentFileWidgetTest.this.fieldsMock;
                this.titleLabel = TitledAttachmentFileWidgetTest.this.titleLabelMock;
                this.comboBox = TitledAttachmentFileWidgetTest.this.comboBoxMock;
                this.errorLabel = TitledAttachmentFileWidgetTest.this.errorLabelMock;
            }

            protected String getAssetPath(AssetInfo asset) {
                return "TEST";
            }
        });
    }

    @Test
    public void clearStatus() {
        this.titledAttachmentFileWidget.selectedPath = "SELECTED_PATH";
        Assert.assertNotNull((Object)this.titledAttachmentFileWidget.selectedPath);
        this.titledAttachmentFileWidget.clearStatus();
        ((ComboBox)Mockito.verify((Object)this.comboBoxMock, (VerificationMode)Mockito.times((int)1))).setText((String)Matchers.eq(null));
        ((TitledAttachmentFileWidget)Mockito.verify((Object)this.titledAttachmentFileWidget, (VerificationMode)Mockito.times((int)1))).updateAssetList();
        ((Span)Mockito.verify((Object)this.errorLabelMock, (VerificationMode)Mockito.times((int)1))).setText((String)Matchers.eq(null));
        Assert.assertNull((Object)this.titledAttachmentFileWidget.selectedPath);
    }

    @Test
    public void updateAssetList() {
        this.titledAttachmentFileWidget.updateAssetList();
        ((ComboBox)Mockito.verify((Object)this.comboBoxMock, (VerificationMode)Mockito.times((int)1))).clear();
        ((TitledAttachmentFileWidget)Mockito.verify((Object)this.titledAttachmentFileWidget, (VerificationMode)Mockito.times((int)1))).updateAssets((RemoteCallback)Matchers.isA(RemoteCallback.class));
    }

    @Test
    public void validateNullPath() {
        this.commonValidate(null, false);
    }

    @Test
    public void validateEmptyPath() {
        this.commonValidate("", false);
    }

    @Test
    public void validatePopulatedPath() {
        this.commonValidate("SELECTED_PATH", true);
    }

    @Test
    public void getAssets() {
        RemoteCallback callbackMock = (RemoteCallback)Mockito.mock(RemoteCallback.class);
        this.titledAttachmentFileWidget.updateAssets(callbackMock);
        ((TitledAttachmentFileWidget)Mockito.verify((Object)this.titledAttachmentFileWidget, (VerificationMode)Mockito.times((int)1))).createProjectQuery();
        ((AssetQueryService)Mockito.verify((Object)this.assetQueryServiceMock, (VerificationMode)Mockito.times((int)1))).getAssets((ProjectAssetsQuery)Matchers.isA(ProjectAssetsQuery.class));
        ((AssetQueryService.Invoker)Mockito.verify((Object)this.invokerMock, (VerificationMode)Mockito.times((int)1))).call((RemoteCallback)Matchers.eq((Object)callbackMock), (ErrorCallback)Matchers.isA(DefaultErrorCallback.class));
    }

    @Test
    public void createProjectQuery() {
        ProjectAssetsQuery retrieved = this.titledAttachmentFileWidget.createProjectQuery();
        Assert.assertNotNull((Object)retrieved);
    }

    @Test
    public void addAssets() {
        int size = 4;
        AssetQueryResult assetQueryResult = this.getAssetQueryResult(size);
        this.titledAttachmentFileWidget.addAssets(assetQueryResult);
        ((ComboBox)Mockito.verify((Object)this.comboBoxMock, (VerificationMode)Mockito.times((int)size))).addItem(Matchers.anyString());
    }

    private void commonValidate(String selectedPath, boolean expected) {
        this.titledAttachmentFileWidget.selectedPath = selectedPath;
        boolean retrieved = this.titledAttachmentFileWidget.validate();
        if (expected) {
            ((Span)Mockito.verify((Object)this.errorLabelMock, (VerificationMode)Mockito.times((int)1))).setText((String)Matchers.eq(null));
            Assert.assertTrue((boolean)retrieved);
        } else {
            ((Span)Mockito.verify((Object)this.errorLabelMock, (VerificationMode)Mockito.times((int)1))).setText((String)Matchers.eq((Object)ScenarioSimulationEditorConstants.INSTANCE.chooseValidDMNAsset()));
            Assert.assertFalse((boolean)retrieved);
        }
    }

    private AssetQueryResult getAssetQueryResult(int size) {
        return AssetQueryResult.normal(this.getAssetInfoList(size));
    }

    private List<AssetInfo> getAssetInfoList(int size) {
        return IntStream.range(0, size).mapToObj(i -> this.getAssetInfoMock()).collect(Collectors.toList());
    }

    private AssetInfo getAssetInfoMock() {
        AssetInfo toReturn = (AssetInfo)Mockito.mock(AssetInfo.class);
        FolderItem folderItemMock = this.getFolderItemMock();
        Mockito.when((Object)toReturn.getFolderItem()).thenReturn((Object)folderItemMock);
        return toReturn;
    }

    private FolderItem getFolderItemMock() {
        FolderItem toReturn = (FolderItem)Mockito.mock(FolderItem.class);
        Mockito.when((Object)toReturn.getType()).thenReturn((Object)FolderItemType.FILE);
        return toReturn;
    }
}

