/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.collectioneditor;

import com.google.gwt.dom.client.DivElement;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwtmockito.GwtMockitoTestRunner;
import org.drools.workbench.screens.scenariosimulation.client.collectioneditor.AbstractCollectionEditorTest;
import org.drools.workbench.screens.scenariosimulation.client.collectioneditor.CollectionPresenter;
import org.drools.workbench.screens.scenariosimulation.client.collectioneditor.CollectionViewImpl;
import org.drools.workbench.screens.scenariosimulation.client.events.CloseCompositeEvent;
import org.drools.workbench.screens.scenariosimulation.client.events.SaveEditorEvent;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=GwtMockitoTestRunner.class)
public class CollectionViewImplTest
extends AbstractCollectionEditorTest {
    private CollectionViewImpl collectionEditorViewImpl;
    @Mock
    protected DivElement collectionEditorModalBodyMock;

    @Override
    @Before
    public void setup() {
        Mockito.when((Object)this.collectionEditorModalBodyMock.getStyle()).thenReturn((Object)this.styleMock);
        this.collectionEditorViewImpl = (CollectionViewImpl)Mockito.spy((Object)new CollectionViewImpl(){
            {
                this.presenter = CollectionViewImplTest.this.collectionPresenterMock;
                this.collectionEditorModalBody = CollectionViewImplTest.this.collectionEditorModalBodyMock;
            }
        });
    }

    @Test
    public void setValue() {
        String testValue = "TEST-JSON";
        this.collectionEditorViewImpl.setValue(testValue);
        ((CollectionPresenter)Mockito.verify((Object)this.collectionPresenterMock, (VerificationMode)Mockito.times((int)1))).setValue((String)Matchers.eq((Object)testValue));
    }

    @Test
    public void onCloseCollectionEditorButtonClick() {
        this.collectionEditorViewImpl.onCloseCollectionEditorButtonClick(this.clickEventMock);
        ((CollectionViewImpl)Mockito.verify((Object)this.collectionEditorViewImpl, (VerificationMode)Mockito.times((int)1))).fireEvent((GwtEvent)Matchers.isA(CloseCompositeEvent.class));
        ((ClickEvent)Mockito.verify((Object)this.clickEventMock, (VerificationMode)Mockito.times((int)1))).stopPropagation();
    }

    @Test
    public void onCancelButtonClick() {
        this.collectionEditorViewImpl.onCancelButtonClick(this.clickEventMock);
        ((CollectionViewImpl)Mockito.verify((Object)this.collectionEditorViewImpl, (VerificationMode)Mockito.times((int)1))).close();
        ((ClickEvent)Mockito.verify((Object)this.clickEventMock, (VerificationMode)Mockito.times((int)1))).stopPropagation();
    }

    @Test
    public void onRemoveButtonClick() {
        this.collectionEditorViewImpl.onRemoveButtonClick(this.clickEventMock);
        ((CollectionPresenter)Mockito.verify((Object)this.collectionPresenterMock, (VerificationMode)Mockito.times((int)1))).remove();
        ((ClickEvent)Mockito.verify((Object)this.clickEventMock, (VerificationMode)Mockito.times((int)1))).stopPropagation();
    }

    @Test
    public void onSaveButtonClick() {
        this.collectionEditorViewImpl.onSaveButtonClick(this.clickEventMock);
        ((CollectionPresenter)Mockito.verify((Object)this.collectionPresenterMock, (VerificationMode)Mockito.times((int)1))).save();
        ((ClickEvent)Mockito.verify((Object)this.clickEventMock, (VerificationMode)Mockito.times((int)1))).stopPropagation();
    }

    @Test
    public void onAddItemButton() {
        this.collectionEditorViewImpl.onAddItemButton(this.clickEventMock);
        ((CollectionPresenter)Mockito.verify((Object)this.collectionPresenterMock, (VerificationMode)Mockito.times((int)1))).showEditingBox();
        ((ClickEvent)Mockito.verify((Object)this.clickEventMock, (VerificationMode)Mockito.times((int)1))).stopPropagation();
    }

    @Test
    public void onFaAngleRightClick() {
        ((CollectionViewImpl)Mockito.doReturn((Object)true).when((Object)this.collectionEditorViewImpl)).isShown();
        this.collectionEditorViewImpl.onFaAngleRightClick(this.clickEventMock);
        ((CollectionPresenter)Mockito.verify((Object)this.collectionPresenterMock, (VerificationMode)Mockito.times((int)1))).onToggleRowExpansion(Matchers.eq((boolean)true));
        ((ClickEvent)Mockito.verify((Object)this.clickEventMock, (VerificationMode)Mockito.times((int)1))).stopPropagation();
        Mockito.reset((Object[])new CollectionPresenter[]{this.collectionPresenterMock});
        Mockito.reset((Object[])new ClickEvent[]{this.clickEventMock});
        ((CollectionViewImpl)Mockito.doReturn((Object)false).when((Object)this.collectionEditorViewImpl)).isShown();
        this.collectionEditorViewImpl.onFaAngleRightClick(this.clickEventMock);
        ((CollectionPresenter)Mockito.verify((Object)this.collectionPresenterMock, (VerificationMode)Mockito.times((int)1))).onToggleRowExpansion(Matchers.eq((boolean)false));
        ((ClickEvent)Mockito.verify((Object)this.clickEventMock, (VerificationMode)Mockito.times((int)1))).stopPropagation();
    }

    @Test
    public void toggleRowExpansion() {
        ((CollectionViewImpl)Mockito.doReturn((Object)true).when((Object)this.collectionEditorViewImpl)).isShown();
        this.collectionEditorViewImpl.toggleRowExpansion();
        ((CollectionViewImpl)Mockito.verify((Object)this.collectionEditorViewImpl, (VerificationMode)Mockito.times((int)1))).toggleRowExpansion(false);
        Mockito.reset((Object[])new CollectionViewImpl[]{this.collectionEditorViewImpl});
        ((CollectionViewImpl)Mockito.doReturn((Object)false).when((Object)this.collectionEditorViewImpl)).isShown();
        this.collectionEditorViewImpl.toggleRowExpansion();
        ((CollectionViewImpl)Mockito.verify((Object)this.collectionEditorViewImpl, (VerificationMode)Mockito.times((int)1))).toggleRowExpansion(true);
    }

    @Test
    public void updateValue() {
        this.collectionEditorViewImpl.updateValue("VALUE");
        ((CollectionViewImpl)Mockito.verify((Object)this.collectionEditorViewImpl, (VerificationMode)Mockito.times((int)1))).fireEvent((GwtEvent)Matchers.isA(SaveEditorEvent.class));
    }

    @Test
    public void close() {
        this.collectionEditorViewImpl.close();
        ((CollectionViewImpl)Mockito.verify((Object)this.collectionEditorViewImpl, (VerificationMode)Mockito.times((int)1))).fireEvent((GwtEvent)Matchers.isA(CloseCompositeEvent.class));
    }

    @Test
    public void setFixedHeight() {
        double value = 23.0;
        Style.Unit unit = Style.Unit.PX;
        this.collectionEditorViewImpl.setFixedHeight(value, unit);
        ((Style)Mockito.verify((Object)this.styleMock, (VerificationMode)Mockito.times((int)1))).setHeight(Matchers.eq((double)value), (Style.Unit)Matchers.eq((Object)unit));
    }
}

