/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.rightpanel;

import com.google.gwt.dom.client.ButtonElement;
import com.google.gwt.dom.client.DivElement;
import com.google.gwt.dom.client.InputElement;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwtmockito.GwtMockitoTestRunner;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.RightPanelPresenter;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.RightPanelView;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.RightPanelViewImpl;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=GwtMockitoTestRunner.class)
public class RightPanelViewImplTest {
    private RightPanelViewImpl rightPanelView;
    @Mock
    private RightPanelPresenter rightPanelPresenterMock;
    @Mock
    private InputElement inputSearchMock;
    @Mock
    private InputElement nameFieldMock;
    @Mock
    private ButtonElement clearSearchButtonMock;
    @Mock
    private DivElement ruleCheatSheetMock;
    @Mock
    private DivElement dmnCheatSheetMock;
    @Mock
    private Style ruleCheatSheetStyleMock;
    @Mock
    private Style dmnCheatSheetStyleMock;

    @Before
    public void setup() {
        this.rightPanelView = (RightPanelViewImpl)Mockito.spy((Object)new RightPanelViewImpl(){
            {
                this.inputSearch = RightPanelViewImplTest.this.inputSearchMock;
                this.clearSearchButton = RightPanelViewImplTest.this.clearSearchButtonMock;
                this.nameField = RightPanelViewImplTest.this.nameFieldMock;
                this.ruleCheatSheet = RightPanelViewImplTest.this.ruleCheatSheetMock;
                this.dmnCheatSheet = RightPanelViewImplTest.this.dmnCheatSheetMock;
            }
        });
        this.rightPanelView.init((RightPanelView.Presenter)this.rightPanelPresenterMock);
        Mockito.when((Object)this.ruleCheatSheetMock.getStyle()).thenReturn((Object)this.ruleCheatSheetStyleMock);
        Mockito.when((Object)this.dmnCheatSheetMock.getStyle()).thenReturn((Object)this.dmnCheatSheetStyleMock);
    }

    @Test
    public void onClearSearchButtonClick() {
        Mockito.reset((Object[])new RightPanelPresenter[]{this.rightPanelPresenterMock});
        this.rightPanelView.onClearSearchButtonClick((ClickEvent)Mockito.mock(ClickEvent.class));
        ((RightPanelPresenter)Mockito.verify((Object)this.rightPanelPresenterMock, (VerificationMode)Mockito.times((int)1))).onClearSearch();
    }

    @Test
    public void onInputSearchKeyUp() {
        this.rightPanelView.onInputSearchKeyUp((KeyUpEvent)Mockito.mock(KeyUpEvent.class));
        ((RightPanelPresenter)Mockito.verify((Object)this.rightPanelPresenterMock, (VerificationMode)Mockito.times((int)1))).onShowClearButton();
    }

    @Test
    public void clearInputSearch() {
        this.rightPanelView.clearInputSearch();
        ((InputElement)Mockito.verify((Object)this.inputSearchMock, (VerificationMode)Mockito.times((int)1))).setValue((String)Matchers.eq((Object)""));
    }

    @Test
    public void clearNameField() {
        this.rightPanelView.clearNameField();
        ((InputElement)Mockito.verify((Object)this.nameFieldMock, (VerificationMode)Mockito.times((int)1))).setValue((String)Matchers.eq((Object)""));
    }

    @Test
    public void hideClearButton() {
        Mockito.reset((Object[])new ButtonElement[]{this.clearSearchButtonMock});
        this.rightPanelView.hideClearButton();
        ((ButtonElement)Mockito.verify((Object)this.clearSearchButtonMock, (VerificationMode)Mockito.times((int)1))).setDisabled(Matchers.eq((boolean)true));
        ((ButtonElement)Mockito.verify((Object)this.clearSearchButtonMock, (VerificationMode)Mockito.times((int)1))).setAttribute((String)Matchers.eq((Object)"style"), (String)Matchers.eq((Object)"display: none;"));
    }

    @Test
    public void showClearButton() {
        Mockito.reset((Object[])new ButtonElement[]{this.clearSearchButtonMock});
        this.rightPanelView.showClearButton();
        ((ButtonElement)Mockito.verify((Object)this.clearSearchButtonMock, (VerificationMode)Mockito.times((int)1))).setDisabled(Matchers.eq((boolean)false));
        ((ButtonElement)Mockito.verify((Object)this.clearSearchButtonMock, (VerificationMode)Mockito.times((int)1))).removeAttribute((String)Matchers.eq((Object)"style"));
    }

    @Test
    public void setRuleCheatSheetContent() {
        this.rightPanelView.setRuleCheatSheetContent();
        ((Style)Mockito.verify((Object)this.ruleCheatSheetStyleMock, (VerificationMode)Mockito.times((int)1))).setDisplay(Style.Display.BLOCK);
        ((Style)Mockito.verify((Object)this.dmnCheatSheetStyleMock, (VerificationMode)Mockito.times((int)1))).setDisplay(Style.Display.NONE);
    }

    @Test
    public void setDMNCheatSheetContent() {
        this.rightPanelView.setDMNCheatSheetContent();
        ((Style)Mockito.verify((Object)this.ruleCheatSheetStyleMock, (VerificationMode)Mockito.times((int)1))).setDisplay(Style.Display.NONE);
        ((Style)Mockito.verify((Object)this.dmnCheatSheetStyleMock, (VerificationMode)Mockito.times((int)1))).setDisplay(Style.Display.BLOCK);
    }
}

