/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.utils;

import com.ait.lienzo.client.core.shape.Viewport;
import com.ait.lienzo.client.core.types.Point2D;
import com.ait.lienzo.test.LienzoMockitoTestRunner;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.drools.workbench.screens.scenariosimulation.client.AbstractScenarioSimulationTest;
import org.drools.workbench.screens.scenariosimulation.client.events.EnableRightPanelEvent;
import org.drools.workbench.screens.scenariosimulation.client.metadata.ScenarioHeaderMetaData;
import org.drools.workbench.screens.scenariosimulation.client.utils.ScenarioSimulationGridHeaderUtilities;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGrid;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGridColumn;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.util.CellContextUtilities;
import org.uberfire.ext.wires.core.grids.client.widget.context.GridBodyCellEditContext;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.GridRenderer;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.impl.BaseGridRendererHelper;

@RunWith(value=LienzoMockitoTestRunner.class)
public class ScenarioSimulationGridHeaderUtilitiesTest
extends AbstractScenarioSimulationTest {
    private static final int HEADER_ROWS = 2;
    private static final double HEADER_HEIGHT = 50.0;
    private static final double HEADER_ROW_HEIGHT = 25.0;
    private static final Integer uiColumnIndex = 0;
    private static final String columnGroup = "col-group";
    private static final String columnOneTitle = "column one";
    private static final String columnTwoTitle = "column two";
    private ScenarioGridColumn scenarioGridColumnOne;
    private ScenarioGridColumn scenarioGridColumnTwo;
    @Mock
    private GridRenderer gridRenderer;
    @Mock
    private BaseGridRendererHelper gridRendererHelper;
    @Mock
    private BaseGridRendererHelper.RenderingInformation ri;
    @Mock
    private BaseGridRendererHelper.ColumnInformation ci;
    @Mock
    private BaseGridRendererHelper.RenderingBlockInformation floatingBlockInformation;
    @Mock
    private ScenarioHeaderMetaData clickedScenarioHeaderMetadataMock;
    private Point2D rp = new Point2D(0.0, 0.0);

    @Override
    @Before
    public void setup() {
        super.setup();
        ((ScenarioGrid)Mockito.doReturn((Object)this.gridRenderer).when((Object)this.scenarioGridMock)).getRenderer();
        ((ScenarioGrid)Mockito.doReturn((Object)this.gridRendererHelper).when((Object)this.scenarioGridMock)).getRendererHelper();
        ((BaseGridRendererHelper)Mockito.doReturn((Object)this.ri).when((Object)this.gridRendererHelper)).getRenderingInformation();
        ((GridRenderer)Mockito.doReturn((Object)50.0).when((Object)this.gridRenderer)).getHeaderHeight();
        ((GridRenderer)Mockito.doReturn((Object)25.0).when((Object)this.gridRenderer)).getHeaderRowHeight();
        ((BaseGridRendererHelper.RenderingInformation)Mockito.doReturn((Object)this.floatingBlockInformation).when((Object)this.ri)).getFloatingBlockInformation();
        ((BaseGridRendererHelper.RenderingBlockInformation)Mockito.doReturn((Object)0.0).when((Object)this.floatingBlockInformation)).getX();
        ((BaseGridRendererHelper.RenderingBlockInformation)Mockito.doReturn((Object)0.0).when((Object)this.floatingBlockInformation)).getWidth();
        ((ScenarioGrid)Mockito.doReturn((Object)Mockito.mock(Viewport.class)).when((Object)this.scenarioGridMock)).getViewport();
        Mockito.when((Object)this.scenarioGridMock.getModel()).thenReturn((Object)this.scenarioGridModelMock);
        ScenarioHeaderMetaData clickedScenarioHeaderMetadataMock = (ScenarioHeaderMetaData)Mockito.mock(ScenarioHeaderMetaData.class);
        this.scenarioGridColumnOne = this.mockGridColumn(100.0, Collections.singletonList(clickedScenarioHeaderMetadataMock), columnOneTitle, columnGroup);
        this.scenarioGridColumnTwo = this.mockGridColumn(100.0, Collections.singletonList(clickedScenarioHeaderMetadataMock), columnTwoTitle, columnGroup);
        this.gridColumns.add(this.scenarioGridColumnOne);
        this.gridColumns.add(this.scenarioGridColumnTwo);
    }

    @Test
    public void testMakeRenderContextNoBlock() {
        ArrayList<ScenarioGridColumn> allColumns = new ArrayList<ScenarioGridColumn>();
        ScenarioGridColumn uiColumn = this.mockGridColumn(100.0);
        allColumns.add(uiColumn);
        ((BaseGridRendererHelper.RenderingInformation)Mockito.doReturn(allColumns).when((Object)this.ri)).getAllColumns();
        ((BaseGridRendererHelper.ColumnInformation)Mockito.doReturn((Object)uiColumn).when((Object)this.ci)).getColumn();
        ((BaseGridRendererHelper.ColumnInformation)Mockito.doReturn((Object)0.0).when((Object)this.ci)).getOffsetX();
        ((BaseGridRendererHelper.ColumnInformation)Mockito.doReturn((Object)0).when((Object)this.ci)).getUiColumnIndex();
        GridBodyCellEditContext context = CellContextUtilities.makeHeaderCellRenderContext((GridWidget)this.scenarioGridMock, (BaseGridRendererHelper.RenderingInformation)this.ri, (BaseGridRendererHelper.ColumnInformation)this.ci, (Point2D)this.rp, (int)0);
        Assert.assertNotNull((Object)context);
        Assert.assertEquals((double)0.0, (double)context.getAbsoluteCellX(), (double)0.0);
        Assert.assertEquals((double)100.0, (double)context.getCellWidth(), (double)0.0);
    }

    @Test
    public void testEnableRightPanelEventInstanceNotAssigned() {
        EnableRightPanelEvent event = ScenarioSimulationGridHeaderUtilities.getEnableRightPanelEvent((ScenarioGrid)this.scenarioGridMock, (ScenarioGridColumn)this.scenarioGridColumnOne, (ScenarioHeaderMetaData)this.clickedScenarioHeaderMetadataMock, (Integer)uiColumnIndex, (String)columnGroup);
        Assertions.assertThat((String)event.getFilterTerm()).isEqualTo((Object)"column one;column two");
        Assertions.assertThat((boolean)event.isNotEqualsSearch()).isTrue();
    }

    @Test
    public void testEnableRightPanelEventInstanceAssigned() {
        Mockito.when((Object)this.scenarioGridColumnOne.isInstanceAssigned()).thenReturn((Object)true);
        EnableRightPanelEvent event = ScenarioSimulationGridHeaderUtilities.getEnableRightPanelEvent((ScenarioGrid)this.scenarioGridMock, (ScenarioGridColumn)this.scenarioGridColumnOne, (ScenarioHeaderMetaData)this.clickedScenarioHeaderMetadataMock, (Integer)uiColumnIndex, (String)columnGroup);
        Assertions.assertThat((String)event.getFilterTerm()).isEqualTo((Object)"column one;column two");
        Assertions.assertThat((boolean)event.isNotEqualsSearch()).isTrue();
    }

    @Test
    public void testEnableRightPanelEventPropertyHeaderPropertyNotAssigned() {
        Mockito.when((Object)this.clickedScenarioHeaderMetadataMock.isPropertyHeader()).thenReturn((Object)true);
        Mockito.when((Object)this.scenarioGridColumnOne.isInstanceAssigned()).thenReturn((Object)true);
        EnableRightPanelEvent event = ScenarioSimulationGridHeaderUtilities.getEnableRightPanelEvent((ScenarioGrid)this.scenarioGridMock, (ScenarioGridColumn)this.scenarioGridColumnOne, (ScenarioHeaderMetaData)this.clickedScenarioHeaderMetadataMock, (Integer)uiColumnIndex, (String)columnGroup);
        Assertions.assertThat((String)event.getFilterTerm()).isEqualTo((Object)columnOneTitle);
        Assertions.assertThat((String)event.getPropertyName()).isNull();
        Assertions.assertThat((boolean)event.isNotEqualsSearch()).isFalse();
    }

    @Test
    public void testIsHeaderEditableNorInstanceNorPropertyAssigned() {
        boolean result = ScenarioSimulationGridHeaderUtilities.isEditableHeader((ScenarioGridColumn)this.scenarioGridColumnOne, (Integer)0);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)result).as("Nor Instance nor Property assigned", new Object[0])).isFalse();
    }

    @Test
    public void testIsHeaderEditableInstanceAssignedAndSelected() {
        Mockito.when((Object)this.scenarioGridColumnOne.isInstanceAssigned()).thenReturn((Object)true);
        ScenarioHeaderMetaData metaDataMock = (ScenarioHeaderMetaData)this.scenarioGridColumnOne.getHeaderMetaData().get(0);
        Mockito.when((Object)metaDataMock.isInstanceHeader()).thenReturn((Object)true);
        boolean result = ScenarioSimulationGridHeaderUtilities.isEditableHeader((ScenarioGridColumn)this.scenarioGridColumnOne, (Integer)0);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)result).as("Instance Assigned and selected", new Object[0])).isTrue();
    }

    @Test
    public void testIsHeaderEditableInstanceAssignedButPropertySelected() {
        Mockito.when((Object)this.scenarioGridColumnOne.isInstanceAssigned()).thenReturn((Object)true);
        ScenarioHeaderMetaData metaDataMock = (ScenarioHeaderMetaData)this.scenarioGridColumnOne.getHeaderMetaData().get(0);
        Mockito.when((Object)metaDataMock.isPropertyHeader()).thenReturn((Object)true);
        boolean result = ScenarioSimulationGridHeaderUtilities.isEditableHeader((ScenarioGridColumn)this.scenarioGridColumnOne, (Integer)0);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)result).as("Instance Assigned but Property selected", new Object[0])).isFalse();
    }

    @Test
    public void testIsHeaderEditableInstanceAndPropertyAssignedButNotSelected() {
        Mockito.when((Object)this.scenarioGridColumnOne.isInstanceAssigned()).thenReturn((Object)true);
        Mockito.when((Object)this.scenarioGridColumnOne.isPropertyAssigned()).thenReturn((Object)true);
        ScenarioHeaderMetaData metaDataMock = (ScenarioHeaderMetaData)this.scenarioGridColumnOne.getHeaderMetaData().get(0);
        Mockito.when((Object)metaDataMock.isPropertyHeader()).thenReturn((Object)false);
        Mockito.when((Object)metaDataMock.isInstanceHeader()).thenReturn((Object)false);
        boolean result = ScenarioSimulationGridHeaderUtilities.isEditableHeader((ScenarioGridColumn)this.scenarioGridColumnOne, (Integer)0);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)result).as("Instance and Property Assigned but not selected", new Object[0])).isFalse();
    }

    @Test
    public void testIsHeaderEditableInstanceAndPropertyAssignedAndPropertySelected() {
        Mockito.when((Object)this.scenarioGridColumnOne.isInstanceAssigned()).thenReturn((Object)true);
        Mockito.when((Object)this.scenarioGridColumnOne.isPropertyAssigned()).thenReturn((Object)true);
        ScenarioHeaderMetaData metaDataMock = (ScenarioHeaderMetaData)this.scenarioGridColumnOne.getHeaderMetaData().get(0);
        Mockito.when((Object)metaDataMock.isPropertyHeader()).thenReturn((Object)true);
        boolean result = ScenarioSimulationGridHeaderUtilities.isEditableHeader((ScenarioGridColumn)this.scenarioGridColumnOne, (Integer)0);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)result).as("Instance and Property Assigned and Property selected", new Object[0])).isTrue();
    }

    @Test
    public void testHeaderMetadataInstanceOf() {
        ScenarioGridColumn invalidColumn = this.mockGridColumn(100.0, Collections.singletonList(Mockito.mock(GridColumn.HeaderMetaData.class)));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ScenarioSimulationGridHeaderUtilities.isEditableHeader((ScenarioGridColumn)invalidColumn, (Integer)0)).isInstanceOf(IllegalStateException.class)).hasMessage("Header metadata has to be an instance of ScenarioHeaderMetaData");
    }

    private ScenarioGridColumn mockGridColumn(double width) {
        ArrayList<GridColumn.HeaderMetaData> headerMetaData = new ArrayList<GridColumn.HeaderMetaData>();
        headerMetaData.add((GridColumn.HeaderMetaData)Mockito.mock(GridColumn.HeaderMetaData.class));
        headerMetaData.add((GridColumn.HeaderMetaData)Mockito.mock(GridColumn.HeaderMetaData.class));
        return this.mockGridColumn(width, headerMetaData);
    }

    private ScenarioGridColumn mockGridColumn(double width, List<GridColumn.HeaderMetaData> headerMetaData) {
        return this.mockGridColumn(width, headerMetaData, null, null);
    }

    private ScenarioGridColumn mockGridColumn(double width, List<GridColumn.HeaderMetaData> headerMetaData, String columnTitle, String columnGroup) {
        ScenarioGridColumn uiColumn = (ScenarioGridColumn)Mockito.mock(ScenarioGridColumn.class);
        ((ScenarioGridColumn)Mockito.doReturn(headerMetaData).when((Object)uiColumn)).getHeaderMetaData();
        ((ScenarioGridColumn)Mockito.doReturn((Object)width).when((Object)uiColumn)).getWidth();
        ScenarioHeaderMetaData informationHeader = (ScenarioHeaderMetaData)Mockito.mock(ScenarioHeaderMetaData.class);
        Mockito.when((Object)informationHeader.getColumnGroup()).thenReturn((Object)columnGroup);
        Mockito.when((Object)informationHeader.getTitle()).thenReturn((Object)columnTitle);
        Mockito.when((Object)uiColumn.getInformationHeaderMetaData()).thenReturn((Object)informationHeader);
        Mockito.when((Object)uiColumn.isEditableHeaders()).thenReturn((Object)true);
        return uiColumn;
    }
}

